_testsinglephase' shared extension.
PyAPI_FUNC(int) _PyTime_MonotonicWithInfo(
    PyTime_t *t,
    _Py_clock_info_t *info);


// Converts a timestamp to the Gregorian time, using the local time zone.
// Return 0 on success, raise an exception and return -1 on error.
// Export for '_datetime' shared extension.
PyAPI_FUNC(int) _PyTime_localtime(time_t t, struct tm *tm);

// Converts a timestamp to the Gregorian time, assuming UTC.
// Return 0 on success, raise an exception and return -1 on error.
// Export for '_datetime' shared extension.
PyAPI_FUNC(int) _PyTime_gmtime(time_t t, struct tm *tm);


// Get the performance counter: clock with the highest available resolution to
// measure a short duration.
//
// Fill info (if set) with information of the function used to get the time.
//
// Return 0 on success, raise an exception and return -1 on error.
extern int _PyTime_PerfCounterWithInfo(
    PyTime_t *t,
    _Py_clock_info_t *info);


// --- _PyDeadline -----------------------------------------------------------

// Create a deadline.
// Pseudo code: return PyTime_MonotonicRaw() + timeout
// Export for '_ssl' shared extension.
PyAPI_FUNC(PyTime_t) _PyDeadline_Init(PyTime_t timeout);

// Get remaining time from a deadline.
// Pseudo code: return deadline - PyTime_MonotonicRaw()
// Export for '_ssl' shared extension.
PyAPI_FUNC(PyTime_t) _PyDeadline_Get(PyTime_t deadline);


// --- _PyTimeFraction -------------------------------------------------------

typedef struct {
    PyTime_t numer;
    PyTime_t denom;
} _PyTimeFraction;

// Set a fraction.
// Return 0 on success.
// Return -1 if the fraction is invalid.
extern int _PyTimeFraction_Set(
    _PyTimeFraction *frac,
    PyTime_t numer,
    PyTime_t denom);

// Compute ticks * frac.numer / frac.denom.
// Clamp to [PyTime_MIN; PyTime_MAX] on overflow.
extern PyTime_t _PyTimeFraction_Mul(
    PyTime_t ticks,
    const _PyTimeFraction *frac);

// Compute a clock resolution: frac.numer / frac.denom / 1e9.
extern double _PyTimeFraction_Resolution(
 