 it is bit easier to reason
// about when thinking about the opcode transitions as a state machine:
#define ADAPTIVE_COOLDOWN_VALUE 52
#define ADAPTIVE_COOLDOWN_BACKOFF 0

// Can't assert this in pycore_backoff.h because of header order dependencies
#if COLD_EXIT_INITIAL_VALUE <= ADAPTIVE_COOLDOWN_VALUE
#  error  "Cold exit value should be larger than adaptive cooldown value"
#endif

static inline _Py_BackoffCounter
adaptive_counter_bits(uint16_t value, uint16_t backoff) {
    return make_backoff_counter(value, backoff);
}

static inline _Py_BackoffCounter
adaptive_counter_warmup(void) {
    return adaptive_counter_bits(ADAPTIVE_WARMUP_VALUE,
                                 ADAPTIVE_WARMUP_BACKOFF);
}

static inline _Py_BackoffCounter
adaptive_counter_cooldown(void) {
    return adaptive_counter_bits(ADAPTIVE_COOLDOWN_VALUE,
                                 ADAPTIVE_COOLDOWN_BACKOFF);
}

static inline _Py_BackoffCounter
adaptive_counter_backoff(_Py_BackoffCounter counter) {
    return restart_backoff_counter(counter);
}


/* Comparison bit masks. */

/* Note this evaluates its arguments twice each */
#define COMPARISON_BIT(x, y) (1 << (2 * ((x) >= (y)) + ((x) <= (y))))

/*
 * The following bits are chosen so that the value of
 * COMPARSION_BIT(left, right)
 * masked by the valu