rns the sequence, o, as a list on success, and NULL on failure.
     This is equivalent to the Python expression: list(o)
       */

     PyAPI_FUNC(PyObject *) PySequence_Fast(PyObject *o, const char* m);
       /*
     Returns the sequence, o, as a list, unless it's already a
     tuple or list.  Use PySequence_Fast_GET_ITEM to access the
     members of this list, and PySequence_Fast_GET_SIZE to get its length.

     Returns NULL on failure.  If the object does not support iteration,
     raises a TypeError exception with m as the message text.
       */

#define PySequence_Fast_GET_SIZE(o) \
    (PyList_Check(o) ? PyList_GET_SIZE(o) : PyTuple_GET_SIZE(o))
       /*
     Return the size of o, assuming that o was returned by
     PySequence_Fast and is not NULL.
       */

#define PySequence_Fast_GET_ITEM(o, i)\
     (PyList_Check(o) ? PyList_GET_ITEM(o, i) : PyTuple_GET_ITEM(o, i))
       /*
     Return the ith element of o, assuming that o was returned by
     PySequence_Fast, and that i is within bounds.
       */

#define PySequence_ITEM(o, i)\
    ( Py_TYPE(o)->tp_as_sequence->sq_item(o, i) )
       /* Assume tp_as_sequence and sq_item exist and that i does not
      need to be corrected for a negative index
       */

#define PySequence_Fast_ITEMS(