                  : ((PyTupleObject *)(sf))->ob_item)
    /* Return a pointer to the underlying item array for
       an object retured by PySequence_Fast */

     PyAPI_FUNC(Py_ssize_t) PySequence_Count(PyObject *o, PyObject *value);

       /*
     Return the number of occurrences on value on o, that is,
     return the number of keys for which o[key]==value.  On
     failure, return -1.  This is equivalent to the Python
     expression: o.count(value).
       */

     PyAPI_FUNC(int) PySequence_Contains(PyObject *seq, PyObject *ob);
       /*
     Return -1 if error; 1 if ob in seq; 0 if ob not in seq.
     Use __contains__ if possible, else _PySequence_IterSearch().
       */

#ifndef Py_LIMITED_API
#define PY_ITERSEARCH_COUNT    1
#define PY_ITERSEARCH_INDEX    2
#define PY_ITERSEARCH_CONTAINS 3
     PyAPI_FUNC(Py_ssize_t) _PySequence_IterSearch(PyObject *seq,
                                        PyObject *obj, int operation);
#endif
    /*
      Iterate over seq.  Result depends on the operation:
      PY_ITERSEARCH_COUNT:  return # of times obj appears in seq; -1 if
        error.
      PY_ITERSEARCH_INDEX:  return 0-based index of first occurrence of
        obj in seq; set ValueError and return -1 if none found;
        also return -1 on error.
      PY_ITERSEARCH_CONTAINS:  return 1 if obj in seq, else 0; -1 on
        error.
    */

/* For DLL-level backwards compatibility */
#undef PySequence_In
     PyAPI_FUNC(int) PySequence_In(PyObject *o, PyObject *value);

/* For source-level backwards compatibility */
#define PySequence_In PySequence_Contains

       /*
     Determine if o contains value.  If an item in o is equal to
     X, return 1, otherwise return 0.  On error, return -1.  This
     is equivalent to the Python expression: value in o.
       */

     PyAPI_FUNC(Py_ssize_t) PySequence_Index(PyObject *o, PyObject *value);

       /*
     Return the first index for which o[i]=value.  On error,
     return -1.    This is equivalent to the Python
     expression: o.index(value).
       */

/* In-place versions of some of the above Sequence functions. */

     PyAPI_FUNC(PyObject *) PySequence_InPlaceConcat(P