*             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Creation and modification of Ruby modules.
 */
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"

/**
 * @defgroup  class  Classes and their hierarchy.
 *
 * @par Terminology
 *   - class: same as in Ruby.
 *   - singleton class: class for a particular object.
 *   - eigenclass: = singleton class
 *   - metaclass: class of a class.  Metaclass is a kind of singleton class.
 *   - metametaclass: class of a metaclass.
 *   - meta^(n)-class: class of a meta^(n-1)-class.
 *   - attached object: A singleton class knows its unique instance.
 *     The instance is called the attached object for the singleton class.
 * @{
 */

RBIMPL_SYMBOL_EXPORT_BEGIN()

RBIMPL_ATTR_NONNULL(())
/**
 * Defines a top-level class.
 *
 * @param[in]  name           Name of the class.
 * @param[in]  super          A class from which the new class will derive.
 * @exception  rb_eTypeError  The constant name `name` is already taken but the
 *                            constant is not a class.
 * @exception  rb_eTypeError  The class  is already  defined but the  class can
 *                            not  be reopened  because its  superclass is  not
 *                            `super`.
 * @exception  rb_eArgError   `super` is NULL.
 * @return     The created class.
 * @post       Top-level constant named `name` refers the returned class.
 * @note       If a class named `name` is already defined and its superclass is
 *             `super`, the function just returns the defined class.
 * @note       The  compaction  GC  does  not move  classes  returned  by  this
 *             function.
 *
 * @internal
 *
 * There are classes without names, but you  can't pass NULL here.  You have to
 * use other ways to create one.
 */
VALUE rb_define_class(const char *name, VALUE super);

RBIMPL_ATTR_NONNULL(())
/**
 * Defines a top-level module.
 *
 * @param[in]  name           Name of the module.
 * @exception  rb_eTypeError  The constant name `name` is already taken but the
 *                            constant is not a module.
 * @return     The created module.
 * @post       Top-level constant named `name` refers the returned module.
 * @note       The  compaction  GC  does  not move  classes  returned  by  this
 *             function.
 *
 * @internal
 *
 * There are modules without names, but you  can't pass NULL here.  You have to
 * use other ways to create one.
 */
VALUE rb_define_module(const char *name);

RBIMPL_ATTR_NONNULL(())
/**
 * Defines a class under the namespace of `outer`.
 *
 * @param[out]  outer          A class which contains the new class.
 * @param[in]   name           Name of the new class
 * @param[in]   super          A class from which the new cla