L(())
/**
 * Resolves a  feature's path.  This  function takes for instance  `"json"` and
 * `[".so", ".rb"]`,  and iterates  over the  `$LOAD_PATH` to  see if  there is
 * either `json.so` or `json.rb` in the directory.
 *
 * This is not what everything `require`  does, but at least `require` is built
 * on top of it.
 *
 * @param[in,out]  feature             File to search, and return buffer.
 * @param[in]      exts                List of file extensions.
 * @exception      rb_eTypeError       `feature` is not a String.
 * @exception      rb_eArgError        `feature` contains NUL bytes.
 * @exception      rb_eEncCompatError  `feature`'s encoding is not path-compat.
 * @retval         0                   Not found
 * @retval         otherwise           Found index in `ext`, plus one.
 * @post           `*feature` is a resolved path.
 */
int rb_find_file_ext(VALUE *feature, const char *const *exts);

/**
 * Identical  to rb_find_file_ext(),  except it  takes  a feature  name and  is
 * extension  at once,  e.g. `"json.rb"`.   This  difference is  much like  how
 * `require` and `load` are different.
 *
 * @param[in]  path                A path relative to `$LOAD_PATH`.
 * @exception  rb_eTypeError       `path` is not a String.
 * @exception  rb_eArgError        `path` contains NUL bytes.
 * @exception  rb_eEncCompatError  `path`'s encoding is not path-compat.
 * @return     Expanded path.
 */
VALUE rb_