= rb_intern("open");
 *
 *     return rb_funcall_passing_block(x, open, 1, &y);
 * }
 * ```
 *
 * @see            rb_yield_block
 * @param[in,out]  recv               Receiver of the method.
 * @param[in]      mid                Name of the method to call.
 * @param[in]      argc               Number of arguments.
 * @param[in]      argv               Arbitrary number of method arguments.
 * @exception      rb_eNoMethodError  No such method.
 * @exception      rb_eNoMethodError  The method is private or protected.
 * @exception      rb_eException      Any exceptions happen inside.
 * @return         What the method evaluates to.
 */
VALUE rb_funcall_passing_block(VALUE recv, ID mid, int argc, const VALUE *argv);

/**
 * Identical  to rb_funcallv_passing_block(),  except  you can  specify how  to
 * handle  the last  element of  the given  array.  It  can also  be seen  as a
 * routine identical to rb_funcallv_public_kw(), except you can pass the passed
 * block.
 *
 * @param[in,out]  recv               Receiver of the method.
 * @param[in]      mid                Name of the method to call.
 * @param[in]      argc               Number of arguments.
 * @param[in]      argv               Arbitrary number of method arguments.
 * @param[in]      kw_splat           Handling of keyword parameters:
 *   - RB_NO_KEYWORDS           `argv`'s last is not a keyword argument.
 *   - RB_PASS_KEYWORDS         `argv`'s last is a keyword argument.
 *   - RB_PASS_CALLED_KEYWORDS  it depends if there is a passed block.
 * @exception      rb_eNoMethodError  No such method.
 * @exception      rb_eNoMethodError  The method is private or protected.
 * @exception      rb_eException      Any exceptions happen inside.
 * @return         What the method evaluates to.
 */
VALUE rb_funcall_passing_block_kw(VALUE recv, ID mid, int argc, const VALUE *argv, int kw_splat);

/**
 * Identical to  rb_funcallv_public(), except  you can pass  a block.   A block
 * here  basically is  an  instance of  ::rb_cProc.  If  you  want to  exercise
 * `to_proc` conversion, do so before passing it here.  However nil and symbols
 * are special-case allowed.
 *
 * @param[in,out]  recv               Receiver of the method.
 * @param[in]      mid                Name of the method to call.
 * @param[in]      argc               Number of arguments.
 * @param[in]      argv               Arbitrary number of method arguments.
 * @param[in]      procval            An instance of Proc, Symbol, or NilClass.
 * @exception      rb_eNoMethodError  No such method.
 * @exception      rb_eNoMethodError  The method is private or protected.
 * @exception      rb_eException      Any exceptions happen inside.
 * @return         What the method evaluates to.
 *
 * @internal
 *
 * Implementation-wise, `procval`  is in  fact a  "block handler"  object.  You
 * could also pass an IFUNC (block_handler_ifunc) here to say precise.  --- But
 * AFAIK there is no  3rd party way to even know that  there are objects called
 * IFUNC behind-the-scene.
 */
VALUE rb_funcall_with_block(VALUE recv, ID mid, int argc, const VALUE *argv, VALUE procval);

/**
 * Identical to rb_funcallv_with_block(), except you  can specify how to handle
 * the last  element of  the given  array.  It can  also be  seen as  a routine
 * identical to rb_funcallv_public_kw(), except you can pass a block.
 *
 * @param[in,out]  recv               Receiver of the method.
 * @param[in]      mid                Name of the method to call.
 * @param[in]      argc               Number of arguments.
 * @param[in]      argv               Arbitrary number of method arguments.
 * @param[in]      procval            An instance of Proc, Symbol, or NilClass.
 * @param[in]      kw_splat           Handling of keyword parameters:
 *   - RB_NO_KEYWORDS           `argv`'s last is not a keyword argument.
 *   - RB_PASS_KEYWORDS         `argv`'s last is a keyword argument.
 *   - RB_PASS_CALLED_KEYWORDS  it depends if there is a passed block.
 * @exception      rb_eNoMethodError  No such method.
 * @exception      rb_eNoMethodError  The method is private or protected.
 * @exception      rb_eException      Any exceptions happen inside.
 * @return         What the method evaluates to.
 */
VALUE rb_funcall_with_block_kw(VALUE recv, ID mid, int argc, const VALUE *argv, VALUE procval, int kw_splat);

/**
 * This resembles ruby's `super`.
 *
 * @param[in]  argc               Number of arguments.
 * @param[in]  argv               Arbitrary number of method arguments.
 * @exception  rb_eNoMethodError  No super method are there.
 * @exception  rb_eException      Any exceptions happen inside.
 * @return     What the super method evaluates to.
 */
VALUE rb_call_super(int argc, const VALUE *argv);

/**
 * Identical to rb_call_super(), except you can  specify how to handle the last
 * element of the given array.
 *
 * @param[in]  argc               Number of arguments.
 * @param[in]  argv               Arbitrary number of method arguments.
 * @param[in]  kw_splat           Handling of keyword parameters:
 *   - RB_NO_KEYWORDS           `argv`'s last is not a keyword argument.
 *   - RB_PASS_KEYWORDS         `argv`'s last is a keyword argument.
 *   - RB_PASS_CALLED_KEYWORDS  it depends if there is a passed block.
 * @exception  rb_eNoMethodError  No super method are there.
 * @exception  rb_eException      Any exceptions happen inside.
 * @return     What the super method evaluates to.
 */
VALUE rb_call_super_kw(int argc, const VALUE *argv, int kw_splat);

/**
 * This resembles ruby's `self`.
 *
 * @exception  rb_eRuntimeError  Called from outside of method context.
 * @return     Current receiver.
 */
VALUE rb_current_receiver(void);

RBIMPL_ATTR_NONNULL((2))
/**
 * Keyword argument deconstructor.
 *
 * Retrieves argument values bound to  keywords, which directed by `table` into
 * `values`,  deleting retrieved  entries  from `keyword_hash`  along the  way.
 * First  `required` number  of  IDs  referred by  `table`  are mandatory,  and
 * succeeding `optional`  (`-optional-1` if  `optional` is negative)  number of
 * IDs are  optional.  If a mandatory  key is not contained  in `keyword_hash`,
 * raises ::rb_eArgError.  If an optional key is not present in `keyword_hash`,
 * the  corresponding  element  in  `values`   is  set  to  ::RUBY_Qundef.   If
 * `optional` is negative, rest of `keyword_hash` are ignored, otherwise raises
 * ::rb_eArgError.
 *
 * @warning     Handling keyword arguments in the  C API is less efficient than
 *              handling them  in Ruby.  Consider  using a Ruby  wrapper method
 *              around a non-keyword C function.
 * @see         https://bugs.ruby-lang.org/issues/11339
 * @param[out]  keyword_hash  Target hash to deconstruct.
 * @param[in]   table         List of keywords that you are interested in.
 * @param[in]   required      Number of mandatory keywords.
 * @param[in]   optional      Number of optional keywords (can be negative).
 * @param[out]  values        Buffer to be filled.
 * @exception   rb_eArgError  Absence of a mandatory keyword.
 * @exception   rb_eArgError  Found an unknown keyword.
 * @return      Number of found values that are stored into `values`.
 */
int rb_get_kwargs(VALUE keyword_hash, const ID *table, int required, int optional, VALUE *values);

RBIMPL_ATTR_NONNULL(())
/**
 * Splits a hash into two.
 *
 * Takes  a hash  of various  keys, and  split it  into symbol-keyed  parts and
 * others.   Symbol-keyed part  becomes  the return  value.   What remains  are
 * returned as a new hash object stored at the argument pointer.
 *
 * @param[in,out]  orighash  Pointer to a target hash to split.
 * @return         An extracted keyword hash.
 * @post           Upon  successful return  `orighash` points  to another  hash
 *                 object, whose contents are the remainder of the operation.
 * @note           The argument hash object is not modified.
 */
VALUE rb_extract_keywords(VALUE *orighash);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_EVAL_H */
PK       ! U/  /    ruby/internal/special_consts.hnu [        #ifndef RBIMPL_SPECIAL_CONSTS_H                      /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_SPECIAL_CONSTS_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines enum ::ruby_special_consts.
 * @see        Sasada,  K.,  "A  Lightweight Representation  of  Floating-Point
 *             Numbers  on  Ruby Interpreter",  in  proceedings  of 10th  JSSST
 *             SIGPPL  Workshop   on  Programming  and   Programming  Languages
 *             (PPL2008), pp. 9-16, 2008.
 */
#include "ruby/internal/attr/artificial.h"
#include "ruby/internal/attr/const.h"
#include "ruby/internal/attr/constexpr.h"
#include "ruby/internal/attr/enum_extensibility.h"
#include "ruby/internal/stdbool.h"
#include "ruby/internal/value.h"

/**
 * @private
 * @warning  Do not touch this macro.
 * @warning  It is an implementation detail.
 * @warning  The  value of  this  macro  must match  for  ruby  itself and  all
 *           extension  libraries, otherwise  serious  memory corruption  shall
 *           occur.
 */
#if defined(USE_FLONUM)
# /* Take that. */
#elif SIZEOF_VALUE >= SIZEOF_DOUBLE
# define USE_FLONUM 1
#else
# define USE_FLONUM 0
#endif

/** This is an old name of #RB_TEST.  Not sure which name is preferred. */
#define RTEST           RB_TEST

#define FIXNUM_P        RB_FIXNUM_P            /**< @old{RB_FIXNUM_P} */
#define IMMEDIATE_P     RB_IMMEDIATE_P         /**< @old{RB_IMMEDIATE_P} */
#define NIL_P           RB_NIL_P               /**< @old{RB_NIL_P} */
#define SPECIAL_CONST_P RB_SPECIAL_CONST_P     /**< @old{RB_SPECIAL_CONST_P} */
#define STATIC_SYM_P    RB_STATIC_SYM_P        /**< @old{RB_STATIC_SYM_P} */

#define Qfalse          RUBY_Qfalse            /**< @old{RUBY_Qfalse} */
#define Qnil            RUBY_Qnil              /**< @old{RUBY_Qnil} */
#define Qtrue           RUBY_Qtrue             /**< @old{RUBY_Qtrue} */
#define Qundef          RUBY_Qundef            /**< @old{RUBY_Qundef} */

#define FIXNUM_FLAG        RUBY_FIXNUM_FLAG    /**< @old{RUBY_FIXNUM_FLAG} */
#define FLONUM_FLAG        RUBY_FLONUM_FLAG    /**< @old{RUBY_FLONUM_FLAG} */
#define FLONUM_MASK        RUBY_FLONUM_MASK    /**< @old{RUBY_FLONUM_MASK} */
#define FLONUM_P           RB_FLONUM_P         /**< @old{RB_FLONUM_P} */
#define IMMEDIATE_MASK     RUBY_IMMEDIATE_MASK /**< @old{RUBY_IMMEDIATE_MASK} */
#define SYMBOL_FLAG        RUBY_SYMBOL_FLAG    /**< @old{RUBY_SYMBOL_FLAG} */

/** @cond INTERNAL_MACRO */
#define RB_FIXNUM_P        RB_FIXNUM_P
#define RB_FLONUM_P        RB_FLONUM_P
#define RB_IMMEDIATE_P     RB_IMMEDIATE_P
#define RB_NIL_P           RB_NIL_P
#define RB_SPECIAL_CONST_P RB_SPECIAL_CONST_P
#define RB_STATIC_SYM_P    RB_STATIC_SYM_P
#define RB_TEST            RB_TEST
#define RB_UNDEF_P         RB_UNDEF_P
#define RB_NIL_OR_UNDEF_P  RB_NIL_OR_UNDEF_P
/** @endcond */

/** special constants - i.e. non-zero and non-fixnum constants */
enum
RBIMPL_ATTR_ENUM_EXTENSIBILITY(closed)
ruby_special_consts {
#if defined(__DOXYGEN__)
    RUBY_Qfalse,                /**< @see ::rb_cFalseClass */
    RUBY_Qtrue,                 /**< @see ::rb_cTrueClass */
    RUBY_Qnil,                  /**< @see ::rb_cNilClass */
    RUBY_Qundef,                /**< Represents so-called undef. */
    RUBY_IMMEDIATE_MASK,        /**< Bit mask detecting special consts. */
    RUBY_FIXNUM_FLAG,           /**< Flag to denote a fixnum. */
    RUBY_FLONUM_MASK,           /**< Bit mask detecting a flonum. */
    RUBY_FLONUM_FLAG,           /**< Flag to denote a flonum. */
    RUBY_SYMBOL_FLAG,           /**< Flag to denote a static symbol. */
#elif USE_FLONUM
    RUBY_Qfalse         = 0x00, /* ...0000 0000 */
    RUBY_Qnil           = 0x04, /* ...0000 0100 */
    RUBY_Qtrue          = 0x14, /* ...0001 0100 */
    RUBY_Qundef         = 0x24, /* ...0010 0100 */
    RUBY_IMMEDIATE_MASK = 0x07, /* ...0000 0111 */
    RUBY_FIXNUM_FLAG    = 0x01, /* ...xxxx xxx1 */
    RUBY_FLONUM_MASK    = 0x03, /* ...0000 0011 */
    RUBY_FLONUM_FLAG    = 0x02, /* ...xxxx xx10 */
    RUBY_SYMBOL_FLAG    = 0x0c, /* ...xxxx 1100 */
#else
    RUBY_Qfalse         = 0x00, /* ...0000 0000 */
    RUBY_Qnil           = 0x02, /* ...0000 0010 */
    RUBY_Qtrue          = 0x06, /* ...0000 0110 */
    RUBY_Qundef         = 0x0a, /* ...0000 1010 */
    RUBY_IMMEDIATE_MASK = 0x03, /* ...0000 0011 */
    RUBY_FIXNUM_FLAG    = 0x01, /* ...xxxx xxx1 */
    RUBY_FLONUM_MASK    = 0x00, /* any values ANDed with FLONUM_MASK cannot be FLONUM_FLAG */
    RUBY_FLONUM_FLAG    = 0x02, /* ...0000 0010 */
    RUBY_SYMBOL_FLAG    = 0x0e, /* ...xxxx 1110 */
#endif

    RUBY_SPECIAL_SHIFT  = 8 /**< Least significant 8 bits are reserved. */
};

RBIMPL_ATTR_CONST()
RBIMPL_ATTR_CONSTEXPR(CXX11)
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Emulates Ruby's "if" statement.
 *
 * @param[in]  obj    An arbitrary ruby object.
 * @retval     false  `obj` is either ::RUBY_Qfalse or ::RUBY_Qnil.
 * @retval     true   Anything else.
 *
 * @internal
 *
 * It HAS to be `__attribute__((const))` in  order for clang to properly deduce
 * `__builtin_assume()`.
 */
static inline bool
RB_TEST(VALUE obj)
{
    /*
     * if USE_FLONUM
     *  Qfalse:  ....0000 0000
     *  Qnil:    ....0000 0100
     * ~Qnil:    ....1111 1011
     *  v        ....xxxx xxxx
     * ----------------------------
     *  RTEST(v) ....xxxx x0xx
     *
     * if ! USE_FLONUM
     *  Qfalse:  ....0000 0000
     *  Qnil:    ....0000 0010
     * ~Qnil:    ....1111 1101
     *  v        ....xxxx xxxx
     * ----------------------------
     *  RTEST(v) ....xxxx xx0x
     *
     *  RTEST(v) can be 0 if and only if (v == Qfalse || v == Qnil).
     */
    return obj & ~RUBY_Qnil;
}

RBIMPL_ATTR_CONST()
RBIMPL_ATTR_CONSTEXPR(CXX11)
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Checks if the given object is nil.
 *
 * @param[in]  obj    An arbitrary ruby object.
 * @retval     true   `obj` is ::RUBY_Qnil.
 * @retval     false  Anything else.
 */
static inline bool
RB_NIL_P(VALUE obj)
{
    return obj == RUBY_Qnil;
}

RBIMPL_ATTR_CONST()
RBIMPL_ATTR_CONSTEXPR(CXX11)
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Checks if the given object is undef.
 *
 * @param[in]  obj    An arbitrary ruby object.
 * @retval     true   `obj` is ::RUBY_Qundef.
 * @retval     false  Anything else.
 */
static inline bool
RB_UNDEF_P(VALUE obj)
{
    return obj == RUBY_Qundef;
}

RBIMPL_ATTR_CONST()
RBIMPL_ATTR_CONSTEXPR(CXX14)
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Checks if the given object is nil or undef.  Can be used to see if
 * a keyword argument is not given or given `nil`.
 *
 * @param[in]  obj    An arbitrary ruby object.
 * @retval     true   `obj` is ::RUBY_Qnil or ::RUBY_Qundef.
 * @retval     false  Anything else.
 */
static inline bool
RB_NIL_OR_UNDEF_P(VALUE obj)
{
    /*
     * if USE_FLONUM
     *  Qundef:       ....0010 0100
     *  Qnil:         ....0000 0100
     *  mask:         ....1101 1111
     *  common_bits:  ....0000 0100
     * ---------------------------------
     *  Qnil & mask   ....0000 0100
     *  Qundef & mask ....0000 0100
     *
     * if ! USE_FLONUM
     *  Qundef:       ....0000 1010
     *  Qnil:         ....0000 0010
     *  mask:         ....1111 0111
     *  common_bits:  ....0000 0010
     * ----------------------------
     *  Qnil & mask   ....0000 0010
     *  Qundef & mask ....0000 0010
     *
     *  NIL_OR_UNDEF_P(v) can be true only when v is Qundef or Qnil.
     */
    const VALUE mask = ~(RUBY_Qundef ^ RUBY_Qnil);
    const VALUE common_bits = RUBY_Qundef & RUBY_Qnil;
    return (obj & mask) == common_bits;
}

RBIMPL_ATTR_CONST()
RBIMPL_ATTR_CONSTEXPR(CXX11)
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Checks if the given object is a so-called Fixnum.
 *
 * @param[in]  obj    An arbitrary ruby object.
 * @retval     true   `obj` is a Fixnum.
 * @retval     false  Anything else.
 * @note       Fixnum was  a thing  in the  20th century, but  it is  rather an
 *             implementation detail today.
 */
static inline bool
RB_FIXNUM_P(VALUE obj)
{
    return obj & RUBY_FIXNUM_FLAG;
}

RBIMPL_ATTR_CONST()
RBIMPL_ATTR_CONSTEXPR(CXX14)
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Checks if the given object is a static symbol.
 *
 * @param[in]  obj    An arbitrary ruby object.
 * @retval     true   `obj` is a static symbol
 * @retval     false  Anything else.
 * @see        RB_DYNAMIC_SYM_P()
 * @see        RB_SYMBOL_P()
 * @note       These days  there are static  and dynamic symbols, just  like we
 *             once had Fixnum/Bignum back in the old days.
 */
static inline bool
RB_STATIC_SYM_P(VALUE obj)
{
    RBIMPL_ATTR_CONSTEXPR(CXX14)
    const VALUE mask = ~(RBIMPL_VALUE_FULL << RUBY_SPECIAL_SHIFT);
    return (obj & mask) == RUBY_SYMBOL_FLAG;
}

RBIMPL_ATTR_CONST()
RBIMPL_ATTR_CONSTEXPR(CXX11)
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Checks if the given object is a so-called Flonum.
 *
 * @param[in]  obj    An arbitrary ruby object.
 * @retval     true   `obj` is a Flonum.
 * @retval     false  Anything else.
 * @see        RB_FLOAT_TYPE_P()
 * @note       These days there are Flonums and non-Flonum floats, just like we
 *             once had Fixnum/Bignum back in the old days.
 */
static inline bool
RB_FLONUM_P(VALUE obj)
{
#if USE_FLONUM
    return (obj & RUBY_FLONUM_MASK) == RUBY_FLONUM_FLAG;
#else
    return false;
#endif
}

RBIMPL_ATTR_CONST()
RBIMPL_ATTR_CONSTEXPR(CXX11)
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Checks if  the given  object is  an immediate  i.e. an  object which  has no
 * corresponding storage inside of the object space.
 *
 * @param[in]  obj    An arbitrary ruby object.
 * @retval     true   `obj` is a Flonum.
 * @retval     false  Anything else.
 * @see        RB_FLOAT_TYPE_P()
 * @note       The concept of "immediate" is purely C specific.
 */
static inline bool
RB_IMMEDIATE_P(VALUE obj)
{
    return obj & RUBY_IMMEDIATE_MASK;
}

RBIMPL_ATTR_CONST()
RBIMPL_ATTR_CONSTEXPR(CXX11)
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Checks if the given object is of enum ::ruby_special_consts.
 *
 * @param[in]  obj    An arbitrary ruby object.
 * @retval     true   `obj` is a special constant.
 * @retval     false  Anything else.
 */
static inline bool
RB_SPECIAL_CONST_P(VALUE obj)
{
    return RB_IMMEDIATE_P(obj) || obj == RUBY_Qfalse;
}

RBIMPL_ATTR_CONST()
RBIMPL_ATTR_CONSTEXPR(CXX11)
/**
 * Identical to RB_SPECIAL_CONST_P, except it returns a ::VALUE.
 *
 * @param[in]  obj          An arbitrary ruby object.
 * @retval     RUBY_Qtrue   `obj` is a special constant.
 * @retval     RUBY_Qfalse  Anything else.
 *
 * @internal
 *
 * This  function is  to mimic  old  rb_special_const_p macro  but have  anyone
 * actually used its return value?  Wasn't it just something no one needed?
 */
static inline VALUE
rb_special_const_p(VALUE obj)
{
    return RB_SPECIAL_CONST_P(obj) * RUBY_Qtrue;
}

/**
 * @cond INTERNAL_MACRO
 * See [ruby-dev:27513] for the following macros.
 */
#define RUBY_Qfalse RBIMPL_CAST((VALUE)RUBY_Qfalse)
#define RUBY_Qtrue  RBIMPL_CAST((VALUE)RUBY_Qtrue)
#define RUBY_Qnil   RBIMPL_CAST((VALUE)RUBY_Qnil)
#define RUBY_Qundef RBIMPL_CAST((VALUE)RUBY_Qundef)
/** @endcond */

#endif /* RBIMPL_SPECIAL_CONSTS_H */
PK       ! ʻO  O    ruby/internal/event.hnu [        #ifndef RBIMPL_EVENT_H                               /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_EVENT_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Debugging and tracing APIs.
 */
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"

/* These macros are not enums because they are wider than int.*/

/**
 * @name Traditional set_trace_func events
 *
 * @{
 */
#define RUBY_EVENT_NONE      0x0000 /**< No events. */
#define RUBY_EVENT_LINE      0x0001 /**< Encountered a new line. */
#define RUBY_EVENT_CLASS     0x0002 /**< Encountered a new class. */
#define RUBY_EVENT_END       0x0004 /**< Encountered an end of a class clause. */
#define RUBY_EVENT_CALL      0x0008 /**< A method, written in Ruby, is called. */
#define RUBY_EVENT_RETURN    0x0010 /**< Encountered a `return` statement. */
#define RUBY_EVENT_C_CALL    0x0020 /**< A method, written in C, is called. */
#define RUBY_EVENT_C_RETURN  0x0040 /**< Return from a method, written in C. */
#define RUBY_EVENT_RAISE     0x0080 /**< Encountered a `raise` statement. */
#define RUBY_EVENT_ALL       0x00ff /**< Bitmask of traditional events. */

/** @} */

/**
 * @name TracePoint extended events
 *
 * @{
 */
#define RUBY_EVENT_B_CALL            0x0100 /**< Encountered an `yield` statement. */
#define RUBY_EVENT_B_RETURN          0x0200 /**< Encountered a `next` statement. */
#define RUBY_EVENT_THREAD_BEGIN      0x0400 /**< Encountered a new thread. */
#define RUBY_EVENT_THREAD_END        0x0800 /**< Encountered an end of a thread. */
#define RUBY_EVENT_FIBER_SWITCH      0x1000 /**< Encountered a `Fiber#yield`. */
#define RUBY_EVENT_SCRIPT_COMPILED   0x2000 /**< Encountered an `eval`. */
#define RUBY_EVENT_TRACEPOINT_ALL    0xffff /**< Bitmask of extended events. */

/** @} */

/**
 * @name Special events
 *
 * @internal
 *
 * These bits are actually used internally.  See vm_core.h if you are curious.
 *
 * @endinternal
 *
 * @{
 */
#define RUBY_EVENT_RESERVED_FOR_INTERNAL_USE 0x030000 /**< Opaque bits. */

/** @} */

/**
 * @name Internal events
 *
 * @shyouhei's understanding  is that some  of them are visible  from extension
 * libraries because  of `ext/objspace`.   But it  seems that  doesn't describe
 * everything?  The ultimate reason why they are here remains unclear.
 *
 * @{
 */
#define RUBY_INTERNAL_EVENT_SWITCH          0x040000 /**< Thread switched. */
#define RUBY_EVENT_SWITCH                   0x040000 /**< @old{RUBY_INTERNAL_EVENT_SWITCH} */
                                         /* 0x080000 */
#define RUBY_INTERNAL_EVENT_NEWOBJ          0x100000 /**< Object allocated. */
#define RUBY_INTERNAL_EVENT_FREEOBJ         0x200000 /**< Object swept. */
#define RUBY_INTERNAL_EVENT_GC_START        0x400000 /**< GC started. */
#define RUBY_INTERNAL_EVENT_GC_END_MARK     0x800000 /**< GC ended mark phase. */
#define RUBY_INTERNAL_EVENT_GC_END_SWEEP   0x1000000 /**< GC ended sweep phase. */
#define RUBY_INTERNAL_EVENT_GC_ENTER       0x2000000 /**< `gc_enter()` is called. */
#define RUBY_INTERNAL_EVENT_GC_EXIT        0x4000000 /**< `gc_exit()` is called. */
#define RUBY_INTERNAL_EVENT_OBJSPACE_MASK  0x7f00000 /**< Bitmask of GC events. */
#define RUBY_INTERNAL_EVENT_MASK          0xffff0000 /**< Bitmask of internal events. */

/** @} */

/**
 * Represents event(s).  As the name implies events are bit flags.
 */
typedef uint32_t rb_event_flag_t;

/**
 * Type of event hooks.  When an  event happens registered functions are kicked
 * with appropriate parameters.
 *
 * @param[in]  evflag  The kind of event that happened.
 * @param[in]  data    The `data` passed to rb_add_event_hook().
 * @param[in]  self    Current receiver.
 * @param[in]  mid     Name of the current method.
 * @param[in]  klass   Current class.
 */
typedef void (*rb_event_hook_func_t)(rb_event_flag_t evflag, VALUE data, VALUE self, ID mid, VALUE klass);

/**
 * @private
 *
 * @deprecated  This macro once was a thing in the old days, but makes no sense
 *              any  longer today.   Exists  here  for backwards  compatibility
 *              only.  You can safely forget about it.
 */
#define RB_EVENT_HOOKS_HAVE_CALLBACK_DATA 1

RBIMPL_SYMBOL_EXPORT_BEGIN()

/**
 * Registers an event hook function.
 *
 * @param[in]  func    A callback.
 * @param[in]  events  A set of events that `func` should run.
 * @param[in]  data    Passed as-is to `func`.
 */
void rb_add_event_hook(rb_event_hook_func_t func, rb_event_flag_t events, VALUE data);

/**
 * Removes the passed function from the list of event hooks.
 *
 * @param[in]  func  A callback.
 * @return     Number of deleted event hooks.
 * @note       As  multiple  events can  share  the  same  `func` it  is  quite
 *             possible for the return value to become more than one.
 *
 * @internal
 *
 * @shyouhei doesn't know if this is an  Easter egg or an official feature, but
 * you can pass 0 to the argument.  That effectively swipes everything out from
 * the hook list.
 */
int rb_remove_event_hook(rb_event_hook_func_t func);
RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_EVENT_H */
PK       ! j(ݏ      ruby/internal/static_assert.hnu [        #ifndef RBIMPL_STATIC_ASSERT_H                       /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_STATIC_ASSERT_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_STATIC_ASSERT.
 */
#include <assert.h>
#include "ruby/internal/has/extension.h"
#include "ruby/internal/compiler_since.h"

/** @cond INTERNAL_MACRO */
#if defined(__cplusplus) && defined(__cpp_static_assert)
# /* https://isocpp.org/std/standing-documents/sd-6-sg10-feature-test-recommendations */
# define RBIMPL_STATIC_ASSERT0 static_assert

#elif defined(__cplusplus) && RBIMPL_COMPILER_SINCE(MSVC, 16, 0, 0)
# define RBIMPL_STATIC_ASSERT0 static_assert

#elif defined(__INTEL_CXX11_MODE__)
# define RBIMPL_STATIC_ASSERT0 static_assert

#elif defined(__cplusplus) && __cplusplus >= 201103L
# define RBIMPL_STATIC_ASSERT0 static_assert

#elif defined(__cplusplus) && RBIMPL_HAS_EXTENSION(cxx_static_assert)
# define RBIMPL_STATIC_ASSERT0 __extension__ static_assert

#elif defined(__GXX_EXPERIMENTAL_CXX0X__) && __GXX_EXPERIMENTAL_CXX0X__
# define RBIMPL_STATIC_ASSERT0 __extension__ static_assert

#elif defined(__STDC_VERSION__) && RBIMPL_HAS_EXTENSION(c_static_assert)
# define RBIMPL_STATIC_ASSERT0 __extension__ _Static_assert

#elif defined(__STDC_VERSION__) && RBIMPL_COMPILER_SINCE(GCC, 4, 6, 0)
# define RBIMPL_STATIC_ASSERT0 __extension__ _Static_assert

#elif defined(static_assert)
# /* Take <assert.h> definition */
# define RBIMPL_STATIC_ASSERT0 static_assert
#endif
/** @endcond */

/**
 * @brief  Wraps (or simulates) `static_assert`
 * @param  name  Valid C/C++ identifier, describing the assertion.
 * @param  expr  Expression to assert.
 * @note   `name` shall not be a string literal.
 */
#if defined(__DOXYGEN__)
# define RBIMPL_STATIC_ASSERT static_assert

#elif defined(RBIMPL_STATIC_ASSERT0)
# define RBIMPL_STATIC_ASSERT(name, expr) \
    RBIMPL_STATIC_ASSERT0(expr, # name ": " # expr)

#else
# define RBIMPL_STATIC_ASSERT(name, expr) \
    typedef int static_assert_ ## name ## _check[1 - 2 * !(expr)]
#endif

#endif /* RBIMPL_STATIC_ASSERT_H */
PK       ! BN      ruby/internal/stdbool.hnu [        #ifndef RBIMPL_STDBOOL_H                             /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_STDBOOL_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      C99 shim for <stdbool.h>
 */
#include "ruby/internal/config.h"

#if defined(__bool_true_false_are_defined)
# /* Take that. */

#elif defined(__cplusplus)
# /* bool is a keyword in C++. */
# if defined(HAVE_STDBOOL_H) && (__cplusplus >= 201103L)
#  include <cstdbool>
# endif
#
# ifndef __bool_true_false_are_defined
#  define __bool_true_false_are_defined
# endif

#elif defined(HAVE_STDBOOL_H)
# /* Take stdbool.h definition. */
# include <stdbool.h>

#elif !defined(HAVE__BOOL)
typedef unsigned char _Bool;
# /* See also http://www.open-std.org/jtc1/sc22/wg14/www/docs/n2229.htm */
# define bool  _Bool
# define true  ((_Bool)+1)
# define false ((_Bool)+0)
# define __bool_true_false_are_defined
#endif

#endif /* RBIMPL_STDBOOL_H */
PK       ! H	  	  !  ruby/internal/compiler_is/intel.hnu [        #ifndef RBIMPL_COMPILER_IS_INTEL_H                   /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_COMPILER_IS_INTEL_H
/**
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines RBIMPL_COMPILER_IS_Intel.
 */
#if ! defined(__INTEL_COMPILER)
# define RBIMPL_COMPILER_IS_Intel 0

#elif ! defined(__INTEL_COMPILER_UPDATE)
# define RBIMPL_COMPILER_IS_Intel 1
# /* __INTEL_COMPILER = XXYZ */
# define RBIMPL_COMPILER_VERSION_MAJOR (__INTEL_COMPILER / 100)
# define RBIMPL_COMPILER_VERSION_MINOR (__INTEL_COMPILER % 100 / 10)
# define RBIMPL_COMPILER_VERSION_PATCH (__INTEL_COMPILER       % 10)

#else
# define RBIMPL_COMPILER_IS_Intel 1
# /* __INTEL_COMPILER = XXYZ */
# define RBIMPL_COMPILER_VERSION_MAJOR (__INTEL_COMPILER / 100)
# define RBIMPL_COMPILER_VERSION_MINOR (__INTEL_COMPILER % 100 / 10)
# define RBIMPL_COMPILER_VERSION_PATCH __INTEL_COMPILER_UPDATE
#endif

#endif /* RBIMPL_COMPILER_IS_INTEL_H */
PK       ! (]hF    !  ruby/internal/compiler_is/apple.hnu [        #ifndef RBIMPL_COMPILER_IS_APPLE_H                   /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_COMPILER_IS_APPLE_H
/**
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines RBIMPL_COMPILER_IS_Apple.
 *
 * Apple  ships clang.   Problem is,  its  `__clang_major__` etc.  are not  the
 * upstream LLVM  version, but XCode's.  We  have to think Apple's  is distinct
 * from LLVM's,  when it comes  to compiler  detection business in  this header
 * file.
 */
#if ! defined(__clang__)
# define RBIMPL_COMPILER_IS_Apple 0

#elif ! defined(__apple_build_version__)
# define RBIMPL_COMPILER_IS_Apple 0

#else
# define RBIMPL_COMPILER_IS_Apple 1
# define RBIMPL_COMPILER_VERSION_MAJOR __clang_major__
# define RBIMPL_COMPILER_VERSION_MINOR __clang_minor__
# define RBIMPL_COMPILER_VERSION_PATCH __clang_patchlevel__
#endif

#endif /* RBIMPL_COMPILER_IS_APPLE_H */
PK       ! 
	  	     ruby/internal/compiler_is/msvc.hnu [        #ifndef RBIMPL_COMPILER_IS_MSVC_H                    /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_COMPILER_IS_MSVC_H
/**
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines RBIMPL_COMPILER_IS_MSVC.
 */
#include "ruby/internal/compiler_is/clang.h"
#include "ruby/internal/compiler_is/intel.h"

#if ! defined(_MSC_VER)
# define RBIMPL_COMPILER_IS_MSVC 0

#elif RBIMPL_COMPILER_IS(Clang)
# define RBIMPL_COMPILER_IS_MSVC 0

#elif RBIMPL_COMPILER_IS(Intel)
# define RBIMPL_COMPILER_IS_MSVC 0

#elif _MSC_VER >= 1400
# define RBIMPL_COMPILER_IS_MSVC 1
# /* _MSC_FULL_VER = XXYYZZZZZ */
# define RBIMPL_COMPILER_VERSION_MAJOR (_MSC_FULL_VER / 10000000)
# define RBIMPL_COMPILER_VERSION_MINOR (_MSC_FULL_VER % 10000000 / 100000)
# define RBIMPL_COMPILER_VERSION_PATCH (_MSC_FULL_VER            % 100000)

#elif defined(_MSC_FULL_VER)
# define RBIMPL_COMPILER_IS_MSVC 1
# /* _MSC_FULL_VER = XXYYZZZZ */
# define RBIMPL_COMPILER_VERSION_MAJOR (_MSC_FULL_VER / 1000000)
# define RBIMPL_COMPILER_VERSION_MINOR (_MSC_FULL_VER % 1000000 / 10000)
# define RBIMPL_COMPILER_VERSION_PATCH (_MSC_FULL_VER           % 10000)

#else
# define RBIMPL_COMPILER_IS_MSVC 1
# /* _MSC_VER = XXYY */
# define RBIMPL_COMPILER_VERSION_MAJOR (_MSC_VER / 100)
# define RBIMPL_COMPILER_VERSION_MINOR (_MSC_VER % 100)
# define RBIMPL_COMPILER_VERSION_PATCH 0
#endif

#endif /* RBIMPL_COMPILER_IS_MSVC_H */
PK       ! pq=    !  ruby/internal/compiler_is/clang.hnu [        #ifndef RBIMPL_COMPILER_IS_CLANG_H                   /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_COMPILER_IS_CLANG_H
/**
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines RBIMPL_COMPILER_IS_Clang.
 */
#include "ruby/internal/compiler_is/apple.h"

#if ! defined(__clang__)
# define RBIMPL_COMPILER_IS_Clang 0

#elif RBIMPL_COMPILER_IS(Apple)
# define RBIMPL_COMPILER_IS_Clang 0

#else
# define RBIMPL_COMPILER_IS_Clang 1
# define RBIMPL_COMPILER_VERSION_MAJOR __clang_major__
# define RBIMPL_COMPILER_VERSION_MINOR __clang_minor__
# define RBIMPL_COMPILER_VERSION_PATCH __clang_patchlevel__
#endif

#endif /* RBIMPL_COMPILER_IS_CLANG_H */
PK       ! 
  
  "  ruby/internal/compiler_is/sunpro.hnu [        #ifndef RBIMPL_COMPILER_IS_SUNPRO_H                  /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_COMPILER_IS_SUNPRO_H
/**
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines RBIMPL_COMPILER_IS_SunPro.
 */
#if ! (defined(__SUNPRO_C) || defined(__SUNPRO_CC))
# define RBIMPL_COMPILER_IS_SunPro 0

#elif defined(__SUNPRO_C) && __SUNPRO_C >= 0x5100
# define RBIMPL_COMPILER_IS_SunPro 1
# /* __SUNPRO_C = 0xXYYZ */
# define RBIMPL_COMPILER_VERSION_MAJOR  (__SUNPRO_C >> 12)
# define RBIMPL_COMPILER_VERSION_MINOR ((__SUNPRO_C >> 8 & 0xF) * 10 + (__SUNPRO_C >> 4 & 0xF))
# define RBIMPL_COMPILER_VERSION_PATCH  (__SUNPRO_C      & 0xF)

#elif defined(__SUNPRO_CC) && __SUNPRO_CC >= 0x5100
# define RBIMPL_COMPILER_IS_SunPro 1
# /* __SUNPRO_CC = 0xXYYZ */
# define RBIMPL_COMPILER_VERSION_MAJOR  (__SUNPRO_CC >> 12)
# define RBIMPL_COMPILER_VERSION_MINOR ((__SUNPRO_CC >> 8 & 0xF) * 10 + (__SUNPRO_CC >> 4 & 0xF))
# define RBIMPL_COMPILER_VERSION_PATCH  (__SUNPRO_CC      & 0xF)

#elif defined(__SUNPRO_C)
# define RBIMPL_COMPILER_IS_SunPro 1
# /* __SUNPRO_C = 0xXYZ */
# define RBIMPL_COMPILER_VERSION_MAJOR (__SUNPRO_C >> 8)
# define RBIMPL_COMPILER_VERSION_MINOR (__SUNPRO_C >> 4 & 0xF)
# define RBIMPL_COMPILER_VERSION_PATCH (__SUNPRO_C      & 0xF)

#else
# define RBIMPL_COMPILER_IS_SunPro 1
# /* __SUNPRO_CC = 0xXYZ */
# define RBIMPL_COMPILER_VERSION_MAJOR (__SUNPRO_CC >> 8)
# define RBIMPL_COMPILER_VERSION_MINOR (__SUNPRO_CC >> 4 & 0xF)
# define RBIMPL_COMPILER_VERSION_PATCH (__SUNPRO_CC      & 0xF)
#endif

#endif /* RBIMPL_COMPILER_IS_SUNPRO_H */
PK       ! ,      ruby/internal/compiler_is/gcc.hnu [        #ifndef RBIMPL_COMPILER_IS_GCC_H                     /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_COMPILER_IS_GCC_H
/**
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines RBIMPL_COMPILER_IS_GCC.
 */
#include "ruby/internal/compiler_is/apple.h"
#include "ruby/internal/compiler_is/clang.h"
#include "ruby/internal/compiler_is/intel.h"

#if ! defined(__GNUC__)
# define RBIMPL_COMPILER_IS_GCC 0

#elif RBIMPL_COMPILER_IS(Apple)
# define RBIMPL_COMPILER_IS_GCC 0

#elif RBIMPL_COMPILER_IS(Clang)
# define RBIMPL_COMPILER_IS_GCC 0

#elif RBIMPL_COMPILER_IS(Intel)
# define RBIMPL_COMPILER_IS_GCC 0

#else
# define RBIMPL_COMPILER_IS_GCC 1
# define RBIMPL_COMPILER_VERSION_MAJOR __GNUC__
# define RBIMPL_COMPILER_VERSION_MINOR __GNUC_MINOR__
# define RBIMPL_COMPILER_VERSION_PATCH __GNUC_PATCHLEVEL__
#endif

#endif /* RBIMPL_COMPILER_IS_GCC_H */
PK       ! L      ruby/internal/encoding/re.hnu [        #ifndef RUBY_INTERNAL_ENCODING_RE_H                  /*-*-C++-*-vi:se ft=cpp:*/
#define RUBY_INTERNAL_ENCODING_RE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Routines to manipulate encodings of symbols.
 */

#include "ruby/internal/dllexport.h"
#include "ruby/internal/encoding/encoding.h"
#include "ruby/internal/value.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()

/**
 * Identical to rb_reg_new(), except it additionally takes an encoding.
 *
 * @param[in]  ptr              A memory region of `len` bytes length.
 * @param[in]  len              Length of  `ptr`, in  bytes, not  including the
 *                              terminating NUL character.
 * @param[in]  enc              Encoding of `ptr`.
 * @param[in]  opts             Options e.g. ONIG_OPTION_MULTILINE.
 * @exception  rb_eRegexpError  Failed to compile `ptr`.
 * @return     An allocated  new instance  of ::rb_cRegexp, of  `enc` encoding,
 *             whose expression is compiled according to `ptr`.
 */
VALUE rb_enc_reg_new(const char *ptr, long len, rb_encoding *enc, int opts);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RUBY_INTERNAL_ENCODING_RE_H */
PK       !     !  ruby/internal/encoding/pathname.hnu [        #ifndef RUBY_INTERNAL_ENCODING_PATHNAME_H            /*-*-C++-*-vi:se ft=cpp:*/
#define RUBY_INTERNAL_ENCODING_PATHNAME_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Routines to manipulate encodings of pathnames.
 */

#include "ruby/internal/attr/nonnull.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/encoding/encoding.h"
#include "ruby/internal/value.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()
RBIMPL_ATTR_NONNULL(())
/**
 * Returns a path component directly adjacent to the passed pointer.
 *
 * ```
 * "/multi/byte/encoded/pathname.txt"
 *         ^    ^                   ^
 *         |    |                   +--- end
 *         |    +--- @return
 *         +--- path
 * ```
 *
 * @param[in]  path  Where to start scanning.
 * @param[in]  end   End of the path string.
 * @param[in]  enc   Encoding of the string.
 * @return     A pointer  in the  passed string where  the next  path component
 *             resides, or `end` if there is no next path component.
 */
char *rb_enc_path_next(const char *path, const char *end, rb_encoding *enc);

RBIMPL_ATTR_NONNULL(())
/**
 * Seeks for non-prefix  part of a pathname.   This can be a no-op  when the OS
 * has no  such concept  like a  path prefix.   But there  are OSes  where path
 * prefixes do exist.
 *
 * ```
 * "C:\multi\byte\encoded\pathname.txt"
 *  ^ ^                               ^
 *  | |                               +--- end
 *  | +--- @return
 *  +--- path
 * ```
 *
 * @param[in]  path  Where to start scanning.
 * @param[in]  end   End of the path string.
 * @param[in]  enc   Encoding of the string.
 * @return     A pointer in the passed  string where non-prefix part starts, or
 *             `path` if the OS does not have path prefix.
 */
char *rb_enc_path_skip_prefix(const char *path, const char *end, rb_encoding *enc);

RBIMPL_ATTR_NONNULL(())
/**
 * Returns the last path component.
 *
 * ```
 * "/multi/byte/encoded/pathname.txt"
 *        ^             ^           ^
 *        |             |           +--- end
 *        |             +--- @return
 *        +--- path
 * ```
 *
 * @param[in]  path  Where to start scanning.
 * @param[in]  end   End of the path string.
 * @param[in]  enc   Encoding of the string.
 * @return     A pointer  in the  passed string where  the last  path component
 *             resides, or `end` if there is no more path component.
 */
char *rb_enc_path_last_separator(const char *path, const char *end, rb_encoding *enc);

RBIMPL_ATTR_NONNULL(())
/**
 * This just returns the passed end basically.  It makes difference in case the
 * passed string ends with tons of path separators like the following:
 *
 * ```
 * "/path/that/ends/with/lots/of/slashes//////////////"
 *  ^                                   ^             ^
 *  |                                   |             +--- end
 *  |                                   +--- @return
 *  +--- path
 * ```
 *
 * @param[in]  path  Where to start scanning.
 * @param[in]  end   End of the path string.
 * @param[in]  enc   Encoding of the string.
 * @return     A  pointer  in  the  passed   string  where  the  trailing  path
 *             separators  start,  or  `end`  if  there  is  no  trailing  path
 *             separators.
 *
 * @internal
 *
 * It  seems this  function  was  introduced to  mimic  what  POSIX says  about
 * `basename(3)`.
 */
char *rb_enc_path_end(const char *path, const char *end, rb_encoding *enc);

RBIMPL_ATTR_NONNULL((1, 4))
/**
 * Our own  encoding-aware version  of `basename(3)`.  Normally,  this function
 * returns the  last path  component of  the given name.   However in  case the
 * passed  name  ends  with a  path  separator,  it  returns  the name  of  the
 * directory, not  the last (empty)  component.  Also if  the passed name  is a
 * root directory, it  returns that root directory.  Note  however that Windows
 * filesystem have drive letters, which this function does not return.
 *
 * @param[in]      name     Target path.
 * @param[out]     baselen  Return buffer.
 * @param[in,out]  alllen   Number of bytes of `name`.
 * @param[enc]     enc      Encoding of `name`.
 * @return         The rightmost component of `name`.
 * @post           `baselen`, if passed,  is updated to be the  number of bytes
 *                 of the returned basename.
 * @post           `alllen`, if passed, is updated to be the number of bytes of
 *                 strings not considered as the basename.
 */
const char *ruby_enc_find_basename(const char *name, long *baselen, long *alllen, rb_encoding *enc);

RBIMPL_ATTR_NONNULL((1, 3))
/**
 * Our own  encoding-aware version of  `extname`.  This function  first applies
 * rb_enc_path_last_separator() to the passed name and only concerns its return
 * value (ignores  any parent directories).  This  function returns complicated
 * results:
 *
 * ```CXX
 * auto path = "...";
 * auto len = strlen(path);
 * auto ret = ruby_enc_find_extname(path, &len, rb_ascii8bit_encoding());
 *
 * switch(len) {
 * case 0:
 *     if (ret == 0) {
 *         // `path` is a file without extensions.
 *     }
 *     else {
 *         // `path` is a dotfile.
 *         // `ret` is the file's name.
 *     }
 *     break;
 *
 * case 1:
 *     // `path` _ends_ with a dot.
 *     // `ret` is that dot.
 *     break;
 *
 * default:
 *     // `path` has an extension.
 *     // `ret` is that extension.
 * }
 * ```
 *
 * @param[in]      name  Target path.
 * @param[in,out]  len   Number of bytes of `name`.
 * @param[in]      enc   Encoding of `name`.
 * @return         See above.
 * @post           `len`, if passed, is updated (see above).
 */
const char *ruby_enc_find_extname(const char *name, long *len, rb_encoding *enc);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RUBY_INTERNAL_ENCODING_PATHNAME_H */
PK       ! J    !  ruby/internal/encoding/encoding.hnu [        #ifndef RUBY_INTERNAL_ENCODING_ENCODING_H            /*-*-C++-*-vi:se ft=cpp:*/
#define RUBY_INTERNAL_ENCODING_ENCODING_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines ::rb_encoding
 */

#include "ruby/oniguruma.h"
#include "ruby/internal/attr/const.h"
#include "ruby/internal/attr/deprecated.h"
#include "ruby/internal/attr/noalias.h"
#include "ruby/internal/attr/pure.h"
#include "ruby/internal/attr/returns_nonnull.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"
#include "ruby/internal/core/rbasic.h"
#include "ruby/internal/fl_type.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()

/**
 * `Encoding` class.
 *
 * @ingroup object
 */
RUBY_EXTERN VALUE rb_cEncoding;

/**
 * @private
 *
 * Bit constants used when embedding encodings into ::RBasic::flags.  Extension
 * libraries must not bother such things.
 */
enum ruby_encoding_consts {

    /** Max possible number of embeddable encodings. */
    RUBY_ENCODING_INLINE_MAX = 127,

    /** Where inline encodings reside. */
    RUBY_ENCODING_SHIFT = (RUBY_FL_USHIFT+10),

    /** Bits we use to store inline encodings. */
    RUBY_ENCODING_MASK = (RUBY_ENCODING_INLINE_MAX<<RUBY_ENCODING_SHIFT
                          /* RUBY_FL_USER10..RUBY_FL_USER16 */),

    /** Max possible length of an encoding name. */
    RUBY_ENCODING_MAXNAMELEN = 42
};

#define ENCODING_INLINE_MAX RUBY_ENCODING_INLINE_MAX /**< @old{RUBY_ENCODING_INLINE_MAX} */
#define ENCODING_SHIFT RUBY_ENCODING_SHIFT           /**< @old{RUBY_ENCODING_SHIFT} */
#define ENCODING_MASK RUBY_ENCODING_MASK             /**< @old{RUBY_ENCODING_MASK} */

/**
 * Destructively assigns the passed encoding  to the passed object.  The object
 * must be  capable of  having inline  encoding.  Using  this macro  needs deep
 * understanding of bit level object binary layout.
 *
 * @param[out]  obj      Target object to modify.
 * @param[in]   ecindex  Encoding in encindex format.
 * @post        `obj`'s encoding is `encindex`.
 */
static inline void
RB_ENCODING_SET_INLINED(VALUE obj, int encindex)
{
    VALUE f = /* upcast */ encindex;

    f <<= RUBY_ENCODING_SHIFT;
    RB_FL_UNSET_RAW(obj, RUBY_ENCODING_MASK);
    RB_FL_SET_RAW(obj, f);
}

/**
 * Queries the  encoding of the  passed object.   The encoding must  be smaller
 * than ::RUBY_ENCODING_INLINE_MAX, which means you have some assumption on the
 * return value.  This means the API is for internal use only.
 *
 * @param[in]  obj  Target object.
 * @return     `obj`'s encoding index.
 */
static inline int
RB_ENCODING_GET_INLINED(VALUE obj)
{
    VALUE ret = RB_FL_TEST_RAW(obj, RUBY_ENCODING_MASK) >> RUBY_ENCODING_SHIFT;

    return RBIMPL_CAST((int)ret);
}

#define ENCODING_SET_INLINED(obj,i) RB_ENCODING_SET_INLINED(obj,i) /**< @old{RB_ENCODING_SET_INLINED} */
#define ENCODING_SET(obj,i) RB_ENCODING_SET(obj,i)                 /**< @old{RB_ENCODING_SET} */
#define ENCODING_GET_INLINED(obj) RB_ENCODING_GET_INLINED(obj)     /**< @old{RB_ENCODING_GET_INLINED} */
#define ENCODING_GET(obj) RB_ENCODING_GET(obj)                     /**< @old{RB_ENCODING_GET} */
#define ENCODING_IS_ASCII8BIT(obj) RB_ENCODING_IS_ASCII8BIT(obj)   /**< @old{RB_ENCODING_IS_ASCII8BIT} */
#define ENCODING_MAXNAMELEN RUBY_ENCODING_MAXNAMELEN               /**< @old{RUBY_ENCODING_MAXNAMELEN} */

/**
 * The  type  of encoding.   Our  design  here  is we  take  Oniguruma/Onigmo's
 * multilingualisation schema as our base data structure.
 */
typedef const OnigEncodingType rb_encoding;

RBIMPL_ATTR_NOALIAS()
/**
 * Converts  a character  option  to its  encoding.  It  only  supports a  very
 * limited set  of Japanese encodings due  to its Japanese origin.   Ruby still
 * has this in-core for backwards compatibility.  But new codes must not bother
 * such  concept like  one-character encoding  option.  Consider  deprecated in
 * practice.
 *
 * @param[in]   c       One of `['n', 'e', 's', 'u', 'i', 'x', 'm']`.
 * @param[out]  option  Return buffer.
 * @param[out]  kcode   Return buffer.
 * @retval      1       `c` understood properly.
 * @retval      0       `c` is not understood.
 * @post        `option` is a ::OnigOptionType.
 * @post        `kcode` is an enum `ruby_preserved_encindex`.
 *
 * @internal
 *
 * `kcode`  is opaque  because  `ruby_preserved_encindex` is  not visible  from
 * extension libraries.  But who cares?
 */
int rb_char_to_option_kcode(int c, int *option, int *kcode);

/**
 * Creates a new encoding, using the passed one as a template.
 *
 * @param[in]  name          Name of the creating encoding.
 * @param[in]  src           Template.
 * @exception  rb_eArgError  Duplicated or malformed `name`.
 * @return     Replicated new encoding's index.
 * @post       Encoding named `name` is created as a copy of `src`, whose index
 *             is the return value.
 *
 * @internal
 *
 * `name` can be `NULL`,  but that just raises an exception.   OTOH it seems no
 * sanity check is done against `src`...?
 */
int rb_enc_replicate(const char *name, rb_encoding *src);

/**
 * Creates a new "dummy" encoding.  Roughly speaking, an encoding is dummy when
 * it is  stateful.  Notable  example of  dummy encoding  are those  defined in
 * ISO/IEC 2022
 *
 * @param[in]  name  Name of the creating encoding.
 * @exception  rb_eArgError  Duplicated or malformed `name`.
 * @return     New dummy encoding's index.
 * @post       Encoding  named `name`  is created,  whose index  is the  return
 *             value.
 */
int rb_define_dummy_encoding(const char *name);

RBIMPL_ATTR_PURE()
/**
 * Queries if the passed encoding is dummy.
 *
 * @param[in]  enc  Encoding in question.
 * @retval     1    It is.
 * @retval     0    It isn't.
 */
int rb_enc_dummy_p(rb_encoding *enc);

RBIMPL_ATTR_PURE()
/**
 * Queries the  index of  the encoding.   An encoding's  index is  a Ruby-local
 * concept.  It is a (sequential) number assigned to each encoding.
 *
 * @param[in]  enc  Encoding in question.
 * @return     Its index.
 * @note       You can pass  null pointers to this function.   It is equivalent
 *             to rb_usascii_encindex() then.
 */
int rb_enc_to_index(rb_encoding *enc);

/**
 * Queries the index of the encoding of the passed object, if any.
 *
 * @param[in]  obj        Object in question.
 * @retval     -1         `obj` is incapable of having an encoding.
 * @retval     otherwise  `obj`'s encoding's index.
 */
int rb_enc_get_index(VALUE obj);

/**
 * @alias{rb_enc_get_index}
 *
 * @internal
 *
 * Implementation wise this is not a verbatim alias of rb_enc_get_index().  But
 * the API is consistent.  Don't bother.
 */
static inline int
RB_ENCODING_GET(VALUE obj)
{
    int encindex = RB_ENCODING_GET_INLINED(obj);

    if (encindex == RUBY_ENCODING_INLINE_MAX) {
        return rb_enc_get_index(obj);
    }
    else {
        return encindex;
    }
}

/**
 * Destructively assigns an encoding (via its index) to an object.
 *
 * @param[out]  obj                Object in question.
 * @param[in]   encindex           An encoding index.
 * @exception   rb_eFrozenError    `obj` is frozen.
 * @exception   rb_eArgError       `obj` is incapable of having an encoding.
 * @exception   rb_eEncodingError  `encindex` is out of bounds.
 * @exception   rb_eLoadError      Failed to load the encoding.
 */
void rb_enc_set_index(VALUE obj, int encindex);

/** @alias{rb_enc_set_index} */
static inline void
RB_ENCODING_SET(VALUE obj, int encindex)
{
    rb_enc_set_index(obj, encindex);
}

/**
 * This is #RB_ENCODING_SET  + RB_ENC_CODERANGE_SET combo.  The  object must be
 * capable  of   having  inline   encoding.   Using   this  macro   needs  deep
 * understanding of bit level object binary layout.
 *
 * @param[out]  obj       Target object.
 * @param[in]   encindex  Encoding in encindex format.
 * @param[in]   cr        An enum ::ruby_coderange_type.
 * @post        `obj`'s encoding is `encindex`.
 * @post        `obj`'s code range is `cr`.
 */
static inline void
RB_ENCODING_CODERANGE_SET(VALUE obj, int encindex, enum ruby_coderange_type cr)
{
    RB_ENCODING_SET(obj, encindex);
    RB_ENC_CODERANGE_SET(obj, cr);
}

RBIMPL_ATTR_PURE()
/**
 * Queries if the passed object can have its encoding.
 *
 * @param[in]  obj  Object in question.
 * @retval     1    It can.
 * @retval     0    It cannot.
 */
int rb_enc_capable(VALUE obj);

/**
 * Queries the index of the encoding.
 *
 * @param[in]  name          Name of the encoding to find.
 * @exception  rb_eArgError  No such encoding named `name`.
 * @retval     -1            `name` exists, but unable to load.
 * @retval     otherwise     Index of encoding named `name`.
 */
int rb_enc_find_index(const char *name);

/**
 * Registers an  "alias" name.  In  the wild, an  encoding can be  called using
 * multiple names.  For instance an encoding  known as `"CP932"` is also called
 * `"SJIS"` on occasions.  This API registers such relationships.
 *
 * @param[in]  alias         New name.
 * @param[in]  orig          Old name.
 * @exception  rb_eArgError  `alias` is duplicated or malformed.
 * @retval     -1            Failed to load `orig`.
 * @retval     otherwise     The index of `orig` and `alias`.
 * @post       `alias` is  a synonym  of `orig`.  They  refer to  the identical
 *             encoding.
 */
int rb_enc_alias(const char *alias, const char *orig);

/**
 * Obtains   a  encoding   index  from   a   wider  range   of  objects   (than
 * rb_enc_find_index()).
 *
 * @param[in]  obj        An ::rb_cEncoding, or its name in ::rb_cString.
 * @retval     -1         `obj` is unexpected type/contents.
 * @retval     otherwise  Index corresponding to `obj`.
 */
int rb_to_encoding_index(VALUE obj);

/**
 * Identical to  rb_find_encoding(), except it  raises an exception  instead of
 * returning NULL.
 *
 * @param[in]  obj            An ::rb_cEncoding, or its name in ::rb_cString.
 * @exception  rb_eTypeError  `obj` is neither ::rb_cEncoding nor ::rb_cString.
 * @exception  rb_eArgError   `obj` is an unknown encoding name.
 * @return     Encoding of `obj`.
 */
rb_encoding *rb_to_encoding(VALUE obj);

/**
 * Identical to rb_to_encoding_index(), except the return type.
 *
 * @param[in]  obj            An ::rb_cEncoding, or its name in ::rb_cString.
 * @exception  rb_eTypeError  `obj` is neither ::rb_cEncoding nor ::rb_cString.
 * @retval     NULL           No such encoding.
 * @return     otherwise      Encoding of `obj`.
 */
rb_encoding *rb_find_encoding(VALUE obj);

/**
 * Identical to rb_enc_get_index(), except the return type.
 *
 * @param[in]  obj        Object in question.
 * @retval     NULL       Obj is incapable of having an encoding.
 * @retval     otherwise  `obj`'s encoding.
 */
rb_encoding *rb_enc_get(VALUE obj);

/**
 * Look for the "common" encoding between the two.  One character can or cannot
 * be expressed depending on an encoding.  This function finds the super-set of
 * encodings that  satisfy contents of  both arguments.  If that  is impossible
 * returns NULL.
 *
 * @param[in]  str1       An object.
 * @param[in]  str2       Another object.
 * @retval     NULL       No encoding can satisfy both at once.
 * @retval     otherwise  Common encoding between the two.
 * @note       Arguments can be non-string, e.g. Regexp.
 */
rb_encoding *rb_enc_compatible(VALUE str1, VALUE str2);

/**
 * Identical to rb_enc_compatible(),  except it raises an  exception instead of
 * returning NULL.
 *
 * @param[in]  str1                An object.
 * @param[in]  str2                Another object.
 * @exception  rb_eEncCompatError  No encoding can satisfy both.
 * @return     Common encoding between the two.
 * @note       Arguments can be non-string, e.g. Regexp.
 */
rb_encoding *rb_enc_check(VALUE str1,VALUE str2);

/**
 * Identical to rb_enc_set_index(), except it additionally does contents fix-up
 * depending on the passed object.  It  for instance changes the byte length of
 * terminating `U+0000` according to the passed encoding.
 *
 * @param[out]  obj                Object in question.
 * @param[in]   encindex           An encoding index.
 * @exception   rb_eFrozenError    `obj` is frozen.
 * @exception   rb_eArgError       `obj` is incapable of having an encoding.
 * @exception   rb_eEncodingError  `encindex` is out of bounds.
 * @exception   rb_eLoadError      Failed to load the encoding.
 * @return      The passed `obj`.
 * @post        `obj`'s contents might be fixed according to `encindex`.
 */
VALUE rb_enc_associate_index(VALUE obj, int encindex);

/**
 * Identical to  rb_enc_associate_index(), except  it takes an  encoding itself
 * instead of its index.
 *
 * @param[out]  obj                Object in question.
 * @param[in]   enc                An encoding.
 * @exception   rb_eFrozenError    `obj` is frozen.
 * @exception   rb_eArgError       `obj` is incapable of having an encoding.
 * @return      The passed `obj`.
 * @post        `obj`'s contents might be fixed according to `enc`.
 */
VALUE rb_enc_associate(VALUE obj, rb_encoding *enc);

/**
 * Destructively copies  the encoding of  the latter  object to that  of former
 * one.     It   can    also   be    seen   as    a   routine    identical   to
 * rb_enc_associate_index(), except it takes an object's encoding instead of an
 * encoding's index.
 *
 * @param[out]  dst                Object to modify.
 * @param[in]   src                Object to reference.
 * @exception   rb_eFrozenError    `dst` is frozen.
 * @exception   rb_eArgError       `dst` is incapable of having an encoding.
 * @exception   rb_eEncodingError  `src` is incapable of having an encoding.
 * @post        `dst`'s encoding is that of `src`'s.
 */
void rb_enc_copy(VALUE dst, VALUE src);


/**
 * Identical to rb_find_encoding(),  except it takes an  encoding index instead
 * of a Ruby object.
 *
 * @param[in]  idx        An encoding index.
 * @retval     NULL       No such encoding.
 * @retval     otherwise  An encoding whose index is `idx`.
 */
rb_encoding *rb_enc_from_index(int idx);

/**
 * Identical to  rb_find_encoding(), except  it takes a  C's string  instead of
 * Ruby's.
 *
 * @param[in]  name       Name of the encoding to query.
 * @retval     NULL       No such encoding.
 * @retval     otherwise  An encoding whose index is `idx`.
 */
rb_encoding *rb_enc_find(const char *name);

/**
 * Queries the (canonical) name of the passed encoding.
 *
 * @param[in]  enc  An encoding.
 * @return     Its name.
 */
static inline const char *
rb_enc_name(rb_encoding *enc)
{
    return enc->name;
}

/**
 * Queries  the minimum  number  of bytes  that the  passed  encoding needs  to
 * represent a character.  For ASCII and compatible encodings this is typically
 * 1.   There  are  however  encodings  whose   minimum  is  not  1;  they  are
 * historically called wide characters.
 *
 * @param[in]  enc  An encoding.
 * @return     Its least possible number of bytes except 0.
 */
static inline int
rb_enc_mbminlen(rb_encoding *enc)
{
    return enc->min_enc_len;
}

/**
 * Queries  the maximum  number  of bytes  that the  passed  encoding needs  to
 * represent a character.   Fixed-width encodings have the same  value for this
 * one  and  #rb_enc_mbminlen.   However there  are  variable-width  encodings.
 * UTF-8, for instance, takes from 1 up to 6 bytes.
 *
 * @param[in]  enc  An encoding.
 * @return     Its maximum possible number of bytes of a character.
 */
static inline int
rb_enc_mbmaxlen(rb_encoding *enc)
{
    return enc->max_enc_len;
}

/**
 * Queries the number of bytes of the character at the passed pointer.
 *
 * @param[in]  p    Pointer to a character's first byte.
 * @param[in]  e    End of the string that has `p`.
 * @param[in]  enc  Encoding of the string.
 * @return     If the character at `p` does  not end until `e`, number of bytes
 *             between `p`  and `e`.   Otherwise the number  of bytes  that the
 *             character at `p` is encoded.
 *
 * @internal
 *
 * Strictly speaking there  are chances when `p`  points to a middle  byte of a
 * wide character.   This function  returns "the  number of  bytes from  `p` to
 * nearest of either `e` or the next character boundary", if you go strict.
 */
int rb_enc_mbclen(const char *p, const char *e, rb_encoding *enc);

/**
 * Identical to rb_enc_mbclen() unless the character at `p` overruns `e`.  That
 * can happen  for instance when  you read from a  socket and its  partial read
 * cuts  a  wide  character  in-between.  In  those  situations  this  function
 * "estimates" theoretical length  of the character in  question.  Typically it
 * tends  to be  possible  to know  how  many bytes  a  character needs  before
 * actually reaching its  end; for instance UTF-8 encodes  a character's length
 * in the first byte of it.  This function returns that info.
 *
 * @note  This implies that the string is not broken.
 *
 * @param[in]  p    Pointer to the character's first byte.
 * @param[in]  e    End of the string that has `p`.
 * @param[in]  enc  Encoding of the string.
 * @return     Number of bytes of character at `p`, measured or estimated.
 */
int rb_enc_fast_mbclen(const char *p, const char *e, rb_encoding *enc);

/**
 * Queries the  number of bytes of  the character at the  passed pointer.  This
 * function returns 3 different types of information:
 *
 * ```CXX
 * auto n = rb_enc_precise_mbclen(p, q, r);
 *
 * if (ONIGENC_MBCLEN_CHARFOUND_P(n)) {
 *     // Character found.  Normal return.
 *     auto found_length = ONIGENC_MBCLEN_CHARFOUND_LEN(n);
 * }
 * else if (ONIGENC_MBCLEN_NEEDMORE_P(n)) {
 *     // Character overruns past `q`; needs more.
 *     auto requested_length = ONIGENC_MBCLEN_NEEDMORE_LEN(n);
 * }
 * else {
 *     // `p` is broken.
 *     assert(ONIGENC_MBCLEN_INVALID_P(n));
 * }
 * ```
 *
 * @param[in]  p    Pointer to the character's first byte.
 * @param[in]  e    End of the string that has `p`.
 * @param[in]  enc  Encoding of the string.
 * @return     Encoded read/needed number of bytes (see above).
 */
int rb_enc_precise_mbclen(const char *p, const char *e, rb_encoding *enc);

#define MBCLEN_CHARFOUND_P(ret)   ONIGENC_MBCLEN_CHARFOUND_P(ret)   /**< @old{ONIGENC_MBCLEN_CHARFOUND_P} */
#define MBCLEN_CHARFOUND_LEN(ret) ONIGENC_MBCLEN_CHARFOUND_LEN(ret) /**< @old{ONIGENC_MBCLEN_CHARFOUND_LEN} */
#define MBCLEN_INVALID_P(ret)     ONIGENC_MBCLEN_INVALID_P(ret)     /**< @old{ONIGENC_MBCLEN_INVALID_P} */
#define MBCLEN_NEEDMORE_P(ret)    ONIGENC_MBCLEN_NEEDMORE_P(ret)    /**< @old{ONIGENC_MBCLEN_NEEDMORE_P} */
#define MBCLEN_NEEDMORE_LEN(ret)  ONIGENC_MBCLEN_NEEDMORE_LEN(ret)  /**< @old{ONIGENC_MBCLEN_NEEDMORE_LEN} */

/**
 * Queries the code point of character  pointed by the passed pointer.  If that
 * code point is included in ASCII  that code point is returned.  Otherwise -1.
 * This can be different from just looking  at the first byte.  For instance it
 * reads 2 bytes in case of UTF-16BE.
 *
 * @param[in]  p          Pointer to the character's first byte.
 * @param[in]  e          End of the string that has `p`.
 * @param[in]  len        Return buffer.
 * @param[in]  enc        Encoding of the string.
 * @retval     -1         The character at `p` is not i ASCII.
 * @retval     otherwise  A code point of the character at `p`.
 * @post       `len` (if set) is the number of bytes of `p`.
 */
int rb_enc_ascget(const char *p, const char *e, int *len, rb_encoding *enc);

/**
 * Queries  the  code  point  of  character  pointed  by  the  passed  pointer.
 * Exceptions happen in case of broken input.
 *
 * @param[in]  p             Pointer to the character's first byte.
 * @param[in]  e             End of the string that has `p`.
 * @param[in]  len           Return buffer.
 * @param[in]  enc           Encoding of the string.
 * @exception  rb_eArgError  `p` is broken.
 * @return     Code point of the character pointed by `p`.
 * @post       `len` (if set) is the number of bytes of `p`.
 */
unsigned int rb_enc_codepoint_len(const char *p, const char *e, int *len, rb_encoding *enc);

/**
 * Queries  the  code  point  of  character  pointed  by  the  passed  pointer.
 * Exceptions happen in case of broken input.
 *
 * @deprecated  Use rb_enc_codepoint_len() instead.
 * @param[in]   p             Pointer to the character's first byte.
 * @param[in]   e             End of the string that has `p`.
 * @param[in]   enc           Encoding of the string.
 * @exception   rb_eArgError  `p` is broken.
 * @return      Code point of the character pointed by `p`.
 *
 * @internal
 *
 * @matz says in commit  91e5ba1cb865a2385d3e1cbfacd824496898e098 that the line
 * below  is a  "prototype for  obsolete function".   However even  today there
 * still are some use  cases of it throughout our repository.   It seems it has
 * its own niche.
 */
static inline unsigned int
rb_enc_codepoint(const char *p, const char *e, rb_encoding *enc)
{
    return rb_enc_codepoint_len(p, e, 0, enc);
    /*                               ^^^
     * This can be `NULL` in C, `nullptr` in C++, and `0` for both.
     * We choose the most portable one here.
     */
}


/**
 * Identical to rb_enc_codepoint(),  except it assumes the  passed character is
 * not broken.
 *
 * @param[in]   p    Pointer to the character's first byte.
 * @param[in]   e    End of the string that has `p`.
 * @param[in]   enc  Encoding of the string.
 * @return      Code point of the character pointed by `p`.
 */
static inline OnigCodePoint
rb_enc_mbc_to_codepoint(const char *p, const char *e, rb_encoding *enc)
{
    const OnigUChar *up = RBIMPL_CAST((const OnigUChar *)p);
    const OnigUChar *ue = RBIMPL_CAST((const OnigUChar *)e);

    return ONIGENC_MBC_TO_CODE(enc, up, ue);
}

/**
 * Queries the  number of bytes  requested to  represent the passed  code point
 * using the passed encoding.
 *
 * @param[in]  code          Code point in question.
 * @param[in]  enc           Encoding to convert the code into a byte sequence.
 * @exception  rb_eArgError  `enc` does not glean `code`.
 * @return     Number of bytes requested to represent `code` using