* The delimiter of `PATH` environment variable. */
#if defined(DOSISH)
#define PATH_SEP ";"
#else
#define PATH_SEP ":"
#endif

/** Identical to #PATH_SEP, except it is of type `char`. */
#define PATH_SEP_CHAR PATH_SEP[0]

/**
 * @private
 *
 * @deprecated  This macro once was a thing in the old days, but makes no sense
 *              any  longer today.   Exists  here  for backwards  compatibility
 *              only.  You can safely forget about it.
 *
 * @internal
 *
 * For  historical interests:  there was  an operating  system called  Human68k
 * which used an environment variable called `"path"` for this purpose.
 */
#define PATH_ENV "PATH"

#if defined(DOSISH)
#define ENV_IGNORECASE
#endif

/**
 * Stone age  assumption was that  an operating  system supports only  one file
 * system at a  moment.  This macro was  to detect if such (one  and only) file
 * system  has case  sensitivity.   This  assumption is  largely  not true  any
 * longer; most operating systems can mount  many kinds of file systems side by
 * side.  Also there are file systems that  do or do not ignore cases depending
 * on configuration (e.g.  EXT4's `casefold` feature).
 *
 * This  macro is  still  used  internally (for  instance  Ruby level  constant
 * `File::FNM_SYSCASE` depends on it), but it is basically a wrong idea for you
 * to use it today.  Please just find another way.
 */
#ifndef CASEFOLD_FILESYSTEM
# if defined DOSISH
#   define CASEFOLD_FILESYSTEM 1
# else
#   define CASEFOLD_FILESYSTEM 0
# endif
#endif

#endif /* RBIMPL_DOSISH_H */
PK       ! mo      ruby/internal/warning_push.hnu [        #ifndef RBIMPL_WARNING_PUSH_H                        /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_WARNING_PUSH_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_WARNING_PUSH.
 *
 * ### Q&A ###
 *
 * Q: Why all the macros defined in this file are function-like macros?
 *
 * A: Sigh.   This  is  because of  Doxygen.  Its  `SKIP_FUNCTION_MACROS = YES`
 *    configuration setting  requests us  that if  we want  it to  ignore these
 *    macros,  then we  have to  do  two things:  (1)  let them  