   *
     * @see enum ::ruby_fl_type
     *
     * @note  This is ::VALUE rather than  an enum for alignment purpose.  Back
     *        in the 1990s there were no such thing like `_Alignas` in C.
     */
    VALUE flags;

    /**
     * Class of an object.  Every object has its class.  Also, everything is an
     * object  in Ruby.   This means  classes are  also objects.   Classes have
     * their own classes,  classes of classes have their classes,  too ...  and
     * it recursively continues forever.
     *
     * Also note the `const` qualifier.  In  ruby an object cannot "change" its
     * class.
     */
    const VALUE klass;

#ifdef __cplusplus
  public:
    RBIMPL_ATTR_CONSTEXPR(CXX11)
    RBIMPL_ATTR_ARTIFICIAL()
    RBIMPL_ATTR_FORCEINLINE()
    RBIMPL_ATTR_NOALIAS()
    /**
     * We need to define this explicit constructor because the field `klass` is
     * const-qualified above,  which effectively  defines the  implicit default
     * constructor as "deleted"  (as of C++11) --  No way but to  define one by
     * ourselves.
     */
    RBasic() :
        flags(RBIMPL_VALUE_NULL),
        klass(RBIMPL_VALUE_NULL)
    {
    }
#endif
};

RBIMPL_SYMBOL_EXPORT_BEGIN()
/**
 * Make the object invisible from Ruby code.
 *
 * It is  useful to let  Ruby's GC manage your  internal data structure  -- The
 * object keeps being managed by GC, but `ObjectSpace.each_object` never yields
 * the object.
 *
 * Note that the object also lose a way to call a method on it.
 *
 * @param[out]  obj  A Ruby object.
 * @return      The passed object.
 * @post        The object is destructively modified to be invisible.
 * @see         rb_obj_reveal
 */
VALUE rb_obj_hide(VALUE obj);

/**
 * Make a hidden object visible again.
 *
 * It is  the caller's  responsibility to  pass the  right `klass`  which `obj`
 * originally used to belong to.
 *
 * @param[out]  obj    A Ruby object.
 * @param[in]   klass  Class of `obj`.
 * @return      Passed `obj`.
 * @pre         `obj` was previously hidden.
 * @post        `obj`'s class is `klass`.
 * @see         rb_obj_hide
 */
VALUE rb_obj_reveal(VALUE obj, VALUE klass); /* do not use this API to change klass information */
RBIMPL_SYMBOL_EXPORT_END()

RBIMPL_ATTR_PURE_UNLESS_DEBUG()
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Queries the class of an object.
 *
 * @param[in]  obj  An object.
 * @return     Its class.
 */
static inline VALUE
RBASIC_CLASS(VALUE obj)
{
    RBIMPL_ASSERT_OR_ASSUME(! RB_SPECIAL_CONST_P(obj));
    return RBASIC(obj)->klass;
}

#endif /* RBIMPL_RBASIC_H */
PK       ! Y
  
    ruby/internal/core/rclass.hnu [        #ifndef RBIMPL_RCLASS_H                              /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_RCLASS_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 * 