  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_HAS_CPP_ATTRIBUTE.
 */
#include "ruby/internal/compiler_is.h"
#include "ruby/internal/compiler_since.h"

/** @cond INTERNAL_MACRO */
#if RBIMPL_COMPILER_IS(SunPro)
# /* Oracle Developer Studio 12.5's C++  preprocessor is reportedly broken.  We
#  * could simulate  __has_cpp_attribute like below,  but don't know  the exact
#  * list of which version supported which attribute.  Just kill everything for
#  * now.  If you can please :FIXME: */
# /* https://unicode-org.atlassian.net/browse/ICU-12893 */
# /* https://github.com/boostorg/config/pull/95 */
# define RBIMPL_HAS_CPP_ATTRIBUTE0(_) 0

#elif defined(__has_cpp_attribute)
# define RBIMPL_HAS_CPP_ATTRIBUTE0(_) __has_cpp_attribute(_)

#elif RBIMPL_COMPILER_IS(MSVC)
# /* MSVC has  never updated  its __cplusplus  since forever  (unless specified
#  * explicitly by a compiler flag).   They also lack __has_cpp_attribute until
#  * 2019.  However, they do have attributes since 2015 or so. */
# /* https://docs.microsoft.com/en-us/cpp/overview/visual-cpp-language-conformance */
# define RBIMPL_HAS_CPP_ATTRIBUTE0(_) (RBIMPL_HAS_CPP_ATTRIBUTE_ ## _)
# define RBIMPL_HAS_CPP_ATTRIBUTE_noreturn           200809 * RBIMPL_COMPILER_SINCE(MSVC, 19, 00, 0)
# define RBIMPL_HAS_CPP_ATTRIBUTE_carries_dependency 200809 * RBIMPL_COMPILER_SINCE(MSVC, 19, 00, 0)
# define RBIMPL_HAS_CPP_ATTRIBUTE_deprecated         201309 * RBIMPL_COMPILER_SINCE(MSVC, 19, 10, 0)
# define RBIMPL_HAS_CPP_ATTRIBUTE_fallthrough        201603 * RBIMPL_COMPILER_SINCE(MSVC, 19, 10, 0)
# define RBIMPL_HAS_CPP_ATTRIBUTE_maybe_unused       201603 * RBIMPL_COMPILER_SINCE(MSVC, 19, 11, 0)
# define RBIMPL_HAS_CPP_ATTRIBUTE_nodiscard          201603 * RBIMPL_COMPILER_SINCE(MSVC, 19, 11, 0)

#elif RBIMPL_COMPILER_BEFORE(Clang, 3, 6, 0)
# /* Clang  3.6.0  introduced  __has_cpp_attribute.  Prior  to  that  following
#  * attributes were already there. */
# /* https://clang.llvm.org/cxx_status.html */
# define RBIMPL_HAS_CPP_ATTRIBUTE0(_) (RBIMPL_HAS_CPP_ATTRIBUTE_ ## _)
# define RBIMPL_HAS_CPP_ATTRIBUTE_noreturn           200809 * RBIMPL_COMPILER_SINCE(Clang, 3, 3, 0)
# define RBIMPL_HAS_CPP_ATTRIBUTE_deprecated         201309 * RBIMPL_COMPILER_SINCE(Clang, 3, 4, 0)

#elif RBIMPL_COMPILER_BEFORE(GCC, 5, 0, 0)
# /* GCC 5+ have __has_cpp_attribute, while 4.x had following attributes. */
# /* https://gcc.gnu.org/projects/cxx-status.html */
# define RBIMPL_HAS_CPP_ATTRIBUTE0(_) (RBIMPL_HAS_CPP_ATTRIBUTE_ ## _)
# define RBIMPL_HAS_CPP_ATTRIBUTE_noreturn           200809 * RBIMPL_COMPILER_SINCE(GCC, 4, 8, 0)
# define RBIMPL_HAS_CPP_ATTRIBUTE_deprecated         201309 * RBIMPL_COMPILER_SINCE(GCC, 4, 9, 0)

#else
# /* :FIXME:
#  * Candidate compilers to list here:
#  * - icpc: They have __INTEL_CXX11_MODE__.
#  */
# define RBIMPL_HAS_CPP_ATTRIBUTE0(_) 0
#endif
/** @endcond */

/** Wraps (or simulates) `__has_cpp_attribute`. */
#if ! defined(__cplusplus)
# /* Makes no sense. */
# define RBIMPL_HAS_CPP_ATTRIBUTE(_) 0
#else
# /* GCC needs workarounds.  See https://gcc.godbolt.org/z/jdz3pa */
# define RBIMPL_HAS_CPP_ATTRIBUTE(_) \
    ((RBIMPL_HAS_CPP_ATTRIBUTE0(_) <= __cplusplus) ? RBIMPL_HAS_CPP_ATTRIBUTE0(_) : 0)
#endif

#endif /* RBIMPL_HAS_CPP_ATTRIBUTE_H */
PK       ! i      ruby/internal/has/extension.hnu [        #ifndef RBIMPL_HAS_EXTENSION_H                       /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_HAS_EXTENSION_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_HAS_EXTENSION.
 */
#include "ruby/internal/has/feature.h"

/** Wraps (or simulates) `__has_extension`. */
#if defined(__has_extension)
# define RBIMPL_HAS_EXTENSION(_) __has_extension(_)
#else
# /* Pre-3.0 clang had __has_feature but not __has_extension. */
# define RBIMPL_HAS_EXTENSION(_) RBIMPL_HAS_FEATURE(_)
#endif

#endif /* RBIMPL_HAS_EXTENSION_H */
PK       ! gGR      ruby/internal/has/feature.hnu [        #ifndef RBIMPL_HAS_FEATURE_H                         /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_HAS_FEATURE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_HAS_FEATURE.
 */

/** Wraps (or simulates) `__has_feature`. */
#if defined(__has_feature)
# define RBIMPL_HAS_FEATURE(_) __has_feature(_)
#else
# define RBIMPL_HAS_FEATURE(_) 0
#endif

#endif /* RBIMPL_HAS_FEATURE_H */
PK       ! A`r  r    ruby/internal/has/builtin.hnu [        #ifndef RBIMPL_HAS_BUILTIN_H                         /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_HAS_BUILTIN_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_HAS_BUILTIN.
 */
#include "ruby/internal/config.h"
#include "ruby/internal/compiler_since.h"

#if defined(__has_builtin)
# if RBIMPL_COMPILER_IS(Intel)
#  /* :TODO: Intel  C Compiler  has __has_builtin (since  19.1 maybe?),  and is
#   * reportedly  broken.  We  have to  skip them.   However the  situation can
#   * change.  They might improve someday.  We need to revisit here later. */
# elif RBIMPL_COMPILER_IS(GCC) && ! __has_builtin(__builtin_alloca)
#  /* FreeBSD's   <sys/cdefs.h>   defines   its   own   *broken*   version   of
#   * __has_builtin.   Cygwin  copied  that  content  to be  a  victim  of  the
#   * broken-ness.  We don't take them into account. */
# else
#  define RBIMPL_HAVE___HAS_BUILTIN 1
# endif
#endif

/** Wraps (or simulates) `__has_builtin`. */
#if defined(RBIMPL_HAVE___HAS_BUILTIN)
# define RBIMPL_HAS_BUILTIN(_) __has_builtin(_)

#elif RBIMPL_COMPILER_IS(GCC)
# /* :FIXME: Historically  GCC has had  tons of builtins, but  it implemented
#  * __has_builtin  only  since  GCC  10.   This section  can  be  made  more
#  * granular. */
# /* https://gcc.gnu.org/bugzilla/show_bug.cgi?id=66970 */
# define RBIMPL_HAS_BUILTIN(_) (RBIMPL_HAS_BUILTIN_ ## _)
# define RBIMPL_HAS_BUILTIN___builtin_add_overflow      RBIMPL_COMPILER_SINCE(GCC, 5, 1, 0)
# define RBIMPL_HAS_BUILTIN___builtin_alloca            RBIMPL_COMPILER_SINCE(GCC, 0, 0, 0)
# define RBIMPL_HAS_BUILTIN___builtin_alloca_with_align RBIMPL_COMPILER_SINCE(GCC, 6, 1, 0)
# define RBIMPL_HAS_BUILTIN___builtin_assume            0
# /* See http://gcc.gnu.org/bugzilla/show_bug.cgi?id=52624 for bswap16. */
# define RBIMPL_HAS_BUILTIN___builtin_bswap16           RBIMPL_COMPILER_SINCE(GCC, 4, 8, 0)
#ifndef __OpenBSD__
# define RBIMPL_HAS_BUILTIN___builtin_bswap32           RBIMPL_COMPILER_SINCE(GCC, 3, 6, 0)
# define RBIMPL_HAS_BUILTIN___builtin_bswap64           RBIMPL_COMPILER_SINCE(GCC, 3, 6, 0)
#endif
# define RBIMPL_HAS_BUILTIN___builtin_clz               RBIMPL_COMPILER_SINCE(GCC, 3, 6, 0)
# define RBIMPL_HAS_BUILTIN___builtin_clzl              RBIMPL_COMPILER_SINCE(GCC, 3, 6, 0)
# define RBIMPL_HAS_BUILTIN___builtin_clzll             RBIMPL_COMPILER_SINCE(GCC, 3, 6, 0)
# define RBIMPL_HAS_BUILTIN___builtin_constant_p        RBIMPL_COMPILER_SINCE(GCC, 2,95, 3)
# define RBIMPL_HAS_BUILTIN___builtin_ctz               RBIMPL_COMPILER_SINCE(GCC, 3, 6, 0)
# define RBIMPL_HAS_BUILTIN___builtin_ctzl              RBIMPL_COMPILER_SINCE(GCC, 3, 6, 0)
# define RBIMPL_HAS_BUILTIN___builtin_ctzll             RBIMPL_COMPILER_SINCE(GCC, 3, 6, 0)
# define RBIMPL_HAS_BUILTIN___builtin_expect            RBIMPL_COMPILER_SINCE(GCC, 3, 0, 0)
# define RBIMPL_HAS_BUILTIN___builtin_mul_overflow      RBIMPL_COMPILER_SINCE(GCC, 5, 1, 0)
# define RBIMPL_HAS_BUILTIN___builtin_mul_overflow_p    RBIMPL_COMPILER_SINCE(GCC, 7, 0, 0)
# define RBIMPL_HAS_BUILTIN___builtin_popcount          RBIMPL_COMPILER_SINCE(GCC, 3, 6, 0)
# define RBIMPL_HAS_BUILTIN___builtin_popcountl         RBIMPL_COMPILER_SINCE(GCC, 3, 6, 0)
# define RBIMPL_HAS_BUILTIN___builtin_popcountll        RBIMPL_COMPILER_SINCE(GCC, 3, 6, 0)
# define RBIMPL_HAS_BUILTIN___builtin_rotateleft32      0
# define RBIMPL_HAS_BUILTIN___builtin_rotateleft64      0
# define RBIMPL_HAS_BUILTIN___builtin_rotateright32     0
# define RBIMPL_HAS_BUILTIN___builtin_rotateright64     0
# define RBIMPL_HAS_BUILTIN___builtin_sub_overflow      RBIMPL_COMPILER_SINCE(GCC, 5, 1, 0)
# define RBIMPL_HAS_BUILTIN___builtin_unreachable       RBIMPL_COMPILER_SINCE(GCC, 4, 5, 0)
# /* Note that "0, 0, 0" might be inaccurate. */

#else
# /* Take config.h definition when available */
# define RBIMPL_HAS_BUILTIN(_) ((RBIMPL_HAS_BUILTIN_ ## _)+0)
# define RBIMPL_HAS_BUILTIN___builtin_add_overflow      HAVE_BUILTIN___BUILTIN_ADD_OVERFLOW
# define RBIMPL_HAS_BUILTIN___builtin_alloca            0
# define RBIMPL_HAS_BUILTIN___builtin_alloca_with_align HAVE_BUILTIN___BUILTIN_ALLOCA_WITH_ALIGN
# define RBIMPL_HAS_BUILTIN___builtin_assume            0
# define RBIMPL_HAS_BUILTIN___builtin_assume_aligned    HAVE_BUILTIN___BUILTIN_ASSUME_ALIGNED
# define RBIMPL_HAS_BUILTIN___builtin_bswap16           HAVE_BUILTIN___BUILTIN_BSWAP16
# define RBIMPL_HAS_BUILTIN___builtin_bswap32           HAVE_BUILTIN___BUILTIN_BSWAP32
# define RBIMPL_HAS_BUILTIN___builtin_bswap64           HAVE_BUILTIN___BUILTIN_BSWAP64
# define RBIMPL_HAS_BUILTIN___builtin_clz               HAVE_BUILTIN___BUILTIN_CLZ
# define RBIMPL_HAS_BUILTIN___builtin_clzl              HAVE_BUILTIN___BUILTIN_CLZL
# define RBIMPL_HAS_BUILTIN___builtin_clzll             HAVE_BUILTIN___BUILTIN_CLZLL
# define RBIMPL_HAS_BUILTIN___builtin_constant_p        HAVE_BUILTIN___BUILTIN_CONSTANT_P
# define RBIMPL_HAS_BUILTIN___builtin_ctz               HAVE_BUILTIN___BUILTIN_CTZ
# define RBIMPL_HAS_BUILTIN___builtin_ctzl              0
# define RBIMPL_HAS_BUILTIN___builtin_ctzll             HAVE_BUILTIN___BUILTIN_CTZLL
# define RBIMPL_HAS_BUILTIN___builtin_expect            HAVE_BUILTIN___BUILTIN_EXPECT
# define RBIMPL_HAS_BUILTIN___builtin_mul_overflow      HAVE_BUILTIN___BUILTIN_MUL_OVERFLOW
# define RBIMPL_HAS_BUILTIN___builtin_mul_overflow_p    HAVE_BUILTIN___BUILTIN_MUL_OVERFLOW_P
# define RBIMPL_HAS_BUILTIN___builtin_popcount          HAVE_BUILTIN___BUILTIN_POPCOUNT
# define RBIMPL_HAS_BUILTIN___builtin_popcountl         0
# define RBIMPL_HAS_BUILTIN___builtin_rotateleft32      0
# define RBIMPL_HAS_BUILTIN___builtin_rotateleft64      0
# define RBIMPL_HAS_BUILTIN___builtin_rotateright32     0
# define RBIMPL_HAS_BUILTIN___builtin_rotateright64     0
# define RBIMPL_HAS_BUILTIN___builtin_popcountll        HAVE_BUILTIN___BUILTIN_POPCOUNTLL
# define RBIMPL_HAS_BUILTIN___builtin_sub_overflow      HAVE_BUILTIN___BUILTIN_SUB_OVERFLOW
# if defined(HAVE___BUILTIN_UNREACHABLE)
#  define RBIMPL_HAS_BUILTIN___builtin_unreachable 1
# else
#  define RBIMPL_HAS_BUILTIN___builtin_unreachable 0
# endif
#endif

#endif /* RBIMPL_HAS_BUILTIN_H */
PK       ! (6
  
  &  ruby/internal/has/declspec_attribute.hnu [        #ifndef RBIMPL_HAS_DECLSPEC_ATTRIBUTE_H              /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_HAS_DECLSPEC_ATTRIBUTE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_HAS_DECLSPEC_ATTRIBUTE.
 */
#include "ruby/internal/compiler_since.h"

/** Wraps (or simulates) `__has_declspec_attribute`. */
#if defined(__has_declspec_attribute)
# define RBIMPL_HAS_DECLSPEC_ATTRIBUTE(_) __has_declspec_attribute(_)
#else
# define RBIMPL_HAS_DECLSPEC_ATTRIBUTE(_) (RBIMPL_HAS_DECLSPEC_ATTRIBUTE_ ## _)
# define RBIMPL_HAS_DECLSPEC_ATTRIBUTE_align       RBIMPL_COMPILER_SINCE(MSVC, 8, 0, 0)
# define RBIMPL_HAS_DECLSPEC_ATTRIBUTE_deprecated  RBIMPL_COMPILER_SINCE(MSVC,13, 0, 0)
# define RBIMPL_HAS_DECLSPEC_ATTRIBUTE_dllexport   RBIMPL_COMPILER_SINCE(MSVC, 8, 0, 0)
# define RBIMPL_HAS_DECLSPEC_ATTRIBUTE_dllimport   RBIMPL_COMPILER_SINCE(MSVC, 8, 0, 0)
# define RBIMPL_HAS_DECLSPEC_ATTRIBUTE_empty_bases RBIMPL_COMPILER_SINCE(MSVC,19, 0, 23918)
# define RBIMPL_HAS_DECLSPEC_ATTRIBUTE_noalias     RBIMPL_COMPILER_SINCE(MSVC, 8, 0, 0)
# define RBIMPL_HAS_DECLSPEC_ATTRIBUTE_noinline    RBIMPL_COMPILER_SINCE(MSVC,13, 0, 0)
# define RBIMPL_HAS_DECLSPEC_ATTRIBUTE_noreturn    RBIMPL_COMPILER_SINCE(MSVC,11, 0, 0)
# define RBIMPL_HAS_DECLSPEC_ATTRIBUTE_nothrow     RBIMPL_COMPILER_SINCE(MSVC, 8, 0, 0)
# define RBIMPL_HAS_DECLSPEC_ATTRIBUTE_restrict    RBIMPL_COMPILER_SINCE(MSVC,14, 0, 0)
# /* Note that "8, 0, 0" might be inaccurate. */
# if ! defined(__cplusplus)
#  /* Clang has this in both C/C++, but MSVC has this in C++ only.*/
#  undef RBIMPL_HAS_DECLSPEC_ATTRIBUTE_nothrow
# endif
#endif

#endif /* RBIMPL_HAS_DECLSPEC_ATTRIBUTE_H */
PK       ! 0Y      ruby/internal/has/c_attribute.hnu [        #ifndef RBIMPL_HAS_C_ATTRIBUTE_H                     /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_HAS_C_ATTRIBUTE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_HAS_C_ATTRIBUTE.
 */

/** Wraps (or simulates) `__has_c_attribute`. */
#if defined(__cplusplus)
# /* Makes no sense. */
# define RBIMPL_HAS_C_ATTRIBUTE(_) 0

#elif defined(__has_c_attribute)
# define RBIMPL_HAS_C_ATTRIBUTE(_) __has_c_attribute(_)

#else
# /* As  of writing  everything  that lacks  __has_c_attribute also  completely
#  * lacks C2x attributes as well.  Might change in future? */
# define RBIMPL_HAS_C_ATTRIBUTE(_) 0
#endif

#endif /* RBIMPL_HAS_C_ATTRIBUTE_H */
PK       ! cH!  H!    ruby/internal/has/attribute.hnu [        #ifndef RBIMPL_HAS_ATTRIBUTE_H                       /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_HAS_ATTRIBUTE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_HAS_ATTRIBUTE.
 */
#include "ruby/internal/config.h"
#include "ruby/internal/compiler_since.h"

#if defined(__has_attribute)
# if __has_attribute(pure) || RBIMPL_COMPILER_IS(GCC)
#  /* FreeBSD's   <sys/cdefs.h>   defines   its   own   *broken*   version   of
#   * __has_attribute.   Cygwin copied  that  content  to be  a  victim of  the
#   * broken-ness.  We don't take them into account. */
#  define RBIMPL_HAVE___HAS_ATTRIBUTE 1
# endif
#endif

/** Wraps (or simulates) `__has_attribute`. */
#if defined(RBIMPL_HAVE___HAS_ATTRIBUTE)
# define RBIMPL_HAS_ATTRIBUTE(_) __has_attribute(_)

#elif RBIMPL_COMPILER_IS(GCC)
# /* GCC  <= 4  lack __has_attribute  predefined macro,  while have  attributes
#  * themselves.  We can simulate the macro like the following: */
# define RBIMPL_HAS_ATTRIBUTE(_) (RBIMPL_HAS_ATTRIBUTE_ ## _)
# define RBIMPL_HAS_ATTRIBUTE_aligned                    RBIMPL_COMPILER_SINCE(GCC, 0, 0, 0)
# define RBIMPL_HAS_ATTRIBUTE_alloc_size                 RBIMPL_COMPILER_SINCE(GCC, 4, 3, 0)
# define RBIMPL_HAS_ATTRIBUTE_artificial                 RBIMPL_COMPILER_SINCE(GCC, 4, 3, 0)
# define RBIMPL_HAS_ATTRIBUTE_always_inline              RBIMPL_COMPILER_SINCE(GCC, 3, 1, 0)
# define RBIMPL_HAS_ATTRIBUTE_cdecl                      RBIMPL_COMPILER_SINCE(GCC, 0, 0, 0)
# define RBIMPL_HAS_ATTRIBUTE_cold                       RBIMPL_COMPILER_SINCE(GCC, 4, 3, 0)
# define RBIMPL_HAS_ATTRIBUTE_const                      RBIMPL_COMPILER_SINCE(GCC, 2, 6, 0)
# define RBIMPL_HAS_ATTRIBUTE_deprecated                 RBIMPL_COMPILER_SINCE(GCC, 3, 1, 0)
# define RBIMPL_HAS_ATTRIBUTE_dllexport                  RBIMPL_COMPILER_SINCE(GCC, 0, 0, 0)
# define RBIMPL_HAS_ATTRIBUTE_dllimport                  RBIMPL_COMPILER_SINCE(GCC, 0, 0, 0)
# define RBIMPL_HAS_ATTRIBUTE_error                      RBIMPL_COMPILER_SINCE(GCC, 4, 3, 0)
# define RBIMPL_HAS_ATTRIBUTE_format                     RBIMPL_COMPILER_SINCE(GCC, 0, 0, 0)
# define RBIMPL_HAS_ATTRIBUTE_hot                        RBIMPL_COMPILER_SINCE(GCC, 4, 3, 0)
# define RBIMPL_HAS_ATTRIBUTE_leaf                       RBIMPL_COMPILER_SINCE(GCC, 4, 6, 0)
# define RBIMPL_HAS_ATTRIBUTE_malloc                     RBIMPL_COMPILER_SINCE(GCC, 3, 0, 0)
# define RBIMPL_HAS_ATTRIBUTE_no_address_safety_analysis RBIMPL_COMPILER_SINCE(GCC, 4, 8, 0)
# define RBIMPL_HAS_ATTRIBUTE_no_sanitize_address        RBIMPL_COMPILER_SINCE(GCC, 4, 8, 0)
# define RBIMPL_HAS_ATTRIBUTE_no_sanitize_undefined      RBIMPL_COMPILER_SINCE(GCC, 4, 9, 0)
# define RBIMPL_HAS_ATTRIBUTE_noinline                   RBIMPL_COMPILER_SINCE(GCC, 3, 1, 0)
# define RBIMPL_HAS_ATTRIBUTE_nonnull                    RBIMPL_COMPILER_SINCE(GCC, 3, 3, 0)
# define RBIMPL_HAS_ATTRIBUTE_noreturn                   RBIMPL_COMPILER_SINCE(GCC, 2, 5, 0)
# define RBIMPL_HAS_ATTRIBUTE_nothrow                    RBIMPL_COMPILER_SINCE(GCC, 3, 3, 0)
# define RBIMPL_HAS_ATTRIBUTE_pure                       RBIMPL_COMPILER_SINCE(GCC, 2,96, 0)
# define RBIMPL_HAS_ATTRIBUTE_returns_nonnull            RBIMPL_COMPILER_SINCE(GCC, 4, 9, 0)
# define RBIMPL_HAS_ATTRIBUTE_returns_twice              RBIMPL_COMPILER_SINCE(GCC, 4, 1, 0)
# define RBIMPL_HAS_ATTRIBUTE_stdcall                    RBIMPL_COMPILER_SINCE(GCC, 0, 0, 0)
# define RBIMPL_HAS_ATTRIBUTE_unused                     RBIMPL_COMPILER_SINCE(GCC, 0, 0, 0)
# define RBIMPL_HAS_ATTRIBUTE_visibility                 RBIMPL_COMPILER_SINCE(GCC, 3, 3, 0)
# define RBIMPL_HAS_ATTRIBUTE_warn_unused_result         RBIMPL_COMPILER_SINCE(GCC, 3, 4, 0)
# define RBIMPL_HAS_ATTRIBUTE_warning                    RBIMPL_COMPILER_SINCE(GCC, 4, 3, 0)
# define RBIMPL_HAS_ATTRIBUTE_weak                       RBIMPL_COMPILER_SINCE(GCC, 0, 0, 0)
# /* Note that "0, 0, 0" might be inaccurate. */

#elif RBIMPL_COMPILER_IS(SunPro)
# /* Oracle Solaris Studio 12.4 (cc version 5.11) introduced __has_attribute.
#  * Before that, following attributes were available. */
# /* See https://docs.oracle.com/cd/F24633_01/index.html */
# define RBIMPL_HAS_ATTRIBUTE(_) (RBIMPL_HAS_ATTRIBUTE_ ## _)
# define RBIMPL_HAS_ATTRIBUTE_alias                      RBIMPL_COMPILER_SINCE(SunPro, 5,  9, 0)
# define RBIMPL_HAS_ATTRIBUTE_aligned                    RBIMPL_COMPILER_SINCE(SunPro, 5,  9, 0)
# define RBIMPL_HAS_ATTRIBUTE_always_inline              RBIMPL_COMPILER_SINCE(SunPro, 5, 10, 0)
# define RBIMPL_HAS_ATTRIBUTE_const                      RBIMPL_COMPILER_SINCE(SunPro, 5,  9, 0)
# define RBIMPL_HAS_ATTRIBUTE_constructor                RBIMPL_COMPILER_SINCE(SunPro, 5,  9, 0)
# define RBIMPL_HAS_ATTRIBUTE_destructor                 RBIMPL_COMPILER_SINCE(SunPro, 5,  9, 0)
# define RBIMPL_HAS_ATTRIBUTE_malloc                     RBIMPL_COMPILER_SINCE(SunPro, 5,  9, 0)
# define RBIMPL_HAS_ATTRIBUTE_noinline                   RBIMPL_COMPILER_SINCE(SunPro, 5,  9, 0)
# define RBIMPL_HAS_ATTRIBUTE_noreturn                   RBIMPL_COMPILER_SINCE(SunPro, 5,  9, 0)
# define RBIMPL_HAS_ATTRIBUTE_packed                     RBIMPL_COMPILER_SINCE(SunPro, 5,  9, 0)
# define RBIMPL_HAS_ATTRIBUTE_pure                       RBIMPL_COMPILER_SINCE(SunPro, 5,  9, 0)
# define RBIMPL_HAS_ATTRIBUTE_returns_twice              RBIMPL_COMPILER_SINCE(SunPro, 5, 10, 0)
# define RBIMPL_HAS_ATTRIBUTE_vector_size                RBIMPL_COMPILER_SINCE(SunPro, 5, 10, 0)
# define RBIMPL_HAS_ATTRIBUTE_visibility                 RBIMPL_COMPILER_SINCE(SunPro, 5,  9, 0)
# define RBIMPL_HAS_ATTRIBUTE_weak                       RBIMPL_COMPILER_SINCE(SunPro, 5,  9, 0)

#elif defined (_MSC_VER)
# define RBIMPL_HAS_ATTRIBUTE(_) 0
# /* Fallback below doesn't work: see win32/Makefile.sub */

#else
# /* Take config.h definition when available. */
# define RBIMPL_HAS_ATTRIBUTE(_) ((RBIMPL_HAS_ATTRIBUTE_ ## _)+0)
# ifdef ALWAYS_INLINE
#  define RBIMPL_HAS_ATTRIBUTE_always_inline 1
# endif
# ifdef FUNC_CDECL
#  define RBIMPL_HAS_ATTRIBUTE_cdecl 1
# endif
# ifdef CONSTFUNC
#  define RBIMPL_HAS_ATTRIBUTE_const 1
# endif
# ifdef DEPRECATED
#  define RBIMPL_HAS_ATTRIBUTE_deprecated 1
# endif
# ifdef ERRORFUNC
#  define RBIMPL_HAS_ATTRIBUTE_error 1
# endif
# ifdef FUNC_FASTCALL
#  define RBIMPL_HAS_ATTRIBUTE_fastcall 1
# endif
# ifdef PUREFUNC
#  define RBIMPL_HAS_ATTRIBUTE_pure 1
# endif
# ifdef NO_ADDRESS_SAFETY_ANALYSIS
#  define RBIMPL_HAS_ATTRIBUTE_no_address_safety_analysis 1
# endif
# ifdef NO_SANITIZE
#  define RBIMPL_HAS_ATTRIBUTE_no_sanitize 1
# endif
# ifdef NO_SANITIZE_ADDRESS
#  define RBIMPL_HAS_ATTRIBUTE_no_sanitize_address 1
# endif
# ifdef NOINLINE
#  define RBIMPL_HAS_ATTRIBUTE_noinline 1
# endif
# ifdef RBIMPL_FUNC_NONNULL
#  define RBIMPL_HAS_ATTRIBUTE_nonnull 1
# endif
# ifdef NORETURN
#  define RBIMPL_HAS_ATTRIBUTE_noreturn 1
# endif
# ifdef FUNC_OPTIMIZED
#  define RBIMPL_HAS_ATTRIBUTE_optimize 1
# endif
# ifdef FUNC_STDCALL
#  define RBIMPL_HAS_ATTRIBUTE_stdcall 1
# endif
# ifdef MAYBE_UNUSED
#  define RBIMPL_HAS_ATTRIBUTE_unused 1
# endif
# ifdef WARN_UNUSED_RESULT
#  define RBIMPL_HAS_ATTRIBUTE_warn_unused_result 1
# endif
# ifdef WARNINGFUNC
#  define RBIMPL_HAS_ATTRIBUTE_warning 1
# endif
# ifdef WEAK
#  define RBIMPL_HAS_ATTRIBUTE_weak 1
# endif
#endif

#endif /* RBIMPL_HAS_ATTRIBUTE_H */
PK       !       ruby/internal/has/warning.hnu [        #ifndef RBIMPL_HAS_WARNING_H                         /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_HAS_WARNING_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_HAS_WARNING.
 */

/** Wraps (or simulates) `__has_warning`. */
#if defined(__has_warning)
# define RBIMPL_HAS_WARNING(_) __has_warning(_)
#else
# define RBIMPL_HAS_WARNING(_) 0
#endif

#endif /* RBIMPL_HAS_WARNING_H */
PK       ! fJ  J    ruby/internal/config.hnu [        #ifndef RBIMPL_CONFIG_H                              /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_CONFIG_H
/**
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Thin wrapper to ruby/config.h
 */
#include "ruby/config.h"

#ifdef RUBY_EXTCONF_H
# include RUBY_EXTCONF_H
#endif

#include "ruby/internal/compiler_since.h"

#undef  HAVE_PROTOTYPES
#define HAVE_PROTOTYPES 1

#unde