.
 * @exception   rb_eTypeError  The constant  name `name`  is already  taken but
 *                             the constant is not a class.
 * @exception   rb_eTypeError  The class  is already defined but  the class can
 *                             not be  reopened because  its superclass  is not
 *                             `super`.
 * @exception   rb_eArgError   `super` is NULL.
 * @return      The created class.
 * @post        `outer::name` refers the returned class.
 * @note        If a class  named `name` is already defined  and its superclass
 *              is `super`, the function just returns the defined class.
 * @note        The  compaction  GC does  not  move  classes returned  by  this
 *              function.
 */
VALUE rb_define_class_under(VALUE outer, const char *name, VALUE super);

RBIMPL_ATTR_NONNULL(())
/**
 * Defines a module under the namespace of `outer`.
 *
 * @param[out]  outer          A class which contains the new module.
 * @param[in]   name           Name of the new module
 * @exception   rb_eTypeError  The constant  name `name`  is already  taken but
 *                             the constant is not a class.
 * @return      The created module.
 * @post        `outer::name` refers the returned module.
 * @note        The  compaction  GC does  not  move  classes returned  by  this
 *              function.
 */
VALUE rb_define_module_under(VALUE outer, const char *name);

/**
 * Includes a module to a class.
 *
 * @param[out]  klass         Inclusion destination.
 * @param[in]   module        Inclusion source.
 * @exception   rb_eArgError  Cyclic inclusion.
 *
 * @internal
 *
 * :FIXME: @shyouhei suspects this function  lacks assertion that the arguments
 * being modules...  Could silently SEGV if non-module was passed?
 */
void rb_include_module(VALUE klass, VALUE module);

/**
 * Extend the object with the module.
 *
 * @warning     This    is   the    same    as   `Module#extend_object`,    not
 *              `Object#extend`!  These  two methods are very  similar, but not
 *              identical.  The difference is the hook.  `Module#extend_object`
 *              does not invoke `Module#extended`, while `Object#extend` does.
 * @param[out]  obj  Object to extend.
 * @param[in]   mod  Module of extension.
 */
void rb_extend_object(VALUE obj, VALUE mod);

/**
 * Identical to rb_include_module(), except it  "prepends" the passed module to
 * the klass,  instead of  includes.  This affects  how `super`  resolves.  For
 * instance:
 *
 * ```ruby
 * class  Q;                def foo;      "<q/>"       end end
 * module W;                def foo; "<w>#{super}</w>" end end
 * class  E < Q; include W; def foo; "<e>#{super}</e>" end end
 * class  R < Q; prepend W; def foo; "<r>#{super}</r>" end end
 *
 * E.new.foo # => "<e><w><q/></w></e>"
 * r.new.foo # => "<W><r><q/></r></w>"
 * ```
 *
 * @param[out]  klass         Target class to modify.
 * @param[in]   module        Module to prepend.
 * @exception   rb_eArgError  Cyclic inclusion.
 */
void rb_prepend_module(VALUE klass, VALUE module);

/** @} */

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_MODULE_H */
PK       ! CP  P    ruby/internal/error.hnu [        #ifndef RBIMPL_ERROR_H                               /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ERROR_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Declares ::rb_raise().
 */
#include "ruby/internal/attr/cold.h"
#include "ruby/internal/attr/format.h"
#include "ruby/internal/attr/noreturn.h"
#include "ruby/internal/attr/nonnull.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"

/**
 * @defgroup exception Exception handlings
 * @{
 */

/**
 * Warning  categories.  A  warning issued  using this  API can  be selectively
 * requested   /   suppressed   by   the  end-users.   For   instance   passing
 * `-W:no-deprecated`  to the  ruby process  would suppress  those warnings  in
 * deprecated category.
 *
 * @warning    There is no way to declare a new category (for now).
 */
typedef enum {
    /** Category unspecified. */
    RB_WARN_CATEGORY_NONE,

    /** Warning is for deprecated features. */
    RB_WARN_CATEGORY_DEPRECATED,

    /** Warning is for experimental features. */
    RB_WARN_CATEGORY_EXPERIMENTAL,

    RB_WARN_CATEGORY_ALL_BITS = 0x6 /* no RB_WARN_CATEGORY_NONE bit */
} rb_warning_category_t;

/** for rb_readwrite_sys_fail first argument */
enum rb_io_wait_readwrite {RB_IO_WAIT_READABLE, RB_IO_WAIT_WRITABLE};
/** @cond INTERNAL_MACRO */
#define RB_IO_WAIT_READABLE RB_IO_WAIT_READABLE
#define RB_IO_WAIT_WRITABLE RB_IO_WAIT_WRITABLE
/** @endcond */

RBIMPL_SYMBOL_EXPORT_BEGIN()

/**
 * This is the same as `$!` in Ruby.
 *
 * @retval   RUBY_Qnil  Not handling exceptions at the moment.
 * @retval   otherwise  The current exception in the current thread.
 * @ingroup  exception
 */
VALUE rb_errinfo(void);

/**
 * Sets the current exception (`$!`) to the given value.
 *
 * @param[in]  err            An instance of ::rb_eException, or ::RUBY_Qnil.
 * @exception  rb_eTypeError  What  is given  was  neither ::rb_eException  nor
 *                            ::RUBY_Qnil.
 * @note       Use  rb_raise()  instead to  raise  `err`.   This function  just
 *             assigns the given object to the global variable.
 * @ingroup    exception
 */
void rb_set_errinfo(VALUE err);

RBIMPL_ATTR_NORETURN()
RBIMPL_ATTR_NONNULL((2))
RBIMPL_ATTR_FORMAT(RBIMPL_PRINTF_FORMAT, 2, 3)
/**
 * Exception  entry point.   By calling  this  function the  execution of  your
 * program gets interrupted to "raise" an  exception up to the callee entities.
 * Programs could "rescue" that exception, or could "ensure" some part of them.
 * If nobody cares  about such things, the raised exception  reaches at the top
 * of execution.  This yields abnormal end of the process.
 *
 * @param[in]  exc  A subclass of ::rb_eException.
 * @param[in]  fmt  Format specifier string compatible with rb_sprintf().
 * @exception  exc  The specified exception.
 * @note       It never returns.
 */
void rb_raise(