/**< @old{RB_NUM2USHORT} */
#define USHORT2NUM    RB_INT2FIX          /**< @old{RB_INT2FIX} */
#define RB_FIX2SHORT  rb_fix2short        /**< @alias{rb_fix2ushort} */
#define FIX2SHORT     RB_FIX2SHORT        /**< @old{RB_FIX2SHORT} */

RBIMPL_SYMBOL_EXPORT_BEGIN()

/**
 * Converts an instance of ::rb_cNumeric into C's `short`.
 *
 * @param[in]  num             Something numeric.
 * @exception  rb_eTypeError   `num` is not a numeric.
 * @exception  rb_eRangeError  `num` is out of range of `short`.
 * @return     The passed value converted into C's `short`.
 */
short rb_num2short(VALUE num);

/**
 * Converts an instance of ::rb_cNumeric into C's `unsigned short`.
 *
 * @param[in]  num             Something numeric.
 * @exception  rb_eTypeError   `num` is not a numeric.
 * @exception  rb_eRangeError  `num` is out of range of `unsigned short`.
 * @return     The passed value converted into C's `unsigned short`.
 */
unsigned short rb_num2ushort(VALUE num);

/**
 * Identical to rb_num2short().
 *
 * @param[in