er  a  directory,  or a  symlink  that
 * (potentially recursively) points to such thing.
 *
 * @param[in]  _                   Ignored (why...?)
 * @param[in]  path                String,  or IO.   In  case of  IO it  issues
 *                                 `fstat(2)` instead of `stat(2)`.
 * @exception  rb_eFrozenError     `path` is a frozen IO (why...?)
 * @exception  rb_eTypeError       `path` is neither String nor IO.
 * @exception  rb_eArgError        `path` contains NUL bytes.
 * @exception  rb_eEncCompatError  `path`'s encoding is not path-compat.
 * @retval     RUBY_Qtrue          `path` is a directory.
 * @retval     RUBY_Qfalse         Otherwise.
 */
VALUE rb_file_directory_p(VALUE _, VALUE path);

/**
 * Converts a  string into an  "OS Path" encoding,  if any.  In  most operating
 * systems there are  no such things like per-OS default  encoding of filename.
 * For them this  function is no-op.  However most notably  on MacOS, pathnames
 * are UTF-8 encoded.  It converts the given string into such encoding.
 *
 * @param[in]  path                An instance of ::rb_cString.
 * @exception  rb_eEncCompatError  `path`'s encoding is not path-compat.
 * @return     `path`'s contents converted to the OS' path encoding.
 */
VALUE rb_str_encode_ospath(VALUE path);

RBIMPL_ATTR_NONNULL(())
RBIMPL_ATTR_PURE()
/**
 * Queries if the given path is an  absolute path.  On POSIX environments it is
 * as easy  as `path[0]  == '/'`.   However on Windows,  drive letters  and UNC
 * paths are also taken into account.
 *
 * @param[in]  path  A possibly relative path string.
 * @retval     1     `path` is absolute.
 * @retval     0     `path` is relative.
 */
int rb_is_absolute_path(const char *path);

/**
 * Queries  the file  size  of the  given file.   Because  this function  calls
 * `fstat(2)`  internally, it  is  a failure  to  pass a  closed  file to  this
 * function.
 *
 * This function flushes the passed file's buffer if any.  Can take time.
 *
 * @param[in]   file                 A file object.
 * @exception   rb_eFrozenError      `file` is frozen.
 * @exception   rb_eIOError          `file` is closed.
 * @exception   rb_eSystemCallError  Permission denied etc.
 * @exception   rb_eNoMethodError    The given non-file object doesn't respond
 *                                   to `#size`.
 * @return      The size of the passed file.
 * @note        Passing a non-regular file such as a UNIX domain socket to this
 *              function  is   not  a  failure.    But  the  return   value  is
 *              unpredictable.  POSIX's `<sys/stat.h>` states  that "the use of
 *              this field is unspecified" then.
 */
rb_off_t rb_file_size(VALUE file);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_INTERN_FILE_H */
PK       ! {C	0  0  !  ruby/internal/intern/enumerator.hnu [        #ifndef RBIMPL_INTERN_ENUMERATOR_H                   /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_INTERN_ENUMERATOR_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Public APIs related to ::rb_cEnumerator.
 */
#include "ruby/internal/attr/nonnull.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/intern/eval.h" /* rb_frame_this_func */
#include "ruby/internal/iterator.h"    /* rb_block_given_p */
#include "ruby/internal/symbol.h"
#include "ruby/internal/value.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()

/**
 * This is the type of functions that rb_enumeratorize_with_size() expects.  In
 * theory an enumerator can have indefinite number of elements, but in practice
 * it often is  the case we can  compute the size of  an enumerator beforehand.
 * If your enumerator has such property, supply a function that calculates such
 * values.
 *
 * @param[in]  recv  The original receiver of the enumerator.
 * @param[in]  argv  Arguments passed to `Object#enum_for` etc.
 * @param[in]  eobj  The enumerator object.
 * @return     The size of `eobj`, in ::rb_cNumeric, or ::RUBY_Qnil if the size
 *             is not known until we actually iterate.
 */
typedef VALUE rb_enumerator_size_func(VALUE recv, VALUE argv, VALUE eobj);

/**
 * Decomposed   `Enumerator::ArithmeicSequence`.   This   is   a  subclass   of
 * ::rb_cEnumerator,  which  represents  a  sequence  of  numbers  with  common
 * difference.  Internal  data structure of the  class is opaque to  users, but
 * you can obtain a decomposed one using rb_arithmetic_sequence_extract().
 */
typedef struct {
    VALUE begin;          /**< "Left" or "lowest" endpoint of the sequence. */
    VALUE end;            /**< "Right" or "highest" endpoint of the sequence.*/
    VALUE step;           /**< Step between a sequence. */
    int exclude_end;      /**< Whether the endpoint is open or closed.  */
} rb_arithmetic_sequence_components_t;

/* enumerator.c */

/**
 *