fer.
 * @exception   rb_eSystemCallError  Access denied for hardware clock.
 * @post        Current time is stored in `*ts`.
 */
void rb_timespec_now(struct timespec *ts);

/**
 * Creates  an  instance of  ::rb_cTime  with  the  given  time and  the  local
 * timezone.
 *
 * @param[in]  sec             Seconds since the UNIX epoch.
 * @param[in]  usec            Subsecond part, in microseconds resolution.
 * @exception  rb_eRangeError  Cannot express the time.
 * @return     An allocated instance of ::rb_cTime.
 */
VALUE rb_time_new(time_t sec, long usec);

/**
 * Identical  to  rb_time_new(), except  it  accepts  the time  in  nanoseconds
 * resolution.
 *
 * @param[in]  sec             Seconds since the UNIX epoch.
 * @param[in]  nsec            Subsecond part, in nanoseconds resolution.
 * @exception  rb_eRangeError  Cannot express the time.
 * @return     An allocated instance of ::rb_cTime.
 */
VALUE rb_time_nano_new(time_t sec, long nsec);

RBIMPL_ATTR_NONNULL(())
/**
 * Creates an instance of ::rb_cTime, with given time and offset.
 *
 * @param[in]  ts            Time specifier.
 * @param[in]  offset        Offset specifier, can take following values:
 *                           - `INT_MAX`: `ts` is in local time.
 *                           - `INT_MAX - 1`: `ts` is in UTC.
 *                           - `-86400` to `86400`: fixed timezone.
 * @exception  rb_eArgError  Malformed `offset`.
 * @return     An allocated instance of ::rb_cTime.
 */
VALUE rb_time_timespec_new(const struct timespec *ts, int offset);

/**
 * Identical to rb_time_timespec_new(), except it  takes Ruby values instead of
 * C structs.
 *
 * @param[in]  timev         Something numeric.  Currently Integers, Rationals,
 *                           and Floats are accepted.
 * @param[in]  off           Offset  specifier.  As  of  2.7  this argument  is
 *                           heavily  extended  to   take  following  kinds  of
 *                           objects:
 *                             - ::RUBY_Qundef ... means UTC.
 *                             - ::rb_cString ... "+12:34" etc.
 *                             - A mysterious  "zone" object.  This  is largely
 *                               undocumented.  However the  initial intent was
 *                               that       we       want       to       accept
 *                               `ActiveSupport::TimeZone`  here.   Other  gems
 *                               could also be possible...   But how to make an
 *                               acceptable class is beyond this document.
 * @exception  rb_eArgError  Malformed `off`.
 * @return     An allocated instance of ::rb_cTime.
 */
VALUE rb_time_num_new(VALUE timev, VALUE off);

/**
 * Creates  a  "time  interval".   This   basically  converts  an  instance  of
 * ::rb_cNumeric  into  a struct  `timeval`,  but  for instance  negative  time
 * interval must not exist.
 *
 * @param[in]  num             An instance of ::rb_cNumeric.
 * @exception  rb_eArgError    `num` is negative.
 * @exception  rb_eRangeError  `num` is out of range of `timeval::tv_sec`.
 * @return     A struct that represents the identical time to `num`.
 */
struct timeval rb_time_interval(VALUE num);

/**
 * Converts an  instance of rb_cTime  to a  struct timeval that  represents the
 * identical point of time.  It can also take something numeric; would consider
 * it as a UNIX time then.
 *
 * @param[in]  time            Instance of either ::rb_cTime or ::rb_cNumeric.
 * @exception  rb_eRangeError  `time` is out of range of `timeval::tv_sec`.
 * @return     A struct that represents the identical time to `num`.
 */
struct timeval rb_time_timeval(VALUE time);

/**
 * Identical to rb_time_timeval(), except for return type.
 *
 * @param[in]  time            Instance of either ::rb_cTime or ::rb_cNumeric.
 * @exception  rb_eRangeError  `time` is out of range of `timeval::tv_sec`.
 * @return     A struct that represents the identical time to `num`.
 */
struct timespec rb_time_timespec(VALUE time);

/**
 * Identical to rb_time_interval(), except for return type.
 *
 * @param[in]  num             An instance of ::rb_cNumeric.
 * @excepti