 and Ruby's.
 */
#include "ruby/internal/config.h"
#include "ruby/internal/arithmetic/fixnum.h"
#include "ruby/internal/arithmetic/intptr_t.h"
#include "ruby/internal/arithmetic/long.h"
#include "ruby/internal/attr/artificial.h"
#include "ruby/internal/attr/const.h"
#include "ruby/internal/attr/constexpr.h"
#include "ruby/internal/compiler_is.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/special_consts.h"
#include "ruby/internal/value.h"
#include "ruby/internal/warning_push.h"
#include "ruby/assert.h"

#define RB_INT2NUM  rb_int2num_inline  /**< @alias{rb_int2num_inline} */
#define RB_NUM2INT  rb_num2int_inline  /**< @alias{rb_num2int_inline} */
#define RB_UINT2NUM rb_uint2num_inline /**< @alias{rb_uint2num_inline} */

#define FIX2INT    RB_FIX2INT          /**< @old{RB_FIX2INT} */
#define FIX2UINT   RB_FIX2UINT         /**< @old{RB_FIX2UINT} */
#define INT2NUM    RB_INT2NUM          /**< @old{RB_INT2NUM} */
#define NUM2INT    RB_NUM2INT          /**< @old{RB_NUM2INT} */
#define NUM2UINT   RB_NUM2UINT         /**< @old{RB_NUM2UINT} */
#define UINT2NUM   RB_UINT2NUM         /**< @old{RB_UINT2NUM} */

/** @cond INTERNAL_MACRO */
#define RB_FIX2INT  RB_FIX2INT
#define RB_NUM2UINT RB_NUM2UINT
#define RB_FIX2UINT RB_FIX2UINT
/** @endcond */

RBIMPL_SYMBOL_EXPORT_BEGIN()

/**
 * Converts an instance of ::rb_cNumeric into C's `long`.
 *
 * @param[in]  num             Something numeric.
 * @exception  rb_eTypeError   `num` is not a numeric.
 * @exception  rb_eRangeError  `num` is out of range of `int`.
 * @return     The passed value converted into C's `long`.
 *
 * @internal
 *
 * Yes, the  API is  really strange.   It returns `long`,  but raises  when the
 * value is out of `int`.  This seems to  be due to the fact that Matz favoured
 * K&R before, and his machine at that moment was an ILP32 architecture.
 */
long rb_num2int(VALUE num);

/**
 * Identical to rb_num2int().
 *
 * @param[in]  num             Something numeric.
 * @exception  rb_eTypeError   `num` is not a numeric.
 * @exception  rb_eRangeError  `num` is out of range of `int`.
 * @return     The passed value converted into C's `long`.
 *
 * @internal
 *
 * This function seems to be a complete  waste of disk space.  @shyouhei has no
 * idea why this is a different thing from rb_num2short().
 */
long rb_fix2int(VALUE num);

/**
 * Converts an instance of ::rb_cNumeric into C's `unsigned long`.
 *
 * @param[in]  num             Something numeric.
 * @exception  rb_eTypeError   `num` is not a numeric.
 * @exception  rb_eRangeError  `num` is out of range of `unsigned int`.
 * @return     The passed value converted into C's `unsigned long`.
 *
 * @internal
 *
 * Yes, the API is really strange.  It returns `unsigned long`, but raises when
 * the value is out  of `unsigned int`.  This seems to be due  to the fact that
 * Matz  favoured K&R  before, and  his  machine a