ds. */
    union {

        /**
         * Object that use  separated memory region for  instance variables use
         * this pattern.
         */
        struct {
            /** Pointer to a C array that holds instance variables. */
            VALUE *ivptr;

            /**
             * This  is a  table that  holds  instance variable  name to  index
             * mapping.  Used when accessing instance variables using names.
             *
             * @internal
             *
             * This is a shortcut for `RCLASS_IV_INDEX_TBL(rb_obj_class(obj))`.
             */
            struct rb_id_table *iv_index_tbl;
        } heap;

#if USE_RVARGC
        /* Embedded instance variables. When an object is small enough, it
         * uses this area to store the instance variables.
         *
         * This is a length 1 array because:
         *   1. GCC has a bug that does not optimize C flexible array members
         *      (https://gcc.gnu.org/bugzilla/show_bug.cgi?id=102452)
         *   2. Zero length arrays are not supported by all compilers
         */
        VALUE ary[1];
#else
        /**
        * Embedded instance  variables.  When  an object  is small  enough, it
        * uses this area to store the instance variables.
        */
        VALUE ary[ROBJECT_EMBED_LEN_MAX];
#endif
    } as;
};

/* Offsets for YJIT */
#ifndef __cplusplus
static const int32_t ROBJECT_OFFSET_AS_HEAP_IVPTR = offsetof(struct RObject, as.heap.ivptr);
static const int32_t ROBJECT_OFFSET_AS_HEAP_IV_INDEX_TBL = offsetof(struct RObject, as.heap.iv_index_tbl);
static const int32_t ROBJECT_OFFSET_AS_ARY = offsetof(struct RObject, as.ary);
#endif

RBIMPL_ATTR_PURE_UNLESS_DEBUG()
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Queries the instance variables.
 *
 * @param[in]  obj  Object in question.
 * @return     Its instance variables, in C array.
 * @pre        `obj` must be an instance of ::RObject.
 *
 * @internal
 *
 * @shyouhei finds no reason for this to be visible from extension libraries.
 */
static inline VALUE *
ROBJECT_IVPTR(VALUE obj)
{
    RBIMPL_ASSERT_TYPE(obj, RUBY_T_OBJECT);

    struct RObject *const ptr = ROBJECT(obj);

    if (RB_FL_ANY_RAW(obj, ROBJECT_EMBED)) {
        return ptr->as.ary;
    }
    else {
        return ptr->as.heap.ivptr;
    }
}

#endif /* RBIMPL_ROBJECT_H */
PK       ! D7  7    ruby/internal/core/rbasic.hnu [        #ifndef RBIMPL_RBASIC_H                              /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_RBASIC_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines struct ::RBasic.
 */
#include "ruby/internal/attr/artificial.h"
#include "ruby/internal/attr/constexpr.h"
#include "ruby/internal/attr/forceinline.h"
#include "ruby/internal/attr/noalias.h"
#include "ruby/internal/attr/pure.h"
#include "ruby/internal/cast.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/special_consts.h"
#include "ruby/internal/value.h"
#include "ruby/assert.h"

/**
 * Convenient casting macro.
 *
 * @param   obj  Arbitrary Ruby object.
 * @return  The passed object casted to ::RBasic.
 */
#define RBASIC(obj)                 RBIMPL_CAST((struct RBasic *)(obj))
/** @cond INTERNAL_MACRO */
#define RBASIC_CLASS                RBASIC_CLASS
#define RBIMPL_RVALUE_EMBED_LEN_MAX 3
#define RVALUE_EMBED_LEN_MAX        RVALUE_EMBED_LEN_MAX
#define RBIMPL_EMBED_LEN_MAX_OF(T) \
    RBIMPL_CAST((int)(sizeof(VALUE[RBIMPL_RVALUE_EMBED_LEN_MAX]) / (sizeof(T))))
/** @endcond */

/**
 * This is an enum because GDB wants it (rather than a macro).  People need not
 * bother.
 */
enum ruby_rvalue_flags {
    /** Max possible number of objects that can be embedded. */
    RVALUE_EMBED_LEN_MAX = RBIMPL_RVALUE_EMBED_LEN_MAX
};

/**
 * Ruby's object's,  base components.  Every  single ruby objects have  them in
 * common.
 */
struct
RUBY_ALIGNAS(SIZEOF_VALUE)
RBasic {

    /**
     * Per-object  flags.  Each  ruby  objects have  their own  characteristics
     * apart from their  classes.  For instance whether an object  is frozen or
     * not is not  controlle