    \
            free,            \
            sval);           \
        data_struct_obj;     \
    })
#else
#define Data_Make_Struct(klass, type, mark, free, sval) \
    rb_data_object_make(              \
        (klass),                      \
        RBIMPL_DATA_FUNC(mark),        \
        RBIMPL_DATA_FUNC(free),        \
        RBIMPL_CAST((void **)&(sval)), \
        sizeof(type))
#endif

/**
 * Obtains a C struct from inside of a wrapper Ruby object.
 *
 * @param      obj            An instance of ::RData.
 * @param      type           Type name of the C struct.
 * @param      sval           Variable name of obtained C struct.
 * @return     Unwrapped C struct that `obj` holds.
 */
#define Data_Get_Struct(obj, type, sval) \
    ((sval) = RBIMPL_CAST((type*)rb_data_object_get(obj)))

RBIMPL_ATTRSET_UNTYPED_DATA_FUNC()
/**
 * @private
 *
 * This is an implementation detail of rb_data_object_wrap().  People don't use
 * it directly.
 *
 * @param[in]  klass          Ruby level class of the returning object.
 * @param[in]  ptr            Pointer to the target C struct.
 * @param[in]  mark           Mark function.
 * @param[in]  free           Free function.
 * @exception  rb_eTypeError  `klass` is not a class.
 * @exception  rb_eNoMemError  Out of memory.
 * @return     An allocated object that wraps `datap`.
 */
static inline VALUE
rb_data_object_wrap_warning(VALUE klass, void *ptr, RUBY_DATA_FUNC mark, RUBY_DATA_FUNC free)
{
    return rb_data_object_wrap(klass, ptr, mark, free);
}

/**
 * @private
 *
 * This is an  implementation detail of #Data_Get_Struct.  People  don't use it
 * directly.
 *
 * @param[in]  obj  An instance of ::RData.
 * @return     Unwrapped C struct that `obj` holds.
 */
static inline void *
rb_data_object_get(VALUE obj)
{
    Check_Type(obj, RUBY_T_DATA);
    return DATA_PTR(obj);
}

RBIMPL_ATTRSET_UNTYPED_DATA_FUNC()
/**
 * @private
 *
 * This is an  implementation detail of #Data_Get_Struct.  People  don't use it
 * directly.
 *
 * @param[in]  obj  An instance of ::RData.
 * @return     Unwrapped C struct that `obj` holds.
 */
static inline void *
rb_data_object_get_warning(VALUE obj)
{
    return rb_data_object_get(obj);
}

#if defined(HAVE_BUILTIN___BUILTIN_CHOOSE_EXPR_CONSTANT_P)
# define rb_data_object_wrap_warning(klass, ptr, mark, free) \
    RB_GNUC_EXTENSION(                                       \
        __builtin_choose_expr(                               \
            __builtin_constant_p(klass) && !(klass),         \
            rb_data_object_wrap(klass, ptr, mark, free),     \
            (rb_data_object_wrap_warning)(klass, ptr, mark, free)))
#endif

/**
 * This is an implementation detail  of #Data_Make_Struct.  People don't use it
 * directly.
 *
 * @param[in]  klass           Ruby level class of the returning object.
 * @param[in]  mark_func       Mark function.
 * @param[in]  free_func       Free function.
 * @param[in]  datap           Variable of created C struct.
 * @param[in]  size            Requested size of allocation.
 * @exception  rb_eTypeError  `klass` is not a class.
 * @exception  rb_eNoMemError  Out of memory.
 * @return     A created Ruby object.
 * @post       `*datap` holds the created C struct.
 */
static inline VALUE
rb_data_object_make(VALUE klass, RUBY_DATA_FUNC mark_func,