NNULL((1))
RBIMPL_ATTR_FORMAT(RBIMPL_PRINTF_FORMAT, 1, 2)
/**
 * Raises the unsung "fatal" exception.  This is considered severe.  Nobody can
 * rescue  the  exception.  Once  raised,  process  termination is  inevitable.
 * However ensure clauses still run, so that resources are properly cleaned up.
 *
 * @param[in]  fmt        Format specifier string compatible with rb_sprintf().
 * @exception  rb_eFatal  An exception that you cannot rescue.
 * @note       It never returns.
 */
void rb_fatal(const char *fmt, ...);

RBIMPL_ATTR_COLD()
RBIMPL_ATTR_NORETURN()
RBIMPL_ATTR_NONNULL((1))
RBIMPL_ATTR_FORMAT(RBIMPL_PRINTF_FORMAT, 1, 2)
/**
 * Interpreter  panic  switch.   Immediate   process  termination  without  any
 * synchronisations shall  occur.  LOTS of  internal states, stack  traces, and
 * even  machine registers  are displayed  if possible  for debugging  purposes
 * then.
 *
 * @warning    Do not use this API.
 * @warning    You are not expected to use this API.
 * @warning    Why not just fix your code instead of calling this API?
 * @warning    It was a  bad idea to expose this API  to extension libraries at
 *             the first  place.  We just  cannot delete  it at this  point for
 *             backwards  compatibility.    That  doesn't  mean   everyone  are
 *             welcomed to call this function at will.
 * @param[in]  fmt  Format specifier string compatible with rb_sprintf().
 * @note       It never returns.
 */
void rb_bug(const char *fmt, ...);

RBIMPL_ATTR_NORETURN()
RBIMPL_ATTR_NONNULL(())
/**
 * This is  a wrapper  of rb_bug()  which automatically  constructs appropriate
 * message from the passed errno.
 *
 * @param[in]  msg  Additional message to display.
 * @exception  err  C level errno.
 * @note       It never returns.
 */
void rb_bug_errno(const char *msg, int err);

RBIMPL_ATTR_NORETURN()
/**
 * Converts a C errno into a Ruby exception, then raises it.  For instance:
 *
 * ```CXX
 * static VALUE
 * foo(VALUE argv)
 * {
 *    const auto cmd = StringValueCStr(argv);
 *    const auto waitr = system(cmd);
 *    if (waitr == -1) {
 *        rb_sys_fail("system(3posix)"); // <-------------- this
 *    }
 *    else {
 *        return INT2FIX(fd);
 *    }
 * }
 * ```
 *
 * @param[in]  msg                  Additional message to raise.
 * @exception  rb_eSystemCallError  An exception representing errno.
 * @note       It never returns.
 */
void rb_sys_fail(const char *msg);

RBIMPL_ATTR_NORETURN()
/**
 * Identical to  rb_sys_fail(), except  it takes the  message in  Ruby's String
 * instead of C's.
 *
 * @param[in]  msg                  Additional message to raise.
 * @exception  rb_eSystemCallError  An exception representing errno.
 * @note       It never returns.
 */
void rb_sys_fail_str(VALUE msg);

RBIMPL_ATTR_NORETURN()
RBIMPL_ATTR_NONNULL((2))
/**
 * Identical to rb_sys_fail(), except it  takes additional module to extend the
 * exception object before raising.
 *
 * @param[in]  mod                  A ::rb_cModule instance.
 * @param[in]  msg                  Additional message to raise.
 * @exception  rb_eSystemCallError  An exception representing errno.
 * @note       It never returns.
 *
 * @internal
 *
 * Does anybody use it?
 */
void rb_mod_sys_fail(VALUE mod, const char *msg);

RBIMPL_ATTR_NORETURN()
/**
 * Identical to rb_mod_sys_fail(), except it takes the message in Ruby's String
 * instead of C's.
 *
 * @param[in]  mod                  A ::rb_cModule instance.
 * @param[in]  msg                  Additional message to raise.
 * @exception  rb_eSystemCallError  An exception representing errno.
 * @note       It never returns.
 */
void rb_mod_sys_fail_str(VALUE mod, VALUE msg);

RBIMPL_ATTR_NORETURN()
/**
 * Raises appropriate exception using the parameters.
 *
 * In Ruby level there are  rb_eEAGAINWaitReadable etc.  This function maps the
 * given parameter to an appropriate exception class, then raises it.
 *
 * @param[in]  waiting  Reason for the IO to wait.
 * @param[in]  msg      A