 * We want C11's `_Alignof`.  However in spite of its clear language, compilers
 * (including GCC  and clang) tend to  have buggy implementations.  We  have to
 * avoid such things to resort to our own version.
 *
 * @see https://gcc.gnu.org/bugzilla/show_bug.cgi?id=52023
 * @see https://gcc.gnu.org/bugzilla/show_bug.cgi?id=69560
 * @see https://bugs.llvm.org/show_bug.cgi?id=26547
 */
#if defined(__DOXYGEN__)
# define RBIMPL_ALIGNOF alignof
#elif defined(__cplusplus)
# /* C++11 `alignof()` can be buggy. */
# /* see: https://gcc.gnu.org/bugzilla/show_bug.cgi?id=69560 */
# /* But don't worry, we can use templates. */
# define RBIMPL_ALIGNOF(T) (static_cast<size_t>(ruby::rbimpl_alignof<T>::value))

namespace ruby {
template<typename T>
struct rbimpl_alignof {
    typedef struct {
        char _;
        T t;
    } type;

    enum {
        value = offsetof(type, t)
    };
};
}

#elif RBIMPL_COMPILER_IS(MSVC)
# /* Windows have no alignment glitch.*/
# define RBIMPL_ALIGNOF __alignof

#elif defined(HAVE__ALIGNOF)
# /* Autoconf detected availability of a sane `_Alignof()`. */
# define RBIMPL_ALIGNOF(T) RB_GNUC_EXTENSION(_Alignof(T))

#else
# /* :BEWARE:  This is  the last  resort.   If your  compiler somehow  supports
#  * querying the alignment of a type,  you definitely should use that instead.
#  * There are 2 known pitfalls for this fallback implementation:
#  *
#  * First, it is either an undefined  behaviour (C) or an explicit error (C++)
#  * to define a  struct inside of `offsetof`.  C compilers  tend to accept such
#  * things, but AFAIK C++ has no room to allow.
#  *
#  * Second, there exist T  such that `struct { char _; T t;  }` is invalid.  A
#  * known example is  when T is a  struct with a flexible  array member.  Such
#  * struct cannot be enclosed into another one.
#  */
# /* see: http://www.open-std.org/jtc1/sc22/wg14/www/docs/n2083.htm */
# /* see: http://www.open-std.org/jtc1/sc22/wg14/www/docs/n2350.htm */
# define RBIMPL_ALIGNOF(T) offsetof(struct { char _; T t; }, t)

#endif

#endif /* RBIMPL_