_pragma(warning(pop))

/**
 * @private
 *
 * Turns a warning into a fatal error.
 *
 * @param  flag  A flag that represents the kind of warnings.
 */
#define RBIMPL_WARNING_ERROR(flag)   __pragma(warning(error: flag))

/**
 * @private
 *
 * Suppresses a warning.
 *
 * @param  flag  A flag that represents the kind of warnings.
 */
#define RBIMPL_WARNING_IGNORED(flag) __pragma(warning(disable: flag))

#elif RBIMPL_COMPILER_SINCE(MSVC, 12, 0, 0)
# /* Not sure exactly when but it seems VC++ 6.0 is a version with it.*/
# define RBIMPL_WARNING_PUSH()        __pragma(warning(push))
# define RBIMPL_WARNING_POP()         __pragma(warning(pop))
# define RBIMPL_WARNING_ERROR(flag)   __pragma(warning(error: flag))
# define RBIMPL_WARNING_IGNORED(flag) __pragma(warning(disable: flag))

#elif RBIMPL_COMPILER_SINCE(Intel, 13, 0, 0)
# define RBIMPL_WARNING_PUSH()        __pragma(warning(push))
# define RBIMPL_WARNING_POP()         __pragma(warning(pop))
# define RBIMPL_WARNING_ERROR(flag)   __pragma(warning(error: flag))
# define RBIMPL_WARNING_IGNORED(flag) __pragma(warning(disable: flag))

#elif RBIMPL_COMPILER_IS(Clang) || RBIMPL_COMPILER_IS(Apple)
# /* Not sure exactly when but it seems LLVM 2.6.0 is a version with it. */
# define RBIMPL_WARNING_PRAGMA0(x)    _Pragma(# x)
# define RBIMPL_WARNING_PRAGMA1(x)    RBIMPL_WARNING_PRAGMA0(clang diagnostic x)
# define RBIMPL_WARNING_PRAGMA2(x, y) RBIMPL_WARNING_PRAGMA1(x # y)
# define RBIMPL_WARNING_PUSH()        RBIMPL_WARNING_PRAGMA1(push)
# define RBIMPL_WARNING_POP()         RBIMPL_WARNING_PRAGMA1(pop)
# define RBIMPL_WARNING_ERROR(flag)   RBIMPL_WARNING_PRAGMA2(error, flag)
# define RBIMPL_WARNING_IGNORED(flag) RBIMPL_WARNING_PRAGMA2(ignored, flag)

#elif RBIMPL_COMPILER_SINCE(GCC, 4, 6, 0)
# /* https://gcc.gnu.org/onlinedocs/gcc-4.6.0/gcc/Diagnostic-Pragmas.html */
# define RBIMPL_WARNING_PRAGMA0(x)    _Pragma(# x)
# define RBIMPL_WARNING_PRAGMA1(x)    RBIMPL_WARNING_PRAGMA0(GCC diagnostic x)
# define RBIMPL_WARNING_PRAGMA2(x, y) RBIMPL_WARNING_PRAGMA1(x # y)
# define RBIMPL_WARNING_PUSH()        RBIMPL_WARNING_PRAGMA1(push)
# define RBIMPL_WARNING_POP()         RBIMPL_WARNING_PRAGMA1(pop)
# define RBIMPL_WARNING_ERROR(flag)   RBIMPL_WARNING_PRAGMA2(error, flag)
# define RBIMPL_WARNING_IGNORED(flag) RBIMPL_WARNING_PRAGMA2(ignored, flag)

#else
# /* :FIXME: improve here */
# define RBIMPL_WARNING_PUSH()        /* void */
# define RBIMPL_WARNING_POP()         /* void */
# define RBIMPL_WARNING_ERROR(flag)   /* void */
# define RBIMPL_WARNING_IGNORED(flag) /* void */
#endif /* _MSC_VER */
/** @endcond */

#endif /* RBIMPL_WARNING_PUSH_H */
PK       ! C  C    ruby/internal/module.hnu [        #ifndef RBIMPL_MODULE_H                              /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_MODULE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *     