header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Compile-time static implementation of ::rb_scan_args().
 *
 * This  is a  beast.  It  statically analyses  the argument  spec string,  and
 * expands the assignment of variables into dedicated codes.
 */
#include "ruby/assert.h"
#include "ruby/internal/attr/diagnose_if.h"
#include "ruby/internal/attr/error.h"
#include "ruby/internal/attr/forceinline.h"
#include "ruby/internal/attr/nonnull.h"
#include "ruby/internal/attr/noreturn.h"
#include "ruby/internal/config.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/has/attribute.h"
#include "ruby/internal/intern/array.h" /* rb_ary_new_from_values */
#include "ruby/internal/intern/error.h" /* rb_error_arity */
#include "ruby/internal/intern/hash.h"  /* rb_hash_dup */
#include "ruby/internal/intern/proc.h"  /* rb_block_proc */
#include "ruby/internal/iterator.h"     /* rb_block_given_p / rb_keyword_given_p */
#include "ruby/internal/static_assert.h"
#include "ruby/internal/stdbool.h"
#include "ruby/internal/value.h"

/**
 * @name Possible values that you should pass to rb_scan_args_kw().
 * @{
 */

/** Same behaviour as rb_scan_args(). */
#define RB_SCAN_ARGS_PASS_CALLED_KEYWORDS 0

/** The final argument should be a hash treated as keywords.*/
#define RB_SCAN_ARGS_KEYWORDS 1

/**
 * Treat a  final argument as  keywords if  it is a  hash, and not  as keywords
 * otherwise.
 */
#define RB_SCAN_ARGS_LAST_HASH_KEYWORDS 3

/** @} */

/**
 * @name Possible values that you should pass to rb_funcallv_kw().
 * @{
 */

/** Do not pass keywords. */
#define RB_NO_KEYWORDS 0

/** Pass keywords, final argument should be a hash of keywords. */
#define RB_PASS_KEYWORDS 1

/**
 * Pass keywords if current method is called with keywords, useful for argument
 * delegation
 */
#define RB_PASS_CALLED_KEYWORDS rb_keyword_given_p()

/** @} */

/**
 * @private
 *
 * @deprecated  This macro once was a thing in the old days, but makes no sense
 *              any  longer today.   Exists  here  for backwards  compatibility
 *              only.  You can safely forget about it.
 */
#define HAVE_RB_SCAN_ARGS_OPTIONAL_HASH 1

RBIMPL_SYMBOL_EXPORT_BEGIN()
RBIMPL_ATTR_NONNULL((2, 3))
/**
 * Retrieves argument from argc and  argv to given ::VALUE references according
 * to the format string.  The format can be described in ABNF as follows:
 *
 * ```
 * scan-arg-spec  := param-arg-spec [keyword-arg-spec] [block-arg-spec]
 *
 * param-arg-spec        := pre-arg-spec [post-arg-spec] / post-arg-spec /
 *                          pre-opt-post-arg-spec
 * pre-arg-spec          := num-of-leading-mandatory-args
 *                          [num-of-optional-args]
 * post-arg-spec         := sym-for-variable-length-args
 *                          [num-of-trailing-mandatory-args]
 * pre-opt-post-arg-spec := num-of-leading-mandatory-args num-of-optional-args
 *                          num-of-trailing-mandatory-args
 * keyword-arg-spec      := sym-for-keyword-arg
 * block-arg-spec        := sym-for-block-arg
 *
 * num-of-leading-mandatory-args  := DIGIT ; The number of leading mandatory
 *                                         ; arguments
 * num-of-optional-args           := DIGIT ; The number of optional arguments
 * sym-for-variable-length-args   := "*"   ; Indicates that variable length
 *                                         ;  arguments are captured as a ruby
 *                                         ; array
 * num-of-trailing-mandatory-args := DIGIT ; The number of trailing mandatory
 *                                         ; arguments
 * sym-for-keyword-arg            := ":"   ; Indicates that keyword argument
 *                                         ; captured as a hash.
 *                                         ; If keyword arguments are not
 *                                         ; provided, returns nil.
 * sym-for-block-arg              := "&"   ; Indicates that an iterator block
 *                                         ; should be captured if given
 * ```
 *
 * For example, "12" means that the  method requires at least