 this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines struct ::RObject.
 */
#include "ruby/internal/config.h"

#ifdef HAVE_STDINT_H
# include <stdint.h>
#endif

#include "ruby/internal/attr/artificial.h"
#include "ruby/internal/attr/deprecated.h"
#include "ruby/internal/attr/pure.h"
#include "ruby/internal/cast.h"
#include "ruby/internal/fl_type.h"
#include "ruby/internal/value.h"
#include "ruby/internal/value_type.h"

/**
 * Convenient casting macro.
 *
 * @param   obj  An object, which is in fact an ::RObject.
 * @return  The passed object casted to ::RObject.
 */
#define ROBJECT(obj)          RBIMPL_CAST((struct RObject *)(obj))
/** @cond INTERNAL_MACRO */
#define ROBJECT_EMBED_LEN_MAX ROBJECT_EMBED_LEN_MAX
#define ROBJECT_EMBED         ROBJECT_EMBED
#define ROBJECT_IV_CAPACITY   ROBJECT_IV_CAPACITY
#define ROBJECT_IVPTR         ROBJECT_IVPTR
/** @endcond */

/**
 * @private
 *
 * Bits that you can set to ::RBasic::flags.
 */
enum ruby_robject_flags {
    /**
     * This flag has  something to do with memory footprint.   If the object is
     * "small"  enough, ruby  tries to  be creative  to abuse  padding bits  of
     * struct ::RObject for storing instance variables.  This flag denotes that
     * situation.
     *
     * @warning  This  bit has  to be  considered read-only.   Setting/clearing
     *           this  bit without  corresponding fix  up must  cause immediate
     *           SEGV.   Also,   internal  structures   of  an   object  change
     *           dynamically  and  transparently  throughout of  its  lifetime.
     *           Don't assume it being persistent.
     *
     * @internal
     *
     * 3rd parties must  not be aware that  there even is more than  one way to
     * store instance variables.  Might better be hidden.
     */
    ROBJECT_EMBED = RUBY_FL_USER1
};

#if !USE_RVARGC
/**
 * This is an enum because GDB wants it (rather than a macro).  People need not
 * bother.
 */
enum ruby_robject_consts {
    /** Max possible number of instance variables that can be embedded. */
    ROBJECT_EMBED_LEN_MAX = RBIMPL_EMBED_LEN_MAX_OF(VALUE)
};
#endif

struct st_table;

/**
 * Ruby's ordinal objects.  Unless otherwise  special cased, all predefined and
 * user-defined classes share this struct to hold their instances.
 */
struct RObject {

    /** Basic part, including flags and