ception  rb_eEWOULDBLOCKWaitWritable
 * @exception  rb_eEINPROGRESSWaitWritable
 * @exception  rb_eEAGAINWaitReadable
 * @exception  rb_eEWOULDBLOCKWaitReadable
 * @exception  rb_eEINPROGRESSWaitReadable
 * @exception  rb_eSystemCallError
 * @note       It never returns.
 */
void rb_readwrite_sys_fail(enum rb_io_wait_readwrite waiting, const char *msg);

RBIMPL_ATTR_NORETURN()
/**
 * Breaks from a block.  Because you are  using a CAPI this is not as intuitive
 * as  it  sounds.   In order  for  this  function  to  properly work,  make  a
 * ::rb_block_call_func_t  function that  calls  it internally,  and pass  that
 * function to rb_block_call().
 *
 * @exception  rb_eLocalJumpError  Called from outside of a block.
 * @note       It never returns.
 */
void rb_iter_break(void);

RBIMPL_ATTR_NORETURN()
/**
 * Identical to  rb_iter_break(), except it  additionally takes the  "value" of
 * this breakage.  It  will be the evaluation result of  the iterator.  This is
 * kind  of  complicated; you  cannot  see  this as  a  "return  from a  block"
 * behaviour.  Take a look at this example:
 *
 * ```ruby
 * def foo(q)
 *   puts(w = yield(q))
 *   puts(e = yield(w))
 *   puts(r = yield(e))
 *   puts(t = yield(r))
 *   puts(y = yield(t))
 *   return "howdy!"
 * end
 *
 * x = foo(0) {|i|
 *   if i > 2
 *     break "hello!"
 *   else
 *     next i + 1
 *   end
 * }
 *
 * puts x
 * ```
 *
 * This script outputs 1, 2, 3, and hello.  Note that the value passed to break
 * becomes the  return value of  foo method, not the  value of yield.   This is
 * confusing, but  can be  handy on occasions  e.g.  when you  want to  bring a
 * local variable out of a block.
 *
 * @param[in]  val                 The value of the iterator.
 * @exception  rb_eLocalJumpError  Called from outside of a block.
 * @note       It never returns.
 */
void rb_iter_break_value(VALUE val);

RBIMPL_ATTR_NORETURN()
/**
 * Terminates the current execution context.  This  API is the entry point of a
 * "well-mannered"  termination  sequence.   When   called  from  an  extension
 * library, it  raises ::rb_eSystemExit exception.  Programs  could rescue that
 * exception.  Can cancel process exit then.  Otherwise, that exception results
 * in a process termination with the status passed to this function.
 *
 * @param[in]  status          Exit status, see also exit(3).
 * @exception  rb_eSystemExit  Exception representing the exit status.
 * @note       It never returns.
 *
 * @internal
 *
 * "When called from  an extension library"?  You might wonder.   In fact there
 * are chances for this function to be  called from outside of it, for instance
 * when dlopen(3)  failed.  In  case it  is not possible  for this  function to
 * raise an exception,  it does not (silently enters to  process cleanup).  But
 * that  is a  kind of  implementation detail  which extension  library authors
 * should not bother.
 */
void rb_exit(int status);

RBIMPL_ATTR_NORETURN()
/**
 * @exception  rb_eNotImpError
 * @note       It never returns.
 */
void rb_notimplement(void);

/**
 * Creates an exception object that represents the given C errno.
 *
 * @param[in]  err                  C level errno.
 * @param[in]  msg                  Additional message.
 * @retval     rb_eSystemCallError  An exception for the errno.
 */
VALUE rb_syserr_new(int err, const char * msg);

/**
 * Identical to rb_syserr_new(),  except it takes the message  in Ruby's String
 * instead of C's.
 *
 * @param[in]  n                    C level errno.
 * @param[in]  arg                  Additional message.
 * @retval     rb_eSystemCallError  An exception for the errno.
 */
VALUE rb_syserr_new_str(int n, VALUE arg);

RBIMPL_ATTR_NORETURN()
/**
 * Raises appropriate exception that represents a C errno.
 *
 * @param[in]  err                  C level errno.
 * @param[in]  msg                  Additional message to raise.
 * @exception  rb_eSystemCallError  An exception representing `err`.
 * @note       It never returns.
 */
void rb_syserr_fail(int err, const char *msg);

RBIMPL_ATTR_NORETURN()
/**
 * Identical to rb_syserr_fail(), except it  takes the message in Ruby's String
 * instead of C's.
 *
 * @param[in]  err                  C level errno.
 * @param[in]  msg                  Additional message to raise.
 * @exception  rb_eSystemCallError  An exception representing `err`.
 * @note       It never returns.
 */
void rb_syserr_fail_str(int err, VALUE msg);

RBIMPL_ATTR_NORETURN()
RBIMPL_ATTR_NONNULL(())
/**
 * Identical  to rb_mod_sys_fail(),  except  it  does not  depend  on C  global
 * variable errno.  Pass it explicitly.
 *
 * @param[in]  mod                  A ::rb_cModule instance.
 * @param[in]  err                  C level errno.
 * @param[in]  msg                  Additional message to raise.
 * @exception  rb_eSystemCallError  An exception representing `err`.
 * @note       It never returns.
 */
void rb_mod_syserr_fail(V