b_eArgError        Wrong `argc`.
 * @exception  rb_eTypeError       Non-string passed.
 * @exception  rb_eEncCompatError  No conversion from arguments to a path.
 * @return     Expanded path.
 *
 * @internal
 *
 * It seems nobody actually uses this function right now.  Maybe delete it?
 */
VALUE rb_file_s_absolute_path(int argc, const VALUE *argv);

/**
 * Maps a  relative path  to its absolute  representation.  Relative  paths are
 * referenced  from the  passed directory  name, or  from the  process' current
 * working directory in case ::RUBY_Qnil is passed.
 *
 * @param[in]  fname               Relative file name.
 * @param[in]  dname               Lookup  base  directory  name,  or  in  case
 *                                 ::RUBY_Qnil is  passed the  process' current
 *                                 working directory is assumed.
 * @exception  rb_eArgError        Strings contain NUL bytes.
 * @exception  rb_eTypeError       Non-string passed.
 * @exception  rb_eEncCompatError  No conversion from arguments to a path.
 * @return     Expanded path.
 */
VALUE rb_file_absolute_path(VALUE fname, VALUE dname);

/**
 * Strips a file path's last component  (and trailing separators if any).  This
 * function is relatively  simple on POSIX environments; just  splits the input
 * with  `/`, strips  the  last one,  if something  remains  joins them  again,
 * otherwise the return value is `"."`.   However when it comes to Windows this
 * function is  quite very  much complicated.   We have to  take UNC  etc. into
 * account.  So for instance `"C:foo"`'s dirname is `"C:."`.
 *
 * @param[in]  fname               File name to strip.
 * @exception  rb_eTypeError       `fname` is not a String.
 * @exception  rb_eArgError        `fname` contains NUL bytes.
 * @exception  rb_eEncCompatError  `fname`'s encoding is not path-compat.
 * @return     A dirname of `fname`.
 * @note       This is a "pure" operation;  it computes the return value solely
 *             from the passed object and never does any