dentical to  rb_mod_syserr_fail(), except  it takes  the message  in Ruby's
 * String instead of C's.
 *
 * @param[in]  mod                  A ::rb_cModule instance.
 * @param[in]  err                  C level errno.
 * @param[in]  msg                  Additional message to raise.
 * @exception  rb_eSystemCallError  An exception representing `err`.
 * @note       It never returns.
 */
void rb_mod_syserr_fail_str(VALUE mod, int err, VALUE msg);

RBIMPL_ATTR_NORETURN()
/**
 * Identical to rb_readwrite_sys_fail(), except it  does not depend on C global
 * variable errno.  Pass it explicitly.
 *
 * @param[in]  waiting  Reason for the IO to wait.
 * @param[in]  err      C level errno.
 * @param[in]  msg      Additional message to raise.
 * @exception  rb_eEAGAINWaitWritable
 * @exception  rb_eEWOULDBLOCKWaitWritable
 * @exception  rb_eEINPROGRESSWaitWritable
 * @exception  rb_eEAGAINWaitReadable
 * @exception  rb_eEWOULDBLOCKWaitReadable
 * @exception  rb_eEINPROGRESSWaitReadable
 * @exception  rb_eSystemCallError
 * @note       It never returns.
 */
void rb_readwrite_syserr_fail(enum rb_io_wait_readwrite waiting, int err, const char *msg);

RBIMPL_ATTR_COLD()
RBIMPL_ATTR_NORETURN()
/**
 * Fails with the given object's type incompatibility to the type.
 *
 * It  seems this  function is  visible from  extension libraries  only because
 * RTYPEDDATA_TYPE() uses  it on RUBY_DEBUG.   So you can basically  ignore it;
 * use some other fine-grained method instead.
 *
 * @param[in]  self           The object in question.
 * @param[in]  t              Expected type of the object.
 * @exception  rb_eTypeError  `self` not in type `t`.
 * @note       It never returns.
 * @note       The second  argument must  have been an  enum ::ruby_value_type,
 *             but for  historical reasons it  remains to  be an int  (in other
 *             words we see no benefits fixing this bug).
 */
void rb_unexpected_type(VALUE self, int t);

/**
 * @private
 *
 * This  is an  implementation detail  of #ruby_verbose.   Please don't  use it
 * directly.
 *
 * @retval  Qnil       Interpreter is quiet.
 * @retval  Qfalse     Interpreter is kind of chatty.
 * @retval  otherwise  Interpreter is very verbose.
 */
VALUE *rb_ruby_verbose_ptr(void);

/**
 * @private
 *
 * This  is an  implementation  detail  of #ruby_debug.   Please  don't use  it
 * directly.
 *
 * @retval  Qnil       Interpreter not in debug mode.
 * @retval  Qfalse     Interpreter not in debug mode.
 * @retval  otherwise  Interpreter is in debug mode.
 */
VALUE *rb_ruby_debug_ptr(void);

/**
 * This variable  controls whether the  interpreter is in debug  mode.  Setting
 * this  to  some truthy  value  is  equivalent to  passing  `-W`  flag to  the
 * interpreter.  Setting this  to ::Qfalse is equivalent to  passing `-W1` flag
 * to the interpreter.   Setting this to ::Qnil is equivalent  to passing `-W0`
 * flag to the interpreter.
 *
 * @retval  Qnil       Interpreter is quiet.
 * @retval  Qfalse     Interpreter is kind of chatty.
 * @retval  otherwise  Interpreter is very verbose.
 */
#define ruby_verbose (*rb_ruby_verbose_ptr())

/**
 * This variable  controls whether the  interpreter is in debug  mode.  Setting
 * this  to  some truthy  value  is  equivalent to  passing  `-d`  flag to  the
 * interpreter.
 *
 * @retval  Qnil       Interpreter not in debug mode.
 * @retval  Qfalse     Interpreter not in debug mode.
 * @retval  otherwise  Interpreter is in debug mode.
 */
#define ruby_debug   (*rb_ruby_debug_ptr())

/* reports if `-W' specified */
RBIMPL_ATTR_NONNULL((1))
RBIMPL_ATTR_FORMAT(RBIMPL_PRINTF_FORMAT, 1, 2)
/**
 * Issues a warning.
 *
 * In  ruby, warnings  these  days  are tightly  coupled  with the  rb_mWarning
 * constant and its `warn` singleton method.   This CAPI is just a thin wrapper
 * of it;  everything passed  are formatted like  what rb_sprintf()  does, then
 * passed  through   to  the  method.    Programs  can  have  their   own  `def
 * Warning.warn` at will  to do whatever they want, from  ignoring the warnings
 * at all to sinking them to some  BigQuery data set via a Fluentd cluster.  By
 * default,  the method  just emits  its passed  contents to  ::rb_stderr using
 * rb_io_write().
 *
 * @note       This function is affected by the `-W` flag.
 * @param[in]  fmt  Format specifier string compatible with rb_sprintf().
 *
 * @internal
 *
 * Above description is in fact inaccurate.  This API interfaces with Ractors.
 */
void rb_warning(const char *fmt, ...);

RBIMPL_ATTR_NONNULL((2))
RBIMPL_ATTR_FORMAT(RBIMPL_PRINTF_FORMAT, 2, 3)
/**
 * Identical to rb_warning(), except it takes additional "category" parameter.
 *
 * @param[in]  cat  Name of a known category.
 * @param[in]  fmt  Format specifier string compatible with rb_sprintf().
 */
void rb_category_warning(rb_warning_category_t cat, const char *fmt, ...);

RBIMPL_ATTR_NONNULL((1, 3))
RBIMPL_ATTR_FORMAT(RBIMPL_PRINTF_FORMAT, 3, 4)
/**
 * Issues a compile-time warning  that happens at `__file__:__line__`.  Purpose
 * of this function being exposed to CAPI is unclear.
 *
 * @note       This function is affected by the `-W` flag.
 * @param[in]  file  The path corresponding to Ruby level `__FILE__`.
 * @param[in]  line  The number corresponding to Ruby level `__LINE__`.
 * @param[in]  fmt   Format specifier string compatible with rb_sprintf().
 */
void rb_compile_warning(const char *file, int line, const char *fmt, ...);

RBIMPL_ATTR_NONNULL((1))
RBIMPL_ATTR_FORMAT(RBIMPL_PRINTF_FORMAT, 1, 2)
/**
 * Identical to rb_sys_fail(), except it does  not raise an exception to render
 * a warning instead.
 *
 * @note       This function is affected by the `-W` flag.
 * @param[in]  fmt  Format specifier string compatible with rb_sprintf().
 */
void rb_sys_warning(const char *fmt, ...);

/* reports always */
RBIMPL_ATTR_COLD()
RBIMPL_ATTR_NONNULL((1))
RBIMPL_ATTR_FORMAT(RBIMPL_PRINTF_FORMAT, 1, 2)
/**
 * Identical to  rb_warning(), except it  reports always regardless  of runtime
 * `-W` flag.
 *
 * @param[in]  fmt  Format specifier string compatible with rb_sprintf().
 */
void rb_warn(const char *fmt, ...);

RBIMPL_ATTR_COLD()
RBIMPL_ATTR_NONNULL((2))
RBIMPL_ATTR_FORMAT(RBIMPL_PRINTF_FORMAT, 2, 3)
/**
 * Identical to  rb_category_warning(), except it reports  always regardless of
 * runtime `-W` flag.
 *
 * @param[in]  cat  Category e.g. deprecated.
 * @param[in]  fmt  Format specifier string compatible with rb_sprintf().
 */
void rb_category_warn(rb_warning_category_t cat, const char *fmt, ...);

RBIMPL_ATTR_NONNULL((1, 3))
RBIMPL_ATTR_FORMAT(RBIMPL_PRINTF_FORMAT, 3, 4)
/**
 * Identical to  rb_compile_warning(), except  it reports always  regardless of
 * runtime `-W` flag.
 *
 * @param[in]  file  The path corresponding to Ruby level `__FILE__`.
 * @param[in]  line  The number corresponding to Ruby level `__LINE__`.
 * @param[in]  fmt   Format specifier string compatible with rb_sprintf().
 */
void rb_compile_warn(const char *file, int line, const char *fmt, ...);

RBIMPL_ATTR_NONNULL((2, 4))
RBIMPL_ATTR_FORMAT(RBIMPL_PRINTF_FORMAT, 4, 5)
/**
 * Identical to  rb_compile_warn(), except  it also accepts category.
 *
 * @param[in]  cat   Category e.g. deprecated.
 * @param[in]  file  The path corresponding to Ruby level `__FILE__`.
 * @param[in]  line  The number corresponding to Ruby level `__LINE__`.
 * @param[in]  fmt   Format specifier string compatible with rb_sprintf().
 */
void rb_category_compile_warn(rb_warning_category_t cat, const char *file, int line, const char *fmt, ...);

/** @} */

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_ERROR_H */
PK       ! NP4T  T  !  ruby/internal/arithmetic/size_t.hnu [        #ifndef RBIMPL_ARITHMETIC_SIZE_T_H                   /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ARITHMETIC_SIZE_T_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Arithmetic conversion between C's `size_t` and Ruby's.
 */
#include "ruby/internal/config.h"
#include "ruby/internal/arithmetic/int.h"
#include "ruby/internal/arithmetic/long.h"
#include "ruby/internal/arithmetic/long_long.h"
#include "ruby/backward/2/long_long.h"

#if defined(__DOXYGEN__)
# /** Converts a C's `size_t` into an instance of ::rb_cInteger. */
# define RB_SIZE2NUM RB_ULONG2NUM
# /** Converts a C's `ssize_t` into an instance of ::rb_cInteger. */
# define RB_SSIZE2NUM RB_LONG2NUM
#elif SIZEOF_SIZE_T == SIZEOF_LONG_LONG
# define RB_SIZE2NUM RB_ULL2NUM
# define RB_SSIZE2NUM RB_LL2NUM
#elif SIZEOF_SIZE_T == SIZEOF_LONG
# define RB_SIZE2NUM RB_ULONG2NUM
# define RB_SSIZE2NUM RB_LONG2NUM
#else
# define RB_SIZE2NUM RB_UINT2NUM
# define RB_SSIZE2NUM RB_INT2NUM
#endif

#if defined(__DOXYGEN__)
# /** Converts an instance of ::rb_cInteger into C's `size_t`. */
# define RB_NUM2SIZE RB_NUM2ULONG
# /** Converts an instance of ::rb_cInteger into C's `ssize_t`. */
# define RB_NUM2SSIZE RB_NUM2LONG
#elif SIZEOF_SIZE_T == SIZEOF_LONG_LONG
# define RB_NUM2SIZE RB_NUM2ULL
# define RB_NUM2SSIZE RB_NUM2LL
#elif SIZEOF_SIZE_T == SIZEOF_LONG
# define RB_NUM2SIZE RB_NUM2ULONG
# define RB_NUM2SSIZE RB_NUM2LONG
#else
# define RB_NUM2SIZE RB_NUM2UINT
# define RB_NUM2SSIZE RB_NUM2INT
#endif

#define NUM2SIZET RB_NUM2SIZE   /**< @old{RB_NUM2SIZE} */
#define SIZET2NUM RB_SIZE2NUM   /**< @old{RB_SIZE2NUM} */
#define NUM2SSIZET RB_NUM2SSIZE /**< @old{RB_NUM2SSIZE} */
#define SSIZET2NUM RB_SSIZE2NUM /**< @old{RB_SSIZE2NUM} */

#endif /* RBIMPL_ARITHMETIC_SIZE_T_H */
PK       ! 	  	     ruby/internal/arithmetic/off_t.hnu [        #ifndef RBIMPL_ARITHMETIC_OFF_T_H                    /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ARITHMETIC_OFF_T_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Arithmetic conversion between C's `off_t` and Ruby's.
 */
#include "ruby/internal/config.h"
#include "ruby/internal/arithmetic/int.h"
#include "ruby/internal/arithmetic/long.h"
#include "ruby/internal/arithmetic/long_long.h"
#include "ruby/backward/2/long_long.h"

/** Converts a C's `off_t` into an instance of ::rb_cInteger. */
#ifdef OFFT2NUM
# /* take that. */
#elif SIZEOF_OFF_T == SIZEOF_LONG_LONG
# define OFFT2NUM RB_LL2NUM
#elif SIZEOF_OFF_T == SIZEOF_LONG
# define OFFT2NUM RB_LONG2NUM
#else
# define OFFT2NUM RB_INT2NUM
#endif

/** Converts an instance of ::rb_cNumeric into C's `off_t`. */
#ifdef NUM2OFFT
# /* take that. */
#elif SIZEOF_OFF_T == SIZEOF_LONG_LONG
# define NUM2OFFT RB_NUM2LL
#elif SIZEOF_OFF_T == SIZEOF_LONG
# define NUM2OFFT RB_NUM2LONG
#else
# define NUM2OFFT RB_NUM2INT
#endif

/** A rb_sprintf() format prefix to be used for an `off_t` parameter. */
#ifdef PRI_OFFT_PREFIX
# /* take that. */
#elif SIZEOF_OFF_T == SIZEOF_LONG_LONG
# define PRI_OFFT_PREFIX PRI_LL_PREFIX
#elif SIZEOF_OFF_T == SIZEOF_LONG
# define PRI_OFFT_PREFIX PRI_LONG_PREFIX
#else
# define PRI_OFFT_PREFIX PRI_INT_PREFIX
#endif

#endif /* RBIMPL_ARITHMETIC_OFF_T_H */
PK       ! bq    $  ruby/internal/arithmetic/st_data_t.hnu [        #ifndef RBIMPL_ARITHMERIC_ST_DATA_T_H                /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ARITHMERIC_ST_DATA_T_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Arithmetic conversion between C's `st_data_t` and Ruby's.
 */
#include "ruby/internal/arithmetic/fixnum.h"
#include "ruby/internal/arithmetic/long.h"
#include "ruby/internal/attr/artificial.h"
#include "ruby/internal/attr/const.h"
#include "ruby/internal/attr/constexpr.h"
#include "ruby/internal/cast.h"
#include "ruby/internal/value.h"
#include "ruby/assert.h"
#include "ruby/st.h"

#define ST2FIX    RB_ST2FIX     /**< @old{RB_ST2FIX} */
/** @cond INTERNAL_MACRO */
#define RB_ST2FIX RB_ST2FIX
/** @endcond */

RBIMPL_ATTR_CONST_UNLESS_DEBUG()
RBIMPL_ATTR_CONSTEXPR_UNLESS_DEBUG(CXX14)
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Converts a C's `st_data_t` into an instance of ::rb_cInteger.
 *
 * @param[in]  i  The data in question.
 * @return     A converted result
 * @warning    THIS CONVERSION LOSES DATA!  Be warned.
 * @see        https://bugs.ruby-lang.org/issues/13877
 * @see        https://bugs.ruby-lang.org/issues/14218
 *
 * @internal
 *
 * This  is   needed  because  of   hash  functions.   Hash   functions  return
 * `st_data_t`,  which could  theoretically  be bigger  than Fixnums.   However
 * allocating Bignums for them every time  we calculate hash values is just too
 * heavy.  To avoid  penalty we need to  ignore some upper bit(s)  and stick to
 * Fixnums.  This function is used for that purpose.
 */
static inline VALUE
RB_ST2FIX(st_data_t i)
{
    SIGNED_VALUE x = i;

    if (x >= 0) {
        x &= RUBY_FIXNUM_MAX;
    }
    else {
        x |= RUBY_FIXNUM_MIN;
    }

    RBIMPL_ASSERT_OR_ASSUME(RB_FIXABLE(x));
    unsigned long y = RBIMPL_CAST((unsigned long)x);
    return RB_LONG2FIX(y);
}

#endif /* RBIMPL_ARITHMETIC_ST_DATA_T_H */
PK       !  ,  ,    ruby/internal/arithmetic/long.hnu [        #ifndef RBIMPL_ARITHMETIC_LONG_H                     /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ARITHMETIC_LONG_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Arithmetic conversion between C's `long` and Ruby's.
 *
 * ### Q&A ###
 *
 * - Q: Why are INT2FIX etc. here, not in `int.h`?
 *
 * - A: Because they  are in fact  handling `long`.   It seems someone  did not
 *      understand the difference of `int`  and `long` when they designed those
 *      macros.
 */
#include "ruby/internal/config.h"
#include "ruby/internal/arithmetic/fixnum.h"   /* FIXABLE */
#include "ruby/internal/arithmetic/intptr_t.h" /* rb_int2big etc.*/
#include "ruby/internal/assume.h"
#include "ruby/internal/attr/artificial.h"
#include "ruby/internal/attr/cold.h"
#include "ruby/internal/attr/const.h"
#include "ruby/internal/attr/constexpr.h"
#include "ruby/internal/attr/noreturn.h"
#include "ruby/internal/cast.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/special_consts.h"      /* FIXNUM_FLAG */
#include "ruby/internal/value.h"
#include "ruby/assert.h"

#define FIX2LONG     RB_FIX2LONG          /**< @old{RB_FIX2LONG} */
#define FIX2ULONG    RB_FIX2ULONG         /**< @old{RB_FIX2ULONG} */
#define INT2FIX      RB_INT2FIX           /**< @old{RB_INT2FIX} */
#define LONG2FIX     RB_INT2FIX           /**< @old{RB_INT2FIX} */
#define LONG2NUM     RB_LONG2NUM          /**< @old{RB_LONG2NUM} */
#define NUM2LONG     RB_NUM2LONG          /**< @old{RB_NUM2LONG} */
#define NUM2ULONG    RB_NUM2ULONG         /**< @old{RB_NUM2ULONG} */
#define RB_FIX2LONG  rb_fix2long          /**< @alias{rb_fix2long} */
#define RB_FIX2ULONG rb_fix2ulong         /**< @alias{rb_fix2ulong} */
#define RB_LONG2FIX  RB_INT2FIX           /**< @alias{RB_INT2FIX} */
#define RB_LONG2NUM  rb_long2num_inline   /**< @alias{rb_long2num_inline} */
#define RB_NUM2LONG  rb_num2long_inline   /**< @alias{rb_num2long_inline} */
#define RB_NUM2ULONG rb_num2ulong_inline  /**< @alias{rb_num2ulong_inline} */
#define RB_ULONG2NUM rb_ulong2num_inline  /**< @alias{rb_ulong2num_inline} */
#define ULONG2NUM    RB_ULONG2NUM         /**< @old{RB_ULONG2NUM} */
#define rb_fix_new   RB_INT2FIX           /**< @alias{RB_INT2FIX} */
#define rb_long2int  rb_long2int_inline   /**< @alias{rb_long2int_inline} */

/** @cond INTERNAL_MACRO */
#define RB_INT2FIX RB_INT2FIX
/** @endcond */

RBIMPL_SYMBOL_EXPORT_BEGIN()

RBIMPL_ATTR_NORETURN()
RBIMPL_ATTR_COLD()
/**
 * This is an utility function to raise an ::rb_eRangeError.
 *
 * @param[in]  num             A signed value about to overflow.
 * @exception  rb_eRangeError  `num` is out of range of `int`.
 */
void rb_out_of_int(SIGNED_VALUE num);

/**
 * Converts an instance of ::rb_cNumeric into C's `long`.
 *
 * @param[in]  num             Something numeric.
 * @exception  rb_eTypeError   `num` is not a numeric.
 * @exception  rb_eRangeError  `num` is out of range of `long`.
 * @return     The passed value converted into C's `long`.
 */
long rb_num2long(VALUE num);

/**
 * Converts an instance of ::rb_cNumeric into C's `unsigned long`.
 *
 * @param[in]  num             Something numeric.
 * @exception  rb_eTypeError   `num` is not a numeric.
 * @exception  rb_eRangeError  `num` is out of range of `unsigned long`.
 * @return     The passed value converted into C's `unsigned long`.
 */
unsigned long rb_num2ulong(VALUE num);
RBIMPL_SYMBOL_EXPORT_END()

RBIMPL_ATTR_CONST_UNLESS_DEBUG()
RBIMPL_ATTR_CONSTEXPR_UNLESS_DEBUG(CXX14)
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Converts a C's `long` into an instance of ::rb_cInteger.
 *
 * @param[in]  i  Arbitrary `long` value.
 * @return     An instance of ::rb_cInteger.
 */
static inline VALUE
RB_INT2FIX(long i)
{
    RBIMPL_ASSERT_OR_ASSUME(RB_FIXABLE(i));

    /* :NOTE: VALUE can be wider than long.  As j being unsigned, 2j+1 is fully
     * defined. Also it can be compiled into a single LEA instruction. */
    const unsigned long j = i;
    const unsigned long k = (j << 1) + RUBY_FIXNUM_FLAG;
    const long          l = k;
    const SIGNED_VALUE  m = l; /* Sign extend */
    const VALUE         n = m;

    RBIMPL_ASSERT_OR_ASSUME(RB_FIXNUM_P(n));
    return n;
}

/**
 * Checks if `int` can hold the given integer.
 *
 * @param[in]  n               Arbitrary `long` value.
 * @exception  rb_eRangeError  `n` is out of range of `int`.
 * @return     Identical value of type `int`
 */
static inline int
rb_long2int_inline(long n)
{
    int i = RBIMPL_CAST((int)n);

    if /* constexpr */ (sizeof(long) <= sizeof(int)) {
        RBIMPL_ASSUME(i == n);
    }

    if (i != n)
        rb_out_of_int(n);

    return i;
}

RBIMPL_ATTR_CONST_UNLESS_DEBUG()
RBIMPL_ATTR_CONSTEXPR_UNLESS_DEBUG(CXX14)
/**
 * @private
 *
 * This  is an  implementation detail  of rb_fix2long().   People don't  use it
 * directly.
 *
 * @param[in]  x  A Fixnum.
 * @return     Identical value of type `long`
 * @pre        Must not pass anything other than a Fixnum.
 */
static inline long
rbimpl_fix2long_by_idiv(VALUE x)
{
    RBIMPL_ASSERT_OR_ASSUME(RB_FIXNUM_P(x));

    /* :NOTE: VALUE  can be wider  than long.  (x-1)/2 never  overflows because
     * RB_FIXNUM_P(x)  holds.   Also it  has  no  portability issue  like  y>>1
     * below. */
    const SIGNED_VALUE y = x - RUBY_FIXNUM_FLAG;
    const SIGNED_VALUE z = y / 2;
    const long         w = RBIMPL_CAST((long)z);

    RBIMPL_ASSERT_OR_ASSUME(RB_FIXABLE(w));
    return w;
}

RBIMPL_ATTR_CONST_UNLESS_DEBUG()
RBIMPL_ATTR_CONSTEXPR_UNLESS_DEBUG(CXX14)
/**
 * @private
 *
 * This  is an  implementation detail  of rb_fix2long().   People don't  use it
 * directly.
 *
 * @param[in]  x  A Fixnum.
 * @return     Identical value of type `long`
 * @pre        Must not pass anything other than a Fixnum.
 */
static inline long
rbimpl_fix2long_by_shift(VALUE x)
{
    RBIMPL_ASSERT_OR_ASSUME(RB_FIXNUM_P(x));

    /* :NOTE: VALUE can be wider than long.  If right shift is arithmetic, this
     * is noticeably faster than above. */
    const SIGNED_VALUE y = x;
    const SIGNED_VALUE z = y >> 1;
    const long         w = RBIMPL_CAST((long)z);

    RBIMPL_ASSERT_OR_ASSUME(RB_FIXABLE(w));
    return w;
}

RBIMPL_ATTR_CONST()
RBIMPL_ATTR_CONSTEXPR(CXX11)
/**
 * @private
 *
 * This  is an  implementation detail  of rb_fix2long().   People don't  use it
 * directly.
 *
 * @retval  true   This C compiler's right shift operator is arithmetic.
 * @retval  false  This C compiler's right shift operator is logical.
 */
static inline bool
rbimpl_right_shift_is_arithmetic_p(void)
{
    return (-1 >> 1) == -1;
}

RBIMPL_ATTR_CONST_UNLESS_DEBUG()
RBIMPL_ATTR_CONSTEXPR_UNLESS_DEBUG(CXX14)
/**
 * Converts a Fixnum into C's `long`.
 *
 * @param[in]  x  Some Fixnum.
 * @pre        Must not pass anything other than a Fixnum.
 * @return     The passed value converted into C's `long`.
 */
static inline long
rb_fix2long(VALUE x)
{
    if /* constexpr */ (rbimpl_right_shift_is_arithmetic_p()) {
        return rbimpl_fix2long_by_shift(x);
    }
    else {
        return rbimpl_fix2long_by_idiv(x);
    }
}

RBIMPL_ATTR_CONST_UNLESS_DEBUG()
RBIMPL_ATTR_CONSTEXPR_UNLESS_DEBUG(CXX14)
/**
 * Converts a Fixnum into C's `unsigned long`.
 *
 * @param[in]  x  Some Fixnum.
 * @pre        Must not pass anything other than a Fixnum.
 * @return     The passed value converted into C's `unsigned long`.
 * @note       Negative fixnums will be converted into large unsigned longs.
 */
static inline unsigned long
rb_fix2ulong(VALUE x)
{
    RBIMPL_ASSERT_OR_ASSUME(RB_FIXNUM_P(x));
    return rb_fix2long(x);
}

/**
 * Converts an instance of ::rb_cNumeric into C's `long`.
 *
 * @param[in]  x               Something numeric.
 * @exception  rb_eTypeError   `x` is not a numeric.
 * @exception  rb_eRangeError  `x` is out of range of `long`.
 * @return     The passed value converted into C's `long`.
 */
static inline long
rb_num2long_inline(VALUE x)
{
    if (RB_FIXNUM_P(x))
        return RB_FIX2LONG(x);
    else
        return rb_num2long(x);
}

/**
 * Converts an instance of ::rb_cNumeric into C's `unsigned long`.
 *
 * @param[in]  x               Something numeric.
 * @exception  rb_eTypeError   `x` is not a numeric.
 * @exception  rb_eRangeError  `x` is out of range of `unsigned long`.
 * @return     The passed value converted into C's `unsigned long`.
 *
 * @internal
 *
 * This  (negative fixnum  would become  a large  unsigned long  while negative
 * bignum  is an  exception)  has been  THE behaviour  of  NUM2ULONG since  the
 * beginning.  It is strange, but we can  no longer change how it works at this
 * moment.  We have to get by with it.
 *
 * @see https://bugs.ruby-lang.org/issues/9089
 */
static inline unsigned long
rb_num2ulong_inline(VALUE x)
{
    if (RB_FIXNUM_P(x))
        return RB_FIX2ULONG(x);
    else
        return rb_num2ulong(x);
}

/**
 * Converts a C's `long` into an instance of ::rb_cInteger.
 *
 * @param[in]  v  Arbitrary `long` value.
 * @return     An instance of ::rb_cInteger.
 */
static inline VALUE
rb_long2num_inline(long v)
{
    if (RB_FIXABLE(v))
        return RB_LONG2FIX(v);
    else
        return rb_int2big(v);
}

/**
 * Converts a C's `unsigned long` into an instance of ::rb_cInteger.
 *
 * @param[in]  v  Arbitrary `unsigned long` value.
 * @return     An instance of ::rb_cInteger.
 */
static inline VALUE
rb_ulong2num_inline(unsigned long v)
{
    if (RB_POSFIXABLE(v))
        return RB_LONG2FIX(v);
    else
        return rb_uint2big(v);
}

/**
 * @cond INTERNAL_MACRO
 *
 * Following overload is necessary because sometimes  INT2FIX is used as a enum
 * value (e.g. `enum {  FOO = INT2FIX(0) };`).  THIS IS NG  in theory because a
 * VALUE does not fit into an enum (which must be a signed int).  But we cannot
 * break existing codes.
 */
#if RBIMPL_HAS_ATTR_CONSTEXPR_CXX14
# /* C++ can write constexpr as enum values. */

#elif ! defined(HAVE_BUILTIN___BUILTIN_CHOOSE_EXPR_CONSTANT_P)
# undef INT2FIX
# define INT2FIX(i) (RBIMPL_CAST((VALUE)(i)) << 1 | RUBY_FIXNUM_FLAG)

#else
# undef INT2FIX
# define INT2FIX(i)                                     \
    __builtin_choose_expr(                              \
        __builtin_constant_p(i),                        \
        RBIMPL_CAST((VALUE)(i)) << 1 | RUBY_FIXNUM_FLAG, \
        RB_INT2FIX(i))
#endif
/** @endcond */

#endif /* RBIMPL_ARITHMETIC_LONG_H */
PK       ! {rf  f  !  ruby/internal/arithmetic/mode_t.hnu [        #ifndef RBIMPL_ARITHMETIC_MODE_T_H                   /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ARITHMETIC_MODE_T_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Arithmetic conversion between C's `mode_t` and Ruby's.
 */
#include "ruby/internal/config.h"
#include "ruby/internal/arithmetic/int.h"

/** Converts a C's `mode_t` into an instance of ::rb_cInteger. */
#ifndef NUM2MODET
# define NUM2MODET RB_NUM2INT
#endif

/** Converts an instance of ::rb_cNumeric into C's `mode_t`. */
#ifndef MODET2NUM
# define MODET2NUM RB_INT2NUM
#endif

/** A rb_sprintf() format prefix to be used for a `mode_t` parameter. */
#ifndef PRI_MODET_PREFIX
# define PRI_MODET_PREFIX PRI_INT_PREFIX
#endif

#endif /* RBIMPL_ARITHMETIC_MODE_T_H */
PK       ! ҃W+
  +
    ruby/internal/arithmetic/char.hnu [        #ifndef RBIMPL_ARITHMETIC_CHAR_H                     /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ARITHMETIC_CHAR_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Arithmetic conversion between C's `char` and Ruby's.
 */
#include "ruby/internal/arithmetic/int.h"  /* NUM2INT is here, but */
#include "ruby/internal/arithmetic/long.h" /* INT2FIX is here.*/
#include "ruby/internal/attr/artificial.h"
#include "ruby/internal/attr/const.h"
#include "ruby/internal/attr/constexpr.h"
#include "ruby/internal/cast.h"
#include "ruby/internal/core/rstring.h"
#include "ruby/internal/value_type.h"

#define RB_NUM2CHR rb_num2char_inline /**< @alias{rb_num2char_inline} */
#define NUM2CHR    RB_NUM2CHR         /**< @old{RB_NUM2CHR} */
#define CHR2FIX    RB_CHR2FIX         /**< @old{RB_CHR2FIX} */

/** @cond INTERNAL_MACRO */
#define RB_CHR2FIX RB_CHR2FIX
/** @endcond */

RBIMPL_ATTR_CONST_UNLESS_DEBUG()
RBIMPL_ATTR_CONSTEXPR_UNLESS_DEBUG(CXX14)
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Converts a C's `unsigned char` into an instance of ::rb_cInteger.
 *
 * @param[in]  c  Arbitrary `unsigned char` value.
 * @return     An instance of ::rb_cInteger.
 *
 * @internal
 *
 * Nobody explicitly states this but in  Ruby, a char means an unsigned integer
 * value of  range 0..255.   This is  a general principle.   AFAIK there  is no
 * single line of code where char is signed.
 */
static inline VALUE
RB_CHR2FIX(unsigned char c)
{
    return RB_INT2FIX(c);
}

/**
 * Converts an instance of ::rb_cNumeric into  C's `char`.  At the same time it
 * accepts a String of more than one character, and returns its first byte.  In
 * the  early days  there  was a  Ruby level  "character"  literal `?c`,  which
 * roughly worked this way.
 *
 * @param[in]  x               Either a string or a numeric.
 * @exception  rb_eTypeError   `x` is not a numeric.
 * @exception  rb_eRangeError  `x` is out of range of `unsigned int`.
 * @return     The passed value converted into C's `char`.
 */
static inline char
rb_num2char_inline(VALUE x)
{
    if (RB_TYPE_P(x, RUBY_T_STRING) && (RSTRING_LEN(x)>=1))
        return RSTRING_PTR(x)[0];
    else
        return RBIMPL_CAST((char)RB_NUM2INT(x));
}

#endif /* RBIMPL_ARITHMETIC_CHAR_H */
PK       ! )    #  ruby/internal/arithmetic/intptr_t.hnu [        #ifndef RBIMPL_ARITHMETIC_INTPTR_T_H                 /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ARITHMETIC_INTPTR_T_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Arithmetic conversion between C's `intptr_t` and Ruby's.
 */
#include "ruby/internal/config.h"

#ifdef HAVE_STDINT_H
# include <stdint.h>
#endif

#include "ruby/internal/value.h"
#include "ruby/internal/dllexport.h"

#define rb_int_new  rb_int2inum  /**< @alias{rb_int2inum} */
#define rb_uint_new rb_uint2inum /**< @alias{rb_uint2inum} */

RBIMPL_SYMBOL_EXPORT_BEGIN()

/**
 * Converts a C's `intptr_t` into an instance of ::rb_cInteger.
 *
 * @param[in]  i  Arbitrary `intptr_t` value.
 * @return     An instance of ::rb_cInteger.
 * @note       This function always allocates Bignums, even if the given number
 *             is small enough to fit into a Fixnum.
 */
VALUE rb_int2big(intptr_t i);

/**
 * Converts a C's `intptr_t` into an instance of ::rb_cInteger.
 *
 * @param[in]  i  Arbitrary `intptr_t` value.
 * @return     An instance of ::rb_cInteger.
 */
VALUE rb_int2inum(intptr_t i);

/**
 * Converts a C's `intptr_t` into an instance of ::rb_cInteger.
 *
 * @param[in]  i  Arbitrary `intptr_t` value.
 * @return     An instance of ::rb_cInteger.
 * @note       This function always allocates Bignums, even if the given number
 *             is small enough to fit into a Fixnum.
 */
VALUE rb_uint2big(uintptr_t i);

/**
 * Converts a C's `uintptr_t` into an instance of ::rb_cInteger.
 *
 * @param[in]  i  Arbitrary `uintptr_t` value.
 * @return     An instance of ::rb_cInteger.
 */
VALUE rb_uint2inum(uintptr_t i);
RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_ARITHMETIC_INTPTR_T_H */
PK       ! =nVt{  {  !  ruby/internal/arithmetic/fixnum.hnu [        #ifndef RBIMPL_ARITHMETIC_FIXNUM_H                   /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ARITHMETIC_FIXNUM_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Handling of integers formerly known as Fixnums.
 */
#include "ruby/backward/2/limits.h"

#define FIXABLE    RB_FIXABLE      /**< @old{RB_FIXABLE} */
#define FIXNUM_MAX RUBY_FIXNUM_MAX /**< @old{RUBY_FIXNUM_MAX} */
#define FIXNUM_MIN RUBY_FIXNUM_MIN /**< @old{RUBY_FIXNUM_MIN} */
#define NEGFIXABLE RB_NEGFIXABLE   /**< @old{RB_NEGFIXABLE} */
#define POSFIXABLE RB_POSFIXABLE   /**< @old{RB_POSFIXABLE} */

/**
 * Checks if the passed value is in  range of fixnum, assuming it is a positive
 * number.  Can sometimes be useful for C's unsigned integer types.
 *
 * @internal
 *
 * FIXABLE can be applied to anything, from double to intmax_t.  The problem is
 * double.   On a  64bit system  RUBY_FIXNUM_MAX is  4,611,686,018,427,387,903,
 * which is not representable by a double.  The nearest value that a double can
 * represent  is   4,611,686,018,427,387,904,  which   is  not   fixable.   The
 * seemingly-strange "< FIXNUM_MAX + 1" expression below is due to this.
 */
#define RB_POSFIXABLE(_) ((_) <  RUBY_FIXNUM_MAX + 1)

/**
 * Checks if the passed value is in  range of fixnum, assuming it is a negative
 * number.  This is an implementation of #RB_FIXABLE.  Rarely used stand alone.
 */
#define RB_NEGFIXABLE(_) ((_) >= RUBY_FIXNUM_MIN)

/** Checks if the passed value is in  range of fixnum */
#define RB_FIXABLE(_)    (RB_POSFIXABLE(_) && RB_NEGFIXABLE(_))

/** Maximum possible value that a fixnum can represent. */
#define RUBY_FIXNUM_MAX  (LONG_MAX / 2)

/** Minimum possible value that a fixnum can represent. */
#define RUBY_FIXNUM_MIN  (LONG_MIN / 2)

#endif /* RBIMPL_ARITHMETIC_FIXNUM_H */
PK       ! (^  ^     ruby/internal/arithmetic/uid_t.hnu [        #ifndef RBIMPL_ARITHMETIC_UID_T_H                    /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ARITHMETIC_UID_T_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Arithmetic conversion between C's `uid_t` and Ruby's.
 */
#include "ruby/internal/config.h"
#include "ruby/internal/arithmetic/long.h"

/** Converts a C's `uid_t` into an instance of ::rb_cInteger. */
#ifndef UIDT2NUM
# define UIDT2NUM RB_LONG2NUM
#endif

/** Converts an instance of ::rb_cNumeric into C's `uid_t`. */
#ifndef NUM2UIDT
# define NUM2UIDT RB_NUM2LONG
#endif

/** A rb_sprintf() format prefix to be used for a `uid_t` parameter. */
#ifndef PRI_UIDT_PREFIX
# define PRI_UIDT_PREFIX PRI_LONG_PREFIX
#endif

#endif /* RBIMPL_ARITHMETIC_UID_T_H */
PK       ! n-o
^  ^     ruby/internal/arithmetic/gid_t.hnu [        #ifndef RBIMPL_ARITHMETIC_GID_T_H                    /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ARITHMETIC_GID_T_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Arithmetic conversion between C's `gid_t` and Ruby's.
 */
#include "ruby/internal/config.h"
#include "ruby/internal/arithmetic/long.h"

/** Converts a C's `gid_t` into an instance of ::rb_cInteger. */
#ifndef GIDT2NUM
# define GIDT2NUM RB_LONG2NUM
#endif

/** Converts an instance of ::rb_cNumeric into C's `gid_t`. */
#ifndef NUM2GIDT
# define NUM2GIDT RB_NUM2LONG
#endif

/** A rb_sprintf() format prefix to be used for a `gid_t` parameter. */
#ifndef PRI_GIDT_PREFIX
# define PRI_GIDT_PREFIX PRI_LONG_PREFIX
#endif

#endif /* RBIMPL_ARITHMETIC_GID_T_H */
PK       ! m3