 developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.openssl.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */

#ifndef HEADER_UI_COMPAT_H
# define HEADER_UI_COMPAT_H

# include <openssl/opensslconf.h>
# include <openssl/ui.h>

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * The following functions were previously part of the DES section, and are
 * provided here for backward compatibility reasons.
 */

# define des_read_pw_string(b,l,p,v) \
        _ossl_old_des_read_pw_string((b),(l),(p),(v))
# define des_read_pw(b,bf,s,p,v) \
        _ossl_old_des_read_pw((b),(bf),(s),(p),(v))

int _ossl_old_des_read_pw_string(char *buf, int length, const char *prompt,
                                 int verify);
int _ossl_old_des_read_pw(char *buf, char *buff, int size, const char *prompt,
                          int verify);

#ifdef  __cplusplus
}
#endif
#endif
PK       ! ֦      openssl/krb5_asn.hnu [        /* krb5_asn.h */
/*
 * Written by Vern Staats <staatsvr@asc.hpc.mil> for the OpenSSL project, **
 * using ocsp/{*.h,*asn*.c} as a starting point
 */

/* ====================================================================
 * Copyright (c) 1998-2000 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.openssl.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    openssl-core@openssl.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.openssl.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */

#ifndef HEADER_KRB5_ASN_H
# define HEADER_KRB5_ASN_H

/*
 * #include <krb5.h>
 */
# include <openssl/safestack.h>

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * ASN.1 from Kerberos RFC 1510
 */

/*-     EncryptedData ::=   SEQUENCE {
 *              etype[0]                      INTEGER, -- EncryptionType
 *              kvno[1]                       INTEGER OPTIONAL,
 *              cipher[2]                     OCTET STRING -- ciphertext
 *      }
 */
typedef struct krb5_encdata_st {
    ASN1_INTEGER *etype;
    ASN1_INTEGER *kvno;
    ASN1_OCTET_STRING *cipher;
} KRB5_ENCDATA;

DECLARE_STACK_OF(KRB5_ENCDATA)

/*-     PrincipalName ::=   SEQUENCE {
 *              name-type[0]                  INTEGER,
 *              name-string[1]                SEQUENCE OF GeneralString
 *      }
 */
typedef struct krb5_princname_st {
    ASN1_INTEGER *nametype;
    STACK_OF(ASN1_GENERALSTRING) *namestring;
} KRB5_PRINCNAME;

DECLARE_STACK_OF(KRB5_PRINCNAME)

/*-     Ticket ::=      [APPLICATION 1] SEQUENCE {
 *              tkt-vno[0]                    INTEGER,
 *              realm[1]                      Realm,
 *              sname[2]                      PrincipalName,
 *              enc-part[3]                   EncryptedData
 *      }
 */
typedef struct krb5_tktbody_st {
    ASN1_INTEGER *tktvno;
    ASN1_GENERALSTRING *realm;
    KRB5_PRINCNAME *sname;
    KRB5_ENCDATA *encdata;
} KRB5_TKTBODY;

typedef STACK_OF(KRB5_TKTBODY) KRB5_TICKET;
DECLARE_STACK_OF(KRB5_TKTBODY)

/*-     AP-REQ ::=      [APPLICATION 14] SEQUENCE {
 *              pvno[0]                       INTEGER,
 *              msg-type[1]                   INTEGER,
 *              ap-options[2]                 APOptions,
 *              ticket[3]                     Ticket,
 *              authenticator[4]              EncryptedData
 *      }
 *
 *      APOptions ::=   BIT STRING {
 *              reserved(0), use-session-key(1), mutual-required(2) }
 */
typedef struct krb5_ap_req_st {
    ASN1_INTEGER *pvno;
    ASN1_INTEGER *msgtype;
    ASN1_BIT_STRING *apoptions;
    KRB5_TICKET *ticket;
    KRB5_ENCDATA *authenticator;
} KRB5_APREQBODY;

typedef STACK_OF(KRB5_APREQBODY) KRB5_APREQ;
DECLARE_STACK_OF(KRB5_APREQBODY)

/*      Authenticator Stuff     */

/*-     Checksum ::=   SEQUENCE {
 *              cksumtype[0]                  INTEGER,
 *              checksum[1]                   OCTET STRING
 *      }
 */
typedef struct krb5_checksum_st {
    ASN1_INTEGER *ctype;
    ASN1_OCTET_STRING *checksum;
} KRB5_CHECKSUM;

DECLARE_STACK_OF(KRB5_CHECKSUM)

/*-     EncryptionKey ::=   SEQUENCE {
 *              keytype[0]                    INTEGER,
 *              keyvalue[1]                   OCTET STRING
 *      }
 */
typedef struct krb5_encryptionkey_st {
    ASN1_INTEGER *ktype;
    ASN1_OCTET_STRING *keyvalue;
} KRB5_ENCKEY;

DECLARE_STACK_OF(KRB5_ENCKEY)

/*-     AuthorizationData ::=   SEQUENCE OF SEQUENCE {
 *              ad-type[0]                    INTEGER,
 *              ad-data[1]                    OCTET STRING
 *      }
 */
typedef struct krb5_authorization_st {
    ASN1_INTEGER *adtype;
    ASN1_OCTET_STRING *addata;
} KRB5_AUTHDATA;

DECLARE_STACK_OF(KRB5_AUTHDATA)

/*-     -- Unencrypted authenticator
 *      Authenticator ::=    [APPLICATION 2] SEQUENCE    {
 *              authenticator-vno[0]          INTEGER,
 *              crealm[1]                     Realm,
 *              cname[2]                      PrincipalName,
 *              cksum[3]                      Checksum OPTIONAL,
 *              cusec[4]                      INTEGER,
 *              ctime[5]                      KerberosTime,
 *              subkey[6]                     EncryptionKey OPTIONAL,
 *              seq-number[7]                 INTEGER OPTIONAL,
 *              authorization-data[8]         AuthorizationData OPTIONAL
 *      }
 */
typedef struct krb5_authenticator_st {
    ASN1_INTEGER *avno;
    ASN1_GENERALSTRING *crealm;
    KRB5_PRINCNAME *cname;
    KRB5_CHECKSUM *cksum;
    ASN1_INTEGER *cusec;
    ASN1_GENERALIZEDTIME *ctime;
    KRB5_ENCKEY *subkey;
    ASN1_INTEGER *seqnum;
    KRB5_AUTHDATA *authorization;
} KRB5_AUTHENTBODY;

typedef STACK_OF(KRB5_AUTHENTBODY) KRB5_AUTHENT;
DECLARE_STACK_OF(KRB5_AUTHENTBODY)

/*-  DECLARE_ASN1_FUNCTIONS(type) = DECLARE_ASN1_FUNCTIONS_name(type, type) =
 *      type *name##_new(void);
 *      void name##_free(type *a);
 *      DECLARE_ASN1_ENCODE_FUNCTIONS(type, name, name) =
 *       DECLARE_ASN1_ENCODE_FUNCTIONS(type, itname, name) =
 *        type *d2i_##name(type **a, const unsigned char **in, long len);
 *        int i2d_##name(type *a, unsigned char **out);
 *        DECLARE_ASN1_ITEM(itname) = OPENSSL_EXTERN const ASN1_ITEM itname##_it
 */

DECLARE_ASN1_FUNCTIONS(KRB5_ENCDATA)
DECLARE_ASN1_FUNCTIONS(KRB5_PRINCNAME)
DECLARE_ASN1_FUNCTIONS(KRB5_TKTBODY)
DECLARE_ASN1_FUNCTIONS(KRB5_APREQBODY)
DECLARE_ASN1_FUNCTIONS(KRB5_TICKET)
DECLARE_ASN1_FUNCTIONS(KRB5_APREQ)

DECLARE_ASN1_FUNCTIONS(KRB5_CHECKSUM)
DECLARE_ASN1_FUNCTIONS(KRB5_ENCKEY)
DECLARE_ASN1_FUNCTIONS(KRB5_AUTHDATA)
DECLARE_ASN1_FUNCTIONS(KRB5_AUTHENTBODY)
DECLARE_ASN1_FUNCTIONS(KRB5_AUTHENT)

/* BEGIN ERROR CODES */
/*
 * The following lines are auto generated by the script mkerr.pl. Any changes
 * made after this point may be overwritten when the script is next run.
 */

#ifdef  __cplusplus
}
#endif
#endif
PK       ! zJ      openssl/ssl23.hnu [        /* ssl/ssl23.h */
/* Copyright (C) 1995-1998 Eric Young (eay@cryptsoft.com)
 * All rights reserved.
 *
 * This package is an SSL implementation written
 * by Eric Young (eay@cryptsoft.com).
 * The implementation was written so as to conform with Netscapes SSL.
 *
 * This library is free for commercial and non-commercial use as long as
 * the following conditions are aheared to.  The following conditions
 * apply to all code found in this distribution, be it the RC4, RSA,
 * lhash, DES, etc., code; not just the SSL code.  The SSL documentation
 * included with this distribution is covered by the same copyright terms
 * except that the holder is Tim Hudson (tjh@cryptsoft.com).
 *
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * If this package is used in a product, Eric Young should be given attribution
 * as the author of the parts of the library used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    "This product includes cryptographic software written by
 *     Eric Young (eay@cryptsoft.com)"
 *    The word 'cryptographic' can be left out if the rouines from the library
 *    being used are not cryptographic related :-).
 * 4. If you include any Windows specific code (or a derivative thereof) from
 *    the apps directory (application code) you must include an acknowledgement:
 *    "This product includes software written by Tim Hudson (tjh@cryptsoft.com)"
 *
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

#ifndef HEADER_SSL23_H
# define HEADER_SSL23_H

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * client
 */
/* write to server */
# define SSL23_ST_CW_CLNT_HELLO_A        (0x210|SSL_ST_CONNECT)
# define SSL23_ST_CW_CLNT_HELLO_B        (0x211|SSL_ST_CONNECT)
/* read from server */
# define SSL23_ST_CR_SRVR_HELLO_A        (0x220|SSL_ST_CONNECT)
# define SSL23_ST_CR_SRVR_HELLO_B        (0x221|SSL_ST_CONNECT)

/* server */
/* read from client */
# define SSL23_ST_SR_CLNT_HELLO_A        (0x210|SSL_ST_ACCEPT)
# define SSL23_ST_SR_CLNT_HELLO_B        (0x211|SSL_ST_ACCEPT)

#ifdef  __cplusplus
}
#endif
#endif
PK       ! T6      openssl/kssl.hnu [        /* ssl/kssl.h */
/*
 * Written by Vern Staats <staatsvr@asc.hpc.mil> for the OpenSSL project
 * 2000. project 2000.
 */
/* ====================================================================
 * Copyright (c) 2000 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.OpenSSL.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    licensing@OpenSSL.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.OpenSSL.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */

/*
 **      19990701        VRS     Started.
 */

#ifndef KSSL_H
# define KSSL_H

# include <openssl/opensslconf.h>

# ifndef OPENSSL_NO_KRB5

#  include <stdio.h>
#  include <ctype.h>
#  include <krb5.h>
#  ifdef OPENSSL_SYS_WIN32
/*
 * These can sometimes get redefined indirectly by krb5 header files after
 * they get undefed in ossl_typ.h
 */
#   undef X509_NAME
#   undef X509_EXTENSIONS
#   undef OCSP_REQUEST
#   undef OCSP_RESPONSE
#  endif

#ifdef  __cplusplus
extern "C" {
#endif

/*
 *      Depending on which KRB5 implementation used, some types from
 *      the other may be missing.  Resolve that here and now
 */
#  ifdef KRB5_HEIMDAL
typedef unsigned char krb5_octet;
#   define FAR
#  else

#   ifndef FAR
#    define FAR
#   endif

#  endif

/*-
 *      Uncomment this to debug kssl problems or
 *      to trace usage of the Kerberos session key
 *
 *      #define         KSSL_DEBUG
 */

#  ifndef KRB5SVC
#   define KRB5SVC "host"
#  endif

#  ifndef KRB5KEYTAB
#   define KRB5KEYTAB      "/etc/krb5.keytab"
#  endif

#  ifndef KRB5SENDAUTH
#   define KRB5SENDAUTH    1
#  endif

#  ifndef KRB5CHECKAUTH
#   define KRB5CHECKAUTH   1
#  endif

#  ifndef KSSL_CLOCKSKEW
#   define KSSL_CLOCKSKEW  300;
#  endif

#  define KSSL_ERR_MAX    255
typedef struct kssl_err_st {
    int reason;
    char text[KSSL_ERR_MAX + 1];
} KSSL_ERR;

/*-     Context for passing
 *              (1) Kerberos session key to SSL, and
 *              (2)     Config data between application and SSL lib
 */
typedef struct kssl_ctx_st {
    /*      used by:    disposition:            */
    char *service_name;         /* C,S default ok (kssl) */
    char *service_host;         /* C input, REQUIRED */
    char *client_princ;         /* S output from krb5 ticket */
    char *keytab_file;          /* S NULL (/etc/krb5.keytab) */
    char *cred_cache;           /* C NULL (default) */
    krb5_enctype enctype;
    int length;
    krb5_octet FAR *key;
} KSSL_CTX;

#  define KSSL_CLIENT     1
#  define KSSL_SERVER     2
#  define KSSL_SERVICE    3
#  define KSSL_KEYTAB     4

#  define KSSL_CTX_OK     0
#  define KSSL_CTX_ERR    1
#  define KSSL_NOMEM      2

/* Public (for use by applications that use OpenSSL with Kerberos 5 support */
krb5_error_code kssl_ctx_setstring(KSSL_CTX *kssl_ctx, int which, char *text);
KSSL_CTX *kssl_ctx_new(void);
KSSL_CTX *kssl_ctx_free(KSSL_CTX *kssl_ctx);
void kssl_ctx_show(KSSL_CTX *kssl_ctx);
krb5_error_code kssl_ctx_setprinc(KSSL_CTX *kssl_ctx, int which,
                                  krb5_da