e Py_OSMODULE_H
#ifdef __cplusplus
extern "C" {
#endif

#if !defined(Py_LIMITED_API) || Py_LIMITED_API+0 >= 0x03060000
PyAPI_FUNC(PyObject *) PyOS_FSPath(PyObject *path);
#endif

#ifdef __cplusplus
}
#endif
#endif /* !Py_OSMODULE_H */
PK       ! M枰P  P    python3.13/osdefs.hnu [        // Operating system dependencies.
//
// Define constants:
//
// - ALTSEP
// - DELIM
// - MAXPATHLEN
// - SEP

#ifndef Py_OSDEFS_H
#define Py_OSDEFS_H
#ifdef __cplusplus
extern "C" {
#endif

#ifdef MS_WINDOWS
#  define SEP L'\\'
#  define ALTSEP L'/'
#  define MAXPATHLEN 256
#  define DELIM L';'
#endif

#ifdef __VXWORKS__
#  define DELIM L';'
#endif

/* Filename separator */
#ifndef SEP
#  define SEP L'/'
#endif

/* Max pathname length */
#ifdef __hpux
#  include <sys/param.h>
#  include <limits.h>
#  ifndef PATH_MAX
#    define PATH_MAX MAXPATHLEN
#  endif
#endif

#ifndef MAXPATHLEN
#  if defined(PATH_MAX) && PATH_MAX > 1024
#    define MAXPATHLEN PATH_MAX
#  else
#    define MAXPATHLEN 1024
#  endif
#endif

/* Search path entry delimiter */
#ifndef DELIM
#  define DELIM L':'
#endif

#ifdef __cplusplus
}
#endif
#endif   // !Py_OSDEFS_H
PK       ! j5O  O    python3.13/tupleobject.hnu [        /* Tuple object interface */

#ifndef Py_TUPLEOBJECT_H
#define Py_TUPLEOBJECT_H
#ifdef __cplusplus
extern "C" {
#endif

/*
Another generally useful object type is a tuple of object pointers.
For Python, this is an immutable type.  C code can change the tuple items
(but not their number), and even use tuples as general-purpose arrays of
object references, but in general only brand new tuples should be mutated,
not ones that might already have been exposed to Python code.

*** WARNING *** PyTuple_SetItem does not increment the new item's reference
count, but does decrement the reference count of the item it replaces,
if not nil.  It does *decrement* the reference count if it is *not*
inserted in the tuple.  Similarly, PyTuple_GetItem does not increment the
returned item's reference count.
*/

PyAPI_DATA(PyTypeObject) PyTuple_Type;
PyAPI_DATA(PyTypeObject) PyTupleIter_Type;

#define PyTuple_Check(op) \
                 PyType_FastSubclass(Py_TYPE(op), Py_TPFLAGS_TUPLE_SUBCLASS)
#define PyTuple_CheckExact(op) Py_IS_TYPE((op), &PyTuple_Type)

PyAPI_FUNC(PyObject *) PyTuple_New(Py_ssize_t size);
PyAPI_FUNC(Py_ssize_t) PyTuple_Size(PyObject *);
PyAPI_FUNC(PyObject *) PyTuple_GetItem(PyObject *, Py_ssize_t);
PyAPI_FUNC(int) PyTuple_SetItem(PyObject *, Py_ssize_t, PyObject *);
PyAPI_FUNC(PyObject *) PyTuple_GetSlice(PyObject *, Py_ssize_t, Py_ssize_t);
PyAPI_FUNC(PyObject *) PyTuple_Pack(Py_ssize_t, ...);

#ifndef Py_LIMITED_API
#  define Py_CPYTHON_TUPLEOBJECT_H
#  include "cpython/tupleobject.h"
#  undef Py_CPYTHON_TUPLEOBJECT_H
#endif

#ifdef __cplusplus
}
#endif
#endif /* !Py_TUPLEOBJECT_H */
PK       ! w    (  python3.13/internal/pycore_bytesobject.hnu [        #ifndef Py_INTERNAL_BYTESOBJECT_H
#define Py_INTERNAL_BYTESOBJECT_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

extern PyObject* _PyBytes_FormatEx(
    const char *format,
    Py_ssize_t format_len,
    PyObject *args,
    int use_bytearray);

extern PyObject* _PyBytes_FromHex(
    PyObject *string,
    int use_bytearray);

// Helper for PyBytes_DecodeEscape that detects invalid escape chars.
// Export for test_peg_generator.
PyAPI_FUNC(PyObject*) _PyBytes_DecodeEscape2(const char *, Py_ssize_t,
                                             const char *,
                                             int *, const char **);
// Export for binary compatibility.
PyAPI_FUNC(PyObject*) _PyBytes_DecodeEscape(const char *, Py_ssize_t,
                                            const char *, const char **);


// Substring Search.
//
// Returns the index of the first occurrence of
// a substring ("needle") in a larger text ("haystack").
// If the needle is not found, return -1.
// If the needle is found, add offset to the index.
//
// Export for 'mmap' shared extension.
PyAPI_FUNC(Py_ssize_t)
_PyBytes_Find(const char *haystack, Py_ssize_t len_haystack,
              const char *needle, Py_ssize_t len_needle,
              Py_ssize_t offset);

// Same as above, but search right-to-left.
// Export for 'mmap' shared extension.
PyAPI_FUNC(Py_ssize_t)
_PyBytes_ReverseFind(const char *haystack, Py_ssize_t len_haystack,
                     const char *needle, Py_ssize_t len_needle,
                     Py_ssize_t offset);


// Helper function to implement the repeat and inplace repeat methods on a
// buffer.
//
// len_dest is assumed to be an integer multiple of len_src.
// If src equals dest, then assume the operation is inplace.
//
// This method repeately doubles the number of bytes copied to reduce
// the number of invocations of memcpy.
//
// Export for 'array' shared extension.
PyAPI_FUNC(void)
_PyBytes_Repeat(char* dest, Py_ssize_t len_dest,
    const char* src, Py_ssize_t len_src);

/* --- _PyBytesWriter ----------------------------------------------------- */

/* The _PyBytesWriter structure is big: it contains an embedded "stack buffer".
   A _PyBytesWriter variable must be declared at the end of variables in a
   function to optimize the memory allocation on the stack. */
typedef struct {
    /* bytes, bytearray or NULL (when the small buffer is used) */
    PyObject *buffer;

    /* Number of allocated size. */
    Py_ssize_t allocated;

    /* Minimum number of allocated bytes,
       incremented by _PyBytesWriter_Prepare() */
    Py_ssize_t min_size;

    /* If non-zero, use a bytearray instead of a bytes object for buffer. */
    int use_bytearray;

    /* If non-zero, overallocate the buffer (default: 0).
       This flag must be zero if use_bytearray is non-zero. */
    int overallocate;

    /* Stack buffer */
    int use_small_buffer;
    char small_buffer[512];
} _PyBytesWriter;

/* Initialize a bytes writer

   By default, the overallocation is disabled. Set the overallocate attribute
   to control the allocation of the buffer.

   Export _PyBytesWriter API for '_pickle' shared extension. */
PyAPI_FUNC(void) _PyBytesWriter_Init(_PyBytesWriter *writer);

/* Get the buffer content and reset the writer.
   Return a bytes object, or a bytearray object if use_bytearray is non-zero.
   Raise an exception and return NULL on error. */
PyAPI_FUNC(PyObject *) _PyBytesWriter_Finish(_PyBytesWriter *writer,
    void *str);

/* Deallocate memory of a writer (clear its internal buffer). */
PyAPI_FUNC(void) _PyBytesWriter_Dealloc(_PyBytesWriter *writer);

/* Allocate the buffer to write size bytes.
   Return the pointer to the beginning of buffer data.
   Raise an exception and return NULL on error. */
PyAPI_FUNC(void*) _PyBytesWriter_Alloc(_PyBytesWriter *writer,
    Py_ssize_t size);

/* Ensure that the buffer is large enough to write *size* bytes.
   Add size to the writer minimum size (min_size attribute).

   str is the current pointer inside the buffer.
   Return the updated current pointer inside the buffer.
   Raise an exception and return NULL on error. */
PyAPI_FUNC(void*) _PyBytesWriter_Prepare(_PyBytesWriter *writer,
    void *str,
    Py_ssize_t size);

/* Resize the buffer to make it larger.
   The new buffer may be larger than size bytes because of overallocation.
   Return the updated current pointer inside the buffer.
   Raise an exception and return NULL on error.

   Note: size must be greater than the number of allocated bytes in the writer.

   This function doesn't use the writer minimum size (min_size attribute).

   See also _PyBytesWriter_Prepare().
   */
PyAPI_FUNC(void*) _PyBytesWriter_Resize(_PyBytesWriter *writer,
    void *str,
    Py_ssize_t size);

/* Write bytes.
   Raise an exception and return NULL on error. */
PyAPI_FUNC(void*) _PyBytesWriter_WriteBytes(_PyBytesWriter *writer,
    void *str,
    const void *bytes,
    Py_ssize_t size);

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_BYTESOBJECT_H */
PK       ! WY {   {     python3.13/internal/pycore_ast.hnu [        // File automatically generated by Parser/asdl_c.py.

#ifndef Py_INTERNAL_AST_H
#define Py_INTERNAL_AST_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

#include "pycore_asdl.h"          // _ASDL_SEQ_HEAD

typedef struct _mod *mod_ty;

typedef struct _stmt *stmt_ty;

typedef struct _expr *expr_ty;

typedef enum _expr_context { Load=1, Store=2, Del=3 } expr_context_ty;

typedef enum _boolop { And=1, Or=2 } boolop_ty;

typedef enum _operator { Add=1, Sub=2, Mult=3, MatMult=4, Div=5, Mod=6, Pow=7,
                         LShift=8, RShift=9, BitOr=10, BitXor=11, BitAnd=12,
                         FloorDiv=13 } operator_ty;

typedef enum _unaryop { Invert=1, Not=2, UAdd=3, USub=4 } unaryop_ty;

typedef enum _cmpop { Eq=1, NotEq=2, Lt=3, LtE=4, Gt=5, GtE=6, Is=7, IsNot=8,
                      In=9, NotIn=10 } cmpop_ty;

typedef struct _comprehension *comprehension_ty;

typedef struct _excepthandler *excepthandler_ty;

typedef struct _arguments *arguments_ty;

typedef struct _arg *arg_ty;

typedef struct _keyword *keyword_ty;

typedef struct _alias *alias_ty;

typedef struct _withitem *withitem_ty;

typedef struct _match_case *match_case_ty;

typedef struct _pattern *pattern_ty;

typedef struct _type_ignore *type_ignore_ty;

typedef struct _type_param *type_param_ty;


typedef struct {
    _ASDL_SEQ_HEAD
    mod_ty typed_elements[1];
} asdl_mod_seq;

asdl_mod_seq *_Py_asdl_mod_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    stmt_ty typed_elements[1];
} asdl_stmt_seq;

asdl_stmt_seq *_Py_asdl_stmt_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    expr_ty typed_elements[1];
} asdl_expr_seq;

asdl_expr_seq *_Py_asdl_expr_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    comprehension_ty typed_elements[1];
} asdl_comprehension_seq;

asdl_comprehension_seq *_Py_asdl_comprehension_seq_new(Py_ssize_t size, PyArena
                                                       *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    excepthandler_ty typed_elements[1];
} asdl_excepthandler_seq;

asdl_excepthandler_seq *_Py_asdl_excepthandler_seq_new(Py_ssize_t size, PyArena
                                                       *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    arguments_ty typed_elements[1];
} asdl_arguments_seq;

asdl_arguments_seq *_Py_asdl_arguments_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    arg_ty typed_elements[1];
} asdl_arg_seq;

asdl_arg_seq *_Py_asdl_arg_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    keyword_ty typed_elements[1];
} asdl_keyword_seq;

asdl_keyword_seq *_Py_asdl_keyword_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    alias_ty typed_elements[1];
} asdl_alias_seq;

asdl_alias_seq *_Py_asdl_alias_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    withitem_ty typed_elements[1];
} asdl_withitem_seq;

asdl_withitem_seq *_Py_asdl_withitem_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    match_case_ty typed_elements[1];
} asdl_match_case_seq;

asdl_match_case_seq *_Py_asdl_match_case_seq_new(Py_ssize_t size, PyArena
                                                 *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    pattern_ty typed_elements[1];
} asdl_pattern_seq;

asdl_pattern_seq *_Py_asdl_pattern_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    type_ignore_ty typed_elements[1];
} asdl_type_ignore_seq;

asdl_type_ignore_seq *_Py_asdl_type_ignore_seq_new(Py_ssize_t size, PyArena
                                                   *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    type_param_ty typed_elements[1];
} asdl_type_param_seq;

asdl_type_param_seq *_Py_asdl_type_param_seq_new(Py_ssize_t size, PyArena
                                                 *arena);


enum _mod_kind {Module_kind=1, Interactive_kind=2, Expression_kind=3,
                 FunctionType_kind=4};
struct _mod {
    enum _mod_kind kind;
    union {
        struct {
            asdl_stmt_seq *body;
            asdl_type_ignore_seq *type_ignores;
        } Module;

        struct {
            asdl_stmt_seq *body;
        } Interactive;

        struct {
            expr_ty body;
        } Expression;

        struct {
            asdl_expr_seq *argtypes;
            expr_ty returns;
        } FunctionType;

    } v;
};

enum _stmt_kind {FunctionDef_kind=1, AsyncFunctionDef_kind=2, ClassDef_kind=3,
                  Return_kind=4, Delete_kind=5, Assign_kind=6,
                  TypeAlias_kind=7, AugAssign_kind=8, AnnAssign_kind=9,
                  For_kind=10, AsyncFor_kind=11, While_kind=12, If_kind=13,
                  With_kind=14, AsyncWith_kind=15, Match_kind=16,
                  Raise_kind=17, Try_kind=18, TryStar_kind=19, Assert_kind=20,
                  Import_kind=21, ImportFrom_kind=22, Global_kind=23,
                  Nonlocal_kind=24, Expr_kind=25, Pass_kind=26, Break_kind=27,
                  Continue_kind=28};
struct _stmt {
    enum _stmt_kind kind;
    union {
        struct {
            identifier name;
            arguments_ty args;
            asdl_stmt_seq *body;
            asdl_expr_seq *decorator_list;
            expr_ty returns;
            string type_comment;
            asdl_type_param_seq *type_params;
        } FunctionDef;

        struct {
            identifier name;
            arguments_ty args;
            asdl_stmt_seq *body;
            asdl_expr_seq *decorator_list;
            expr_ty returns;
            string type_comment;
            asdl_type_param_seq *type_params;
        } AsyncFunctionDef;

        struct {
            identifier name;
            asdl_expr_seq *bases;
            asdl_keyword_seq *keywords;
            asdl_stmt_seq *body;
            asdl_expr_seq *decorator_list;
            asdl_type_param_seq *type_params;
        } ClassDef;

        struct {
            expr_ty value;
        } Return;

        struct {
            asdl_expr_seq *targets;
        } Delete;

        struct {
            asdl_expr_seq *targets;
            expr_ty value;
            string type_comment;
        } Assign;

        struct {
            expr_ty name;
            asdl_type_param_seq *type_params;
            expr_ty value;
        } TypeAlias;

        struct {
            expr_ty target;
            operator_ty op;
            expr_ty value;
        } AugAssign;

        struct {
            expr_ty target;
            expr_ty annotation;
            expr_ty value;
            int simple;
        } AnnAssign;

        struct {
            expr_ty target;
            expr_ty iter;
            asdl_stmt_seq *body;
            asdl_stmt_seq *orelse;
            string type_comment;
        } For;

        struct {
            expr_ty target;
            expr_ty iter;
            asdl_stmt_seq *body;
            asdl_stmt_seq *orelse;
            string type_comment;
        } AsyncFor;

        struct {
            expr_ty test;
            asdl_stmt_seq *body;
            asdl_stmt_seq *orelse;
        } While;

        struct {
            expr_ty test;
            asdl_stmt_seq *body;
            asdl_stmt_seq *orelse;
        } If;

        struct {
            asdl_withitem_seq *items;
            asdl_stmt_seq *body;
            string type_comment;
        } With;

        struct {
            asdl_withitem_seq *items;
            asdl_stmt_seq *body;
            string type_comment;
        } AsyncWith;

        struct {
            expr_ty subject;
            asdl_match_case_seq *cases;
        } Match;

        struct {
            expr_ty exc;
            expr_ty cause;
        } Raise;

        struct {
            asdl_stmt_seq *body;
            asdl_excepthandler_seq *handlers;
            asdl_stmt_seq *orelse;
            asdl_stmt_seq *finalbody;
        } Try;

        struct {
            asdl_stmt_seq *body;
            asdl_excepthandler_seq *handlers;
            asdl_stmt_seq *orelse;
            asdl_stmt_seq *finalbody;
        } TryStar;

        struct {
            expr_ty test;
            expr_ty msg;
        } Assert;

        struct {
            asdl_alias_seq *names;
        } Import;

        struct {
            identifier module;
            asdl_alias_seq *names;
            int level;
        } ImportFrom;

        struct {
            asdl_identifier_seq *names;
        } Global;

        struct {
            asdl_identifier_seq *names;
        } Nonlocal;

        struct {
            expr_ty value;
        } Expr;

    } v;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

enum _expr_kind {BoolOp_kind=1, NamedExpr_kind=2, BinOp_kind=3, UnaryOp_kind=4,
                  Lambda_kind=5, IfExp_kind=6, Dict_kind=7, Set_kind=8,
                  ListComp_kind=9, SetComp_kind=10, DictComp_kind=11,
                  GeneratorExp_kind=12, Await_kind=13, Yield_kind=14,
                  YieldFrom_kind=15, Compare_kind=16, Call_kind=17,
                  FormattedValue_kind=18, JoinedStr_kind=19, Constant_kind=20,
                  Attribute_kind=21, Subscript_kind=22, Starred_kind=23,
                  Name_kind=24, List_kind=25, Tuple_kind=26, Slice_kind=27};
struct _expr {
    enum _expr_kind kind;
    union {
        struct {
            boolop_ty op;
            asdl_expr_seq *values;
        } BoolOp;

        struct {
            expr_ty target;
            expr_ty value;
        } NamedExpr;

        struct {
            expr_ty left;
            operator_ty op;
            expr_ty right;
        } BinOp;

        struct {
            unaryop_ty op;
            expr_ty operand;
        } UnaryOp;

        struct {
            arguments_ty args;
            expr_ty body;
        } Lambda;

        struct {
            expr_ty test;
            expr_ty body;
            expr_ty orelse;
        } IfExp;

        struct {
            asdl_expr_seq *keys;
            asdl_expr_seq *values;
        } Dict;

        struct {
            asdl_expr_seq *elts;
        } Set;

        struct {
            expr_ty elt;
            asdl_comprehension_seq *generators;
        } ListComp;

        struct {
            expr_ty elt;
            asdl_comprehension_seq *generators;
        } SetComp;

        struct {
            expr_ty key;
            expr_ty value;
            asdl_comprehension_seq *generators;
        } DictComp;

        struct {
            expr_ty elt;
            asdl_comprehension_seq *generators;
        } GeneratorExp;

        struct {
            expr_ty value;
        } Await;

        struct {
            expr_ty value;
        } Yield;

        struct {
            expr_ty value;
        } YieldFrom;

        struct {
            expr_ty left;
            asdl_int_seq *ops;
            asdl_expr_seq *comparators;
        } Compare;

        struct {
            expr_ty func;
            asdl_expr_seq *args;
            asdl_keyword_seq *keywords;
        } Call;

        struct {
            expr_ty value;
            int conversion;
            expr_ty format_spec;
        } FormattedValue;

        struct {
            asdl_expr_seq *values;
        } JoinedStr;

        struct {
            constant value;
            string kind;
        } Constant;

        struct {
            expr_ty value;
            identifier attr;
            expr_context_ty ctx;
        } Attribute;

        struct {
            expr_ty value;
            expr_ty slice;
            expr_context_ty ctx;
        } Subscript;

        struct {
            expr_ty value;
            expr_context_ty ctx;
        } Starred;

        struct {
            identifier id;
            expr_context_ty ctx;
        } Name;

        struct {
            asdl_expr_seq *elts;
            expr_context_ty ctx;
        } List;

        struct {
            asdl_expr_seq *elts;
            expr_context_ty ctx;
        } Tuple;

        struct {
            expr_ty lower;
            expr_ty upper;
            expr_ty step;
        } Slice;

    } v;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

struct _comprehension {
    expr_ty target;
    expr_ty iter;
    asdl_expr_seq *ifs;
    int is_async;
};

enum _excepthandler_kind {ExceptHandler_kind=1};
struct _excepthandler {
    enum _excepthandler_kind kind;
    union {
        struct {
            expr_ty type;
            identifier name;
            asdl_stmt_seq *body;
        } ExceptHandler;

    } v;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

struct _arguments {
    asdl_arg_seq *posonlyargs;
    asdl_arg_seq *args;
    arg_ty vararg;
    asdl_arg_seq *kwonlyargs;
    asdl_expr_seq *kw_defaults;
    arg_ty kwarg;
    asdl_expr_seq *defaults;
};

struct _arg {
    identifier arg;
    expr_ty annotation;
    string type_comment;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

struct _keyword {
    identifier arg;
    expr_ty value;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

struct _alias {
    identifier name;
    identifier asname;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

struct _withitem {
    expr_ty context_expr;
    expr_ty optional_vars;
};

struct _match_case {
    pattern_ty pattern;
    expr_ty guard;
    asdl_stmt_seq *body;
};

enum _pattern_kind {MatchValue_kind=1, MatchSingleton_kind=2,
                     MatchSequence_kind=3, MatchMapping_kind=4,
                     MatchClass_kind=5, MatchStar_kind=6, MatchAs_kind=7,
                     MatchOr_kind=8};
struct _pattern {
    enum _pattern_kind kind;
    union {
        struct {
            expr_ty value;
        } MatchValue;

        struct {
            constant value;
        } MatchSingleton;

        struct {
            asdl_pattern_seq *patterns;
        } MatchSequence;

        struct {
            asdl_expr_seq *keys;
            asdl_pattern_seq *patterns;
            identifier rest;
        } MatchMapping;

        struct {
            expr_ty cls;
            asdl_pattern_seq *patterns;
            asdl_identifier_seq *kwd_attrs;
            asdl_pattern_seq *kwd_patterns;
        } MatchClass;

        struct {
            identifier name;
        } MatchStar;

        struct {
            pattern_ty pattern;
            identifier name;
        } MatchAs;

        struct {
            asdl_pattern_seq *patterns;
        } MatchOr;

    } v;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

enum _type_ignore_kind {TypeIgnore_kind=1};
struct _type_ignore {
    enum _type_ignore_kind kind;
    union {
        struct {
            int lineno;
            string tag;
        } TypeIgnore;

    } v;
};

enum _type_param_kind {TypeVar_kind=1, ParamSpec_kind=2, TypeVarTuple_kind=3};
struct _type_param {
    enum _type_param_kind kind;
    union {
        struct {
            identifier name;
            expr_ty bound;
            expr_ty default_value;
        } TypeVar;

        struct {
            identifier name;
            expr_ty default_value;
        } ParamSpec;

        struct {
            identifier name;
            expr_ty default_value;
        } TypeVarTuple;

    } v;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};


// Note: these macros affect function definitions, not only call sites.
mod_ty _PyAST_Module(asdl_stmt_seq * body, asdl_type_ignore_seq * type_ignores,
                     PyArena *arena);
mod_ty _PyAST_Interactive(asdl_stmt_seq * body, PyArena *arena);
mod_ty _PyAST_Expression(expr_ty body, PyArena *arena);
mod_ty _PyAST_FunctionType(asdl_expr_seq * argtypes, expr_ty returns, PyArena
                           *arena);
stmt_ty _PyAST_FunctionDef(identifier name, arguments_ty args, asdl_stmt_seq *
                           body, asdl_expr_seq * decorator_list, expr_ty
                           returns, string type_comment, asdl_type_param_seq *
                           type_params, int lineno, int col_offset, int
                           end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_AsyncFunctionDef(identifier name, arguments_ty args,
                                asdl_stmt_seq * body, asdl_expr_seq *
                                decorator_list, expr_ty returns, string
                                type_comment, asdl_type_param_seq *
                                type_params, int lineno, int col_offset, int
                                end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_ClassDef(identifier name, asdl_expr_seq * bases,
                        asdl_keyword_seq * keywords, asdl_stmt_seq * body,
                        asdl_expr_seq * decorator_list, asdl_type_param_seq *
                        type_params, int lineno, int col_offset, int
                        end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Return(expr_ty value, int lineno, int col_offset, int
                      end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Delete(asdl_expr_seq * targets, int lineno, int col_offset, int
                      end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Assign(asdl_expr_seq * targets, expr_ty value, string
                      type_comment, int lineno, int col_offset, int end_lineno,
                      int end_col_offset, PyArena *arena);
stmt_ty _PyAST_TypeAlias(expr_ty name, asdl_type_param_seq * type_params,
                         expr_ty value, int lineno, int col_offset, int
                         end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_AugAssign(expr_ty target, operator_ty op, expr_ty value, int
                         lineno, int col_offset, int end_lineno, int
                         end_col_offset, PyArena *arena);
stmt_ty _PyAST_AnnAssign(expr_ty target, expr_ty annotation, expr_ty value, int
                         simple, int lineno, int col_offset, int end_lineno,
                         int end_col_offset, PyArena *arena);
stmt_ty _PyAST_For(expr_ty target, expr_ty iter, asdl_stmt_seq * body,
                   asdl_stmt_seq * orelse, string type_comment, int lineno, int
                   col_offset, int end_lineno, int end_col_offset, PyArena
                   *arena);
stmt_ty _PyAST_AsyncFor(expr_ty target, expr_ty iter, asdl_stmt_seq * body,
                        asdl_stmt_seq * orelse, string type_comment, int
                        lineno, int col_offset, int end_lineno, int
                        end_col_offset, PyArena *arena);
stmt_ty _PyAST_While(expr_ty test, asdl_stmt_seq * body, asdl_stmt_seq *
                     orelse, int lineno, int col_offset, int end_lineno, int
                     end_col_offset, PyArena *arena);
stmt_ty _PyAST_If(expr_ty test, asdl_stmt_seq * body, asdl_stmt_seq * orelse,
                  int lineno, int col_offset, int end_lineno, int
                  end_col_offset, PyArena *arena);
stmt_ty _PyAST_With(asdl_withitem_seq * items, asdl_stmt_seq * body, string
                    type_comment, int lineno, int col_offset, int end_lineno,
                    int end_col_offset, PyArena *arena);
stmt_ty _PyAST_AsyncWith(asdl_withitem_seq * items, asdl_stmt_seq * body,
                         string type_comment, int lineno, int col_offset, int
                         end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Match(expr_ty subject, asdl_match_case_seq * cases, int lineno,
                     int col_offset, int end_lineno, int end_col_offset,
                     PyArena *arena);
stmt_ty _PyAST_Raise(expr_ty exc, expr_ty cause, int lineno, int col_offset,
                     int end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Try(asdl_stmt_seq * body, asdl_excepthandler_seq * handlers,
                   asdl_stmt_seq * orelse, asdl_stmt_seq * finalbody, int
                   lineno, int col_offset, int end_lineno, int end_col_offset,
                   PyArena *arena);
stmt_ty _PyAST_TryStar(asdl_stmt_seq * body, asdl_excepthandler_seq * handlers,
                       asdl_stmt_seq * orelse, asdl_stmt_seq * finalbody, int
                       lineno, int col_offset, int end_lineno, int
                       end_col_offset, PyArena *arena);
stmt_ty _PyAST_Assert(expr_ty test, expr_ty msg, int lineno, int col_offset,
                      int end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Import(asdl_alias_seq * names, int lineno, int col_offset, int
                      end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_ImportFrom(identifier module, asdl_alias_seq * names, int level,
                          int lineno, int col_offset, int end_lineno, int
                          end_col_offset, PyArena *arena);
stmt_ty _PyAST_Global(asdl_identifier_seq * names, int lineno, int col_offset,
                      int end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Nonlocal(asdl_identifier_seq * names, int lineno, int
                        col_offset, int end_lineno, int end_col_offset, PyArena
                        *arena);
stmt_ty _PyAST_Expr(expr_ty value, int lineno, int col_offset, int end_lineno,
                    int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Pass(int lineno, int col_offset, int end_lineno, int
                    end_col_offset, PyArena *arena);
stmt_ty _PyAST_Break(int lineno, int col_offset, int end_lineno, int
                     end_col_offset, PyArena *arena);
stmt_ty _PyAST_Continue(int lineno, int col_offset, int end_lineno, int
                        end_col_offset, PyArena *arena);
expr_ty _PyAST_BoolOp(boolop_ty op, asdl_expr_seq * values, int lineno, int
                      col_offset, int end_lineno, int end_col_offset, PyArena
                      *arena);
expr_ty _PyAST_NamedExpr(expr_ty target, expr_ty value, int lineno, int
                         col_offset, int end_lineno, int end_col_offset,
                         PyArena *arena);
expr_ty _PyAST_BinOp(expr_ty left, operator_ty op, expr_ty right, int lineno,
                     int col_offset, int end_lineno, int end_col_offset,
                     PyArena *arena);
expr_ty _PyAST_UnaryOp(unaryop_ty op, expr_ty operand, int lineno, int
                       col_offset, int end_lineno, int end_col_offset, PyArena
                       *arena);
expr_ty _PyAST_Lambda(arguments_ty args, expr_ty body, int lineno, int
                      col_offset, int end_lineno, int end_col_offset, PyArena
                      *arena);
expr_ty _PyAST_IfExp(expr_ty test, expr_ty body, expr_ty orelse, int lineno,
                     int col_offset, int end_lineno, int end_col_offset,
                     PyArena *arena);
expr_ty _PyAST_Dict(asdl_expr_seq * keys, asdl_expr_seq * values, int lineno,
                    int col_offset, int end_lineno, int end_col_offset, PyArena
                    *arena);
expr_ty _PyAST_Set(asdl_expr_seq * elts, int lineno, int col_offset, int
                   end_lineno, int end_col_offset, PyArena *arena);
expr_ty _PyAST_ListComp(expr_ty elt, asdl_comprehension_seq * generators, int
                        lineno, int col_offset, int end_lineno, int
                        end_col_offset, PyArena *arena);
expr_ty _PyAST_SetComp(expr_ty elt, asdl_comprehension_seq * generators, int
                       lineno, int col_offset, int end_lineno, int
                       end_col_offset, PyArena *arena);
expr_ty _PyAST_DictComp(expr_ty key, expr_ty value, asdl_comprehension_seq *
                        generators, int lineno, int col_offset, int end_lineno,
                        int end_col_offset, PyArena *arena);
expr_ty _PyAST_GeneratorExp(expr_ty elt, asdl_comprehension_seq * generators,
                            int lineno, int col_offset, int end_lineno, int
                            end_col_offset, PyArena *arena);
expr_ty _PyAST_Await(expr_ty value, int lineno, int col_offset, int end_lineno,
                     int end_col_offset, PyArena *arena);
expr_ty _PyAST_Yield(expr_ty value, int lineno, int col_offset, int end_lineno,
                     int end_col_offset, PyArena *arena);
expr_ty _PyAST_YieldFrom(expr_ty value, int lineno, int col_offset, int
                         end_lineno, int end_col_offset, PyArena *arena);
expr_ty _PyAST_Compare(expr_ty left, asdl_int_seq * ops, asdl_expr_seq *
                       comparators, int lineno, int col_offset, int end_lineno,
                       int end_col_offset, PyArena *arena);
expr_ty _PyAST_Call(expr_ty func, asdl_expr_seq * args, asdl_keyword_seq *
                    keywords, int lineno, int col_offset, int end_lineno, int
                    end_col_offset, PyArena *arena);
expr_ty _PyAST_FormattedValue(expr_ty value, int conversion, expr_ty
                              format_spec, int lineno, int col_offset, int
                              end_lineno, int end_col_offset, PyArena *arena);
expr_ty _PyAST_JoinedStr(asdl_expr_seq * values, int lineno, int col_offset,
                         int end_lineno, int end_col_offset, PyArena *arena);
expr_ty _PyAST_Constant(constant value, string kind, int lineno, int
                        col_offset, int end_lineno, int end_col_offset, PyArena
                        *arena);
expr_ty _PyAST_Attribute(expr_ty value, identifier attr, expr_context_ty ctx,
                         int lineno, int col_offset, int end_lineno, int
                         end_col_offset, PyArena *arena);
expr_ty _PyAST_Subscript(expr_ty value, expr_ty slice, expr_context_ty ctx, int
                         lineno, int col_offset, int end_lineno, int
                         end_col_offset, PyArena *arena);
expr_ty _PyAST_Starred(expr_ty value, expr_context_ty ctx, int lineno, int
                       col_offset, int end_lineno, int end_col_offset, PyArena
                       *arena);
expr_ty _PyAST_Name(identifier id, expr_context_ty ctx, int lineno, int
                    col_offset, int end_lineno, int end_col_offset, PyArena
                    *arena);
expr_ty _PyAST_List(asdl_expr_seq * elts, expr_context_ty ctx, int lineno, int
                    col_offset, int end_lineno, int end_col_offset, PyArena
                    *arena);
expr_ty _PyAST_Tuple(asdl_expr_seq * elts, expr_context_ty ctx, int lineno, int
                     col_offset, int end_lineno, int end_col_offset, PyArena
                     *arena);
expr_ty _PyAST_Slice(expr_ty lower, expr_ty upper, expr_ty step, int lineno,
                     int col_offset, int end_lineno, int end_col_offset,
                     PyArena *arena);
comprehension_ty _PyAST_comprehension(expr_ty target, expr_ty iter,
                                      asdl_expr_seq * ifs, int is_async,
                                      PyArena *arena);
excepthandler_ty _PyAST_ExceptHandler(expr_ty type, identifier name,
                                      asdl_stmt_seq * body, int lineno, int
                                      col_offset, int end_lineno, int
                                      end_col_offset, PyArena *arena);
arguments_ty _PyAST_arguments(asdl_arg_seq * posonlyargs, asdl_arg_seq * args,
                              arg_ty vararg, asdl_arg_seq * kwonlyargs,
                              asdl_expr_seq * kw_defaults, arg_ty kwarg,
                              asdl_expr_seq * defaults, PyArena *arena);
arg_ty _PyAST_arg(identifier arg, expr_ty annotation, string type_comment, int
                  lineno, int col_offset, int end_lineno, int end_col_offset,
                  PyArena *arena);
keyword_ty _PyAST_keyword(identifier arg, expr_ty value, int lineno, int
                          col_offset, int end_lineno, int end_col_offset,
                          PyArena *arena);
alias_ty _PyAST_alias(identifier name, identifier asname, int lineno, int
                      col_offset, int end_lineno, int end_col_offset, PyArena
                      *arena);
withitem_ty _PyAST_withitem(expr_ty context_expr, expr_ty optional_vars,
                            PyArena *arena);
match_case_ty _PyAST_match_case(pattern_ty pattern, expr_ty guard,
                                asdl_stmt_seq * body, PyArena *arena);
pattern_ty _PyAST_MatchValue(expr_ty value, int lineno, int col_offset, int
                             end_lineno, int end_col_offset, PyArena *arena);
pattern_ty _PyAST_MatchSingleton(constant value, int lineno, int col_offset,
                                 int end_lineno, int end_col_offset, PyArena
                                 *arena);
pattern_ty _PyAST_MatchSequence(asdl_pattern_seq * patterns, int lineno, int
                                col_offset, int end_lineno, int end_col_offset,
                                PyArena *arena);
pattern_ty _PyAST_MatchMapping(asdl_expr_seq * keys, asdl_pattern_seq *
                               patterns, identifier rest, int lineno, int
                               col_offset, int end_lineno, int end_col_offset,
                               PyArena *arena);
pattern_ty _PyAST_MatchClass(expr_ty cls, asdl_pattern_seq * patterns,
                             asdl_identifier_seq * kwd_attrs, asdl_pattern_seq
                             * kwd_patterns, int lineno, int col_offset, int
                             end_lineno, int end_col_offset, PyArena *arena);
pattern_ty _PyAST_MatchStar(identifier name, int lineno, int col_offset, int
                            end_lineno, int end_col_offset, PyArena *arena);
pattern_ty _PyAST_MatchAs(pattern_ty pattern, identifier name, int lineno, int
                          col_offset, int end_lineno, int end_col_offset,
                          PyArena *arena);
pattern_ty _PyAST_MatchOr(asdl_pattern_seq * patterns, int lineno, int
                          col_offset, int end_lineno, int end_col_offset,
                          PyArena *arena);
type_ignore_ty _PyAST_TypeIgnore(int lineno, string tag, PyArena *arena);
type_param_ty _PyAST_TypeVar(identifier name, expr_ty bound, expr_ty
                             default_value, int lineno, int col_offset, int
                             end_lineno, int end_col_offset, PyArena *arena);
type_param_ty _PyAST_ParamSpec(identifier name, expr_ty default_value, int
                               lineno, int col_offset, int end_lineno, int
                               end_col_offset, PyArena *arena);
type_param_ty _PyAST_TypeVarTuple(identifier name, expr_ty default_value, int
                                  lineno, int col_offset, int end_lineno, int
                                  end_col_offset, PyArena *arena);


PyObject* PyAST_mod2obj(mod_ty t);
mod_ty PyAST_obj2mod(PyObject* ast, PyArena* arena, int mode);
int PyAST_Check(PyObject* obj);

extern int _PyAST_Validate(mod_ty);

/* _PyAST_ExprAsUnicode is defined in ast_unparse.c */
extern PyObject* _PyAST_ExprAsUnicode(expr_ty);

/* Return the borrowed reference to the first literal string in the
   sequence of statements or NULL if it doesn't start from a literal string.
   Doesn't set exception. */
extern PyObject* _PyAST_GetDocString(asdl_stmt_seq *);

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_AST_H */
PK       ! 't	  t	  "  python3.13/internal/pycore_llist.hnu [        // A doubly-linked list that can be embedded in a struct.
//
// Usage:
//  struct llist_node head = LLIST_INIT(head);
//  typedef struct {
//      ...
//      struct llist_node node;
//      ...
//  } MyObj;
//
//  llist_insert_tail(&head, &obj->node);
//  llist_remove(&obj->node);
//
//  struct llist_node *node;
//  llist_for_each(node, &head) {
//      MyObj *obj = llist_data(node, MyObj, node);
//      ...
//  }
//

#ifndef Py_INTERNAL_LLIST_H
#define Py_INTERNAL_LLIST_H

#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "Py_BUILD_CORE must be defined to include this header"
#endif

struct llist_node {
    struct llist_node *next;
    struct llist_node *prev;
};

// Get the struct containing a node.
#define llist_data(node, type, member) (_Py_CONTAINER_OF(node, type, member))

// Iterate over a list.
#define llist_for_each(node, head) \
    for (node = (head)->next; node != (head); node = node->next)

// Iterate over a list, but allow removal of the current node.
#define llist_for_each_safe(node, head) \
    for (struct llist_node *_next = (node = (head)->next, node->next); \
         node != (head); node = _next, _next = node->next)

#define LLIST_INIT(head) { &head, &head }

static inline void
llist_init(struct llist_node *head)
{
    head->next = head;
    head->prev = head;
}

// Returns 1 if the list is empty, 0 otherwise.
static inline int
llist_empty(struct llist_node *head)
{
    return head->next == head;
}

// Appends to the tail of the list.
static inline void
llist_insert_tail(struct llist_node *head, struct llist_node *node)
{
    node->prev = head->prev;
    node->next = head;
    head->prev->next = node;
    head->prev = node;
}

// Remove a node from the list.
static inline void
llist_remove(struct llist_node *node)
{
    struct llist_node *prev = node->prev;
    struct llist_node *next = node->next;
    prev->next = next;
    next->prev = prev;
    node->prev = NULL;
    node->next = NULL;
}

// Append all nodes from head2 onto head1. head2 is left empty.
static inline void
llist_concat(struct llist_node *head1, struct llist_node *head2)
{
    if (!llist_empty(head2)) {
        head1->prev->next = head2->next;
        head2->next->prev = head1->prev;

        head1->prev = head2->prev;
        head2->prev->next = head1;
        llist_init(head2);
    }
}

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_LLIST_H */
PK       !  P	  P	  )  python3.13/internal/pycore_object_stack.hnu [        #ifndef Py_INTERNAL_OBJECT_STACK_H
#define Py_INTERNAL_OBJECT_STACK_H

#include "pycore_freelist.h"        // _PyFreeListState

#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

// _PyObjectStack is a stack of Python objects implemented as a linked list of
// fixed size buffers.

// Chosen so that _PyObjectStackChunk is a power-of-two size.
#define _Py_OBJECT_STACK_CHUNK_SIZE 254

typedef struct _PyObjectStackChunk {
    struct _PyObjectStackChunk *prev;
    Py_ssize_t n;
    PyObject *objs[_Py_OBJECT_STACK_CHUNK_SIZE];
} _PyObjectStackChunk;

typedef struct _PyObjectStack {
    _PyObjectStackChunk *head;
} _PyObjectStack;


extern _PyObjectStackChunk *
_PyObjectStackChunk_New(void);

extern void
_PyObjectStackChunk_Free(_PyObjectStackChunk *);

// Push an item onto the stack. Return -1 on allocation failure, 0 on success.
static inline int
_PyObjectStack_Push(_PyObjectStack *stack, PyObject *obj)
{
    _PyObjectStackChunk *buf = stack->head;
    if (buf == NULL || buf->n == _Py_OBJECT_STACK_CHUNK_SIZE) {
        buf = _PyObjectStackChunk_New();
        if (buf == NULL) {
            return -1;
        }
        buf->prev = stack->head;
        buf->n = 0;
        stack->head = buf;
    }

    assert(buf->n >= 0 && buf->n < _Py_OBJECT_STACK_CHUNK_SIZE);
    buf->objs[buf->n] = obj;
    buf->n++;
    return 0;
}

// Pop the top item from the stack.  Return NULL if the stack is empty.
static inline PyObject *
_PyObjectStack_Pop(_PyObjectStack *stack)
{
    _PyObjectStackChunk *buf = stack->head;
    if (buf == NULL) {
        return NULL;
    }
    assert(buf->n > 0 && buf->n <= _Py_OBJECT_STACK_CHUNK_SIZE);
    buf->n--;
    PyObject *obj = buf->objs[buf->n];
    if (buf->n == 0) {
        stack->head = buf->prev;
        _PyObjectStackChunk_Free(buf);
    }
    return obj;
}

static inline Py_ssize_t
_PyObjectStack_Size(_PyObjectStack *stack)
{
    Py_ssize_t size = 0;
    for (_PyObjectStackChunk *buf = stack->head; buf != NULL; buf = buf->prev) {
        size += buf->n;
    }
    return size;
}

// Merge src into dst, leaving src empty
extern void
_PyObjectStack_Merge(_PyObjectStack *dst, _PyObjectStack *src);

// Remove all items from the stack
extern void
_PyObjectStack_Clear(_PyObjectStack *stack);

#ifdef __cplusplus
}
#endif
#endif  // !Py_INTERNAL_OBJECT_STACK_H
PK       ! t~6q  q  (  python3.13/internal/pycore_pylifecycle.hnu [        #ifndef Py_INTERNAL_LIFECYCLE_H
#define Py_INTERNAL_LIFECYCLE_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

#include "pycore_runtime.h"       // _PyRuntimeState

/* Forward declarations */
struct _PyArgv;
struct pyruntimestate;

extern int _Py_SetFileSystemEncoding(
    const char *encoding,
    const char *errors);
extern void _Py_ClearFileSystemEncoding(void);
extern PyStatus _PyUnicode_InitEncodings(PyThreadState *tstate);
#ifdef MS_WINDOWS
extern int _PyUnicode_EnableLegacyWindowsFSEncoding(void);
#endif

extern int _Py_IsLocaleCoercionTarget(const char *ctype_loc);

/* Various one-time initializers */

extern void _Py_InitVersion(void);
extern PyStatus _PyFaulthandler_Init(int enable);
extern PyObject * _PyBuiltin_Init(PyInterpreterState *interp);
extern PyStatus _PySys_Create(
    PyThreadState *tstate,
    PyObject **sysmod_p);
extern PyStatus _PySys_ReadPreinitWarnOptions(PyWideStringList *options);
extern PyStatus _PySys_ReadPreinitXOptions(PyConfig *config);
extern int _PySys_UpdateConfig(PyThreadState *tstate);
extern void _PySys_FiniTypes(PyInterpreterState *interp);
extern int _PyBuiltins_AddExceptions(PyObject * bltinmod);
extern PyStatus _Py_HashRandomization_Init(const PyConfig *);

extern PyStatus _PyGC_Init(PyInterpreterState *interp);
extern PyStatus _PyAtExit_Init(PyInterpreterState *interp);

/* Various internal finalizers */

extern int _PySignal_Init(int install_signal_handlers);
extern void _PySignal_Fini(void);

extern void _PyGC_Fini(PyInterpreterState *interp);
extern void _Py_HashRandomization_Fini(void);
extern void _PyFaulthandler_Fini(void);
extern void _PyHash_Fini(void);
extern void _PyTraceMalloc_Fini(void);
extern void _PyWarnings_Fini(PyInterpreterState *interp);
extern void _PyAST_Fini(PyInterpreterState *interp);
extern void _PyAtExit_Fini(PyInterpreterState *interp);
extern void _PyThread_FiniType(PyInterpreterState *interp);
extern void _PyArg_Fini(void);
extern void _Py_FinalizeAllocatedBlocks(_PyRuntimeState *);

extern PyStatus _PyGILState_Init(PyInterpreterState *interp);
extern void _PyGILState_SetTstate(PyThreadState *tstate);
extern void _PyGILState_Fini(PyInterpreterState *interp);

extern void _PyGC_DumpShutdownStats(PyInterpreterState *interp);

extern PyStatus _Py_PreInitializeFromPyArgv(
    const PyPreConfig *src_config,
    const struct _PyArgv *args);
extern PyStatus _Py_PreInitializeFromConfig(
    const PyConfig *config,
    const struct _PyArgv *args);

extern wchar_t * _Py_GetStdlibDir(void);

extern int _Py_HandleSystemExit(int *exitcode_p);

extern PyObject* _PyErr_WriteUnraisableDefaultHook(PyObject *unraisable);

extern void _PyErr_Print(PyThreadState *tstate);
extern void _PyErr_Display(PyObject *file, PyObject *exception,
                                PyObject *value, PyObject *tb);
extern void _PyErr_DisplayException(PyObject *file, PyObject *exc);

exter