_acquire(const uint64_t *obj)
{
    _Py_USING_STD;
    return atomic_load_explicit((const _Atomic(uint64_t)*)obj,
                                memory_order_acquire);
}

static inline uint32_t
_Py_atomic_load_uint32_acquire(const uint32_t *obj)
{
    _Py_USING_STD;
    return atomic_load_explicit((const _Atomic(uint32_t)*)obj,
                                memory_order_acquire);
}

static inline Py_ssize_t
_Py_atomic_load_ssize_acquire(const Py_ssize_t *obj)
{
    _Py_USING_STD;
    return atomic_load_explicit((const _Atomic(Py_ssize_t)*)obj,
                                memory_order_acquire);
}


// --- _Py_atomic_fence ------------------------------------------------------

 static inline void
_Py_atomic_fence_seq_cst(void)
{
    _Py_USING_STD;
    atomic_thread_fence(memory_order_seq_cst);
}

 static inline void
_Py_atomic_fence_acquire(void)
{
    _Py_USING_STD;
    atomic_thread_fence(memory_order_acquire);
}

 static inline void
_Py_atomic_fence_release(void)
{
    _Py_USING_STD;
    atomic_thread_fence(memory_order_release);
}
PK       !        python3.13/cpython/frameobject.hnu [        /* Frame object interface */

#ifndef Py_CPYTHON_FRAMEOBJECT_H
#  error "this header file must not be included directly"
#endif

/* Standard object interface */

PyAPI_FUNC(PyFrameObject *) PyFrame_New(PyThreadState *, PyCodeObject *,
                                        PyObject *, PyObject *);

/* The rest of the interface is specific for frame objects */

/* Conversions between "fast locals" and locals in dictionary */

PyAPI_FUNC(void) PyFrame_LocalsToFast(PyFrameObject *, int);

/* -- Caveat emptor --
 * The concept of entry frames is an implementation detail of the CPython
 * in