es_InitTypes(PyInterpreterState *);


/* Substring Search.

   Returns the index of the first occurrence of
   a substring ("needle") in a larger text ("haystack").
   If the needle is not found, return -1.
   If the needle is found, add offset to the index.
*/

PyAPI_FUNC(Py_ssize_t)
_PyBytes_Find(const char *haystack, Py_ssize_t len_haystack,
              const char *needle, Py_ssize_t len_needle,
              Py_ssize_t offset);

/* Same as above, but search right-to-left */
PyAPI_FUNC(Py_ssize_t)
_PyBytes_ReverseFind(const char *haystack, Py_ssize_t len_haystack,
                     const char *needle, Py_ssize_t len_needle,
                     Py_ssize_t offset);


/** Helper function to implement the repeat and inplace repeat methods on a buffer
 *
 * len_dest is assumed to be an integer multiple of len_src.
 * If src equals dest, then assume the operation is inplace.
 *
 * This method repeately doubles the number of bytes copied to reduce
 * the number of invocations of memcpy.
 */
PyAPI_FUNC(void)
_PyBytes_Repeat(char* dest, Py_ssize_t len_dest,
    const char* src, Py_ssize_t len_src);

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_BYTESOBJECT_H */
PK       ! 9#br  r     python3.11/internal/pycore_ast.hnu [        // File automatically generated by Parser/asdl_c.py.

#ifndef Py_INTERNAL_AST_H
#define Py_INTERNAL_AST_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

#include "pycore_asdl.h"

typedef struct _mod *mod_ty;

typedef struct _stmt *stmt_ty;

typedef struct _expr *expr_ty;

typedef enum _expr_context { Load=1, Store=2, Del=3 } expr_context_ty;

typedef enum _boolop { And=1, Or=2 } boolop_ty;

typedef enum _operator { Add=1, Sub=2, Mult=3, MatMult=4, Div=5, Mod=6, Pow=7,
                         LShift=8, RShift=9, BitOr=10, BitXor=11, BitAnd=12,
                         FloorDiv=13 } operator_ty;

typedef enum _unaryop { Invert=1, Not=2, UAdd=3, USub=4 } unaryop_ty;

typedef enum _cmpop { Eq=1, NotEq=2, Lt=3, LtE=4, Gt=5, GtE=6, Is=7, IsNot=8,
                      In=9, NotIn=10 } cmpop_ty;

typedef struct _comprehension *comprehension_ty;

typedef struct _excepthandler *excepthandler_ty;

typedef struct _arguments *arguments_ty;

typedef struct _arg *arg_ty;

typedef struct _keyword *keyword_ty;

typedef struct _alias *alias_ty;

typedef struct _withitem *withitem_ty;

typedef struct _match_case *match_case_ty;

typedef struct _pattern *pattern_ty;

typedef struct _type_ignore *type_ignore_ty;


typedef struct {
    _ASDL_SEQ_HEAD
    mod_ty typed_elements[1];
} asdl_mod_seq;

asdl_mod_seq *_Py_asdl_mod_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    stmt_ty typed_elements[1];
} asdl_stmt_seq;

asdl_stmt_seq *_Py_asdl_stmt_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    expr_ty typed_elements[1];
} asdl_expr_seq;

asdl_expr_seq *_Py_asdl_expr_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    comprehension_ty typed_elements[1];
} asdl_comprehension_seq;

asdl_comprehension_seq *_Py_asdl_comprehension_seq_new(Py_ssize_t size, PyArena
                                                       *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    excepthandler_ty typed_elements[1];
} asdl_excepthandler_seq;

asdl_excepthandler_seq *_Py_asdl_excepthandler_seq_new(Py_ssize_t size, PyArena
                                                       *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    arguments_ty typed_elements[1];
} asdl_arguments_seq;

asdl_arguments_seq *_Py_asdl_arguments_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    arg_ty typed_elements[1];
} asdl_arg_seq;

asdl_arg_seq *_Py_asdl_arg_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    keyword_ty typed_elements[1];
} asdl_keyword_seq;

asdl_keyword_seq *_Py_asdl_keyword_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    alias_ty typed_elements[1];
} asdl_alias_seq;

asdl_alias_seq *_Py_asdl_alias_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    withitem_ty typed_elements[1];
} asdl_withitem_seq;

asdl_withitem_seq *_Py_asdl_withitem_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    match_case_ty typed_elements[1];
} asdl_match_case_seq;

asdl_match_case_seq *_Py_asdl_match_case_seq_new(Py_ssize_t size, PyArena
                                                 *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    pattern_ty typed_elements[1];
} asdl_pattern_seq;

asdl_pattern_seq *_Py_asdl_pattern_seq_new(Py_ssize_t size, PyArena *arena);

typedef struct {
    _ASDL_SEQ_HEAD
    type_ignore_ty typed_elements[1];
} asdl_type_ignore_seq;

asdl_type_ignore_seq *_Py_asdl_type_ignore_seq_new(Py_ssize_t size, PyArena
                                                   *arena);


enum _mod_kind {Module_kind=1, Interactive_kind=2, Expression_kind=3,
                 FunctionType_kind=4};
struct _mod {
    enum _mod_kind kind;
    union {
        struct {
            asdl_stmt_seq *body;
            asdl_type_ignore_seq *type_ignores;
        } Module;

        struct {
            asdl_stmt_seq *body;
        } Interactive;

        struct {
            expr_ty body;
        } Expression;

        struct {
            asdl_expr_seq *argtypes;
            expr_ty returns;
        } FunctionType;

    } v;
};

enum _stmt_kind {FunctionDef_kind=1, AsyncFunctionDef_kind=2, ClassDef_kind=3,
                  Return_kind=4, Delete_kind=5, Assign_kind=6,
                  AugAssign_kind=7, AnnAssign_kind=8, For_kind=9,
                  AsyncFor_kind=10, While_kind=11, If_kind=12, With_kind=13,
                  AsyncWith_kind=14, Match_kind=15, Raise_kind=16, Try_kind=17,
                  TryStar_kind=18, Assert_kind=19, Import_kind=20,
                  ImportFrom_kind=21, Global_kind=22, Nonlocal_kind=23,
                  Expr_kind=24, Pass_kind=25, Break_kind=26, Continue_kind=27};
struct _stmt {
    enum _stmt_kind kind;
    union {
        struct {
            identifier name;
            arguments_ty args;
            asdl_stmt_seq *body;
            asdl_expr_seq *decorator_list;
            expr_ty returns;
            string type_comment;
        } FunctionDef;

        struct {
            identifier name;
            arguments_ty args;
            asdl_stmt_seq *body;
            asdl_expr_seq *decorator_list;
            expr_ty returns;
            string type_comment;
        } AsyncFunctionDef;

        struct {
            identifier name;
            asdl_expr_seq *bases;
            asdl_keyword_seq *keywords;
            asdl_stmt_seq *body;
            asdl_expr_seq *decorator_list;
        } ClassDef;

        struct {
            expr_ty value;
        } Return;

        struct {
            asdl_expr_seq *targets;
        } Delete;

        struct {
            asdl_expr_seq *targets;
            expr_ty value;
            string type_comment;
        } Assign;

        struct {
            expr_ty target;
            operator_ty op;
            expr_ty value;
        } AugAssign;

        struct {
            expr_ty target;
            expr_ty annotation;
            expr_ty value;
            int simple;
        } AnnAssign;

        struct {
            expr_ty target;
            expr_ty iter;
            asdl_stmt_seq *body;
            asdl_stmt_seq *orelse;
            string type_comment;
        } For;

        struct {
            expr_ty target;
            expr_ty iter;
            asdl_stmt_seq *body;
            asdl_stmt_seq *orelse;
            string type_comment;
        } AsyncFor;

        struct {
            expr_ty test;
            asdl_stmt_seq *body;
            asdl_stmt_seq *orelse;
        } While;

        struct {
            expr_ty test;
            asdl_stmt_seq *body;
            asdl_stmt_seq *orelse;
        } If;

        struct {
            asdl_withitem_seq *items;
            asdl_stmt_seq *body;
            string type_comment;
        } With;

        struct {
            asdl_withitem_seq *items;
            asdl_stmt_seq *body;
            string type_comment;
        } AsyncWith;

        struct {
            expr_ty subject;
            asdl_match_case_seq *cases;
        } Match;

        struct {
            expr_ty exc;
            expr_ty cause;
        } Raise;

        struct {
            asdl_stmt_seq *body;
            asdl_excepthandler_seq *handlers;
            asdl_stmt_seq *orelse;
            asdl_stmt_seq *finalbody;
        } Try;

        struct {
            asdl_stmt_seq *body;
            asdl_excepthandler_seq *handlers;
            asdl_stmt_seq *orelse;
            asdl_stmt_seq *finalbody;
        } TryStar;

        struct {
            expr_ty test;
            expr_ty msg;
        } Assert;

        struct {
            asdl_alias_seq *names;
        } Import;

        struct {
            identifier module;
            asdl_alias_seq *names;
            int level;
        } ImportFrom;

        struct {
            asdl_identifier_seq *names;
        } Global;

        struct {
            asdl_identifier_seq *names;
        } Nonlocal;

        struct {
            expr_ty value;
        } Expr;

    } v;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

enum _expr_kind {BoolOp_kind=1, NamedExpr_kind=2, BinOp_kind=3, UnaryOp_kind=4,
                  Lambda_kind=5, IfExp_kind=6, Dict_kind=7, Set_kind=8,
                  ListComp_kind=9, SetComp_kind=10, DictComp_kind=11,
                  GeneratorExp_kind=12, Await_kind=13, Yield_kind=14,
                  YieldFrom_kind=15, Compare_kind=16, Call_kind=17,
                  FormattedValue_kind=18, JoinedStr_kind=19, Constant_kind=20,
                  Attribute_kind=21, Subscript_kind=22, Starred_kind=23,
                  Name_kind=24, List_kind=25, Tuple_kind=26, Slice_kind=27};
struct _expr {
    enum _expr_kind kind;
    union {
        struct {
            boolop_ty op;
            asdl_expr_seq *values;
        } BoolOp;

        struct {
            expr_ty target;
            expr_ty value;
        } NamedExpr;

        struct {
            expr_ty left;
            operator_ty op;
            expr_ty right;
        } BinOp;

        struct {
            unaryop_ty op;
            expr_ty operand;
        } UnaryOp;

        struct {
            arguments_ty args;
            expr_ty body;
        } Lambda;

        struct {
            expr_ty test;
            expr_ty body;
            expr_ty orelse;
        } IfExp;

        struct {
            asdl_expr_seq *keys;
            asdl_expr_seq *values;
        } Dict;

        struct {
            asdl_expr_seq *elts;
        } Set;

        struct {
            expr_ty elt;
            asdl_comprehension_seq *generators;
        } ListComp;

        struct {
            expr_ty elt;
            asdl_comprehension_seq *generators;
        } SetComp;

        struct {
            expr_ty key;
            expr_ty value;
            asdl_comprehension_seq *generators;
        } DictComp;

        struct {
            expr_ty elt;
            asdl_comprehension_seq *generators;
        } GeneratorExp;

        struct {
            expr_ty value;
        } Await;

        struct {
            expr_ty value;
        } Yield;

        struct {
            expr_ty value;
        } YieldFrom;

        struct {
            expr_ty left;
            asdl_int_seq *ops;
            asdl_expr_seq *comparators;
        } Compare;

        struct {
            expr_ty func;
            asdl_expr_seq *args;
            asdl_keyword_seq *keywords;
        } Call;

        struct {
            expr_ty value;
            int conversion;
            expr_ty format_spec;
        } FormattedValue;

        struct {
            asdl_expr_seq *values;
        } JoinedStr;

        struct {
            constant value;
            string kind;
        } Constant;

        struct {
            expr_ty value;
            identifier attr;
            expr_context_ty ctx;
        } Attribute;

        struct {
            expr_ty value;
            expr_ty slice;
            expr_context_ty ctx;
        } Subscript;

        struct {
            expr_ty value;
            expr_context_ty ctx;
        } Starred;

        struct {
            identifier id;
            expr_context_ty ctx;
        } Name;

        struct {
            asdl_expr_seq *elts;
            expr_context_ty ctx;
        } List;

        struct {
            asdl_expr_seq *elts;
            expr_context_ty ctx;
        } Tuple;

        struct {
            expr_ty lower;
            expr_ty upper;
            expr_ty step;
        } Slice;

    } v;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

struct _comprehension {
    expr_ty target;
    expr_ty iter;
    asdl_expr_seq *ifs;
    int is_async;
};

enum _excepthandler_kind {ExceptHandler_kind=1};
struct _excepthandler {
    enum _excepthandler_kind kind;
    union {
        struct {
            expr_ty type;
            identifier name;
            asdl_stmt_seq *body;
        } ExceptHandler;

    } v;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

struct _arguments {
    asdl_arg_seq *posonlyargs;
    asdl_arg_seq *args;
    arg_ty vararg;
    asdl_arg_seq *kwonlyargs;
    asdl_expr_seq *kw_defaults;
    arg_ty kwarg;
    asdl_expr_seq *defaults;
};

struct _arg {
    identifier arg;
    expr_ty annotation;
    string type_comment;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

struct _keyword {
    identifier arg;
    expr_ty value;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

struct _alias {
    identifier name;
    identifier asname;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

struct _withitem {
    expr_ty context_expr;
    expr_ty optional_vars;
};

struct _match_case {
    pattern_ty pattern;
    expr_ty guard;
    asdl_stmt_seq *body;
};

enum _pattern_kind {MatchValue_kind=1, MatchSingleton_kind=2,
                     MatchSequence_kind=3, MatchMapping_kind=4,
                     MatchClass_kind=5, MatchStar_kind=6, MatchAs_kind=7,
                     MatchOr_kind=8};
struct _pattern {
    enum _pattern_kind kind;
    union {
        struct {
            expr_ty value;
        } MatchValue;

        struct {
            constant value;
        } MatchSingleton;

        struct {
            asdl_pattern_seq *patterns;
        } MatchSequence;

        struct {
            asdl_expr_seq *keys;
            asdl_pattern_seq *patterns;
            identifier rest;
        } MatchMapping;

        struct {
            expr_ty cls;
            asdl_pattern_seq *patterns;
            asdl_identifier_seq *kwd_attrs;
            asdl_pattern_seq *kwd_patterns;
        } MatchClass;

        struct {
            identifier name;
        } MatchStar;

        struct {
            pattern_ty pattern;
            identifier name;
        } MatchAs;

        struct {
            asdl_pattern_seq *patterns;
        } MatchOr;

    } v;
    int lineno;
    int col_offset;
    int end_lineno;
    int end_col_offset;
};

enum _type_ignore_kind {TypeIgnore_kind=1};
struct _type_ignore {
    enum _type_ignore_kind kind;
    union {
        struct {
            int lineno;
            string tag;
        } TypeIgnore;

    } v;
};


// Note: these macros affect function definitions, not only call sites.
mod_ty _PyAST_Module(asdl_stmt_seq * body, asdl_type_ignore_seq * type_ignores,
                     PyArena *arena);
mod_ty _PyAST_Interactive(asdl_stmt_seq * body, PyArena *arena);
mod_ty _PyAST_Expression(expr_ty body, PyArena *arena);
mod_ty _PyAST_FunctionType(asdl_expr_seq * argtypes, expr_ty returns, PyArena
                           *arena);
stmt_ty _PyAST_FunctionDef(identifier name, arguments_ty args, asdl_stmt_seq *
                           body, asdl_expr_seq * decorator_list, expr_ty
                           returns, string type_comment, int lineno, int
                           col_offset, int end_lineno, int end_col_offset,
                           PyArena *arena);
stmt_ty _PyAST_AsyncFunctionDef(identifier name, arguments_ty args,
                                asdl_stmt_seq * body, asdl_expr_seq *
                                decorator_list, expr_ty returns, string
                                type_comment, int lineno, int col_offset, int
                                end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_ClassDef(identifier name, asdl_expr_seq * bases,
                        asdl_keyword_seq * keywords, asdl_stmt_seq * body,
                        asdl_expr_seq * decorator_list, int lineno, int
                        col_offset, int end_lineno, int end_col_offset, PyArena
                        *arena);
stmt_ty _PyAST_Return(expr_ty value, int lineno, int col_offset, int
                      end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Delete(asdl_expr_seq * targets, int lineno, int col_offset, int
                      end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Assign(asdl_expr_seq * targets, expr_ty value, string
                      type_comment, int lineno, int col_offset, int end_lineno,
                      int end_col_offset, PyArena *arena);
stmt_ty _PyAST_AugAssign(expr_ty target, operator_ty op, expr_ty value, int
                         lineno, int col_offset, int end_lineno, int
                         end_col_offset, PyArena *arena);
stmt_ty _PyAST_AnnAssign(expr_ty target, expr_ty annotation, expr_ty value, int
                         simple, int lineno, int col_offset, int end_lineno,
                         int end_col_offset, PyArena *arena);
stmt_ty _PyAST_For(expr_ty target, expr_ty iter, asdl_stmt_seq * body,
                   asdl_stmt_seq * orelse, string type_comment, int lineno, int
                   col_offset, int end_lineno, int end_col_offset, PyArena
                   *arena);
stmt_ty _PyAST_AsyncFor(expr_ty target, expr_ty iter, asdl_stmt_seq * body,
                        asdl_stmt_seq * orelse, string type_comment, int
                        lineno, int col_offset, int end_lineno, int
                        end_col_offset, PyArena *arena);
stmt_ty _PyAST_While(expr_ty test, asdl_stmt_seq * body, asdl_stmt_seq *
                     orelse, int lineno, int col_offset, int end_lineno, int
                     end_col_offset, PyArena *arena);
stmt_ty _PyAST_If(expr_ty test, asdl_stmt_seq * body, asdl_stmt_seq * orelse,
                  int lineno, int col_offset, int end_lineno, int
                  end_col_offset, PyArena *arena);
stmt_ty _PyAST_With(asdl_withitem_seq * items, asdl_stmt_seq * body, string
                    type_comment, int lineno, int col_offset, int end_lineno,
                    int end_col_offset, PyArena *arena);
stmt_ty _PyAST_AsyncWith(asdl_withitem_seq * items, asdl_stmt_seq * body,
                         string type_comment, int lineno, int col_offset, int
                         end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Match(expr_ty subject, asdl_match_case_seq * cases, int lineno,
                     int col_offset, int end_lineno, int end_col_offset,
                     PyArena *arena);
stmt_ty _PyAST_Raise(expr_ty exc, expr_ty cause, int lineno, int col_offset,
                     int end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Try(asdl_stmt_seq * body, asdl_excepthandler_seq * handlers,
                   asdl_stmt_seq * orelse, asdl_stmt_seq * finalbody, int
                   lineno, int col_offset, int end_lineno, int end_col_offset,
                   PyArena *arena);
stmt_ty _PyAST_TryStar(asdl_stmt_seq * body, asdl_excepthandler_seq * handlers,
                       asdl_stmt_seq * orelse, asdl_stmt_seq * finalbody, int
                       lineno, int col_offset, int end_lineno, int
                       end_col_offset, PyArena *arena);
stmt_ty _PyAST_Assert(expr_ty test, expr_ty msg, int lineno, int col_offset,
                      int end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Import(asdl_alias_seq * names, int lineno, int col_offset, int
                      end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_ImportFrom(identifier module, asdl_alias_seq * names, int level,
                          int lineno, int col_offset, int end_lineno, int
                          end_col_offset, PyArena *arena);
stmt_ty _PyAST_Global(asdl_identifier_seq * names, int lineno, int col_offset,
                      int end_lineno, int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Nonlocal(asdl_identifier_seq * names, int lineno, int
                        col_offset, int end_lineno, int end_col_offset, PyArena
                        *arena);
stmt_ty _PyAST_Expr(expr_ty value, int lineno, int col_offset, int end_lineno,
                    int end_col_offset, PyArena *arena);
stmt_ty _PyAST_Pass(int lineno, int col_offset, int end_lineno, int
                    end_col_offset, PyArena *arena);
stmt_ty _PyAST_Break(int lineno, int col_offset, int end_lineno, int
                     end_col_offset, PyArena *arena);
stmt_ty _PyAST_Continue(int lineno, int col_offset, int end_lineno, int
                        end_col_offset, PyArena *arena);
expr_ty _PyAST_BoolOp(boolop_ty op, asdl_expr_seq * values, int lineno, int
                      col_offset, int end_lineno, int end_col_offset, PyArena
                      *arena);
expr_ty _PyAST_NamedExpr(expr_ty target, expr_ty value, int lineno, int
                         col_offset, int end_lineno, int end_col_offset,
                         PyArena *arena);
expr_ty _PyAST_BinOp(expr_ty left, operator_ty op, expr_ty right, int lineno,
                     int col_offset, int end_lineno, int end_col_offset,
                     PyArena *arena);
expr_ty _PyAST_UnaryOp(unaryop_ty op, expr_ty operand, int lineno, int
                       col_offset, int end_lineno, int end_col_offset, PyArena
                       *arena);
expr_ty _PyAST_Lambda(arguments_ty args, expr_ty body, int lineno, int
                      col_offset, int end_lineno, int end_col_offset, PyArena
                      *arena);
expr_ty _PyAST_IfExp(expr_ty test, expr_ty body, expr_ty orelse, int lineno,
                     int col_offset, int end_lineno, int end_col_offset,
                     PyArena *arena);
expr_ty _PyAST_Dict(asdl_expr_seq * keys, asdl_expr_seq * values, int lineno,
                    int col_offset, int end_lineno, int end_col_offset, PyArena
                    *arena);
expr_ty _PyAST_Set(asdl_expr_seq * elts, int lineno, int col_offset, int
                   end_lineno, int end_col_offset, PyArena *arena);
expr_ty _PyAST_ListComp(expr_ty elt, asdl_comprehension_seq * generators, int
                        lineno, int col_offset, int end_lineno, int
                        end_col_offset, PyArena *arena);
expr_ty _PyAST_SetComp(expr_ty elt, asdl_comprehension_seq * generators, int
                       lineno, int col_offset, int end_lineno, int
                       end_col_offset, PyArena *arena);
expr_ty _PyAST_DictComp(expr_ty key, expr_ty value, asdl_comprehension_seq *
                        generators, int lineno, int col_offset, int end_lineno,
                        int end_col_offset, PyArena *arena);
expr_ty _PyAST_GeneratorExp(expr_ty elt, asdl_comprehension_seq * generators,
                            int lineno, int col_offset, int end_lineno, int
                            end_col_offset, PyArena *arena);
expr_ty _PyAST_Await(expr_ty value, int lineno, int col_offset, int end_lineno,
                     int end_col_offset, PyArena *arena);
expr_ty _PyAST_Yield(expr_ty value, int lineno, int col_offset, int end_lineno,
                     int end_col_offset, PyArena *arena);
expr_ty _PyAST_YieldFrom(expr_ty value, int lineno, int col_offset, int
                         end_lineno, int end_col_offset, PyArena *arena);
expr_ty _PyAST_Compare(expr_ty left, asdl_int_seq * ops, asdl_expr_seq *
                       comparators, int lineno, int col_offset, int end_lineno,
                       int end_col_offset, PyArena *arena);
expr_ty _PyAST_Call(expr_ty func, asdl_expr_seq * args, asdl_keyword_seq *
                    keywords, int lineno, int col_offset, int end_lineno, int
                    end_col_offset, PyArena *arena);
expr_ty _PyAST_FormattedValue(expr_ty value, int conversion, expr_ty
                              format_spec, int lineno, int col_offset, int
                              end_lineno, int end_col_offset, PyArena *arena);
expr_ty _PyAST_JoinedStr(asdl_expr_seq * values, int lineno, int col_offset,
                         int end_lineno, int end_col_offset, PyArena *arena);
expr_ty _PyAST_Constant(constant value, string kind, int lineno, int
                        col_offset, int end_lineno, int end_col_offset, PyArena
                        *arena);
expr_ty _PyAST_Attribute(expr_ty value, identifier attr, expr_context_ty ctx,
                         int lineno, int col_offset, int end_lineno, int
                         end_col_offset, PyArena *arena);
expr_ty _PyAST_Subscript(expr_ty value, expr_ty slice, expr_context_ty ctx, int
                         lineno, int col_offset, int end_lineno, int
                         end_col_offset, PyArena *arena);
expr_ty _PyAST_Starred(expr_ty value, expr_context_ty ctx, int lineno, int
                       col_offset, int end_lineno, int end_col_offset, PyArena
                       *arena);
expr_ty _PyAST_Name(identifier id, expr_context_ty ctx, int lineno, int
                    col_offset, int end_lineno, int end_col_offset, PyArena
                    *arena);
expr_ty _PyAST_List(asdl_expr_seq * elts, expr_context_ty ctx, int lineno, int
                    col_offset, int end_lineno, int end_col_offset, PyArena
                    *arena);
expr_ty _PyAST_Tuple(asdl_expr_seq * elts, expr_context_ty ctx, int lineno, int
                     col_offset, int end_lineno, int end_col_offset, PyArena
                     *arena);
expr_ty _PyAST_Slice(expr_ty lower, expr_ty upper, expr_ty step, int lineno,
                     int col_offset, int end_lineno, int end_col_offset,
                     PyArena *arena);
comprehension_ty _PyAST_comprehension(expr_ty target, expr_ty iter,
                                      asdl_expr_seq * ifs, int is_async,
                                      PyArena *arena);
excepthandler_ty _PyAST_ExceptHandler(expr_ty type, identifier name,
                                      asdl_stmt_seq * body, int lineno, int
                                      col_offset, int end_lineno, int
                                      end_col_offset, PyArena *arena);
arguments_ty _PyAST_arguments(asdl_arg_seq * posonlyargs, asdl_arg_seq * args,
                              arg_ty vararg, asdl_arg_seq * kwonlyargs,
                              asdl_expr_seq * kw_defaults, arg_ty kwarg,
                              asdl_expr_seq * defaults, PyArena *arena);
arg_ty _PyAST_arg(identifier arg, expr_ty annotation, string type_comment, int
                  lineno, int col_offset, int end_lineno, int end_col_offset,
                  PyArena *arena);
keyword_ty _PyAST_keyword(identifier arg, expr_ty value, int lineno, int
                          col_offset, int end_lineno, int end_col_offset,
                          PyArena *arena);
alias_ty _PyAST_alias(identifier name, identifier asname, int lineno, int
                      col_offset, int end_lineno, int end_col_offset, PyArena
                      *arena);
withitem_ty _PyAST_withitem(expr_ty context_expr, expr_ty optional_vars,
                            PyArena *arena);
match_case_ty _PyAST_match_case(pattern_ty pattern, expr_ty guard,
                                asdl_stmt_seq * body, PyArena *arena);
pattern_ty _PyAST_MatchValue(expr_ty value, int lineno, int col_offset, int
                             end_lineno, int end_col_offset, PyArena *arena);
pattern_ty _PyAST_MatchSingleton(constant value, int lineno, int col_offset,
                                 int end_lineno, int end_col_offset, PyArena
                                 *arena);
pattern_ty _PyAST_MatchSequence(asdl_pattern_seq * patterns, int lineno, int
                                col_offset, int end_lineno, int end_col_offset,
                                PyArena *arena);
pattern_ty _PyAST_MatchMapping(asdl_expr_seq * keys, asdl_pattern_seq *
                               patterns, identifier rest, int lineno, int
                               col_offset, int end_lineno, int end_col_offset,
                               PyArena *arena);
pattern_ty _PyAST_MatchClass(expr_ty cls, asdl_pattern_seq * patterns,
                             asdl_identifier_seq * kwd_attrs, asdl_pattern_seq
                             * kwd_patterns, int lineno, int col_offset, int
                             end_lineno, int end_col_offset, PyArena *arena);
pattern_ty _PyAST_MatchStar(identifier name, int lineno, int col_offset, int
                            end_lineno, int end_col_offset, PyArena *arena);
pattern_ty _PyAST_MatchAs(pattern_ty pattern, identifier name, int lineno, int
                          col_offset, int end_lineno, int end_col_offset,
                          PyArena *arena);
pattern_ty _PyAST_MatchOr(asdl_pattern_seq * patterns, int lineno, int
                          col_offset, int end_lineno, int end_col_offset,
                          PyArena *arena);
type_ignore_ty _PyAST_TypeIgnore(int lineno, string tag, PyArena *arena);


PyObject* PyAST_mod2obj(mod_ty t);
mod_ty PyAST_obj2mod(PyObject* ast, PyArena* arena, int mode);
int PyAST_Check(PyObject* obj);

extern int _PyAST_Validate(mod_ty);

/* _PyAST_ExprAsUnicode is defined in ast_unparse.c */
extern PyObject* _PyAST_ExprAsUnicode(expr_ty);

/* Return the borrowed reference to the first literal string in the
   sequence of statements or NULL if it doesn't start from a literal string.
   Doesn't set exception. */
extern PyObject* _PyAST_GetDocString(asdl_stmt_seq *);

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_AST_H */
PK       ! 0Q
  
  (  python3.11/internal/pycore_pylifecycle.hnu [        #ifndef Py_INTERNAL_LIFECYCLE_H
#define Py_INTERNAL_LIFECYCLE_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

#include "pycore_runtime.h"       // _PyRuntimeState

/* Forward declarations */
struct _PyArgv;
struct pyruntimestate;

/* True if the main interpreter thread exited due to an unhandled
 * KeyboardInterrupt exception, suggesting the user pressed ^C. */
PyAPI_DATA(int) _Py_UnhandledKeyboardInterrupt;

extern int _Py_SetFileSystemEncoding(
    const char *encoding,
    const char *errors);
extern void _Py_ClearFileSystemEncoding(void);
extern PyStatus _PyUnicode_InitEncodings(PyThreadState *tstate);
#ifdef MS_WINDOWS
extern int _PyUnicode_EnableLegacyWindowsFSEncoding(void);
#endif

PyAPI_FUNC(void) _Py_ClearStandardStreamEncoding(void);

PyAPI_FUNC(int) _Py_IsLocaleCoercionTarget(const char *ctype_loc);

/* Various one-time initializers */

extern PyStatus _PyFaulthandler_Init(int enable);
extern int _PyTraceMalloc_Init(int enable);
extern PyObject * _PyBuiltin_Init(PyInterpreterState *interp);
extern PyStatus _PySys_Create(
    PyThreadState *tstate,
    PyObject **sysmod_p);
extern PyStatus _PySys_ReadPreinitWarnOptions(PyWideStringList *options);
extern PyStatus _PySys_ReadPreinitXOptions(PyConfig *config);
extern int _PySys_UpdateConfig(PyThreadState *tstate);
extern void _PySys_Fini(PyInterpreterState *interp);
extern int _PyBuiltins_AddExceptions(PyObject * bltinmod);
extern PyStatus _Py_HashRandomization_Init(const PyConfig *);

extern PyStatus _PyImportZip_Init(PyThreadState *tstate);
extern PyStatus _PyGC_Init(PyInterpreterState *interp);
extern PyStatus _PyAtExit_Init(PyInterpreterState *interp);
extern int _Py_Deepfreeze_Init(void);

/* Various internal finalizers */

extern int _PySignal_Init(int install_signal_handlers);
extern void _PySignal_Fini(void);

extern void _PyImport_Fini(void);
extern void _PyImport_Fini2(void);
extern void _PyGC_Fini(PyInterpreterState *interp);
extern void _Py_HashRandomization_Fini(void);
extern void _PyFaulthandler_Fini(void);
extern void _PyHash_Fini(void);
extern void _PyTraceMalloc_Fini(void);
extern void _PyWarnings_Fini(PyInterpreterState *interp);
extern void _PyAST_Fini(PyInterpreterState *interp);
extern void _PyAtExit_Fini(PyInterpreterState *interp);
extern void _PyThread_FiniType(PyInterpreterState *interp);
extern void _Py_Deepfreeze_Fini(void);
extern void _PyArg_Fini(void);

extern PyStatus _PyGILState_Init(_PyRuntimeState *runtime);
extern PyStatus _PyGILState_SetTstate(PyThreadState *tstate);
extern void _PyGILState_Fini(PyInterpreterState *interp);

PyAPI_FUNC(void) _PyGC_DumpShutdownStats(PyInterpreterState *interp);

PyAPI_FUNC(PyStatus) _Py_PreInitializeFromPyArgv(
    const PyPreConfig *src_config,
    const struct _PyArgv *args);
PyAPI_FUNC(PyStatus) _Py_PreInitializeFromConfig(
    const PyConfig *config,
    const struct _PyArgv *args);

PyAPI_FUNC(wchar_t *) _Py_GetStdlibDir(void);

PyAPI_FUNC(int) _Py_HandleSystemExit(int *exitcode_p);

PyAPI_FUNC(PyObject*) _PyErr_WriteUnraisableDefaultHook(PyObject *unraisable);

PyAPI_FUNC(void) _PyErr_Print(PyThreadState *tstate);
PyAPI_FUNC(void) _PyErr_Display(PyObject *file, PyObject *exception,
                                PyObject *value, PyObject *tb);

PyAPI_FUNC(void) _PyThreadState_DeleteCurrent(PyThreadState *tstate);

extern void _PyAtExit_Call(PyInterpreterState *interp);

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_LIFECYCLE_H */
PK       ! !!    %  python3.11/internal/pycore_function.hnu [        #ifndef Py_INTERNAL_FUNCTION_H
#define Py_INTERNAL_FUNCTION_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

extern PyFunctionObject* _PyFunction_FromConstructor(PyFrameConstructor *constr);

extern uint32_t _PyFunction_GetVersionForCurrentState(PyFunctionObject *func);

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_FUNCTION_H */
PK       ! JD
  
  !  python3.11/internal/pycore_long.hnu [        #ifndef Py_INTERNAL_LONG_H
#define Py_INTERNAL_LONG_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

#include "pycore_global_objects.h"  // _PY_NSMALLNEGINTS
#include "pycore_runtime.h"       // _PyRuntime

/*
 * Default int base conversion size limitation: Denial of Service prevention.
 *
 * Chosen such that this isn't wildly slow on modern hardware and so that
 * everyone's existing deployed numpy test suite passes before
 * https://github.com/numpy/numpy/issues/22098 is widely available.
 *
 * $ python -m timeit -s 's = "1"*4300' 'int(s)'
 * 2000 loops, best of 5: 125 usec per loop
 * $ python -m timeit -s 's = "1"*4300; v = int(s)' 'str(v)'
 * 1000 loops, best of 5: 311 usec per loop
 * (zen2 cloud VM)
 *
 * 4300 decimal digits fits a ~14284 bit number.
 */
#define _PY_LONG_DEFAULT_MAX_STR_DIGITS 4300
/*
 * Threshold for max digits check.  For performance reasons int() and
 * int.__str__() don't checks values that are smaller than this
 * threshold.  Acts as a guaranteed minimum size limit for bignums that
 * applications can expect from CPython.
 *
 * % python -m timeit -s 's = "1"*640; v = int(s)' 'str(int(s))'
 * 20000 loops, best of 5: 12 usec per loop
 *
 * "640 digits should be enough for anyone." - gps
 * fits a ~2126 bit decimal number.
 */
#define _PY_LONG_MAX_STR_DIGITS_THRESHOLD 640

#if ((_PY_LONG_DEFAULT_MAX_STR_DIGITS != 0) && \
   (_PY_LONG_DEFAULT_MAX_STR_DIGITS < _PY_LONG_MAX_STR_DIGITS_THRESHOLD))
# error "_PY_LONG_DEFAULT_MAX_STR_DIGITS smaller than threshold."
#endif


/* runtime lifecycle */

extern PyStatus _PyLong_InitTypes(PyInterpreterState *);
extern void _PyLong_FiniTypes(PyInterpreterState *interp);


/* other API */

#define _PyLong_SMALL_INTS _Py_SINGLETON(small_ints)

// _PyLong_GetZero() and _PyLong_GetOne() must always be available
// _PyLong_FromUnsignedChar must always be available
#if _PY_NSMALLPOSINTS < 257
#  error "_PY_NSMALLPOSINTS must be greater than or equal to 257"
#endif

// Return a borrowed reference to the zero singleton.
// The function cannot return NULL.
static inline PyObject* _PyLong_GetZero(void)
{ return (PyObject *)&_PyLong_SMALL_INTS[_PY_NSMALLNEGINTS]; }

// Return a borrowed reference to the one singleton.
// The function cannot return NULL.
static inline PyObject* _PyLong_GetOne(void)
{ return (PyObject *)&_PyLong_SMALL_INTS[_PY_NSMALLNEGINTS+1]; }

static inline PyObject* _PyLong_FromUnsignedChar(unsigned char i)
{
    return Py_NewRef((PyObject *)&_PyLong_SMALL_INTS[_PY_NSMALLNEGINTS+i]);
}

PyObject *_PyLong_Add(PyLongObject *left, PyLongObject *right);
PyObject *_PyLong_Multiply(PyLongObject *left, PyLongObject *right);
PyObject *_PyLong_Subtract(PyLongObject *left, PyLongObject *right);

/* Used by Python/mystrtoul.c, _PyBytes_FromHex(),
   _PyBytes_DecodeEscape(), etc. */
PyAPI_DATA(unsigned char) _PyLong_DigitValue[256];

/* Format the object based on the format_spec, as defined in PEP 3101
   (Advanced String Formatting). */
PyAPI_FUNC(int) _PyLong_FormatAdvancedWriter(
    _PyUnicodeWriter *writer,
    PyObject *obj,
    PyObject *format_spec,
    Py_ssize_t start,
    Py_ssize_t end);

PyAPI_FUNC(int) _PyLong_FormatWriter(
    _PyUnicodeWriter *writer,
    PyObject *obj,
    int base,
    int alternate);

PyAPI_FUNC(char*) _PyLong_FormatBytesWriter(
    _PyBytesWriter *writer,
    char *str,
    PyObject *obj,
    int base,
    int alternate);

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_LONG_H */
PK       ! lsĿ  Ŀ  )  python3.11/internal/pycore_runtime_init.hnu [        #ifndef Py_INTERNAL_RUNTIME_INIT_H
#define Py_INTERNAL_RUNTIME_INIT_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

#include "pycore_object.h"


/* The static initializers defined here should only be used
   in the runtime init code (in pystate.c and pylifecycle.c). */


#define _PyRuntimeState_INIT \
    { \
        .gilstate = { \
            .check_enabled = 1, \
            /* A TSS key must be initialized with Py_tss_NEEDS_INIT \
               in accordance with the specification. */ \
            .autoTSSkey = Py_tss_NEEDS_INIT, \
        }, \
        .interpreters = { \
            /* This prevents interpreters from getting created \
              until _PyInterpreterState_Enable() is called. */ \
            .next_id = -1, \
        }, \
        .global_objects = _Py_global_objects_INIT, \
        ._main_interpreter = _PyInterpreterState_INIT, \
    }

#ifdef HAVE_DLOPEN
#  include <dlfcn.h>
#  if HAVE_DECL_RTLD_NOW
#    define _Py_DLOPEN_FLAGS RTLD_NOW
#  else
#    define _Py_DLOPEN_FLAGS RTLD_LAZY
#  endif
#  define DLOPENFLAGS_INIT .dlopenflags = _Py_DLOPEN_FLAGS,
#else
#  define _Py_DLOPEN_FLAGS 0
#  define DLOPENFLAGS_INIT
#endif

#define _PyInterpreterState_INIT \
    { \
        ._static = 1, \
        .id_refcount = -1, \
        DLOPENFLAGS_INIT \
        .ceval = { \
            .recursion_limit = Py_DEFAULT_RECURSION_LIMIT, \
        }, \
        .gc = { \
            .enabled = 1, \
            .generations = { \
                /* .head is set in _PyGC_InitState(). */ \
                { .threshold = 700, }, \
                { .threshold = 10, }, \
                { .threshold = 10, }, \
            }, \
        }, \
        ._initial_thread = _PyThreadState_INIT, \
    }

#define _PyThreadState_INIT \
    { \
        ._static = 1, \
        .recursion_limit = Py_DEFAULT_RECURSION_LIMIT, \
        .context_ver = 1, \
    }


// global objects

#define _PyLong_DIGIT_INIT(val) \
    { \
        _PyVarObject_IMMORTAL_INIT(&PyLong_Type, \
                                   ((val) == 0 ? 0 : ((val) > 0 ? 1 : -1))), \
        .ob_digit = { ((val) >= 0 ? (val) : -(val)) }, \
    }

#define _PyBytes_SIMPLE_INIT(CH, LEN) \
    { \
        _PyVarObject_IMMORTAL_INIT(&PyBytes_Type, LEN), \
        .ob_shash = -1, \
        .ob_sval = { CH }, \
    }
#define _PyBytes_CHAR_INIT(CH) \
    { \
        _PyBytes_SIMPLE_INIT(CH, 1) \
    }

#define _PyUnicode_ASCII_BASE_INIT(LITERAL, ASCII) \
    { \
        .ob_base = _PyObject_IMMORTAL_INIT(&PyUnicode_Type), \
        .length = sizeof(LITERAL) - 1, \
        .hash = -1, \
        .state = { \
            .kind = 1, \
            .compact = 1, \
            .ascii = ASCII, \
            .ready = 1, \
        }, \
    }
#define _PyASCIIObject_INIT(LITERAL) \
    { \
        ._ascii = _PyUnicode_ASCII_BASE_INIT(LITERAL, 1), \
        ._data = LITERAL \
    }
#define INIT_STR(NAME, LITERAL) \
    ._ ## NAME = _PyASCIIObject_INIT(LITERAL)
#define INIT_ID(NAME) \
    ._ ## NAME = _PyASCIIObject_INIT(#NAME)
#define _PyUnicode_LATIN1_INIT(LITERAL) \
    { \
        ._latin1 = { \
            ._base = _PyUnicode_ASCII_BASE_INIT(LITERAL, 0), \
        }, \
        ._data = LITERAL, \
    }

/* The following is auto-generated by Tools/scripts/generate_global_objects.py. */
#define _Py_global_objects_INIT { \
    .singletons = { \
        .small_ints = { \
            _PyLong_DIGIT_INIT(-5), \
            _PyLong_DIGIT_INIT(-4), \
            _PyLong_DIGIT_INIT(-3), \
            _PyLong_DIGIT_INIT(-2), \
            _PyLong_DIGIT_INIT(-1), \
            _PyLong_DIGIT_INIT(0), \
            _PyLong_DIGIT_INIT(1), \
            _PyLong_DIGIT_INIT(2), \
            _PyLong_DIGIT_INIT(3), \
            _PyLong_DIGIT_INIT(4), \
            _PyLong_DIGIT_INIT(5), \
            _PyLong_DIGIT_INIT(6), \
            _PyLong_DIGIT_INIT(7), \
            _PyLong_DIGIT_INIT(8), \
            _PyLong_DIGIT_INIT(9), \
            _PyLong_DIGIT_INIT(10), \
            _PyLong_DIGIT_INIT(11), \
            _PyLong_DIGIT_INIT(12), \
            _PyLong_DIGIT_INIT(13), \
            _PyLong_DIGIT_INIT(14), \
            _PyLong_DIGIT_INIT(15), \
            _PyLong_DIGIT_INIT(16), \
            _PyLong_DIGIT_INIT(17), \
            _PyLong_DIGIT_INIT(18), \
            _PyLong_DIGIT_INIT(19), \
            _PyLong_DIGIT_INIT(20), \
            _PyLong_DIGIT_INIT(21), \
            _PyLong_DIGIT_INIT(22), \
            _PyLong_DIGIT_INIT(23), \
            _PyLong_DIGIT_INIT(24), \
            _PyLong_DIGIT_INIT(25), \
            _PyLong_DIGIT_INIT(26), \
            _PyLong_DIGIT_INIT(27), \
            _PyLong_DIGIT_INIT(28), \
            _PyLong_DIGIT_INIT(29), \
            _PyLong_DIGIT_INIT(30), \
            _PyLong_DIGIT_INIT(31), \
            _PyLong_DIGIT_INIT(32), \
            _PyLong_DIGIT_INIT(33), \
            _PyLong_DIGIT_INIT(34), \
            _PyLong_DIGIT_INIT(35), \
            _PyLong_DIGIT_INIT(36), \
            _PyLong_DIGIT_INIT(37), \
            _PyLong_DIGIT_INIT(38), \
            _PyLong_DIGIT_INIT(39), \
            _PyLong_DIGIT_INIT(40), \
            _PyLong_DIGIT_INIT(41), \
            _PyLong_DIGIT_INIT(42), \
            _PyLong_DIGIT_INIT(43), \
            _PyLong_DIGIT_INIT(44), \
            _PyLong_DIGIT_INIT(45), \
            _PyLong_DIGIT_INIT(46), \
            _PyLong_DIGIT_INIT(47), \
            _PyLong_DIGIT_INIT(48), \
            _PyLong_DIGIT_INIT(49), \
            _PyLong_DIGIT_INIT(50), \
            _PyLong_DIGIT_INIT(51), \
            _PyLong_DIGIT_INIT(52), \
            _PyLong_DIGIT_INIT(53), \
            _PyLong_DIGIT_INIT(54), \
            _PyLong_DIGIT_INIT(55), \
            _PyLong_DIGIT_INIT(56), \
            _PyLong_DIGIT_INIT(57), \
            _PyLong_DIGIT_INIT(58), \
            _PyLong_DIGIT_INIT(59), \
            _PyLong_DIGIT_INIT(60), \
            _PyLong_DIGIT_INIT(61), \
            _PyLong_DIGIT_INIT(62), \
            _PyLong_DIGIT_INIT(63), \
            _PyLong_DIGIT_INIT(64), \
            _PyLong_DIGIT_INIT(65), \
            _PyLong_DIGIT_INIT(66), \
            _PyLong_DIGIT_INIT(67), \
            _PyLong_DIGIT_INIT(68), \
            _PyLong_DIGIT_INIT(69), \
            _PyLong_DIGIT_INIT(70), \
            _PyLong_DIGIT_INIT(71), \
            _PyLong_DIGIT_INIT(72), \
            _PyLong_DIGIT_INIT(73), \
            _PyLong_DIGIT_INIT(74), \
            _PyLong_DIGIT_INIT(75), \
            _PyLong_DIGIT_INIT(76), \
            _PyLong_DIGIT_INIT(77), \
            _PyLong_DIGIT_INIT(78), \
            _PyLong_DIGIT_INIT(79), \
            _PyLong_DIGIT_INIT(80), \
            _PyLong_DIGIT_INIT(81), \
            _PyLong_DIGIT_INIT(82), \
            _PyLong_DIGIT_INIT(83), \
            _PyLong_DIGIT_INIT(84), \
            _PyLong_DIGIT_INIT(85), \
            _PyLong_DIGIT_INIT(86), \
            _PyLong_DIGIT_INIT(87), \
            _PyLong_DIGIT_INIT(88), \
            _PyLong_DIGIT_INIT(89), \
            _PyLong_DIGIT_INIT(90), \
            _PyLong_DIGIT_INIT(91), \
            _PyLong_DIGIT_INIT(92), \
            _PyLong_DIGIT_INIT(93), \
            _PyLong_DIGIT_INIT(94), \
            _PyLong_DIGIT_INIT(95), \
            _PyLong_DIGIT_INIT(96), \
            _PyLong_DIGIT_INIT(97), \
            _PyLong_DIGIT_INIT(98), \
            _PyLong_DIGIT_INIT(99), \
            _PyLong_DIGIT_INIT(100), \
            _PyLong_DIGIT_INIT(101), \
            _PyLong_DIGIT_INIT(102), \
            _PyLong_DIGIT_INIT(103), \
            _PyLong_DIGIT_INIT(104), \
            _PyLong_DIGIT_INIT(105), \
            _PyLong_DIGIT_INIT(106), \
            _PyLong_DIGIT_INIT(107), \
            _PyLong_DIGIT_INIT(108), \
            _PyLong_DIGIT_INIT(109), \
            _PyLong_DIGIT_INIT(110), \
            _PyLong_DIGIT_INIT(111), \
            _PyLong_DIGIT_INIT(112), \
            _PyLong_DIGIT_INIT(113), \
            _PyLong_DIGIT_INIT(114), \
            _PyLong_DIGIT_INIT(115), \
            _PyLong_DIGIT_INIT(116), \
            _PyLong_DIGIT_INIT(117), \
            _PyLong_DIGIT_INIT(118), \
            _PyLong_DIGIT_INIT(119), \
            _PyLong_DIGIT_INIT(120), \
            _PyLong_DIGIT_INIT(121), \
            _PyLong_DIGIT_INIT(122), \
            _PyLong_DIGIT_INIT(123), \
            _PyLong_DIGIT_INIT(124), \
            _PyLong_DIGIT_INIT(125), \
            _PyLong_DIGIT_INIT(126), \
            _PyLong_DIGIT_INIT(127), \
            _PyLong_DIGIT_INIT(128), \
            _PyLong_DIGIT_INIT(129), \
            _PyLong_DIGIT_INIT(130), \
            _PyLong_DIGIT_INIT(131), \
            _PyLong_DIGIT_INIT(132), \
            _PyLong_DIGIT_INIT(133), \
            _PyLong_DIGIT_INIT(134), \
            _PyLong_DIGIT_INIT(135), \
            _PyLong_DIGIT_INIT(136), \
            _PyLong_DIGIT_INIT(137), \
            _PyLong_DIGIT_INIT(138), \
            _PyLong_DIGIT_INIT(139), \
            _PyLong_DIGIT_INIT(140), \
            _PyLong_DIGIT_INIT(141), \
            _PyLong_DIGIT_INIT(142), \
            _PyLong_DIGIT_INIT(143), \
            _PyLong_DIGIT_INIT(144), \
            _PyLong_DIGIT_INIT(145), \
            _PyLong_DIGIT_INIT(146), \
            _PyLong_DIGIT_INIT(147), \
            _PyLong_DIGIT_INIT(148), \
            _PyLong_DIGIT_INIT(149), \
            _PyLong_DIGIT_INIT(150), \
            _PyLong_DIGIT_INIT(151), \
            _PyLong_DIGIT_INIT(152), \
            _PyLong_DIGIT_INIT(153), \
            _PyLong_DIGIT_INIT(154), \
            _PyLong_DIGIT_INIT(155), \
            _PyLong_DIGIT_INIT(156), \
            _PyLong_DIGIT_INIT(157), \
            _PyLong_DIGIT_INIT(158), \
            _PyLong_DIGIT_INIT(159), \
            _PyLong_DIGIT_INIT(160), \
            _PyLong_DIGIT_INIT(161), \
            _PyLong_DIGIT_INIT(162), \
            _PyLong_DIGIT_INIT(163), \
            _PyLong_DIGIT_INIT(164), \
            _PyLong_DIGIT_INIT(165), \
            _PyLong_DIGIT_INIT(166), \
            _PyLong_DIGIT_INIT(167), \
            _PyLong_DIGIT_INIT(168), \
            _PyLong_DIGIT_INIT(169), \
            _PyLong_DIGIT_INIT(170), \
            _PyLong_DIGIT_INIT(171), \
            _PyLong_DIGIT_INIT(172), \
            _PyLong_DIGIT_INIT(173), \
            _PyLong_DIGIT_INIT(174), \
            _PyLong_DIGIT_INIT(175), \
            _PyLong_DIGIT_INIT(176), \
            _PyLong_DIGIT_INIT(177), \
            _PyLong_DIGIT_INIT(178), \
            _PyLong_DIGIT_INIT(179), \
            _PyLong_DIGIT_INIT(180), \
            _PyLong_DIGIT_INIT(181), \
            _PyLong_DIGIT_INIT(182), \
            _PyLong_DIGIT_INIT(183), \
            _PyLong_DIGIT_INIT(184), \
            _PyLong_DIGIT_INIT(185), \
            _PyLong_DIGIT_INIT(186), \
            _PyLong_DIGIT_INIT(187), \
            _PyLong_DIGIT_INIT(188), \
            _PyLong_DIGIT_INIT(189), \
            _PyLong_DIGIT_INIT(190), \
            _PyLong_DIGIT_INIT(191), \
            _PyLong_DIGIT_INIT(192), \
            _PyLong_DIGIT_INIT(193), \
            _PyLong_DIGIT_INIT(194), \
            _PyLong_DIGIT_INIT(195), \
            _PyLong_DIGIT_INIT(196), \
            _PyLong_DIGIT_INIT(197), \
            _PyLong_DIGIT_INIT(198), \
            _PyLong_DIGIT_INIT(199), \
            _PyLong_DIGIT_INIT(200), \
            _PyLong_DIGIT_INIT(201), \
            _PyLong_DIGIT_INIT(202), \
            _PyLong_DIGIT_INIT(203), \
            _PyLong_DIGIT_INIT(204), \
            _PyLong_DIGIT_INIT(205), \
            _PyLong_DIGIT_INIT(206), \
            _PyLong_DIGIT_INIT(207), \
            _PyLong_DIGIT_INIT(208), \
            _PyLong_DIGIT_INIT(209), \
            _PyLong_DIGIT_INIT(210), \
            _PyLong_DIGIT_INIT(211), \
            _PyLong_DIGIT_INIT(212), \
            _PyLong_DIGIT_INIT(213), \
            _PyLong_DIGIT_INIT(214), \
            _PyLong_DIGIT_INIT(215), \
            _PyLong_DIGIT_INIT(216), \
            _PyLong_DIGIT_INIT(217), \
            _PyLong_DIGIT_INIT(218), \
            _PyLong_DIGIT_INIT(219), \
            _PyLong_DIGIT_INIT(220), \
            _PyLong_DIGIT_INIT(221), \
            _PyLong_DIGIT_INIT(222), \
            _PyLong_DIGIT_INIT(223), \
            _PyLong_DIGIT_INIT(224), \
            _PyLong_DIGIT_INIT(225), \
            _PyLong_DIGIT_INIT(226), \
            _PyLong_DIGIT_INIT(227), \
            _PyLong_DIGIT_INIT(228), \
            _PyLong_DIGIT_INIT(229), \
            _PyLong_DIGIT_INIT(230), \
            _PyLong_DIGIT_INIT(231), \
            _PyLong_DIGIT_INIT(232), \
            _PyLong_DIGIT_INIT(233), \
            _PyLong_DIGIT_INIT(234), \
            _PyLong_DIGIT_INIT(235), \
            _PyLong_DIGIT_INIT(236), \
            _PyLong_DIGIT_INIT(237), \
            _PyLong_DIGIT_INIT(238), \
            _PyLong_DIGIT_INIT(239), \
            _PyLong_DIGIT_INIT(240), \
            _PyLong_DIGIT_INIT(241), \
            _PyLong_DIGIT_INIT(242), \
            _PyLong_DIGIT_INIT(243), \
            _PyLong_DIGIT_INIT(244), \
            _PyLong_DIGIT_INIT(245), \
            _PyLong_DIGIT_INIT(246), \
            _PyLong_DIGIT_INIT(247), \
            _PyLong_DIGIT_INIT(248), \
            _PyLong_DIGIT_INIT(249), \
            _PyLong_DIGIT_INIT(250), \
            _PyLong_DIGIT_INIT(251), \
            _PyLong_DIGIT_INIT(252), \
            _PyLong_DIGIT_INIT(253), \
            _PyLong_DIGIT_INIT(254), \
            _PyLong_DIGIT_INIT(255), \
            _PyLong_DIGIT_INIT(256), \
        }, \
        \
        .bytes_empty = _PyBytes_SIMPLE_INIT(0, 0), \
        .bytes_characters = { \
            _PyBytes_CHAR_INIT(0), \
            _PyBytes_CHAR_INIT(1), \
            _PyBytes_CHAR_INIT(2), \
            _PyBytes_CHAR_INIT(3), \
            _PyBytes_CHAR_INIT(4), \
            _PyBytes_CHAR_INIT(5), \
            _PyBytes_CHAR_INIT(6), \
            _PyBytes_CHAR_INIT(7), \
            _PyBytes_CHAR_INIT(8), \
            _PyBytes_CHAR_INIT(9), \
            _PyBytes_CHAR_INIT(10), \
            _PyBytes_CHAR_INIT(11), \
            _PyBytes_CHAR_INIT(12), \
            _PyBytes_CHAR_INIT(13), \
            _PyBytes_CHAR_INIT(14), \
            _PyBytes_CHAR_INIT(15), \
            _PyBytes_CHAR_INIT(16), \
            _PyBytes_CHAR_INIT(17), \
            _PyBytes_CHAR_INIT(18), \
            _PyBytes_CHAR_INIT(19), \
            _PyBytes_CHAR_INIT(20), \
            _PyBytes_CHAR_INIT(21), \
            _PyBytes_CHAR_INIT(22), \
            _PyBytes_CHAR_INIT(23), \
            _PyBytes_CHAR_INIT(24), \
            _PyBytes_CHAR_INIT(25), \
            _PyBytes_CHAR_INIT(26), \
            _PyBytes_CHAR_INIT(27), \
            _PyBytes_CHAR_INIT(28), \
            _PyBytes_CHAR_INIT(29), \
            _PyBytes_CHAR_INIT(30), \
            _PyBytes_CHAR_INIT(31), \
            _PyBytes_CHAR_INIT(32), \
            _PyBytes_CHAR_INIT(33), \
            _PyBytes_CHAR_INIT(34), \
            _PyBytes_CHAR_INIT(35), \
            _PyBytes_CHAR_INIT(36), \
            _PyBytes_CHAR_INIT(37), \
            _PyBytes_CHAR_INIT(38), \
            _PyBytes_CHAR_INIT(39), \
            _PyBytes_CHAR_INIT(40), \
            _PyBytes_CHAR_INIT(41), \
            _PyBytes_CHAR_INIT(42), \
            _PyBytes_CHAR_INIT(43), \
            _PyBytes_CHAR_INIT(44), \
            _PyBytes_CHAR_INIT(45), \
            _PyBytes_CHAR_INIT(46), \
            _PyBytes_CHAR_INIT(47), \
            _PyBytes_CHAR_INIT(48), \
            _PyBytes_CHAR_INIT(49), \
            _PyBytes_CHAR_INIT(50), \
            _PyBytes_CHAR_INIT(51), \
            _PyBytes_CHAR_INIT(52), \
            _PyBytes_CHAR_INIT(53), \
            _PyBytes_CHAR_INIT(54), \
            _PyBytes_CHAR_INIT(55), \
            _PyBytes_CHAR_INIT(56), \
            _PyBytes_CHAR_INIT(57), \
            _PyBytes_CHAR_INIT(58), \
            _PyBytes_CHAR_INIT(59), \
            _PyBytes_CHAR_INIT(60), \
            _PyBytes_CHAR_INIT(61), \
            _PyBytes_CHAR_INIT(62), \
            _PyBytes_CHAR_INIT(63), \
            _PyBytes_CHAR_INIT(64), \
            _PyBytes_CHAR_INIT(65), \
            _PyBytes_CHAR_INIT(66), \
            _PyBytes_CHAR_INIT(67), \
            _PyBytes_CHAR_INIT(68), \
            _PyBytes_CHAR_INIT(69), \
            _PyBytes_CHAR_INIT(70), \
            _PyBytes_CHAR_INIT(71), \
            _PyBytes_CHAR_INIT(72), \
            _PyBytes_CHAR_INIT(73), \
            _PyBytes_CHAR_INIT(74), \
            _PyBytes_CHAR_INIT(75), \
            _PyBytes_CHAR_INIT(76), \
            _PyBytes_CHAR_INIT(77), \
            _PyBytes_CHAR_INIT(78), \
            _PyBytes_CHAR_INIT(79), \
            _PyBytes_CHAR_INIT(80), \
            _PyBytes_CHAR_INIT(81), \
            _PyBytes_CHAR_INIT(82), \
            _PyBytes_CHAR_INIT(83), \
            _PyBytes_CHAR_INIT(84), \
            _PyBytes_CHAR_INIT(85), \
            _PyBytes_CHAR_INIT(86), \
            _PyBytes_CHAR_INIT(87), \
            _PyBytes_CHAR_INIT(88), \
            _PyBytes_CHAR_INIT(89), \
            _PyBytes_CHAR_INIT(90), \
            _PyBytes_CHAR_INIT(91), \
            _PyBytes_CHAR_INIT(92), \
            _PyBytes_CHAR_INIT(93), \
            _PyBytes_CHAR_INIT(94), \
            _PyBytes_CHAR_INIT(95), \
            _PyBytes_CHAR_INIT(96), \
            _PyBytes_CHAR_INIT(97), \
            _PyBytes_CHAR_INIT(98), \
            _PyBytes_CHAR_INIT(99), \
            _PyBytes_CHAR_INIT(100), \
            _PyBytes_CHAR_INIT(101), \
            _PyBytes_CHAR_INIT(102), \
            _PyBytes_CHAR_INIT(103), \
            _PyBytes_CHAR_INIT(104), \
            _PyBytes_CHAR_INIT(105), \
            _PyBytes_CHAR_INIT(106), \
            _PyBytes_CHAR_INIT(107), \
            _PyBytes_CHAR_INIT(108), \
            _PyBytes_CHAR_INIT(109), \
            _PyBytes_CHAR_INIT(110), \
            _PyBytes_CHAR_INIT(111), \
            _PyBytes_CHAR_INIT(112), \
            _PyBytes_CHAR_INIT(113), \
            _PyBytes_CHAR_INIT(114), \
            _PyBytes_CHAR_INIT(115), \
            _PyBytes_CHAR_INIT(116), \
            _PyBytes_CHAR_INIT(117), \
            _PyBytes_CHAR_INIT(118), \
            _PyBytes_CHAR_INIT(119), \
            _PyBytes_CHAR_INIT(120), \
            _PyBytes_CHAR_INIT(121), \
            _PyBytes_CHAR_INIT(122), \
            _PyBytes_CHAR_INIT(123), \
            _PyBytes_CHAR_INIT(124), \
            _PyBytes_CHAR_INIT(125), \
            _PyBytes_CHAR_INIT(126), \
            _PyBytes_CHAR_INIT(127), \
            _PyBytes_CHAR_INIT(128), \
            _PyBytes_CHAR_INIT(129), \
            _PyBytes_CHAR_INIT(130), \
            _PyBytes_CHAR_INIT(131), \
            _PyBytes_CHAR_INIT(132), \
            _PyBytes_CHAR_INIT(133), \
            _PyBytes_CHAR_INIT(134), \
            _PyBytes_CHAR_INIT(135), \
            _PyBytes_CHAR_INIT(136), \
            _PyBytes_CHAR_INIT(137), \
            _PyBytes_CHAR_INIT(138), \
            _PyBytes_CHAR_INIT(139), \
            _PyBytes_CHAR_INIT(140), \
            _PyBytes_CHAR_INIT(141), \
            _PyBytes_CHAR_INIT(142), \
            _PyBytes_CHAR_INIT(143), \
            _PyBytes_CHAR_INIT(144), \
            _PyBytes_CHAR_INIT(145), \
            _PyBytes_CHAR_INIT(146), \
            _PyBytes_CHAR_INIT(147), \
            _PyBytes_CHAR_INIT(148), \
            _PyBytes_CHAR_INIT(149), \
            _PyBytes_CHAR_INIT(150), \
            _PyBytes_CHAR_INIT(151), \
            _PyBytes_CHAR_INIT(152), \
            _PyBytes_CHAR_INIT(153), \
            _PyBytes_CHAR_INIT(154), \
            _PyBytes_CHAR_INIT(155), \
            _PyBytes_CHAR_INIT(156), \
            _PyBytes_CHAR_INIT(157), \
            _PyBytes_CHAR_INIT(158), \
            _PyBytes_CHAR_INIT(159), \
            _PyBytes_CHAR_INIT(160), \
            _PyBytes_CHAR_INIT(161), \
            _PyBytes_CHAR_INIT(162), \
            _PyBytes_CHAR_INIT(163), \
            _PyBytes_CHAR_INIT(164), \
            _PyBytes_CHAR_INIT(165), \
            _PyBytes_CHAR_INIT(166), \
            _PyBytes_CHAR_INIT(167), \
            _PyBytes_CHAR_INIT(168), \
            _PyBytes_CHAR_INIT(169), \
            _PyBytes_CHAR_INIT(170), \
            _PyBytes_CHAR_INIT(171), \
            _PyBytes_CHAR_INIT(172), \
            _PyBytes_CHAR_INIT(173), \
            _PyBytes_CHAR_INIT(174), \
            _PyBytes_CHAR_INIT(175), \
            _PyBytes_CHAR_INIT(176), \
            _PyBytes_CHAR_INIT(177), \
            _PyBytes_CHAR_INIT(178), \
            _PyBytes_CHAR_INIT(179), \
            _PyBytes_CHAR_INIT(180), \
            _PyBytes_CHAR_INIT(181), \
            _PyBytes_CHAR_INIT(182), \
            _PyBytes_CHAR_INIT(183), \
            _PyBytes_CHAR_INIT(184), \
            _PyBytes_CHAR_INIT(185), \
            _PyBytes_CHAR_INIT(186), \
            _PyBytes_CHAR_INIT(187), \
            _PyBytes_CHAR_INIT(188), \
            _PyBytes_CHAR_INIT(189), \
            _PyBytes_CHAR_INIT(190), \
            _PyBytes_CHAR_INIT(191), \
            _PyBytes_CHAR_INIT(192), \
            _PyBytes_CHAR_INIT(193), \
            _PyBytes_CHAR_INIT(194), \
            _PyBytes_CHAR_INIT(195), \
            _PyBytes_CHAR_INIT(196), \
            _PyBytes_CHAR_INIT(197), \
            _PyBytes_CHAR_INIT(198), \
            _PyBytes_CHAR_INIT(199), \
            _PyBytes_CHAR_INIT(200), \
            _PyBytes_CHAR_INIT(201), \
            _PyBytes_CHAR_INIT(202), \
            _PyBytes_CHAR_INIT(203), \
            _PyBytes_CHAR_INIT(204), \
            _PyBytes_CHAR_INIT(205), \
            _PyBytes_CHAR_INIT(206), \
            _PyBytes_CHAR_INIT(207), \
            _PyBytes_CHAR_INIT(208), \
            _PyBytes_CHAR_INIT(209), \
            _PyBytes_CHAR_INIT(210), \
            _PyBytes_CHAR_INIT(211), \
            _PyBytes_CHAR_INIT(212), \
            _PyBytes_CHAR_INIT(213), \
            _PyBytes_CHAR_INIT(214), \
            _PyBytes_CHAR_INIT(215), \
            _PyBytes_CHAR_INIT(216), \
            _PyBytes_CHAR_INIT(217), \
            _PyBytes_CHAR_INIT(218), \
            _PyBytes_CHAR_INIT(219), \
            _PyBytes_CHAR_INIT(220), \
            _PyBytes_CHAR_INIT(221), \
            _PyBytes_CHAR_INIT(222), \
            _PyBytes_CHAR_INIT(223), \
            _PyBytes_CHAR_INIT(224), \
            _PyBytes_CHAR_INIT(225), \
            _PyBytes_CHAR_INIT(226), \
            _PyBytes_CHAR_INIT(227), \
            _PyBytes_CHAR_INIT(228), \
            _PyBytes_CHAR_INIT(229), \
            _PyBytes_CHAR_INIT(230), \
            _PyBytes_CHAR_INIT(231), \
            _PyBytes_CHAR_INIT(232), \
            _PyBytes_CHAR_INIT(233), \
            _PyBytes_CHAR_INIT(234), \
            _PyBytes_CHAR_INIT(235), \
            _PyBytes_CHAR_INIT(236), \
            _PyBytes_CHAR_INIT(237), \
            _PyBytes_CHAR_INIT(238), \
            _PyBytes_CHAR_INIT(239), \
            _PyBytes_CHAR_INIT(240), \
            _PyBytes_CHAR_INIT(241), \
            _PyBytes_CHAR_INIT(242), \
            _PyBytes_CHAR_INIT(243), \
            _PyBytes_CHAR_INIT(244), \
            _PyBytes_CHAR_INIT(245), \
            _PyBytes_CHAR_INIT(246), \
            _PyBytes_CHAR_INIT(247), \
            _PyBytes_CHAR_INIT(248), \
            _PyBytes_CHAR_INIT(249), \
            _PyBytes_CHAR_INIT(250), \
            _PyBytes_CHAR_INIT(251), \
            _PyBytes_CHAR_INIT(252), \
            _PyBytes_CHAR_INIT(253), \
            _PyBytes_CHAR_INIT(254), \
            _PyBytes_CHAR_INIT(255), \
        }, \
        \
        .strings = { \
            .literals = { \
                INIT_STR(anon_dictcomp, "<dictcomp>"), \
                INIT_STR(anon_genexpr, "<genexpr>"), \
                INIT_STR(anon_lambda, "<lambda>"), \
                INIT_STR(anon_listcomp, "<listcomp>"), \
                INIT_STR(anon_module, "<module>"), \
                INIT_STR(anon_setcomp, "<setcomp>"), \
                INIT_STR(anon_string, "<string>"), \
                INIT_STR(anon_unknown, "<unknown>"), \
                INIT_STR(close_br, "}"), \
                INIT_STR(comma_sep, ", "), \
                INIT_STR(dbl_close_br, "}}"), \
                INIT_STR(dbl_open_br, "{{"), \
                INIT_STR(dbl_percent, "%%"), \
                INIT_STR(dot, "."), \
                INIT_STR(dot_locals, ".<locals>"), \
                INIT_STR(empty, ""), \
                INIT_STR(list_err, "list index out of range"), \
                INIT_STR(newline, "\n"), \
                INIT_STR(open_br, "{"), \
                INIT_STR(percent, "%"), \
                INIT_STR(utf_8, "utf-8"), \
            }, \
            .identifiers = { \
                INIT_ID(False), \
                INIT_ID(Py_Repr), \
                INIT_ID(TextIOWrapper), \
                INIT_ID(True), \
                INIT_ID(WarningMessage), \
                INIT_ID(_), \
                INIT_ID(__IOBase_closed), \
                INIT_ID(__abc_tpflags__), \
                INIT_ID(__abs__), \
                INIT_ID(__abstractmethods__), \
                INIT_ID(__add__), \
                INIT_ID(__aenter__), \
                INIT_ID(__aexit__), \
                INIT_ID(__aiter__), \
                INIT_ID(__all__), \
                INIT_ID(__and__), \
                INIT_ID(__anext__), \
                INIT_ID(__annotations__), \
                INIT_ID(__args__), \
                INIT_ID(__await__), \
                INIT_ID(__bases__), \
                INIT_ID(__bool__), \
                INIT_ID(__build_class__), \
                INIT_ID(__builtins__), \
                INIT_ID(__bytes__), \
                INIT_ID(__call__), \
                INIT_ID(__cantrace__), \
                INIT_ID(__class__), \
                INIT_ID(__class_getitem__), \
                INIT_ID(__classcell__), \
                INIT_ID(__complex__), \
                INIT_ID(__contains__), \
                INIT_ID(__copy__), \
                INIT_ID(__del__), \
                INIT_ID(__delattr__), \
                INIT_ID(__delete__), \
                INIT_ID(__delitem__), \
                INIT_ID(__dict__), \
                INIT_ID(__dir__), \
                INIT_ID(__divmod__), \
                INIT_ID(__doc__), \
                INIT_ID(__enter__), \
                INIT_ID(__eq__), \
                INIT_ID(__exit__), \
                INIT_ID(__file__), \
                INIT_ID(__float__), \
                INIT_ID(__floordiv__), \
                INIT_ID(__format__), \
                INIT_ID(__fspath__), \
                INIT_ID(__ge__), \
                INIT_ID(__get__), \
                INIT_ID(__getattr__), \
                INIT_ID(__getattribute__), \
                INIT_ID(__getinitargs__), \
                INIT_ID(__getitem__), \
                INIT_ID(__getnewargs__), \
                INIT_ID(__getnewargs_ex__), \
                INIT_ID(__getstate__), \
                INIT_ID(__gt__), \
                INIT_ID(__hash__), \
                INIT_ID(__iadd__), \
                INIT_ID(__iand__), \
                INIT_ID(__ifloordiv__), \
                INIT_ID(__ilshift__), \
                INIT_ID(__imatmul__), \
                INIT_ID(__imod__), \
                INIT_ID(__import__), \
                INIT_ID(__imul__), \
                INIT_ID(__index__), \
                INIT_ID(__init__), \
                INIT_ID(__init_subclass__), \
                INIT_ID(__instancecheck__), \
                INIT_ID(__int__), \
                INIT_ID(__invert__), \
                INIT_ID(__ior__), \
                INIT_ID(__ipow__), \
                INIT_ID(__irshift__), \
                INIT_ID(__isabstractmethod__), \
                INIT_ID(__isub__), \
                INIT_ID(__iter__), \
                INIT_ID(__itruediv__), \
                INIT_ID(__ixor__), \
                INIT_ID(__le__), \
                INIT_ID(__len__), \
                INIT_ID(__length_hint__), \
                INIT_ID(__lltrace__), \
                INIT_ID(__loader__), \
                INIT_ID(__lshift__), \
                INIT_ID(__lt__), \
                INIT_ID(__main__), \
                INIT_ID(__matmul__), \
                INIT_ID(__missing__), \
                INIT_ID(__mod__), \
                INIT_ID(__module__), \
                INIT_ID(__mro_entries__), \
                INIT_ID(__mul__), \
                INIT_ID(__name__), \
                INIT_ID(__ne__), \
                INIT_ID(__neg__), \
                INIT_ID(__new__), \
                INIT_ID(__newobj__), \
                INIT_ID(__newobj_ex__), \
                INIT_ID(__next__), \
                INIT_ID(__notes__), \
                INIT_ID(__or__), \
                INIT_ID(__orig_class__), \
                INIT_ID(__origin__), \
                INIT_ID(__package__), \
                INIT_ID(__parameters__), \
                INIT_ID(__path__), \
                INIT_ID(__pos__), \
                INIT_ID(__pow__), \
                INIT_ID(__prepare__), \
                INIT_ID(__qualname__), \
                INIT_ID(__radd__), \
                INIT_ID(__rand__), \
                INIT_ID(__rdivmod__), \
                INIT_ID(__reduce__), \
                INIT_ID(__reduce_ex__), \
                INIT_ID(__repr__), \
                INIT_ID(__reversed__), \
                INIT_ID(__rfloordiv__), \
                INIT_ID(__rlshift__), \
                INIT_ID(__rmatmul__), \
                INIT_ID(__rmod__), \
                INIT_ID(__rmul__), \
                INIT_ID(__ror__), \
                INIT_ID(__round__), \
                INIT_ID(__rpow__), \
                INIT_ID(__rrshift__), \
                INIT_ID(__rshift__), \
                INIT_ID(__rsub__), \
                INIT_ID(__rtruediv__), \
                INIT_ID(__rxor__), \
                INIT_ID(__set__), \
                INIT_ID(__set_name__), \
                INIT_ID(__setattr__), \
                INIT_ID(__setitem__), \
                INIT_ID(__setstate__), \
                INIT_ID(__sizeof__), \
                INIT_ID(__slotnames__), \
                INIT_ID(__slots__), \
                INIT_ID(__spec__), \
                INIT_ID(__str__), \
                INIT_ID(__sub__), \
                INIT_ID(__subclasscheck__), \
                INIT_ID(__subclasshook__), \
                INIT_ID(__truediv__), \
                INIT_ID(__trunc__), \
                INIT_ID(__typing_is_unpacked_typevartuple__), \
                INIT_ID(__typing_prepare_subst__), \
                INIT_ID(__typing_subst__), \
                INIT_ID(__typing_unpacked_tuple_args__), \
                INIT_ID(__warningregistry__), \
                INIT_ID(__weakref__), \
                INIT_ID(__xor__), \
                INIT_ID(_abc_impl), \
                INIT_ID(_annotation), \
                INIT_ID(_blksize), \
                INIT_ID(_bootstrap), \
                INIT_ID(_dealloc_warn), \
                INIT_ID(_finalizing), \
                INIT_ID(_find_and_load), \
                INIT_ID(_fix_up_module), \
                INIT_ID(_get_sourcefile), \
                INIT_ID(_handle_fromlist), \
                INIT_ID(_initializing), \
                INIT_ID(_is_text_encoding), \
                INIT_ID(_lock_unlock_module), \
                INIT_ID(_showwarnmsg), \
                INIT_ID(_shutdown), \
                INIT_ID(_slotnames), \
                INIT_ID(_strptime_time), \
                INIT_ID(_uninitialized_submodules), \
                INIT_ID(_warn_unawaited_coroutine), \
                INIT_ID(_xoptions), \
                INIT_ID(add), \
                INIT_ID(append), \
                INIT_ID(big), \
                INIT_ID(buffer), \
                INIT_ID(builtins), \
                INIT_ID(c_call), \
                INIT_ID(c_exception), \
                INIT_ID(c_return), \
                INIT_ID(call), \
                INIT_ID(clear), \
                INIT_ID(close), \
                INIT_ID(closed), \
                INIT_ID(code), \
                INIT_ID(copy), \
                INIT_ID(copyreg), \
                INIT_ID(decode), \
                INIT_ID(default), \
                INIT_ID(defaultaction), \
                INIT_ID(dictcomp), \
                INIT_ID(difference_update), \
                INIT_ID(dispatch_table), \
                INIT_ID(displayhook), \
                INIT_ID(enable), \
                INIT_ID(encode), \
                INIT_ID(encoding), \
                INIT_ID(end_lineno), \
                INIT_ID(end_offset), \
                INIT_ID(errors), \
                INIT_ID(excepthook), \
                INIT_ID(exception), \
                INIT_ID(extend), \
                INIT_ID(filename), \
                INIT_ID(fileno), \
                INIT_ID(fillvalue), \
                INIT_ID(filters), \
                INIT_ID(find_class), \
                INIT_ID(flush), \
                INIT_ID(genexpr), \
                INIT_ID(get), \
                INIT_ID(get_source), \
                INIT_ID(getattr), \
                INIT_ID(getstate), \
                INIT_ID(ignore), \
                INIT_ID(importlib), \
                INIT_ID(inf), \
                INIT_ID(intersection), \
                INIT_ID(isatty), \
                INIT_ID(isinstance), \
                INIT_ID(items), \
                INIT_ID(iter), \
                INIT_ID(join), \
                INIT_ID(keys), \
                INIT_ID(lambda), \
                INIT_ID(last_traceback), \
                INIT_ID(last_type), \
                INIT_ID(last_value), \
                INIT_ID(latin1), \
                INIT_ID(len), \
                INIT_ID(line), \
                INIT_ID(lineno), \
                INIT_ID(listcomp), \
                INIT_ID(little), \
                INIT_ID(locale), \
                INIT_ID(match), \
                INIT_ID(metaclass), \
                INIT_ID(mode), \
                INIT_ID(modules), \
                INIT_ID(mro), \
                INIT_ID(msg), \
                INIT_ID(n_fields), \
                INIT_ID(n_sequence_fields), \
                INIT_ID(n_unnamed_fields), \
                INIT_ID(name), \
                INIT_ID(newlines), \
                INIT_ID(next), \
                INIT_ID(obj), \
                INIT_ID(offset), \
                INIT_ID(onceregistry), \
                INIT_ID(opcode), \
                INIT_ID(open), \
                INIT_ID(parent), \
                INIT_ID(partial), \
                INIT_ID(path), \
                INIT_ID(peek), \
                INIT_ID(persistent_id), \
                INIT_ID(persistent_load), \
                INIT_ID(print_file_and_line), \
                INIT_ID(ps1), \
                INIT_ID(ps2), \
                INIT_ID(raw), \
                INIT_ID(read), \
                INIT_ID(read1), \
                INIT_ID(readable), \
                INIT_ID(readall), \
                INIT_ID(readinto), \
                INIT_ID(readinto1), \
                INIT_ID(readline), \
                INIT_ID(reducer_override), \
                INIT_ID(reload), \
                INIT_ID(replace), \
                INIT_ID(reset), \
                INIT_ID(return), \
                INIT_ID(reversed), \
                INIT_ID(seek), \
                INIT_ID(seekable), \
                INIT_ID(send), \
                INIT_ID(setcomp), \
                INIT_ID(setstate), \
                INIT_ID(sort), \
                INIT_ID(stderr), \
                INIT_ID(stdin), \
                INIT_ID(stdout), \
                INIT_ID(strict), \
                INIT_ID(symmetric_difference_update), \
                INIT_ID(tell), \
                INIT_ID(text), \
                INIT_ID(threading), \
                INIT_ID(throw), \
                INIT_ID(top), \
                INIT_ID(truncate), \
                INIT_ID(unraisablehook), \
                INIT_ID(values), \
                INIT_ID(version), \
                INIT_ID(warnings), \
                INIT_ID(warnoptions), \
                INIT_ID(writable), \
                INIT_ID(write), \
                INIT_ID(zipimporter), \
            }, \
            .ascii = { \
                _PyASCIIObject_INIT("\x00"), \
                _PyASCIIObject_INIT("\x01"), \
                _PyASCIIObject_INIT("\x02"), \
                _PyASCIIObject_INIT("\x03"), \
                _PyASCIIObject_INIT("\x04"), \
                _PyASCIIObject_INIT("\x05"), \
                _PyASCIIObject_INIT("\x06"), \
                _PyASCIIObject_INIT("\x07"), \
                _PyASCIIObject_INIT("\x08"), \
                _PyASCIIObject_INIT("\x09"), \
                _PyASCIIObject_INIT("\x0a"), \
                _PyASCIIObject_INIT("\x0b"), \
                _PyASCIIObject_INIT("\x0c"), \
                _PyASCIIObject_INIT("\x0d"), \
                _PyASCIIObject_INIT("\x0e"), \
                _PyASCIIObject_INIT("\x0f"), \
                _PyASCIIObject_INIT("\x10"), \
                _PyASCIIObject_INIT("\x11"), \
                _PyASCIIObject_INIT("\x12"), \
                _PyASCIIObject_INIT("\x13"), \
                _PyASCIIObject_INIT("\x14"), \
                _PyASCIIObject_INIT("\x15"), \
                _PyASCIIObject_INIT("\x16"), \
                _PyASCIIObject_INIT("\x17"), \
                _PyASCIIObject_INIT("\x18"), \
                _PyASCIIObject_INIT("\x19"), \
                _PyASCIIObject_INIT("\x1a"), \
                _PyASCIIObject_INIT("\x1b"), \
                _PyASCIIObject_INIT("\x1c"), \
                _PyASCIIObject_INIT("\x1d"), \
                _PyASCIIObject_INIT("\x1e"), \
                _PyASCIIObject_INIT("\x1f"), \
                _PyASCIIObject_INIT("\x20"), \
                _PyASCIIObject_INIT("\x21"), \
                _PyASCIIObject_INIT("\x22"), \
                _PyASCIIObject_INIT("\x23"), \
                _PyASCIIObject_INIT("\x24"), \
                _PyASCIIObject_INIT("\x25"), \
                _PyASCIIObject_INIT("\x26"), \
                _PyASCIIObject_INIT("\x27"), \
                _PyASCIIObject_INIT("\x28"), \
                _PyASCIIObject_INIT("\x29"), \
                _PyASCIIObject_INIT("\x2a"), \
                _PyASCIIObject_INIT("\x2b"), \
                _PyASCIIObject_INIT("\x2c"), \
                _PyASCIIObject_INIT("\x2d"), \
                _PyASCIIObject_INIT("\x2e"), \
                _PyASCIIObject_INIT("\x2f"), \
                _PyASCIIObject_INIT("\x30"), \
                _PyASCIIObject_INIT("\x31"), \
                _PyASCIIObject_INIT("\x32"), \
                _PyASCIIObject_INIT("\x33"), \
                _PyASCIIObject_INIT("\x34"), \
                _PyASCIIObject_INIT("\x35"), \
                _PyASCIIObject_INIT("\x36"), \
                _PyASCIIObject_INIT("\x37"), \
                _PyASCIIObject_INIT("\x38"), \
                _PyASCIIObject_INIT("\x39"), \
                _PyASCIIObject_INIT("\x3a"), \
                _PyASCIIObject_INIT("\x3b"), \
                _PyASCIIObject_INIT("\x3c"), \
                _PyASCIIObject_INIT("\x3d"), \
                _PyASCIIObject_INIT("\x3e"), \
                _PyASCIIObject_INIT("\x3f"), \
                _PyASCIIObject_INIT("\x40"), \
                _PyASCIIObject_INIT("\x41"), \
                _PyASCIIObject_INIT("\x42"), \
                _PyASCIIObject_INIT("\x43"), \
                _PyASCIIObject_INIT("\x44"), \
                _PyASCIIObject_INIT("\x45"), \
                _PyASCIIObject_INIT("\x46"), \
                _PyASCIIObject_INIT("\x47"), \
                _PyASCIIObject_INIT("\x48"), \
                _PyASCIIObject_INIT("\x49"), \
                _PyASCIIObject_INIT("\x4a"), \
                _PyASCIIObject_INIT("\x4b"), \
                _PyASCIIObject_INIT("\x4c"), \
                _PyASCIIObject_INIT("\x4d"), \
                _PyASCIIObject_INIT("\x4e"), \
                _PyASCIIObject_INIT("\x4f"), \
                _PyASCIIObject_INIT("\x50"), \
                _PyASCIIObject_INIT("\x51"), \
                _PyASCIIObject_INIT("\x52"), \
                _PyASCIIObject_INIT("\x53"), \
                _PyASCIIObject_INIT("\x54"), \
                _PyASCIIObject_INIT("\x55"), \
                _PyASCIIObject_INIT("\x56"), \
                _PyASCIIObject_INIT("\x57"), \
                _PyASCIIObject_INIT("\x58"), \
                _PyASCIIObject_INIT("\x59"), \
                _PyASCIIObject_INIT("\x5a"), \
                _PyASCIIObject_INIT("\x5b"), \
                _PyASCIIObject_INIT("\x5c"), \
                _PyASCIIObject_INIT("\x5d"), \
                _PyASCIIObject_INIT("\x5e"), \
                _PyASCIIObject_INIT("\x5f"), \
                _PyASCIIObject_INIT("\x60"), \
                _PyASCIIObject_INIT("\x61"), \
                _PyASCIIObject_INIT("\x62"), \
                _PyASCIIObject_INIT("\x63"), \
                _PyASCIIObject_INIT("\x64"), \
                _PyASCIIObject_INIT("\x65"), \
                _PyASCIIObject_INIT("\x66"), \
                _PyASCIIObject_INIT("\x67"), \
                _PyASCIIObject_INIT("\x68"), \
                _PyASCIIObject_INIT("\x69"), \
                _PyASCIIObject_INIT("\x6a"), \
                _PyASCIIObject_INIT("\x6b"), \
                _PyASCIIObject_INIT("\x6c"), \
                _PyASCIIObject_INIT("\x6d"), \
                _PyASCIIObject_INIT("\x6e"), \
                _PyASCIIObject_INIT("\x6f"), \
                _PyASCIIObject_INIT("\x70"), \
                _PyASCIIObject_INIT("\x71"), \
                _PyASCIIObject_INIT("\x72"), \
                _PyASCIIObject_INIT("\x73"), \
                _PyASCIIObject_INIT("\x74"), \
                _PyASCIIObject_INIT("\x75"), \
                _PyASCIIObject_INIT("\x76"), \
                _PyASCIIObject_INIT("\x77"), \
                _PyASCIIObject_INIT("\x78"), \
                _PyASCIIObject_INIT("\x79"), \
                _PyASCIIObject_INIT("\x7a"), \
                _PyASCIIObject_INIT("\x7b"), \
                _PyASCIIObject_INIT("\x7c"), \
                _PyASCIIObject_INIT("\x7d"), \
                _PyASCIIObject_INIT("\x7e"), \
                _PyASCIIObject_INIT("\x7f"), \
            }, \
            .latin1 = { \
                _PyUnicode_LATIN1_INIT("\x80"), \
                _PyUnicode_LATIN1_INIT("\x81"), \
                _PyUnicode_LATIN1_INIT("\x82"), \
                _PyUnicode_LATIN1_INIT("\x83"), \
                _PyUnicode_LATIN1_INIT("\x84"), \
                _PyUnicode_LATIN1_INIT("\x85"), \
                _PyUnicode_LATIN1_INIT("\x86"), \
                _PyUnicode_LATIN1_INIT("\x87"), \
                _PyUnicode_LATIN1_INIT("\x88"), \
                _PyUnicode_LATIN1_INIT("\x89"), \
                _PyUnicode_LATIN1_INIT("\x8a"), \
                _PyUnicode_LATIN1_INIT("\x8b"), \
                _PyUnicode_LATIN1_INIT("\x8c"), \
                _PyUnicode_LATIN1_INIT("\x8d"), \
                _PyUnicode_LATIN1_INIT("\x8e"), \
                _PyUnicode_LATIN1_INIT("\x8f"), \
                _PyUnicode_LATIN1_INIT("\x90"), \
                _PyUnicode_LATIN1_INIT("\x91"), \
                _PyUnicode_LATIN1_INIT("\x92"), \
                _PyUnicode_LATIN1_INIT("\x93"), \
                _PyUnicode_LATIN1_INIT("\x94"), \
                _PyUnicode_LATIN1_INIT("\x95"), \
                _PyUnicode_LATIN1_INIT("\x96"), \
                _PyUnicode_LATIN1_INIT("\x97"), \
                _PyUnicode_LATIN1_INIT("\x98"), \
                _PyUnicode_LATIN1_INIT("\x99"), \
                _PyUnicode_LATIN1_INIT("\x9a"), \
                _PyUnicode_LATIN1_INIT("\x9b"), \
                _PyUnicode_LATIN1_INIT("\x9c"), \
                _PyUnicode_LATIN1_INIT("\x9d"), \
                _PyUnicode_LATIN1_INIT("\x9e"), \
                _PyUnicode_LATIN1_INIT("\x9f"), \
                _PyUnicode_LATIN1_INIT("\xa0"), \
                _PyUnicode_LATIN1_INIT("\xa1"), \
                _PyUnicode_LATIN1_INIT("\xa2"), \
                _PyUnicode_LATIN1_INIT("\xa3"), \
                _PyUnicode_LATIN1_INIT("\xa4"), \
                _PyUnicode_LATIN1_INIT("\xa5"), \
                _PyUnicode_LATIN1_INIT("\xa6"), \
                _PyUnicode_LATIN1_INIT("\xa7"), \
                _PyUnicode_LATIN1_INIT("\xa8"), \
                _PyUnicode_LATIN1_INIT("\xa9"), \
                _PyUnicode_LATIN1_INIT("\xaa"), \
                _PyUnicode_LATIN1_INIT("\xab"), \
                _PyUnicode_LATIN1_INIT("\xac"), \
                _PyUnicode_LATIN1_INIT("\xad"), \
                _PyUnicode_LATIN1_INIT("\xae"), \
                _PyUnicode_LATIN1_INIT("\xaf"), \
                _PyUnicode_LATIN1_INIT("\xb0"), \
                _PyUnicode_LATIN1_INIT("\xb1"), \
                _PyUnicode_LATIN1_INIT("\xb2"), \
                _PyUnicode_LATIN1_INIT("\xb3"), \
                _PyUnicode_LATIN1_INIT("\xb4"), \
                _PyUnicode_LATIN1_INIT("\xb5"), \
                _PyUnicode_LATIN1_INIT("\xb6"), \
                _PyUnicode_LATIN1_INIT("\xb7"), \
                _PyUnicode_LATIN1_INIT("\xb8"), \
                _PyUnicode_LATIN1_INIT("\xb9"), \
                _PyUnicode_LATIN1_INIT("\xba"), \
                _PyUnicode_LATIN1_INIT("\xbb"), \
                _PyUnicode_LATIN1_INIT("\xbc"), \
                _PyUnicode_LATIN1_INIT("\xbd"), \
                _PyUnicode_LATIN1_INIT("\xbe"), \
                _PyUnicode_LATIN1_INIT("\xbf"), \
                _PyUnicode_LATIN1_INIT("\xc0"), \
                _PyUnicode_LATIN1_INIT("\xc1"), \
                _PyUnicode_LATIN1_INIT("\xc2"), \
                _PyUnicode_LATIN1_INIT("\xc3"), \
                _PyUnicode_LATIN1_INIT("\xc4"), \
                _PyUnicode_LATIN1_INIT("\xc5"), \
                _PyUnicode_LATIN1_INIT("\xc6"), \
                _PyUnicode_LATIN1_INIT("\xc7"), \
                _PyUnicode_LATIN1_INIT("\xc8"), \
                _PyUnicode_LATIN1_INIT("\xc9"), \
                _PyUnicode_LATIN1_INIT("\xca"), \
                _PyUnicode_LATIN1_INIT("\xcb"), \
                _PyUnicode_LATIN1_INIT("\xcc"), \
                _PyUnicode_LATIN1_INIT("\xcd"), \
                _PyUnicode_LATIN1