
    return atomic_load_explicit((const _Atomic(uint32_t)*)obj,
                                memory_order_relaxed);
}

static inline uint64_t
_Py_atomic_load_uint64_relaxed(const uint64_t *obj)
{
    _Py_USING_STD;
    return atomic_load_explicit((const _Atomic(uint64_t)*)obj,
                                memory_order_relaxed);
}

static inline uintptr_t
_Py_atomic_load_uintptr_relaxed(const uintptr_t *obj)
{
    _Py_USING_STD;
    return atomic_load_explicit((const _Atomic(uintptr_t)*)obj,
                                memory_order_relaxed);
}

static inline unsigned int
_Py_atomic_load_uint_relaxed(const unsigned int *obj)
{
    _Py_USING_STD;
    return atomic_load_explicit((const _Atomic(unsigned int)*)obj,
                                memory_order_relaxed);
}

static inline Py_ssize_t
_Py_atomic_load_ssize_relaxed(const Py_ssize_t *obj)
{
    _Py_USING_STD;
    return atomic_load_explicit((const _Atomic(Py_ssize_t)*)obj,
                                memory_order_relaxed);
}

static inline void*
_Py_atomic_load_ptr_relaxed(const void *obj)
{
    _Py_USING_STD;
    return atomic_load_explicit((const _Atomic(void*)*)obj,
                                memory_order_relaxed);
}

static inline unsigned long long
_Py_atomic_load_ullong_relaxed(const unsigned long long *obj)
{
    _Py_USING_STD;
    return atomic_load_explicit((const _Atomic(unsigned long long)*)obj,
                                memory_order_relaxed);
}


// --- _Py_atomic_store ------------------------------------------------------

static inline void
_Py_atomic_store_int(int *obj, int value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(int)*)obj, value);
}

static inline void
_Py_atomic_store_int8(int8_t *obj, int8_t value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(int8_t)*)obj, value);
}

static inline void
_Py_atomic_store_int16(int16_t *obj, int16_t value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(int16_