N_INFO_NONE = 15
} _PyCodeLocationInfoKind;

#ifdef __cplusplus
}
#endif
#endif  // !Py_CODE_H
#endif  // !Py_LIMITED_API
PK       ! SX_  _  !  python3.13/cpython/pyatomic_std.hnu [        // This is the implementation of Python atomic operations using C++11 or C11
// atomics. Note that the pyatomic_gcc.h implementation is preferred for GCC
// compatible compilers, even if they support C++11 atomics.

#ifndef Py_ATOMIC_STD_H
#  error "this header file must not be included directly"
#endif

#ifdef __cplusplus
extern "C++" {
#  include <atomic>
}
#  define _Py_USING_STD using namespace std
#  define _Atomic(tp) atomic<tp>
#else
#  define  _Py_USING_STD
#  include <stdatomic.h>
#endif


// --- _Py_atomic_add --------------------------------------------------------

static inline int
_Py_atomic_add_int(int *obj, int value)
{
    _Py_USING_STD;
    return atomic_fetch_add((_Atomic(int)*)obj, value);
}

static inline int8_t
_Py_atomic_add_int8(int8_t *obj, int8_t value)
{
    _Py_USING_STD;
    return atomic_fetch_add((_Atomic(int8_t)*)obj, value);
}

static inline int16_t
_Py_atomic_add_int16(int16_t *obj, int16_t value)
{
    _Py_USING_STD;
    return atomic_fetch_add((_Atomic(int16_t)*)obj, value);
}

static inline int32_t
_Py_atomic_add_int32(int32_t *obj, int32_t value)
{
    _Py_USING_STD;
    return atomic_fetch_add((_Atomic(int32_t)*)obj, value);
}

static inline int64_t
_Py_atomic_add_int64(int64_t *obj, int64_t value)
{
    _Py_USING_STD;
    return atomic_fetch_add((_Atomic(int64_t)*)obj, value);
}

static inline intptr_t
_Py_atomic_add_intptr(intptr_t *obj, intptr_t value)
{
    _Py_USING_STD;
    return atomic_fetch_add((_Atomic(intptr_t)*)obj, value);
}

static inline unsigned int
_Py_atomic_add_uint(unsigned int *obj, unsigned int value)
{
    _Py_USING_STD;
    return atomic_fetch_add((_Atomic(unsigned int)*)obj, value);
}

static inline uint8_t
_Py_atomic_add_uint8(uint8_t *obj, uint8_t value)
{
    _Py_USING_STD;
    return atomic_fetch_add((_Atomic(uint8_t)*)obj, value);
}

static inline uint16_t
_Py_atomic_add_uint16(uint16_t *obj, uint16_t value)
{
    _Py_USING_STD;
    return atomic_fetch_add(