ct *, PyObject *, PyObject *);

struct PyMethodDef {
    const char  *ml_name;   /* The name of the built-in function/method */
    PyCFunction ml_meth;    /* The C function that implements it */
    int         ml_flags;   /* Combination of METH_xxx flags, which mostly
                               describe the args expected by the C func */
    const char  *ml_doc;    /* The __doc__ attribute, or NULL */
};

/* PyCFunction_New is declared as a function for stable ABI (declaration is
 * needed for e.g. GCC with -fvisibility=hidden), but redefined as a macro
 * that calls PyCFunction_NewEx. */
PyAPI_FUNC(PyObject *) PyCFunction_New(PyMethodDef *, PyObject *);
#define PyCFunction_New(ML, SELF) PyCFunction_NewEx((ML), (SELF), NULL)

/* PyCFunction_NewEx is similar: on 3.9+, this calls PyCMethod_New. */
PyAPI_FUNC(PyObject *) PyCFunction_NewEx(PyMethodDef *, PyObject *,
                   