lue)
{
    _Py_USING_STD;
    atomic_store((_Atomic(int32_t)*)obj, value);
}

static inline void
_Py_atomic_store_int64(int64_t *obj, int64_t value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(int64_t)*)obj, value);
}

static inline void
_Py_atomic_store_intptr(intptr_t *obj, intptr_t value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(intptr_t)*)obj, value);
}

static inline void
_Py_atomic_store_uint8(uint8_t *obj, uint8_t value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(uint8_t)*)obj, value);
}

static inline void
_Py_atomic_store_uint16(uint16_t *obj, uint16_t value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(uint16_t)*)obj, value);
}

static inline void
_Py_atomic_store_uint32(uint32_t *obj, uint32_t value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(uint32_t)*)obj, value);
}

static inline void
_Py_atomic_store_uint64(uint64_t *obj, uint64_t value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(uint64_t)*)obj, value);
}

static inline void
_Py_atomic_store_uintptr(uintptr_t *obj, uintptr_t value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(uintptr_t)*)obj, value);
}

static inline void
_Py_atomic_store_uint(unsigned int *obj, unsigned int value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(unsigned int)*)obj, value);
}

static inline void
_Py_atomic_store_ptr(void *obj, void *value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(void*)*)obj, value);
}

static inline void
_Py_atomic_store_ssize(Py_ssize_t *obj, Py_ssize_t value)
{
    _Py_USING_STD;
    atomic_store((_Atomic(Py_ssize_t)*)obj, value);
}


// --- _Py_atomic_store_relaxed ----------------------------------------------

static inline void
_Py_atomic_store_int_relaxed(int *obj, int value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(int)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_int8_relaxed(int8_t *obj, int8_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(int8_t)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_int16_relaxed(int16_t *obj, int16_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(int16_t)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_int32_relaxed(int32_t *obj, int32_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(int32_t)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_int64_relaxed(int64_t *obj, int64_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(int64_t)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_intptr_relaxed(intptr_t *obj, intptr_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(intptr_t)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_uint8_relaxed(uint8_t *obj, uint8_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(uint8_t)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_uint16_relaxed(uint16_t *obj, uint16_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(uint16_t)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_uint32_relaxed(uint32_t *obj, uint32_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(uint32_t)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_uint64_relaxed(uint64_t *obj, uint64_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(uint64_t)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_uintptr_relaxed(uintptr_t *obj, uintptr_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(uintptr_t)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_uint_relaxed(unsigned int *obj, unsigned int value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(unsigned int)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_ptr_relaxed(void *obj, void *value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(void*)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_ssize_relaxed(Py_ssize_t *obj, Py_ssize_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(Py_ssize_t)*)obj, value,
                          memory_order_relaxed);
}

static inline void
_Py_atomic_store_ullong_relaxed(unsigned long long *obj,
                                unsigned long long value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(unsigned long long)*)obj, value,
                          memory_order_relaxed);
}


// --- _Py_atomic_load_ptr_acquire / _Py_atomic_store_ptr_release ------------

static inline void *
_Py_atomic_load_ptr_acquire(const void *obj)
{
    _Py_USING_STD;
    return atomic_load_explicit((const _Atomic(void*)*)obj,
                                memory_order_acquire);
}

static inline uintptr_t
_Py_atomic_load_uintptr_acquire(const uintptr_t *obj)
{
    _Py_USING_STD;
    return atomic_load_explicit((const _Atomic(uintptr_t)*)obj,
                                memory_order_acquire);
}

static inline void
_Py_atomic_store_ptr_release(void *obj, void *value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(void*)*)obj, value,
                          memory_order_release);
}

static inline void
_Py_atomic_store_uintptr_release(uintptr_t *obj, uintptr_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(uintptr_t)*)obj, value,
                          memory_order_release);
}

static inline void
_Py_atomic_store_int_release(int *obj, int value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(int)*)obj, value,
                          memory_order_release);
}

static inline void
_Py_atomic_store_ssize_release(Py_ssize_t *obj, Py_ssize_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(Py_ssize_t)*)obj, value,
                          memory_order_release);
}

static inline int
_Py_atomic_load_int_acquire(const int *obj)
{
    _Py_USING_STD;
    return atomic_load_explicit((const _Atomic(int)*)obj,
                                memory_order_acquire);
}

static inline void
_Py_atomic_store_uint32_release(uint32_t *obj, uint32_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(uint32_t)*)obj, value,
                          memory_order_release);
}

static inline void
_Py_atomic_store_uint64_release(uint64_t *obj, uint64_t value)
{
    _Py_USING_STD;
    atomic_store_explicit((_Atomic(uint64_t)*)obj, value,
           