-8"

#include "php_version.h"
#include "zend.h"
#include "zend_sort.h"
#include "php_compat.h"

#include "zend_API.h"

#undef sprintf
#define sprintf php_sprintf

/* Operating system family defintion */
#ifdef PHP_WIN32
# define PHP_OS_FAMILY			"Windows"
#elif defined(BSD) || defined(__DragonFly__) || defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
# define PHP_OS_FAMILY			"BSD"
#elif defined(__APPLE__) || defined(__MACH__)
# define PHP_OS_FAMILY			"Darwin"
#elif defined(__sun__)
# define PHP_OS_FAMILY			"Solaris"
#elif defined(__linux__)
# define PHP_OS_FAMILY			"Linux"
#else
# define PHP_OS_FAMILY			"Unknown"
#endif

/* PHP's DEBUG value must match Zend's ZEND_DEBUG value */
#undef PHP_DEBUG
#define PHP_DEBUG ZEND_DEBUG

#ifdef PHP_WIN32
#	include "tsrm_win32.h"
#	ifdef PHP_EXPORTS
#		define PHPAPI __declspec(dllexport)
#	else
#		define PHPAPI __declspec(dllimport)
#	endif
#	define PHP_DIR_SEPARATOR '\\'
#	define PHP_EOL "\r\n"
#else
#	if defined(__GNUC__) && __GNUC__ >= 4
#		define PHPAPI __attribute__ ((visibility("default")))
#	else
#		define PHPAPI
#	endif
#	define THREAD_LS
#	define PHP_DIR_SEPARATOR '/'
#	define PHP_EOL "\n"
#endif

/* Windows specific defines */
#ifdef PHP_WIN32
# define PHP_PROG_SENDMAIL		"Built in mailer"
# define HAVE_DECLARED_TIMEZONE
# define WIN32_LEAN_AND_MEAN
# define NOOPENFILE

# include <io.h>
# include <malloc.h>
# include <direct.h>
# include <stdlib.h>
# include <stdio.h>
# include <stdarg.h>
# include <sys/types.h>
# include <process.h>

typedef int uid_t;
typedef int gid_t;
typedef char * caddr_t;
typedef unsigned int uint;
typedef unsigned long ulong;
# if !NSAPI
typedef int pid_t;
# endif

# ifndef PHP_DEBUG
#  ifdef inline
#   undef inline
#  endif
#  define inline		__inline
# endif

# define M_TWOPI        (M_PI * 2.0)
# define off_t			_off_t

# define lstat(x, y)	php_sys_lstat(x, y)
# define chdir(path)	_chdir(path)
# define mkdir(a, b)	_mkdir(a)
# define rmdir(a)		_rmdir(a)
# define getpid			_getpid
# define php_sleep(t)	SleepEx(t*1000, TRUE)

