SR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Link, EvolvableLinkInterface, withAttribute, 2)
    ZEND_ARG_INFO(0, attribute)
    ZEND_ARG_INFO(0, value)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Link, EvolvableLinkInterface, withoutAttribute, 1)
    ZEND_ARG_INFO(0, attribute)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Link, EvolvableLinkProviderInterface, withLink, 1)
    ZEND_ARG_OBJ_INFO(0, link, Psr\\Link\\LinkInterface, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Link, EvolvableLinkProviderInterface, withoutLink, 1)
    ZEND_ARG_OBJ_INFO(0, link, Psr\\Link\\LinkInterface, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Link, LinkInterface, getHref, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Link, LinkInterface, isTemplated, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Link, LinkInterface, getRels, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Link, LinkInterface, getAttributes, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Link, LinkProviderInterface, getLinks, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Link, LinkProviderInterface, getLinksByRel, 1)
    ZEND_ARG_INFO(0, rel)
PHP_PSR_END_ARG_INFO()

#endif /* PSR_LINK_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: fdm=marker
 * vim: et sw=4 ts=4
 */
PK       ! $  $  $  php/ext/imagick/php_imagick_shared.hnu [        /*
   +----------------------------------------------------------------------+
   | PHP Version 5 / Imagick	                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 2006-2013 Mikko Koppanen, Scott MacVicar               |
   | ImageMagick (c) ImageMagick Studio LLC                               |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Author: Mikko Kopppanen <mkoppanen@php.net>                          |
   |         Scott MacVicar <scottmac@php.net>                            |
   +----------------------------------------------------------------------+
*/

#ifndef _PHP_IMAGICK_SHARED_H_
# define _PHP_IMAGICK_SHARED_H_

/* Should work with ImageMagick 6.x for now */
#include "php.h"

#if defined(PHP_WIN32) && defined(IMAGICK_EXPORTS)
#define PHP_IMAGICK_API __declspec(dllexport)
#else
#define PHP_IMAGICK_API PHPAPI
#endif

/*
	Allow extensions to use the class entries
*/
PHP_IMAGICK_API zend_class_entry *php_imagick_get_class_entry();
PHP_IMAGICK_API zend_class_entry *php_imagickdraw_get_class_entry();
PHP_IMAGICK_API zend_class_entry *php_imagickpixel_get_class_entry();

#endif
PK       ! DoD  D    php/ext/gmp/php_gmp_int.hnu [        #ifndef incl_PHP_GMP_INT_H
#define incl_PHP_GMP_INT_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "php.h"
#include <gmp.h>

#ifdef PHP_WIN32
# define PHP_GMP_API __declspec(dllexport)
#elif defined(__GNUC__) && __GNUC__ >= 4
# define PHP_GMP_API __attribute__ ((visibility("default")))
#else
# define PHP_GMP_API
#endif

typedef struct _gmp_object {
	mpz_t num;
	zend_object std;
} gmp_object;

static inline gmp_object *php_gmp_object_from_zend_object(zend_object *zobj) {
	return (gmp_object *)( ((char *)zobj) - XtOffsetOf(gmp_object, std) );
}

PHP_GMP_API zend_class_entry *php_gmp_class_entry();

/* GMP and MPIR use different datatypes on different platforms */
#ifdef PHP_WIN32
typedef zend_long gmp_long;
typedef zend_ulong gmp_ulong;
#else
typedef long gmp_long;
typedef unsigned long gmp_ulong;
#endif

#endif
PK       ! L      php/ext/date/php_date.hnu [        /*
   +----------------------------------------------------------------------+
   | PHP Version 7                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2018 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#ifndef PHP_DATE_H
#define PHP_DATE_H

#include "lib/timelib.h"
#include "Zend/zend_hash.h"

#include "php_version.h"
#define PHP_DATE_VERSION PHP_VERSION

extern zend_module_entry date_module_entry;
#define phpext_date_ptr &date_module_entry

PHP_FUNCTION(date);
PHP_FUNCTION(idate);
PHP_FUNCTION(gmdate);
PHP_FUNCTION(strtotime);

PHP_FUNCTION(mktime);
PHP_FUNCTION(gmmktime);

PHP_FUNCTION(checkdate);

#ifdef HAVE_STRFTIME
PHP_FUNCTION(strftime);
PHP_FUNCTION(gmstrftime);
#endif

PHP_FUNCTION(time);
PHP_FUNCTION(localtime);
PHP_FUNCTION(getdate);

/* Advanced Interface */
PHP_METHOD(DateTime, __construct);
PHP_METHOD(DateTime, __wakeup);
PHP_METHOD(DateTime, __set_state);
PHP_FUNCTION(date_create);
PHP_FUNCTION(date_create_immutable);
PHP_FUNCTION(date_create_from_format);
PHP_FUNCTION(date_create_immutable_from_format);
PHP_FUNCTION(date_parse);
PHP_FUNCTION(date_parse_from_format);
PHP_FUNCTION(date_get_last_errors);
PHP_FUNCTION(date_format);
PHP_FUNCTION(date_modify);
PHP_FUNCTION(date_add);
PHP_FUNCTION(date_sub);
PHP_FUNCTION(date_timezone_get);
PHP_FUNCTION(date_timezone_set);
PHP_FUNCTION(date_offset_get);
PHP_FUNCTION(date_diff);

PHP_FUNCTION(date_time_set);
PHP_FUNCTION(date_date_set);
PHP_FUNCTION(date_isodate_set);
PHP_FUNCTION(date_timestamp_set);
PHP_FUNCTION(date_timestamp_get);

PHP_METHOD(DateTimeImmutable, __construct);
PHP_METHOD(DateTimeImmutable, __set_state);
PHP_METHOD(DateTimeImmutable, modify);
PHP_METHOD(DateTimeImmutable, add);
PHP_METHOD(DateTimeImmutable, sub);
PHP_METHOD(DateTimeImmutable, setTimezone);
PHP_METHOD(DateTimeImmutable, setTime);
PHP_METHOD(DateTimeImmutable, setDate);
PHP_METHOD(DateTimeImmutable, setISODate);
PHP_METHOD(DateTimeImmutable, setTimestamp);
PHP_METHOD(DateTimeImmutable, createFromMutable);

PHP_METHOD(DateTimeZone, __construct);
PHP_METHOD(DateTimeZone, __wakeup);
PHP_METHOD(DateTimeZone, __set_state);
PHP_FUNCTION(timezone_open);
PHP_FUNCTION(timezone_name_get);
PHP_FUNCTION(timezone_name_from_abbr);
PHP_FUNCTION(timezone_offset_get);
PHP_FUNCTION(timezone_transitions_get);
PHP_FUNCTION(timezone_location_get);
PHP_FUNCTION(timezone_identifiers_list);
PHP_FUNCTION(timezone_abbreviations_list);
PHP_FUNCTION(timezone_version_get);

PHP_METHOD(DateInterval, __construct);
PHP_METHOD(DateInterval, __wakeup);
PHP_METHOD(DateInterval, __set_state);
PHP_FUNCTION(date_interval_format);
PHP_FUNCTION(date_interval_create_from_date_string);

PHP_METHOD(DatePeriod, __construct);
PHP_METHOD(DatePeriod, __wakeup);
PHP_METHOD(DatePeriod, __set_state);
PHP_METHOD(DatePeriod, getStartDate);
PHP_METHOD(DatePeriod, getEndDate);
PHP_METHOD(DatePeriod, getDateInterval);
PHP_METHOD(DatePeriod, getRecurrences);

/* Options and Configuration */
PHP_FUNCTION(date_default_timezone_set);
PHP_FUNCTION(date_default_timezone_get);

/* Astro functions */
PHP_FUNCTION(date_sunrise);
PHP_FUNCTION(date_sunset);
PHP_FUNCTION(date_sun_info);

PHP_RINIT_FUNCTION(date);
PHP_RSHUTDOWN_FUNCTION(date);
PHP_MINIT_FUNCTION(date);
PHP_MSHUTDOWN_FUNCTION(date);
PHP_MINFO_FUNCTION(date);

typedef struct _php_date_obj php_date_obj;
typedef struct _php_timezone_obj php_timezone_obj;
typedef struct _php_interval_obj php_interval_obj;
typedef struct _php_period_obj php_period_obj;

struct _php_date_obj {
	timelib_time *time;
	HashTable    *props;
	zend_object   std;
};

static inline php_date_obj *php_date_obj_from_obj(zend_object *obj) {
	return (php_date_obj*)((char*)(obj) - XtOffsetOf(php_date_obj, std));
}

#define Z_PHPDATE_P(zv)  php_date_obj_from_obj(Z_OBJ_P((zv)))

struct _php_timezone_obj {
	int             initialized;
	int             type;
	union {
		timelib_tzinfo   *tz;         /* TIMELIB_ZONETYPE_ID */
		timelib_sll       utc_offset; /* TIMELIB_ZONETYPE_OFFSET */
		timelib_abbr_info z;          /* TIMELIB_ZONETYPE_ABBR */
	} tzi;
	HashTable *props;
	zend_object std;
};

static inline php_timezone_obj *php_timezone_obj_from_obj(zend_object *obj) {
	return (php_timezone_obj*)((char*)(obj) - XtOffsetOf(php_timezone_obj, std));
}

#define Z_PHPTIMEZONE_P(zv)  php_timezone_obj_from_obj(Z_OBJ_P((zv)))

struct _php_interval_obj {
	timelib_rel_time *diff;
	HashTable        *props;
	int               initialized;
	zend_object       std;
};

static inline php_interval_obj *php_interval_obj_from_obj(zend_object *obj) {
	return (php_interval_obj*)((char*)(obj) - XtOffsetOf(php_interval_obj, std));
}

#define Z_PHPINTERVAL_P(zv)  php_interval_obj_from_obj(Z_OBJ_P((zv)))

struct _php_period_obj {
	timelib_time     *start;
	zend_class_entry *start_ce;
	timelib_time     *current;
	timelib_time     *end;
	timelib_rel_time *interval;
	int               recurrences;
	int               initialized;
	int               include_start_date;
	zend_object       std;
};

static inline php_period_obj *php_period_obj_from_obj(zend_object *obj) {
	return (php_period_obj*)((char*)(obj) - XtOffsetOf(php_period_obj, std));
}

#define Z_PHPPERIOD_P(zv)  php_period_obj_from_obj(Z_OBJ_P((zv)))

ZEND_BEGIN_MODULE_GLOBALS(date)
	char                    *default_timezone;
	char                    *timezone;
	HashTable               *tzcache;
	timelib_error_container *last_errors;
	int                     timezone_valid;
ZEND_END_MODULE_GLOBALS(date)

#define DATEG(v) ZEND_MODULE_GLOBALS_ACCESSOR(date, v)

PHPAPI time_t php_time();

/* Backwards compatibility wrapper */
PHPAPI zend_long php_parse_date(char *string, zend_long *now);
PHPAPI void php_mktime(INTERNAL_FUNCTION_PARAMETERS, int gmt);
PHPAPI int php_idate(char format, time_t ts, int localtime);
#if HAVE_STRFTIME
#define _php_strftime php_strftime
PHPAPI void php_strftime(INTERNAL_FUNCTION_PARAMETERS, int gm);
#endif
PHPAPI zend_string *php_format_date(char *format, size_t format_len, time_t ts, int localtime);

/* Mechanism to set new TZ database */
PHPAPI void php_date_set_tzdb(timelib_tzdb *tzdb);
PHPAPI timelib_tzinfo *get_timezone_info(void);

/* Grabbing CE's so that other exts can use the date objects too */
PHPAPI zend_class_entry *php_date_get_date_ce(void);
PHPAPI zend_class_entry *php_date_get_immutable_ce(void);
PHPAPI zend_class_entry *php_date_get_interface_ce(void);
PHPAPI zend_class_entry *php_date_get_timezone_ce(void);

/* Functions for creating DateTime objects, and initializing them from a string */
PHPAPI zval *php_date_instantiate(zend_class_entry *pce, zval *object);
PHPAPI int php_date_initialize(php_date_obj *dateobj, /*const*/ char *time_str, size_t time_str_len, char *format, zval *timezone_object, int ctor);


#endif /* PHP_DATE_H */
PK       ! ov+x  +x    php/ext/date/lib/timelib.hnu [        /*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015 Derick Rethans
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef __TIMELIB_H__
#define __TIMELIB_H__

#ifdef HAVE_TIMELIB_CONFIG_H
# include "timelib_config.h"
#endif

#include <stdlib.h>
#include <limits.h>
#include <inttypes.h>

# ifndef HAVE_INT32_T
#  if SIZEOF_INT == 4
typedef int int32_t;
#  elif SIZEOF_LONG == 4
typedef long int int32_t;
#  endif
# endif

# ifndef HAVE_UINT32_T
#  if SIZEOF_INT == 4
typedef unsigned int uint32_t;
#  elif SIZEOF_LONG == 4
typedef unsigned long int uint32_t;
#  endif
# endif

#ifdef _WIN32
# if _MSC_VER >= 1600
# include <stdint.h>
# endif
# ifndef SIZEOF_INT
#  define SIZEOF_INT 4
# endif
# ifndef SIZEOF_LONG
#  define SIZEOF_LONG 4
# endif
# ifndef int32_t
typedef __int32           int32_t;
# endif
# ifndef uint32_t
typedef unsigned __int32  uint32_t;
# endif
# ifndef int64_t
typedef __int64           int64_t;
# endif
# ifndef uint64_t
typedef unsigned __int64  uint64_t;
# endif
# ifndef PRId32
#  define PRId32       "I32d"
# endif
# ifndef PRIu32
#  define PRIu32       "I32u"
# endif
# ifndef PRId64
#  define PRId64       "I64d"
# endif
# ifndef PRIu64
#  define PRIu64       "I64u"
# endif
# ifndef INT32_MAX
#define INT32_MAX    _I32_MAX
# endif
# ifndef INT32_MIN
#define INT32_MIN    ((int32_t)_I32_MIN)
# endif
# ifndef UINT32_MAX
#define UINT32_MAX   _UI32_MAX
# endif
# ifndef INT64_MIN
#define INT64_MIN    ((int64_t)_I64_MIN)
# endif
# ifndef INT64_MAX
#define INT64_MAX    _I64_MAX
# endif
# ifndef UINT64_MAX
#define UINT64_MAX   _UI64_MAX
# endif
#endif

#if (defined(__x86_64__) || defined(__LP64__) || defined(_LP64) || defined(_WIN64)) && !defined(TIMELIB_FORCE_LONG32)
typedef int64_t timelib_long;
typedef uint64_t timelib_ulong;
# define TIMELIB_LONG_MAX INT64_MAX
# define TIMELIB_LONG_MIN INT64_MIN
# define TIMELIB_ULONG_MAX UINT64_MAX
# define TIMELIB_LONG_FMT "%" PRId64
# define TIMELIB_ULONG_FMT "%" PRIu64
#else
typedef int32_t timelib_long;
typedef uint32_t timelib_ulong;
# define TIMELIB_LONG_MAX INT32_MAX
# define TIMELIB_LONG_MIN INT32_MIN
# define TIMELIB_ULONG_MAX UINT32_MAX
# define TIMELIB_LONG_FMT "%" PRId32
# define TIMELIB_ULONG_FMT "%" PRIu32
#endif

#if defined(_MSC_VER)
typedef uint64_t timelib_ull;
typedef int64_t timelib_sll;
# define TIMELIB_LL_CONST(n) n ## i64
#else
typedef unsigned long long timelib_ull;
typedef signed long long timelib_sll;
# define TIMELIB_LL_CONST(n) n ## ll
#endif

typedef struct _ttinfo ttinfo;
typedef struct _tlinfo tlinfo;

typedef struct _tlocinfo
{
	char country_code[3];
	double latitude;
	double longitude;
	char *comments;
} tlocinfo;

typedef struct _timelib_tzinfo
{
	char    *name;
	struct {
		uint32_t ttisgmtcnt;
		uint32_t ttisstdcnt;
		uint32_t leapcnt;
		uint32_t timecnt;
		uint32_t typecnt;
		uint32_t charcnt;
	} bit32;
	struct {
		uint64_t ttisgmtcnt;
		uint64_t ttisstdcnt;
		uint64_t leapcnt;
		uint64_t timecnt;
		uint64_t typecnt;
		uint64_t charcnt;
	} bit64;

	int32_t *trans;
	unsigned char *trans_idx;

	ttinfo  *type;
	char    *timezone_abbr;

	tlinfo  *leap_times;
	unsigned char bc;
	tlocinfo location;
} timelib_tzinfo;

typedef struct _timelib_rel_time {
	timelib_sll y, m, d; /* Years, Months and Days */
	timelib_sll h, i, s; /* Hours, mInutes and Seconds */
	timelib_sll us;      /* Microseconds */

	int weekday; /* Stores the day in 'next monday' */
	int weekday_behavior; /* 0: the current day should *not* be counted when advancing forwards; 1: the current day *should* be counted */

	int first_last_day_of;
	int invert; /* Whether the difference should be inverted */
	timelib_sll days; /* Contains the number of *days*, instead of Y-M-D differences */

	struct {
		unsigned int type;
		timelib_sll amount;
	} special;

	unsigned int   have_weekday_relative, have_special_relative;
} timelib_rel_time;

typedef struct _timelib_time_offset {
	int32_t      offset;
	unsigned int leap_secs;
	unsigned int is_dst;
	char        *abbr;
	timelib_sll  transition_time;
} timelib_time_offset;

typedef struct _timelib_time {
	timelib_sll      y, m, d;     /* Year, Month, Day */
	timelib_sll      h, i, s;     /* Hour, mInute, Second */
	timelib_sll      us;          /* Microseconds */
	int              z;           /* UTC offset in seconds */
	char            *tz_abbr;     /* Timezone abbreviation (display only) */
	timelib_tzinfo  *tz_info;     /* Timezone structure */
	signed int       dst;         /* Flag if we were parsing a DST zone */
	timelib_rel_time relative;

	timelib_sll      sse;         /* Seconds since epoch */

	unsigned int   have_time, have_date, have_zone, have_relative, have_weeknr_day;

	unsigned int   sse_uptodate; /* !0 if the sse member is up to date with the date/time members */
	unsigned int   tim_uptodate; /* !0 if the date/time members are up to date with the sse member */
	unsigned int   is_localtime; /*  1 if the current struct represents localtime, 0 if it is in GMT */
	unsigned int   zone_type;    /*  1 time offset,
	                              *  3 TimeZone identifier,
	                              *  2 TimeZone abbreviation */
} timelib_time;

typedef struct _timelib_abbr_info {
	timelib_sll  utc_offset;
	char        *abbr;
	int          dst;
} timelib_abbr_info;

#define TIMELIB_WARN_MASK                      0x1ff
#define TIMELIB_ERR_MASK                       0x2ff

#define TIMELIB_WARN_DOUBLE_TZ                 0x101
#define TIMELIB_WARN_INVALID_TIME              0x102
#define TIMELIB_WARN_INVALID_DATE              0x103
#define TIMELIB_WARN_TRAILING_DATA             0x11a

#define TIMELIB_ERR_DOUBLE_TZ                  0x201
#define TIMELIB_ERR_TZID_NOT_FOUND             0x202
#define TIMELIB_ERR_DOUBLE_TIME                0x203
#define TIMELIB_ERR_DOUBLE_DATE                0x204
#define TIMELIB_ERR_UNEXPECTED_CHARACTER       0x205
#define TIMELIB_ERR_EMPTY_STRING               0x206
#define TIMELIB_ERR_UNEXPECTED_DATA            0x207
#define TIMELIB_ERR_NO_TEXTUAL_DAY             0x208
#define TIMELIB_ERR_NO_TWO_DIGIT_DAY           0x209
#define TIMELIB_ERR_NO_THREE_DIGIT_DAY_OF_YEAR 0x20a
#define TIMELIB_ERR_NO_TWO_DIGIT_MONTH         0x20b
#define TIMELIB_ERR_NO_TEXTUAL_MONTH           0x20c
#define TIMELIB_ERR_NO_TWO_DIGIT_YEAR          0x20d
#define TIMELIB_ERR_NO_FOUR_DIGIT_YEAR         0x20e
#define TIMELIB_ERR_NO_TWO_DIGIT_HOUR          0x20f
#define TIMELIB_ERR_HOUR_LARGER_THAN_12        0x210
#define TIMELIB_ERR_MERIDIAN_BEFORE_HOUR       0x211
#define TIMELIB_ERR_NO_MERIDIAN                0x212
#define TIMELIB_ERR_NO_TWO_DIGIT_MINUTE        0x213
#define TIMELIB_ERR_NO_TWO_DIGIT_SECOND        0x214
#define TIMELIB_ERR_NO_SIX_DIGIT_MICROSECOND   0x215
#define TIMELIB_ERR_NO_SEP_SYMBOL              0x216
#define TIMELIB_ERR_EXPECTED_ESCAPE_CHAR       0x217
#define TIMELIB_ERR_NO_ESCAPED_CHAR            0x218
#define TIMELIB_ERR_WRONG_FORMAT_SEP           0x219
#define TIMELIB_ERR_TRAILING_DATA              0x21a
#define TIMELIB_ERR_DATA_MISSING               0x21b

#define TIMELIB_ZONETYPE_OFFSET 1
#define TIMELIB_ZONETYPE_ABBR   2
#define TIMELIB_ZONETYPE_ID     3

typedef struct _timelib_error_message {
	int         error_code;
	int         position;
	char        character;
	char       *message;
} timelib_error_message;

typedef struct _timelib_error_container {
	timelib_error_message *error_messages;
	timelib_error_message *warning_messages;
	int                    error_count;
	int                    warning_count;
} timelib_error_container;

typedef struct _timelib_tz_lookup_table {
	char       *name;
	int         type;
	float       gmtoffset;
	char       *full_tz_name;
} timelib_tz_lookup_table;

typedef struct _timelib_tzdb_index_entry {
	char *id;
	unsigned int pos;
} timelib_tzdb_index_entry;

typedef struct _timelib_tzdb {
	char                           *version;
	int                             index_size;
	const timelib_tzdb_index_entry *index;
	const unsigned char            *data;
} timelib_tzdb;

#ifndef timelib_malloc
# define timelib_malloc  malloc
# define timelib_realloc realloc
# define timelib_calloc  calloc
# define timelib_strdup  strdup
# define timelib_free    free
#endif

#define TIMELIB_VERSION 201709
#define TIMELIB_EXTENDED_VERSION 20170900
#define TIMELIB_ASCII_VERSION "2017.09"

#define TIMELIB_NONE             0x00
#define TIMELIB_OVERRIDE_TIME    0x01
#define TIMELIB_NO_CLONE         0x02

#define TIMELIB_UNSET   -99999

/* An entry for each of these error codes is also in the
 * timelib_error_messages array in timelib.c */
#define TIMELIB_ERROR_NO_ERROR                            0x00
#define TIMELIB_ERROR_CANNOT_ALLOCATE                     0x01
#define TIMELIB_ERROR_CORRUPT_TRANSITIONS_DONT_INCREASE   0x02
#define TIMELIB_ERROR_CORRUPT_NO_64BIT_PREAMBLE           0x03
#define TIMELIB_ERROR_CORRUPT_NO_ABBREVIATION             0x04
#define TIMELIB_ERROR_UNSUPPORTED_VERSION                 0x05
#define TIMELIB_ERROR_NO_SUCH_TIMEZONE                    0x06

#ifdef __cplusplus
extern "C" {
#endif

/* Function pointers */
typedef timelib_tzinfo* (*timelib_tz_get_wrapper)(char *tzname, const timelib_tzdb *tzdb, int *error_code);

/* From dow.c */
/* Calculates the day of the week from y, m, and d. 0=Sunday..6=Saturday */
timelib_sll timelib_day_of_week(timelib_sll y, timelib_sll m, timelib_sll d);

/* Calculates the day of the ISO week from y, m, and d. 1=Monday, 7=Sunday */
timelib_sll timelib_iso_day_of_week(timelib_sll y, timelib_sll m, timelib_sll d);

/* Calculates the day of the year according to y-m-d. 0=Jan 1st..364/365=Dec
 * 31st */
timelib_sll timelib_day_of_year(timelib_sll y, timelib_sll m, timelib_sll d);

/* Calculates the day of the year according to y-w-dow. 0..364/365 */
timelib_sll timelib_daynr_from_weeknr(timelib_sll iy, timelib_sll iw, timelib_sll id);

/* Calculates the number of days in month m for year y. 28..31 */
timelib_sll timelib_days_in_month(timelib_sll y, timelib_sll m);

/* Calculates the ISO year and week from y, m, and d, into iw and iy */
void timelib_isoweek_from_date(timelib_sll y, timelib_sll m, timelib_sll d, timelib_sll *iw, timelib_sll *iy);

/* Calculates the ISO year, week, and day of week from y, m, and d, into iy,
 * iw, and id */
void timelib_isodate_from_date(timelib_sll y, timelib_sll m, timelib_sll d, timelib_sll *iy, timelib_sll *iw, timelib_sll *id);

/* Calculates the year, month, and day from iy, iw, and iw, into y, m, and d */
void timelib_date_from_isodate(timelib_sll iy, timelib_sll iw, timelib_sll id, timelib_sll *y, timelib_sll *m, timelib_sll *d);

/* Returns true if h, i and s fit in the range 00:00:00..23:59:59, false
 * otherwise */
int timelib_valid_time(timelib_sll h, timelib_sll i, timelib_sll s);

/* Returns true if m fits in the range 1..12, and d fits in the range
 * 1..<days-in-month> for year y */
int timelib_valid_date(timelib_sll y, timelib_sll m, timelib_sll d);

/* From parse_date.re */

/* Parses the date/time string in 's' with length 'len' into the constituent
 * parts of timelib_time*.
 *
 * Depending on the contents of the string 's', not all elements might be
 * filled. You can check whether a specific element has been parsed by
 * comparing with the TIMELIB_UNSET define.
 *
 * If errors occur, this function keeps already parsed elements in the
 * returned timelib_time* value.
 *
 * If the **errors points to a timelib_error_container variable, warnings
 * and errors will be recorded. You are responsible for freeing the stored
 * information with timelib_error_container_dtor(). To see whether errors have
 * occured, inspect errors->errors_count. To see whether warnings have occured,
 * inspect errors->warnings_count.
 *
 * The returned timelib_time* value is dynamically allocated and should be
 * freed with timelib_time_dtor().
 */
timelib_time *timelib_strtotime(char *s, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper);

/* Parses the date/time string in 's' with length 'len' into the constituent
 * parts of timelib_time* according to the format in 'format'.
 *
 * Depending on the contents of the string 's', not all elements might be
 * filled. You can check whether a specific element has been parsed by
 * comparing with the TIMELIB_UNSET define.
 *
 * If errors occur, this function keeps already parsed elements in the
 * returned timelib_time* value.
 *
 * If the **errors points to a timelib_error_container variable, warnings
 * and errors will be recorded. You are responsible for freeing the stored
 * information with timelib_error_container_dtor(). To see whether errors have
 * occured, inspect errors->errors_count. To see whether warnings have occured,
 * inspect errors->warnings_count.
 *
 * The returned timelib_time* value is dynamically allocated and should be
 * freed with timelib_time_dtor().
 */
timelib_time *timelib_parse_from_format(char *format, char *s, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper);

/* Fills the gaps in the parsed timelib_time with information from the reference date/time in 'now'
 *
 * If any of the 'parsed' y, m, d, h, i or s parameters is unset (TIMELIB_UNSET):
 * - if microtime (us) is unset, then the us of the parsed time is set to 0.
 * - else if microtime (us) is unset and 'now'->'us' is set, use it, otherwise use 0.
 *
 * For either of the 'parsed' y, m, d, h, i, s, z (utc offset in seconds) or
 * dst is unset, set it to the corresponding value in 'now' if set, otherwise
 * set it to 0.
 *
 * It duplicates tz_abbr if unset in 'parsed' but set in 'now'.
 *
 * It duplicates tz_info if unset in 'parsed', but set in 'now' unless
 * TIMELIB_NO_CLONE is passed, in which case only the pointer in 'parsed' is
 * set to 'now'.
 *
 * If the option TIMELIB_OVERRIDE_TIME is passed and the parsed date/time has
 * no time portion, the function will ignore the time aspect in 'now' and
 * instead fill it with zeros.
 */
void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options);

/* Tries to convert a time zone abbreviation, gmtoffset and/or isdst flag
 * combination to a time zone identifier.
 *
 * If 'abbr' is either 'utc' or 'gmt' (case insensitve) then "UTC" is
 * returned.
 *
 * It first uses the data in the timezonemap.h file to find a matching
 * abbreviation/GMT offset combination. If not found, it uses the data in
 * fallbackmap.h to match only the GMT offset/isdst flag to try to find a
 * match. If nothing is found, NULL is returned.
 *
 * The returned char* is not duplicated, and should not be freed.
 */
char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst);

/* Returns an array of known time zone abbreviations
 *
 * This file is generated from the time zone database through the
 * gettzmapping.php scripts, which requires that an up-to-date time zone
 * database is used with the PHP binary that runs the script.
 *
 * Each item in the returned list contains the abbreviation, a flag whether
 * it's an abbreviation used with DST, the UTC offset in seconds, and the name
 * of the time zone identifier that this abbreviation belongs to.
 *
 * The order for each specific abbreviation is controlled through the
 * preference list in the gettzmapping.php script. Time zones that match the
 * pattern ±\d{2,4} are excluded
 */
const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void);

/**
 * DEPRECATED, but still used by PHP.
 */
timelib_long timelib_parse_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper);

/* From parse_iso_intervals.re */

/**
 * Parses a subset of an ISO 8601 intervals specification string into its
 * constituent parts.
 *
 * If the **errors points to a timelib_error_container variable, warnings
 * and errors will be recorded. You are responsible for freeing the stored
 * information with timelib_error_container_dtor(). To see whether errors have
 * occured, inspect errors->errors_count. To see whether warnings have occured,
 * inspect errors->warnings_count.
 */
void timelib_strtointerval(char *s, size_t len,
                           timelib_time **begin, timelib_time **end,
						   timelib_rel_time **period, int *recurrences,
						   timelib_error_container **errors);


/* From tm2unixtime.c */

/**
 * Uses the y/m/d/h/i/s fields to calculate and store the equivalent timestamp
 * in the sse field.
 *
 * It uses the time zone information associated with 'time' to account for the
 * right UTC offset and/or DST rules. You can associate time zone information
 * with the timelib_set_timezone_* functions (see below).
 *
 * If the type is 'TIMELIB_ZONETYPE_ID' and there is no associated tzinfo, it
 * will use the second argument 'tzi' to provide the rules necessary to
 * calculate the right timestamp.
 */
void timelib_update_ts(timelib_time* time, timelib_tzinfo* tzi);

/**
 * Takes the information from the y/m/d/h/i/s fields and makes sure their
 * values are in the right range.
 *
 * If a value under- or overflows it will adjust the larger measure up (or
 * down). It also takes into account leap days.
 */
void timelib_do_normalize(timelib_time *base);

/**
 * Takes the information from the y/m/d/h/i/s fields of 'rt' and makes sure
 * their values are in the right range.
 *
 * If a value under- or overflows it will adjust the larger measure up (or
 * down). As this function operates on a *relative date/time*, it also takes
 * into account leap days and correctly accounts for the difference depending
 * on the base date/time in 'base'.
 */
void timelib_do_rel_normalize(timelib_time *base, timelib_rel_time *rt);

/* From unixtime2tm.c */

/**
 * Takes the unix timestamp in seconds from 'ts' and populates the y/m/d/h/i/s
 * fields of 'tm' without taking time zones into account
 */
void timelib_unixtime2gmt(timelib_time* tm, timelib_sll ts);

/**
 * Takes the Unix timestamp from 'ts', and calculates the y/m/d/h/i/s fields
 * according to the time zone information attached to 'tm'.
 */
void timelib_unixtime2local(timelib_time *tm, timelib_sll ts);

/**
 * Takes the Unix timestamp stored in 'tm', and calculates the y/m/d/h/i/s
 * fields according to the time zone information attached to 'tm'.
 */
void timelib_update_from_sse(timelib_time *tm);

/**
 * Attaches the UTC offset as time zone information to 't'.
 *
 * 'utc_offset' is in seconds East of UTC.
 */
void timelib_set_timezone_from_offset(timelib_time *t, timelib_sll utc_offset);

/**
 * Attaches the information from 'abbr_info' as time zone information to 't'.
 *
 * The timelib_abbr_info struct contains an abbreviation ('abbr') which string
 * value is duplicated, as well as a 'utc_offset' and 'dst' flag. It only
 * supports a 'dst' change over of 1 hour.
 */
void timelib_set_timezone_from_abbr(timelib_time *t, timelib_abbr_info abbr_info);

/**
 * Attaches the time zone information in 'tz' to to 't'.
 *
 * It fetches the right UTC offset that is currently stored in the time
 * stamp field in 't' ('sse'), and assigns that to the 'z' field and 'dst'
 * field (whether DST is in effect at the time). It also sets the current
 * abbrevation to the 'tz_addr' field, making sure that if a value was already
 * set it was freed.
 *
 * The time zone information in 'tz' is *not* duplicated into the 't' field so
 * it should not be freed until all timelib_time* variables have been freed as
 * well.
 */
void timelib_set_timezone(timelib_time *t, timelib_tzinfo *tz);

/* From parse_tz.c */

/**
 * Returns whether the time zone ID 'timezone' is available in the time zone
 * database as pointed to be 'tzdb'.
 */
int timelib_timezone_id_is_valid(char *timezone, const timelib_tzdb *tzdb);

/**
 * Converts the binary stored time zone information from 'tzdb' for the time
 * zone 'timeozne' into a structure the library can use for calculations.
 *
 * The function can be used on both timelib_builtin_db as well as a time zone
 * db as opened by timelib_zoneinfo.
 * The function will return null upon failure, and also set an error code
 * through 'error_code'. 'error_code' must not be a null pointer. The error
 * code is one of the TIMELIB_ERROR_* constants as listed above. These error
 * constants can be converted into a string by timelib_get_error_message.
 *
 * This function allocates memory for the new time zone structure, which must
 * be freed after use. Although it is recommended that a cache of each used
 * time zone is kept.
 */
timelib_tzinfo *timelib_parse_tzfile(char *timezone, const timelib_tzdb *tzdb, int *error_code);

/**
 * Frees up the resources allocated by 'timelib_parse_tzfile'.
 */
void timelib_tzinfo_dtor(timelib_tzinfo *tz);

/**
 * Deep-clones a timelib_tzinfo structure.
 *
 * This allocates resources that need to be freed with 'timelib_tzinfo_dtor'
 */
timelib_tzinfo* timelib_tzinfo_clone(timelib_tzinfo *tz);

/**
 * Returns whether DST is active with time zone 'tz' for the time stamp 'ts'.
 *
 * Returns 0 if DST is not active, 1 if DST is active, or -1 if no transitions
 * were available through 'tz'.
 */
int timelib_timestamp_is_in_dst(timelib_sll ts, timelib_tzinfo *tz);

/**
 * Returns offset information with time zone 'tz' for the time stamp 'ts'.
 *
 * The returned information contains: the offset in seconds East of UTC (in
 * 'offset'), whether DST is active ('is_dst'), what the current time zone
 * abbreviation is ('abbr') and the transition time that got to this state (in
 * 'transistion_time');
 */
timelib_time_offset *timelib_get_time_zone_info(timelib_sll ts, timelib_tzinfo *tz);

/**
 * Returns the UTC offset currently applicable for the information stored in 't'.
 *
 * The value returned is the UTC offset in seconds East.
 */
timelib_sll timelib_get_current_offset(timelib_time *t);

/**
 * Displays debugging information about the time zone information in 'tz'.
 */
void timelib_dump_tzinfo(timelib_tzinfo *tz);

/**
 * Returns a pointer to the built-in time zone database.
 *
 * You must *not* free the returned pointer as it is part of the text segment.
 */
const timelib_tzdb *timelib_builtin_db(void);

/**
 * Returns a pointer to the start of an array containing a list of timezone identifiers.
 *
 * The amount of entries in the array is returned through the 'count' OUT parameter.
 *
 * Each entry contains the time zone ID ('id' field), and the position within the time zone
 * information ('pos' field). The pos field should not be used.
 */
const timelib_tzdb_index_entry *timelib_timezone_identifiers_list(const timelib_tzdb *tzdb, int *count);

/* From parse_zoneinfo.c */

/**
 * Scans the directory and subdirectories of 'directory' for valid time zone files and builds
 * a time zone database out of these files.
 *
 * Typically, the directory should point to '/usr/share/zoneinfo'.
 *
 * Unlike 'timelib_builtin_db', the return value of this function must be freed
 * with the 'timelib_zoneinfo_dtor' function.
 */
timelib_tzdb *timelib_zoneinfo(char *directory);

/**
 * Frees up the resources as created through 'timelib_