ple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 *
 * The author of this file:
 *
 */
/*
 * The source code included in this files was separated from mbfilter.h
 * by Moriyoshi Koizumi <moriyoshi@php.net> on 20 Dec 2002. The file
 * mbfilter.h is included in this package .
 *
 */

#ifndef MBFL_MEMORY_DEVICE_H
#define MBFL_MEMORY_DEVICE_H

#include "mbfl_defs.h"
#include "mbfl_string.h"

#define MBFL_MEMORY_DEVICE_ALLOC_SIZE	64

typedef struct _mbfl_memory_device {
	unsigned char *buffer;
	int length;
	int pos;
	int allocsz;
} mbfl_memory_device;

typedef struct _mbfl_wchar_device {
	unsigned int *buffer;
	int length;
	int pos;
	int allocsz;
} mbfl_wchar_device;

MBFLAPI extern void mbfl_memory_device_init(mbfl_memory_device *device, int initsz, int allocsz);
MBFLAPI extern void mbfl_memory_device_realloc(mbfl_memory_device *device, int initsz, int allocsz);
MBFLAPI extern void mbfl_memory_device_clear(mbfl_memory_device *device);
MBFLAPI extern void mbfl_memory_device_reset(mbfl_memory_device *device);
MBFLAPI extern mbfl_string * mbfl_memory_device_result(mbfl_memory_device *device, mbfl_string *result);
MBFLAPI extern void mbfl_memory_device_unput(mbfl_memory_device *device);
MBFLAPI extern int mbfl_memory_device_output(int c, void *data);
MBFLAPI extern int mbfl_memory_device_output2(int c, void *data);
MBFLAPI extern int mbfl_memory_device_output4(int c, void *data);
MBFLAPI extern int mbfl_memory_device_strcat(mbfl_memory_device *device, const char *psrc);
MBFLAPI extern int mbfl_memory_device_strncat(mbfl_memory_device *device, const char *psrc, int len);
MBFLAPI extern int mbfl_memory_device_devcat(mbfl_memory_device *dest, mbfl_memory_device *src);

MBFLAPI extern void mbfl_wchar_device_init(mbfl_wchar_device *device);
MBFLAPI extern int mbfl_wchar_device_output(int c, void *data);
MBFLAPI extern void mbfl_wchar_device_clear(mbfl_wchar_device *device);



#endif /* MBFL_MEMORY_DEVICE_H */
PK       ! e    .  php/ext/mbstring/libmbfl/mbfl/mbfilter_wchar.hnu [        /*
 * "streamable kanji code filter and converter"
 * Copyright (c) 1998-2002 HappySize, Inc. All rights reserved.
 *
 * LICENSE NOTICES
 *
 * This file is part of "streamable kanji code filter and converter",
 * which is distributed under the terms of GNU Lesser General Public
 * License (version 2) as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with "streamable kanji code filter and converter";
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 *
 * The author of this file:
 *
 */
/*
 * The source code included in this files was separated from mbfilter.c
 * by Moriyoshi Koizumi <moriyoshi@php.net> on 20 Dec 2002. The file
 * mbfilter.c is included in this package .
 *
 */

#ifndef MBFL_MBFILTER_WCHAR_H
#define MBFL_MBFILTER_WCHAR_H

#include "mbfl_defs.h"
#include "mbfilter.h"

MBFLAPI extern const mbfl_encoding mbfl_encoding_wchar;

#endif /* MBFL_MBFILTER_WCHAR_H */
PK       ! _9  9  +  php/ext/mbstring/libmbfl/mbfl/mbfl_consts.hnu [        /*
 * "streamable kanji code filter and converter"
 * Copyright (c) 1998-2002 HappySize, Inc. All rights reserved.
 *
 * LICENSE NOTICES
 *
 * This file is part of "streamable kanji code filter and converter",
 * which is distributed under the terms of GNU Lesser General Public
 * License (version 2) as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with "streamable kanji code filter and converter";
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 *
 * The author of this file:
 *
 */
/*
 * The source code included in this files was separated from mbfilter.h
 * by Moriyoshi Koizumi <moriyoshi@php.net> on 20 Dec 2002. The file
 * mbfilter.h is included in this package .
 *
 */

#ifndef MBFL_CONSTS_H
#define MBFL_CONSTS_H

#define MBFL_ENCTYPE_SBCS		0x00000001
#define MBFL_ENCTYPE_MBCS		0x00000002
#define MBFL_ENCTYPE_WCS2BE		0x00000010
#define MBFL_ENCTYPE_WCS2LE		0x00000020
#define MBFL_ENCTYPE_MWC2BE		0x00000040
#define MBFL_ENCTYPE_MWC2LE		0x00000080
#define MBFL_ENCTYPE_WCS4BE		0x00000100
#define MBFL_ENCTYPE_WCS4LE		0x00000200
#define MBFL_ENCTYPE_MWC4BE		0x00000400
#define MBFL_ENCTYPE_MWC4LE		0x00000800
#define MBFL_ENCTYPE_SHFTCODE	0x00001000
#define MBFL_ENCTYPE_ENC_STRM	0x00002000
#define MBFL_ENCTYPE_GL_UNSAFE	0x00004000

/* wchar plane, special character */
#define MBFL_WCSPLANE_MASK			0xffff
#define MBFL_WCSPLANE_UCS2MAX		0x00010000
#define MBFL_WCSPLANE_UTF32MAX		0x00110000
#define MBFL_WCSPLANE_SUPMIN		0x00010000
#define MBFL_WCSPLANE_SUPMAX		0x00200000
#define MBFL_WCSPLANE_JIS0213		0x70e00000		/* JIS HEX : 2121h - 7E7Eh */
#define MBFL_WCSPLANE_JIS0208		0x70e10000		/* JIS HEX : 2121h - 7E7Eh */
#define MBFL_WCSPLANE_JIS0212		0x70e20000		/* JIS HEX : 2121h - 7E7Eh */
#define MBFL_WCSPLANE_WINCP932		0x70e30000		/* JIS HEX : 2121h - 9898h */
#define MBFL_WCSPLANE_8859_1		0x70e40000		/*  00h - FFh */
#define MBFL_WCSPLANE_8859_2		0x70e50000		/*  00h - FFh */
#define MBFL_WCSPLANE_8859_3		0x70e60000		/*  00h - FFh */
#define MBFL_WCSPLANE_8859_4		0x70e70000		/*  00h - FFh */
#define MBFL_WCSPLANE_8859_5		0x70e80000		/*  00h - FFh */
#define MBFL_WCSPLANE_8859_6		0x70e90000		/*  00h - FFh */
#define MBFL_WCSPLANE_8859_7		0x70ea0000		/*  00h - FFh */
#define MBFL_WCSPLANE_8859_8		0x70eb0000		/*  00h - FFh */
#define MBFL_WCSPLANE_8859_9		0x70ec0000		/*  00h - FFh */
#define MBFL_WCSPLANE_8859_10		0x70ed0000		/*  00h - FFh */
#define MBFL_WCSPLANE_8859_13		0x70ee0000		/*  00h - FFh */
#define MBFL_WCSPLANE_8859_14		0x70ef0000		/*  00h - FFh */
#define MBFL_WCSPLANE_8859_15		0x70f00000		/*  00h - FFh */
#define MBFL_WCSPLANE_KSC5601		0x70f10000		/*  2121h - 7E7Eh */
#define MBFL_WCSPLANE_GB2312		0x70f20000		/*  2121h - 7E7Eh */
#define MBFL_WCSPLANE_WINCP936		0x70f30000		/*  2121h - 9898h */
#define MBFL_WCSPLANE_BIG5		0x70f40000		/*  2121h - 9898h */
#define MBFL_WCSPLANE_CNS11643		0x70f50000		/*  2121h - 9898h */
#define MBFL_WCSPLANE_UHC		0x70f60000		/*  8141h - fefeh */
#define MBFL_WCSPLANE_CP1251		0x70f70000
#define MBFL_WCSPLANE_CP866		0x70f80000
#define MBFL_WCSPLANE_KOI8R 		0x70f90000
#define MBFL_WCSPLANE_8859_16		0x70fa0000		/*  00h - FFh */
#define MBFL_WCSPLANE_ARMSCII8 		0x70fb0000
#define MBFL_WCSPLANE_KOI8U 		0x70fc0000
#define MBFL_WCSPLANE_CP1254	        0x70fd0000              /*  00h - FFh */
#define MBFL_WCSPLANE_CP850	        0x70fe0000              /*  00h - FFh */
#define MBFL_WCSPLANE_GB18030		0x70ff0000		/* a1a1h-e3329a35h  */
#define MBFL_WCSGROUP_MASK                0xffffff
#define MBFL_WCSGROUP_UCS4MAX		0x70000000
#define MBFL_WCSGROUP_WCHARMAX		0x78000000
#define MBFL_WCSGROUP_THROUGH		0x78000000		/* 000000h - FFFFFFh */

#define MBFL_QPRINT_STS_MIME_HEADER 0x1000000
#define MBFL_BASE64_STS_MIME_HEADER 0x1000000

#endif /* MBFL_CONSTS_H */
PK       ! {8  8  -  php/ext/mbstring/libmbfl/mbfl/mbfl_language.hnu [        /*
 * "streamable kanji code filter and converter"
 * Copyright (c) 1998-2002 HappySize, Inc. All rights reserved.
 *
 * LICENSE NOTICES
 *
 * This file is part of "streamable kanji code filter and converter",
 * which is distributed under the terms of GNU Lesser General Public
 * License (version 2) as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with "streamable kanji code filter and converter";
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 *
 * The author of this file:
 *
 */
/*
 * The source code included in this files was separated from mbfilter.h
 * by Moriyoshi Koizumi <moriyoshi@php.net> on 20 Dec 2002. The file
 * mbfilter.h is included in this package .
 *
 */

#ifndef MBFL_LANGUAGE_H
#define MBFL_LANGUAGE_H

#include "mbfl_defs.h"
#include "mbfl_encoding.h"

enum mbfl_no_language {
	mbfl_no_language_invalid = -1,
	mbfl_no_language_neutral,
	mbfl_no_language_uni,
	mbfl_no_language_min,
	mbfl_no_language_catalan,		/* ca */
	mbfl_no_language_danish,		/* da */
	mbfl_no_language_german,		/* de */
	mbfl_no_language_english,		/* en */
	mbfl_no_language_estonian,		/* et */
	mbfl_no_language_greek,			/* el */
	mbfl_no_language_spanish,		/* es */
	mbfl_no_language_french,		/* fr */
	mbfl_no_language_italian,		/* it */
	mbfl_no_language_japanese,		/* ja */
	mbfl_no_language_korean,		/* ko */
	mbfl_no_language_dutch,			/* nl */
	mbfl_no_language_polish,		/* pl */
	mbfl_no_language_portuguese,	        /* pt */
	mbfl_no_language_swedish,		/* sv */
	mbfl_no_language_simplified_chinese,		/* zh-cn */
	mbfl_no_language_traditional_chinese,		/* zh-tw */
	mbfl_no_language_russian,		/* ru */
	mbfl_no_language_ukrainian,		/* ua */
	mbfl_no_language_armenian,		/* hy */
	mbfl_no_language_turkish,		/* tr */
	mbfl_no_language_max
};

typedef enum mbfl_no_language mbfl_language_id;

/*
 * language
 */
typedef struct _mbfl_language {
	enum mbfl_no_language no_language;
	const char *name;
	const char *short_name;
	const char *(*aliases)[];
	enum mbfl_no_encoding mail_charset;
	enum mbfl_no_encoding mail_header_encoding;
	enum mbfl_no_encoding mail_body_encoding;
} mbfl_language;

MBFLAPI extern const mbfl_language * mbfl_name2language(const char *name);
MBFLAPI extern const mbfl_language * mbfl_no2language(enum mbfl_no_language no_language);
MBFLAPI extern enum mbfl_no_language mbfl_name2no_language(const char *name);
MBFLAPI extern const char * mbfl_no_language2name(enum mbfl_no_language no_language);


#endif /* MBFL_LANGUAGE_H */
PK       ! 9  9  )  php/ext/mbstring/libmbfl/mbfl/mbfl_defs.hnu [        /*
 * "streamable kanji code filter and converter"
 * Copyright (c) 1998-2002 HappySize, Inc. All rights reserved.
 *
 * LICENSE NOTICES
 *
 * This file is part of "streamable kanji code filter and converter",
 * which is distributed under the terms of GNU Lesser General Public
 * License (version 2) as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with "streamable kanji code filter and converter";
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 *
 * The author of this file:
 *
 */
/*
 * The source code included in this files was separated from mbfilter.h
 * by Moriyoshi Koizumi <moriyoshi@php.net> on 20 Dec 2002. The file
 * mbfilter.h is included in this package .
 *
 */

#ifndef MBFL_DEFS_H
#define MBFL_DEFS_H

#ifndef NULL
#ifdef __cplusplus
#define NULL (0L)
#else
#define NULL (void *)(0L)
#endif
#endif

#ifdef WIN32
#ifdef MBFL_DLL_EXPORT
#define MBFLAPI __declspec(dllexport)
#else
#define MBFLAPI __declspec(dllimport)
#endif /* MBFL_DLL_EXPORT */
#else
#if defined(__GNUC__) && __GNUC__ >= 4
#define MBFLAPI __attribute__((visibility("default")))
#else
#define MBFLAPI
#endif /* defined(__GNUC__) && __GNUC__ >= 4 */
#endif /* WIN32 */

#endif /* MBFL_DEFS_H */
PK       ! r(  r(  (  php/ext/mbstring/libmbfl/mbfl/mbfilter.hnu [        /* charset=UTF-8
 * vim: encoding=utf-8:
 * */

/*
 * "streamable kanji code filter and converter"
 *
 * Copyright (c) 1998,1999,2000,2001 HappySize, Inc. All rights reserved.
 *
 * This software is released under the GNU Lesser General Public License.
 * (Version 2.1, February 1999)
 * Please read the following detail of the licence (in japanese).
 *
 * ◆使用許諾条件◆
 *
 * このソフトウェアは株式会社ハッピーサイズによって開発されました。株式会社ハッ
 * ピーサイズは、著作権法および万国著作権条約の定めにより、このソフトウェアに関
 * するすべての権利を留保する権利を持ち、ここに行使します。株式会社ハッピーサイ
 * ズは以下に明記した条件に従って、このソフトウェアを使用する排他的ではない権利
 * をお客様に許諾します。何人たりとも、以下の条件に反してこのソフトウェアを使用
 * することはできません。
 *
 * このソフトウェアを「GNU Lesser General Public License (Version 2.1, February
 * 1999)」に示された条件で使用することを、全ての方に許諾します。「GNU Lesser
 * General Public License」を満たさない使用には、株式会社ハッピーサイズから書面
 * による許諾を得る必要があります。
 *
 * 「GNU Lesser General Public License」の全文は以下のウェブページから取得でき
 * ます。「GNU Lesser General Public License」とは、これまでLibrary General
 * Public Licenseと呼ばれていたものです。
 *     http://www.gnu.org/ --- GNUウェブサイト
 *     http://www.gnu.org/copyleft/lesser.html --- ライセンス文面
 * このライセンスの内容がわからない方、守れない方には使用を許諾しません。
 *
 * しかしながら、当社とGNUプロジェクトとの特定の関係を示唆または主張するもので
 * はありません。
 *
 * ◆保証内容◆
 *
 * このソフトウェアは、期待された動作・機能・性能を持つことを目標として設計され
 * 開発されていますが、これを保証するものではありません。このソフトウェアは「こ
 * のまま」の状態で提供されており、たとえばこのソフトウェアの有用性ないし特定の
 * 目的に合致することといった、何らかの保証内容が、明示されたり暗黙に示されてい
 * る場合であっても、その保証は無効です。このソフトウェアを使用した結果ないし使
 * 用しなかった結果によって、直接あるいは間接に受けた身体的な傷害、財産上の損害
 * 、データの損失あるいはその他の全ての損害については、その損害の可能性が使用者
 * 、当社あるいは第三者によって警告されていた場合であっても、当社はその損害の賠
 * 償および補填を行いません。この規定は他の全ての、書面上または書面に無い保証・
 * 契約・規定に優先します。
 *
 * ◆著作権者の連絡先および使用条件についての問い合わせ先◆
 *
 * 〒102-0073
 * 東京都千代田区九段北1-13-5日本地所第一ビル4F
 * 株式会社ハッピーサイズ
 * Phone: 03-3512-3655, Fax: 03-3512-3656
 * Email: sales@happysize.co.jp
 * Web: http://happysize.com/
 *
 * ◆著者◆
 *
 * 金本　茂 <sgk@happysize.co.jp>
 *
 * ◆履歴◆
 *
 * 1998/11/10 sgk implementation in C++
 * 1999/4/25  sgk Cで書きなおし。
 * 1999/4/26  sgk 入力フィルタを実装。漢字コードを推定しながらフィルタを追加。
 * 1999/6/??      Unicodeサポート。
 * 1999/6/22  sgk ライセンスをLGPLに変更。
 *
 */

/*
 * Unicode support
 *
 * Portions copyright (c) 1999,2000,2001 by the PHP3 internationalization team.
 * All rights reserved.
 *
 */

/*
 *
 * streamable kanji code filter and converter
 *    mbfl : Multi Byte FiLter Liblary
 *
 */

#ifndef MBFL_MBFILTER_H
#define MBFL_MBFILTER_H

#include "mbfl_defs.h"
#include "mbfl_consts.h"
#include "mbfl_allocators.h"
#include "mbfl_encoding.h"
#include "mbfl_language.h"
#include "mbfl_string.h"
#include "mbfl_convert.h"
#include "mbfl_ident.h"

/*
 * version information
 */
#define MBFL_VERSION_MAJOR 1
#define MBFL_VERSION_MINOR 3
#define MBFL_VERSION_TEENY 2

/*
 * convert filter
 */
#define MBFL_OUTPUTFILTER_ILLEGAL_MODE_NONE 0
#define MBFL_OUTPUTFILTER_ILLEGAL_MODE_CHAR 1
#define MBFL_OUTPUTFILTER_ILLEGAL_MODE_LONG 2
#define MBFL_OUTPUTFILTER_ILLEGAL_MODE_ENTITY 3

/*
 * convenience macros
 */
#ifndef MIN
#define MIN(a,b) ((a)<(b)?(a):(b))
#endif

/*
 * buffering converter
 */
typedef struct _mbfl_buffer_converter mbfl_buffer_converter;

struct _mbfl_buffer_converter {
	mbfl_convert_filter *filter1;
	mbfl_convert_filter *filter2;
	mbfl_memory_device device;
	const mbfl_encoding *from;
	const mbfl_encoding *to;
};

MBFLAPI extern mbfl_buffer_converter * mbfl_buffer_converter_new(enum mbfl_no_encoding from, enum mbfl_no_encoding to, int buf_initsz);
MBFLAPI extern mbfl_buffer_converter * mbfl_buffer_converter_new2(const mbfl_encoding *from, const mbfl_encoding *to, int buf_initsz);
MBFLAPI extern void mbfl_buffer_converter_delete(mbfl_buffer_converter *convd);
MBFLAPI extern void mbfl_buffer_converter_reset(mbfl_buffer_converter *convd);
MBFLAPI extern int mbfl_buffer_converter_illegal_mode(mbfl_buffer_converter *convd, int mode);
MBFLAPI extern int mbfl_buffer_converter_illegal_substchar(mbfl_buffer_converter *convd, int substchar);
MBFLAPI extern int mbfl_buffer_converter_strncat(mbfl_buffer_converter *convd, const unsigned char *p, int n);
MBFLAPI extern int mbfl_buffer_converter_feed(mbfl_buffer_converter *convd, mbfl_string *string);
MBFLAPI extern int mbfl_buffer_converter_feed2(mbfl_buffer_converter *convd, mbfl_string *string, int *loc);
MBFLAPI extern int mbfl_buffer_converter_flush(mbfl_buffer_converter *convd);
MBFLAPI extern mbfl_string * mbfl_buffer_converter_getbuffer(mbfl_buffer_converter *convd, mbfl_string *result);
MBFLAPI extern mbfl_string * mbfl_buffer_converter_result(mbfl_buffer_converter *convd, mbfl_string *result);
MBFLAPI extern mbfl_string * mbfl_buffer_converter_feed_result(mbfl_buffer_converter *convd, mbfl_string *string, mbfl_string *result);
MBFLAPI extern int mbfl_buffer_illegalchars(mbfl_buffer_converter *convd);

/*
 * encoding detector
 */
typedef struct _mbfl_encoding_detector mbfl_encoding_detector;

struct _mbfl_encoding_detector {
	mbfl_identify_filter **filter_list;
	int filter_list_size;
	int strict;
};

MBFLAPI extern mbfl_encoding_detector * mbfl_encoding_detector_new(enum mbfl_no_encoding *elist, int elistsz, int strict);
MBFLAPI extern mbfl_encoding_detector * mbfl_encoding_detector_new2(const mbfl_encoding **elist, int elistsz, int strict);
MBFLAPI extern void mbfl_encoding_detector_delete(mbfl_encoding_detector *identd);
MBFLAPI extern int mbfl_encoding_detector_feed(mbfl_encoding_detector *identd, mbfl_string *string);
MBFLAPI extern enum mbfl_no_encoding mbfl_encoding_detector_judge(mbfl_encoding_detector *identd);
MBFLAPI extern const mbfl_encoding *mbfl_encoding_detector_judge2(mbfl_encoding_detector *identd);


/*
 * encoding converter
 */
MBFLAPI extern mbfl_string *
mbfl_convert_encoding(mbfl_string *string, mbfl_string *result, enum mbfl_no_encoding toenc);


/*
 * identify encoding
 */
MBFLAPI extern const mbfl_encoding *
mbfl_identify_encoding(mbfl_string *string, enum mbfl_no_encoding *elist, int elistsz, int strict);

MBFLAPI extern const mbfl_encoding *
mbfl_identify_encoding2(mbfl_string *string, const mbfl_encoding **elist, int elistsz, int strict);
/*
 * strlen
 */
MBFLAPI extern int
mbfl_strlen(mbfl_string *string);

/*
 * oddlen
 */
MBFLAPI extern int
mbfl_oddlen(mbfl_string *string);

/*
 * strpos
 */
MBFLAPI extern int
mbfl_strpos(mbfl_string *haystack, mbfl_string *needle, int offset, int reverse);


/*
 * substr_count
 */
MBFLAPI extern int
mbfl_substr_count(mbfl_string *haystack, mbfl_string *needle);

/*
 * substr
 */
MBFLAPI extern mbfl_string *
mbfl_substr(mbfl_string *string, mbfl_string *result, int from, int length);

/*
 * strcut
 */
MBFLAPI extern mbfl_string *
mbfl_strcut(mbfl_string *string, mbfl_string *result, int from, int length);

/*
 *  strwidth
 */
MBFLAPI extern int
mbfl_strwidth(mbfl_string *string);

/*
 *  strimwidth
 */
MBFLAPI extern mbfl_string *
mbfl_strimwidth(mbfl_string *string, mbfl_string *marker, mbfl_string *result, int from, int width);

/*
 * MIME header encode
 */
struct mime_header_encoder_data;	/* forward declaration */

MBFLAPI extern struct mime_header_encoder_data *
mime_header_encoder_new(
    enum mbfl_no_encoding incode,
    enum mbfl_no_encoding outcode,
    enum mbfl_no_encoding encoding);

MBFLAPI extern void
mime_header_encoder_delete(struct mime_header_encoder_data *pe);

MBFLAPI extern int
mime_header_encoder_feed(int c, struct mime_header_encoder_data *pe);

MBFLAPI extern mbfl_string *
mime_header_encoder_result(struct mime_header_encoder_data *pe, mbfl_string *result);

MBFLAPI extern mbfl_string *
mbfl_mime_header_encode(
    mbfl_string *string, mbfl_string *result,
    enum mbfl_no_encoding outcode,
    enum mbfl_no_encoding encoding,
    const char *linefeed,
    int indent);

/*
 * MIME header decode
 */
struct mime_header_decoder_data;	/* forward declaration */

MBFLAPI extern struct mime_header_decoder_data *
mime_header_decoder_new(enum mbfl_no_encoding outcode);

MBFLAPI extern void
mime_header_decoder_delete(struct mime_header_decoder_data *pd);

MBFLAPI extern int
mime_header_decoder_feed(int c, struct mime_header_decoder_data *pd);

MBFLAPI extern mbfl_string *
mime_header_decoder_result(struct mime_header_decoder_data *pd, mbfl_string *result);

MBFLAPI extern mbfl_string *
mbfl_mime_header_decode(
    mbfl_string *string,
    mbfl_string *result,
    enum mbfl_no_encoding outcode);

/*
 * convert HTML numeric entity
 */
MBFLAPI extern mbfl_string *
mbfl_html_numeric_entity(mbfl_string *string, mbfl_string *result, int *convmap, int mapsize, int type);

/*
 * convert of harfwidth and fullwidth for japanese
 */
MBFLAPI extern mbfl_string *
mbfl_ja_jp_hantozen(mbfl_string *string, mbfl_string *result, int mode);

#endif	/* MBFL_MBFILTER_H */
PK       ! l;      php/ext/mbstring/mbstring.hnu [        /*
   +----------------------------------------------------------------------+
   | PHP Version 7                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2018 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Author: Tsukada Takuya <tsukada@fminn.nagano.nagano.jp>              |
   +----------------------------------------------------------------------+
 */

/* $Id$ */

/*
 * PHP 4 Multibyte String module "mbstring" (currently only for Japanese)
 *
 * History:
 *   2000.5.19  Release php-4.0RC2_jstring-1.0
 *   2001.4.1   Release php4_jstring-1.0.91
 *   2001.4.30  Release php4-jstring-1.1 (contribute to The PHP Group)
 *   2001.5.1   Renamed from jstring to mbstring (hirokawa@php.net)
 */

/*
 * PHP3 Internationalization support program.
 *
 * Copyright (c) 1999,2000 by the PHP3 internationalization team.
 * All rights reserved.
 *
 * See README_PHP3-i18n-ja for more detail.
 *
 * Authors:
 *    Hironori Sato <satoh@jpnnet.com>
 *    Shigeru Kanemoto <sgk@happysize.co.jp>
 *    Tsukada Takuya <tsukada@fminn.nagano.nagano.jp>
 */


#ifndef _MBSTRING_H
#define _MBSTRING_H

#ifdef COMPILE_DL_MBSTRING
#undef HAVE_MBSTRING
#define HAVE_MBSTRING 1
#endif

#include "php_version.h"
#define PHP_MBSTRING_VERSION PHP_VERSION

#ifdef PHP_WIN32
#	undef MBSTRING_API
#	ifdef MBSTRING_EXPORTS
#		define MBSTRING_API __declspec(dllexport)
#	elif defined(COMPILE_DL_MBSTRING)
#		define MBSTRING_API __declspec(dllimport)
#	else
#		define MBSTRING_API /* nothing special */
#	endif
#elif defined(__GNUC__) && __GNUC__ >= 4
#	undef MBSTRING_API
#	define MBSTRING_API __attribute__ ((visibility("default")))
#else
#	undef MBSTRING_API
#	define MBSTRING_API /* nothing special */
#endif


#if HAVE_MBSTRING

#include "libmbfl/mbfl/mbfilter.h"
#include "SAPI.h"

#define PHP_MBSTRING_API 20021024

extern zend_module_entry mbstring_module_entry;
#define mbstring_module_ptr &mbstring_module_entry

PHP_MINIT_FUNCTION(mbstring);
PHP_MSHUTDOWN_FUNCTION(mbstring);
PHP_RINIT_FUNCTION(mbstring);
PHP_RSHUTDOWN_FUNCTION(mbstring);
PHP_MINFO_FUNCTION(mbstring);

/* functions in php_unicode.c */
PHP_FUNCTION(mb_convert_case);
PHP_FUNCTION(mb_strtoupper);
PHP_FUNCTION(mb_strtolower);

/* php function registration */
PHP_FUNCTION(mb_language);
PHP_FUNCTION(mb_internal_encoding);
PHP_FUNCTION(mb_http_input);
PHP_FUNCTION(mb_http_output);
PHP_FUNCTION(mb_detect_order);
PHP_FUNCTION(mb_substitute_character);
PHP_FUNCTION(mb_preferred_mime_name);
PHP_FUNCTION(mb_parse_str);
PHP_FUNCTION(mb_output_handler);
PHP_FUNCTION(mb_strlen);
PHP_FUNCTION(mb_strpos);
PHP_FUNCTION(mb_strrpos);
PHP_FUNCTION(mb_stripos);
PHP_FUNCTION(mb_strripos);
PHP_FUNCTION(mb_strstr);
PHP_FUNCTION(mb_strrchr);
PHP_FUNCTION(mb_stristr);
PHP_FUNCTION(mb_strrichr);
PHP_FUNCTION(mb_substr_count);
PHP_FUNCTION(mb_substr);
PHP_FUNCTION(mb_strcut);
PHP_FUNCTION(mb_strwidth);
PHP_FUNCTION(mb_strimwidth);
PHP_FUNCTION(mb_convert_encoding);
PHP_FUNCTION(mb_detect_encoding);
PHP_FUNCTION(mb_list_encodings);
PHP_FUNCTION(mb_encoding_aliases);
PHP_FUNCTION(mb_convert_kana);
PHP_FUNCTION(mb_encode_mimeheader);
PHP_FUNCTION(mb_decode_mimeheader);
PHP_FUNCTION(mb_convert_variables);
PHP_FUNCTION(mb_encode_numericentity);
PHP_FUNCTION(mb_decode_numericentity);
PHP_FUNCTION(mb_send_mail);
PHP_FUNCTION(mb_get_info);
PHP_FUNCTION(mb_check_encoding);
PHP_FUNCTION(mb_ord);
PHP_FUNCTION(mb_chr);
PHP_FUNCTION(mb_scrub);


MBSTRING_API char *php_mb_safe_strrchr_ex(const char *s, unsigned int c,
                                    size_t nbytes, const mbfl_encoding *enc);
MBSTRING_API char *php_mb_safe_strrchr(const char *s, unsigned int c,
                                 size_t nbytes);

MBSTRING_API char * php_mb_convert_encoding(const char *input, size_t length,
                                      const char *_to_encoding,
                                      const char *_from_encodings,
                                      size_t *output_len);

MBSTRING_API int php_mb_check_encoding_list(const char *encoding_list);

MBSTRING_API size_t php_mb_mbchar_bytes_ex(const char *s, const mbfl_encoding *enc);
MBSTRING_API size_t php_mb_mbchar_bytes(const char *s);

MBSTRING_API int php_mb_encoding_detector_ex(const char *arg_string, int arg_length,
											 char *arg_list);

MBSTRING_API int php_mb_encoding_converter_ex(char **str, int *len, const char *encoding_to,
											  const char *encoding_from);
MBSTRING_API int php_mb_stripos(int mode, const char *old_haystack, unsigned int old_haystack_len, const char *old_needle, unsigned int old_needle_len, long offset, const char *from_encoding);
MBSTRING_API int php_mb_check_encoding(const char *input, size_t length, const char *enc);

/* internal use only */
int _php_mb_ini_mbstring_internal_encoding_set(const char *new_value, uint32_t new_value_length);

ZEND_BEGIN_MODULE_GLOBALS(mbstring)
	char *internal_encoding_name;
	enum mbfl_no_language language;
	const mbfl_encoding *internal_encoding;
	const mbfl_encoding *current_internal_encoding;
	const mbfl_encoding *http_output_encoding;
	const mbfl_encoding *current_http_output_encoding;
	const mbfl_encoding *http_input_identify;
	const mbfl_encoding *http_input_identify_get;
	const mbfl_encoding *http_input_identify_post;
	const mbfl_encoding *http_input_identify_cookie;
	const mbfl_encoding *http_input_identify_string;
	const mbfl_encoding **http_input_list;
	size_t http_input_list_size;
	const mbfl_encoding **detect_order_list;
	size_t detect_order_list_size;
	const mbfl_encoding **current_detect_order_list;
	size_t current_detect_order_list_size;
	enum mbfl_no_encoding *default_detect_order_list;
	size_t default_detect_order_list_size;
	int filter_illegal_mode;
	int filter_illegal_substchar;
	int current_filter_illegal_mode;
	int current_filter_illegal_substchar;
	long func_overload;
	zend_bool encoding_translation;
	long strict_detection;
	long illegalchars;
	mbfl_buffer_converter *outconv;
    void *http_output_conv_mimetypes;
#if HAVE_MBREGEX
    struct _zend_mb_regex_globals *mb_regex_globals;
#endif
ZEND_END_MODULE_GLOBALS(mbstring)

#define MB_OVERLOAD_MAIL 1
#define MB_OVERLOAD_STRING 2
#define MB_OVERLOAD_REGEX 4

struct mb_overload_def {
	int type;
	char *orig_func;
	char *ovld_func;
	char *save_func;
};

#define MBSTRG(v) ZEND_MODULE_GLOBALS_ACCESSOR(mbstring, v)

#if defined(ZTS) && defined(COMPILE_DL_MBSTRING)
ZEND_TSRMLS_CACHE_EXTERN()
#endif

#else	/* HAVE_MBSTRING */

#define mbstring_module_ptr NULL

#endif	/* HAVE_MBSTRING */

#define phpext_mbstring_ptr mbstring_module_ptr

#endif		/* _MBSTRING_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
PK       ! W0
  
    php/ext/pdo/php_pdo.hnu [        /*
  +----------------------------------------------------------------------+
  | PHP Version 7                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2018 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Wez Furlong <wez@php.net>                                    |
  +----------------------------------------------------------------------+
*/

/* $Id$ */

#ifndef PHP_PDO_H
#define PHP_PDO_H

#include "zend.h"

extern zend_module_entry pdo_module_entry;
#define phpext_pdo_ptr &pdo_module_entry

#include "php_version.h"
#define PHP_PDO_VERSION PHP_VERSION

#ifdef PHP_WIN32
#	if defined(PDO_EXPORTS) || (!defined(COMPILE_DL_PDO))
#		define PDO_API __declspec(dllexport)
#	elif defined(COMPILE_DL_PDO)
#		define PDO_API __declspec(dllimport)
#	else
#		define PDO_API /* nothing special */
#	endif
#elif defined(__GNUC__) && __GNUC__ >= 4
#	define PDO_API __attribute__ ((visibility("default")))
#else
#	define PDO_API /* nothing special */
#endif

#ifdef ZTS
# include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(pdo);
PHP_MSHUTDOWN_FUNCTION(pdo);
PHP_MINFO_FUNCTION(pdo);

ZEND_BEGIN_MODULE_GLOBALS(pdo)
	zend_long  global_value;
ZEND_END_MODULE_GLOBALS(pdo)

#ifdef ZTS
# define PDOG(v) TSRMG(pdo_globals_id, zend_pdo_globals *, v)
#else
# define PDOG(v) (pdo_globals.v)
#endif

#define REGISTER_PDO_CLASS_CONST_LONG(const_name, value) \
	zend_declare_class_constant_long(php_pdo_get_dbh_ce(), const_name, sizeof(const_name)-1, (zend_long)value);

#define REGISTER_PDO_CLASS_CONST_STRING(const_name, value) \
	zend_declare_class_constant_stringl(php_pdo_get_dbh_ce(), const_name, sizeof(const_name)-1, value, sizeof(value)-1);

#define PDO_CONSTRUCT_CHECK	\
	if (!dbh->driver) {	\
		pdo_raise_impl_error(dbh, NULL, "00000", "PDO constructor was not called");	\
		return;	\
	}	\


#endif	/* PHP_PDO_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
PK       ! P`  `    php/ext/pdo/php_pdo_driver.hnu [        /*
  +----------------------------------------------------------------------+
  | PHP Version 7                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2018 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Wez Furlong <wez@php.net>                                    |
  +----------------------------------------------------------------------+
*/

/* $Id$ */

#ifndef PHP_PDO_DRIVER_H
#define PHP_PDO_DRIVER_H

#include "php_pdo.h"

/* forward declarations */
typedef struct _pdo_dbh_t 		 pdo_dbh_t;
typedef struct _pdo_dbh_object_t pdo_dbh_object_t;
typedef struct _pdo_stmt_t		 pdo_stmt_t;
typedef struct _pdo_row_t		 pdo_row_t;
struct pdo_bound_param_data;

#ifdef PHP_WIN32
typedef __int64 pdo_int64_t;
typedef unsigned __int64 pdo_uint64_t;
#else
typedef long long int pdo_int64_t;
typedef unsigned long long int pdo_uint64_t;
#endif
PDO_API char *php_pdo_int64_to_str(pdo_int64_t i64);

#ifndef TRUE
# define TRUE 1
#endif
#ifndef FALSE
# define FALSE 0
#endif

#define PDO_DRIVER_API	20170320

enum pdo_param_type {
	PDO_PARAM_NULL,

	/* int as in long (the php native int type).
	 * If you mark a column as an int, PDO expects get_col to return
	 * a pointer to a long */
	PDO_PARAM_INT,

	/* get_col ptr should point to start of the string buffer */
	PDO_PARAM_STR,

	/* get_col: when len is 0 ptr should point to a php_stream *,
	 * otherwise it should behave like a string. Indicate a NULL field
	 * value by setting the ptr to NULL */
	PDO_PARAM_LOB,

	/* get_col: will expect the ptr to point to a new PDOStatement object handle,
	 * but this isn't wired up yet */
	PDO_PARAM_STMT, /* hierarchical result set */

	/* get_col ptr should point to a zend_bool */
	PDO_PARAM_BOOL,

	/* get_col ptr should point to a zval*
	   and the driver is responsible for adding correct type information to get_column_meta()
	 */
	PDO_PARAM_ZVAL,

	/* magic flag to denote a parameter as being input/output */
	PDO_PARAM_INPUT_OUTPUT = 0x80000000,

	/* magic flag to denote a string that uses the national character set
	   see section 4.2.1 of SQL-92: http://www.contrib.andrew.cmu.edu/~shadow/sql/sql1992.txt
	 */
	PDO_PARAM_STR_NATL = 0x40000000,

	/* magic flag to denote a string that uses the regular character set */
	PDO_PARAM_STR_CHAR = 0x20000000,
};

#define PDO_PARAM_FLAGS			0xFFFF0000

#define PDO_PARAM_TYPE(x)		((x) & ~PDO_PARAM_FLAGS)

enum pdo_fetch_type {
	PDO_FETCH_USE_DEFAULT,
	PDO_FETCH_LAZY,
	PDO_FETCH_ASSOC,
	PDO_FETCH_NUM,
	PDO_FETCH_BOTH,
	PDO_FETCH_OBJ,
	PDO_FETCH_BOUND, /* return true/false only; rely on bound columns */
	PDO_FETCH_COLUMN,	/* fetch a numbered column only */
	PDO_FETCH_CLASS,	/* create an instance of named class, call ctor and set properties */
	PDO_FETCH_INTO,		/* fetch row into an existing object */
	PDO_FETCH_FUNC,		/* fetch into function and return its result */
	PDO_FETCH_NAMED,    /* like PDO_FETCH_ASSOC, but can handle duplicate names */
	PDO_FETCH_KEY_PAIR,	/* fetch into an array where the 1st column is a key and all subsequent columns are values */
	PDO_FETCH__MAX /* must be last */
};

#define PDO_FETCH_FLAGS     0xFFFF0000  /* fetchAll() modes or'd to PDO_FETCH_XYZ */
#define PDO_FETCH_GROUP     0x00010000  /* fetch into groups */
#define PDO_FETCH_UNIQUE    0x00030000  /* fetch into groups assuming first col is unique */
#define PDO_FETCH_CLASSTYPE 0x00040000  /* fetch class gets its class name from 1st column */
#define PDO_FETCH_SERIALIZE 0x00080000  /* fetch class instances by calling serialize */
#define PDO_FETCH_PROPS_LATE 0x00100000  /* fetch props after calling ctor */

/* fetch orientation for scrollable cursors */
enum pdo_fetch_orientation {
	PDO_FETCH_ORI_NEXT,		/* default: fetch the next available row */
	PDO_FETCH_ORI_PRIOR,	/* scroll back to prior row and fetch that */
	PDO_FETCH_ORI_FIRST,	/* scroll to the first row and fetch that */
	PDO_FETCH_ORI_LAST,		/* scroll to the last row and fetch that */
	PDO_FETCH_ORI_ABS,		/* scroll to an absolute numbered row and fetch that */
	PDO_FETCH_ORI_REL		/* scroll relative to the current row, and fetch that */
};

enum pdo_attribute_type {
	PDO_ATTR_AUTOCOMMIT,	/* use to turn on or off auto-commit mode */
	PDO_ATTR_PREFETCH,		/* configure the prefetch size for drivers that support it. Size is in KB */
	PDO_ATTR_TIMEOUT,		/* connection timeout in seconds */
	PDO_ATTR_ERRMODE,		/* control how errors are handled */
	PDO_ATTR_SERVER_VERSION,	/* database server version */
	PDO_ATTR_CLIENT_VERSION,	/* client library version */
	PDO_ATTR_SERVER_INFO,		/* server information */
	PDO_ATTR_CONNECTION_STATUS,	/* connection status */
	PDO_ATTR_CASE,				/* control case folding for portability */
	PDO_ATTR_CURSOR_NAME,		/* name a cursor for use in "WHERE CURRENT OF <name>" */
	PDO_ATTR_CURSOR,			/* cursor type */
	PDO_ATTR_ORACLE_NULLS,		/* convert empty strings to NULL */
	PDO_ATTR_PERSISTENT,		/* pconnect style connection */
	PDO_ATTR_STATEMENT_CLASS,	/* array(classname, array(ctor_args)) to specify the class of the constructed statement */
	PDO_ATTR_FETCH_TABLE_NAMES, /* include table names in the column names, where available */
	PDO_ATTR_FETCH_CATALOG_NAMES, /* include the catalog/db name names in the column names, where available */
	PDO_ATTR_DRIVER_NAME,		  /* name of the driver (as used in the constructor) */
	PDO_ATTR_STRINGIFY_FETCHES,	/* converts integer/float types to strings during fetch */
	PDO_ATTR_MAX_COLUMN_LEN,	/* make database calculate maximum length of data found in a column */
	PDO_ATTR_DEFAULT_FETCH_MODE, /* Set the default fetch mode */
	PDO_ATTR_EMULATE_PREPARES,  /* use query emulation rather than native */
	PDO_ATTR_DEFAULT_STR_PARAM, /* set the default string parameter type (see the PDO::PARAM_STR_* magic flags) */

	/* this defines the start of the range for driver specific options.
	 * Drivers should define their own attribute constants beginning with this
	 * value. */
	PDO_ATTR_DRIVER_SPECIFIC = 1000
};

enum pdo_cursor_type {
	PDO_CURSOR_FWDONLY,		/* forward only cursor (default) */
	PDO_CURSOR_SCROLL		/* scrollable cursor */
};

/* SQL-92 SQLSTATE error codes.

The character string value returned for an SQLSTATE consists of a two-character
class value followed by a three-character subclass value. A class value of 01
indicates a warning and is accompanied by a return code of
SQL_SUCCESS_WITH_INFO.

Class values other than '01', except for the class 'IM',
indicate an error and are accompanied by a return code of SQL_ERROR. The class
'IM' is specific to warnings and errors that derive from the implementation of
ODBC itself.

The subclass value '000' in any class indicates that there is no
subclass for that SQLSTATE. The assignment of class and subclass values is
defined by SQL-92.
*/

typedef char pdo_error_type[6]; /* SQLSTATE */


#define PDO_ERR_NONE				"00000"

enum pdo_error_mode {
	PDO_ERRMODE_SILENT,		/* just set error codes */
	PDO_ERRMODE_WARNING,	/* raise E_WARNING */
	PDO_ERRMODE_EXCEPTION	/* throw exceptions */
};

enum pdo_case_conversion {
	PDO_CASE_NATURAL,
	PDO_CASE_UPPER,
	PDO_CASE_LOWER
};

/* oracle interop settings */
enum pdo_null_handling {
	PDO_NULL_NATURAL = 0,
	PDO_NULL_EMPTY_STRING = 1,
	PDO_NULL_TO_STRING = 2
};

/* {{{ utils for reading attributes set as driver_options */
static inline zend_long pdo_attr_lval(zval *options, enum pdo_attribute_type option_name, zend_long defval)
{
	zval *v;

	if (options && (v = zend_hash_index_find(Z_ARRVAL_P(options), option_name))) {
		return zval_get_long(v);
	}
	return defval;
}
static inline zend_string *pdo_attr_strval(zval *options, enum pdo_attribute_type option_name, zend_string *defval)
{
	zval *v;

	if (options && (v = zend_hash_index_find(Z_ARRVAL_P(options), option_name))) {
		return zval_get_string(v);
	}
	return defval ? zend_string_copy(defval) : NULL;
}
/* }}} */

/* This structure is registered with PDO when a PDO driver extension is
 * initialized */
typedef struct {
	const char	*driver_name;
	size_t		driver_name_len;
	zend_ulong	api_version; /* needs to be compatible with PDO */

#define PDO_DRIVER_HEADER(name)	\
	#name, sizeof(#name)-1, \
	PDO_DRIVER_API

	/* create driver specific portion of the database handle and stash it into
	 * the dbh.  dbh contains the data source string and flags for this
	 * instance.  You MUST respect dbh->is_persistent and pass that flag to
	 * pemalloc() for all allocations that are stored in the dbh or your instance
	 * data in the db, otherwise you will crash PHP when persistent connections
	 * are used.
	 */
	int (*db_handle_factory)(pdo_dbh_t *dbh, zval *driver_options);

} pdo_driver_t;

/* {{{ methods for a database handle */

/* close or otherwise disconnect the database */
typedef int (*pdo_dbh_close_func)(pdo_dbh_t *dbh);

/* prepare a statement and stash driver specific portion into stmt */
typedef int (*pdo_dbh_prepare_func)(pdo_dbh_t *dbh, const char *sql, size_t sql_len, pdo_stmt_t *stmt, zval *driver_options);

/* execute a statement (that does not return a result set) */
typedef zend_long (*pdo_dbh_do_func)(pdo_dbh_t *dbh, const char *sql, size_t sql_len);

/* quote a string */
typedef int (*pdo_dbh_quote_func)(pdo_dbh_t *dbh, const char *unquoted, size_t unquotedlen, char **quoted, size_t *quotedlen, enum pdo_param_type paramtype);

/* transaction related */
typedef int (*pdo_dbh_txn_func)(pdo_dbh_t *dbh);

/* setting of attributes */
typedef int (*pdo_dbh_set_attr_func)(pdo_dbh_t *dbh, zend_long attr, zval *val);

/* return last insert id.  NULL indicates error condition, otherwise, the return value
 * MUST be an emalloc'd NULL terminated string. */
typedef char *(*pdo_dbh_last_id_func)(pdo_dbh_t *dbh, const char *name, size_t *len);

/* fetch error information.  if stmt is not null, fetch information pertaining
 * to the statement, otherwise fetch global error information.  The driver
 * should add the following information to the array "info" in this order:
 * - native error code
 * - string representation of the error code ... any other optional driver
 *   specific data ...  */
typedef	int (*pdo_dbh_fetch_error_func)(pdo_dbh_t *dbh, pdo_stmt_t *stmt, zval *info);

/* fetching of attributes */
typedef int (*pdo_dbh_get_attr_func)(pdo_dbh_t *dbh, zend_long attr, zval *val);

/* checking/pinging persistent connections; return SUCCESS if the connection
 * is still alive and ready to be used, FAILURE otherwise.
 * You may set this handler to NULL, which is equivalent to returning SUCCESS. */
typedef int (*pdo_dbh_check_liveness_func)(pdo_dbh_t *dbh);

/* called at request end for each persistent dbh; this gives the driver
 * the opportunity to safely release resources that only have per-request
 * scope */
typedef void (*pdo_dbh_request_shutdown)(pdo_dbh_t *dbh);

/* for adding methods to the dbh or stmt objects
pointer to a list of driver specific functions. The convention is
to prefix the function names using the PDO driver name; this will
reduce the chance of collisions with future functionality in the
PDO class or in user code (they can extend the PDO object).
*/
enum {
	PDO_DBH_DRIVER_METHOD_KIND_DBH = 0,
	PDO_DBH_DRIVER_METHOD_KIND_STMT,
	PDO_DBH_DRIVER_METHOD_KIND__MAX
};

typedef const zend_function_entry *(*pdo_dbh_get_driver_methods_func)(pdo_dbh_t *dbh, int kind);

struct pdo_dbh_methods {
	pdo_dbh_close_func		closer;
	pdo_dbh_prepare_func	preparer;
	pdo_dbh_do_func			doer;
	pdo_dbh_quote_func		quoter;
	pdo_dbh_txn_func		begin;
	pdo_dbh_txn_func		commit;
	pdo_dbh_txn_func		rollback;
	pdo_dbh_set_attr_func	set_attribute;
	pdo_dbh_last_id_func		last_id;
	pdo_dbh_fetch_error_func	fetch_err;
	pdo_dbh_get_attr_func   	get_attribute;
	pdo_dbh_check_liveness_func	check_liveness;
	pdo_dbh_get_driver_methods_func get_driver_methods;
	pdo_dbh_request_shutdown	persistent_shutdown;
	pdo_dbh_txn_func		in_transaction;
};

/* }}} */

/* {{{ methods for a statement handle */

/* free the statement handle */
typedef int (*pdo_stmt_dtor_func)(pdo_stmt_t *stmt);

/* start the query */
typedef int (*pdo_stmt_execute_func)(pdo_stmt_t *stmt);

/* causes the next row in the set to be fetched; indicates if there are no
 * more rows.  The ori and offset params modify which row should be returned,
 * if the stmt represents a scrollable cursor */
typedef int (*pdo_stmt_fetch_func)(pdo_stmt_t *stmt,
	enum pdo_fetch_orientation ori, zend_long offset);

/* queries information about the type of a column, by index (0 based).
 * Driver should populate stmt->columns[colno] with appropriate info */
typedef int (*pdo_stmt_describe_col_func)(pdo_stmt_t *stmt, int colno);

/* retrieves pointer and size of the value for a column.
 * Note that PDO expects the driver to manage the lifetime of this data;
 * it will copy the value into a zval on behalf of the script.
 * If the driver sets caller_frees, ptr should point to emalloc'd memory
 * and PDO will free it as soon as it is done using it.
 */
typedef int (*pdo_stmt_get_col_data_func)(pdo_stmt_t *stmt, int colno, char **ptr, size_t *len, int *caller_frees);

/* hook for bound params */
enum pdo_param_event {
	PDO_PARAM_EVT_ALLOC,
	PDO_PARAM_EVT_FREE,
	PDO_PARAM_EVT_EXEC_PRE,
	PDO_PARAM_EVT_EXEC_POST,
	PDO_PARAM_EVT_FETCH_PRE,
	PDO_PARAM_EVT_FETCH_POST,
	PDO_PARAM_EVT_NORMALIZE
};

typedef int (*pdo_stmt_param_hook_func)(pdo_stmt_t *stmt, struct pdo_bound_param_data *param, enum pdo_param_event event_type);

/* setting of attributes */
typedef int (*pdo_stmt_set_attr_func)(pdo_stmt_t *stmt, zend_long attr, zval *val);

/* fetching of attributes */
typedef int (*pdo_stmt_get_attr_func)(pdo_stmt_t *stmt, zend_long attr, zval *val);

/* retrieves meta data for a numbered column.
 * Returns SUCCESS/FAILURE.
 * On SUCCESS, fill in return_value with an array with the following fields.
 * If a particular field is not supported, then the driver simply does not add it to
 * the array, so that scripts can use isset() to check for it.
 *
 * ### this is just a rough first cut, and subject to change ###
 *
 * these are added by PDO itself, based on data from the describe handler:
 *   name => the column name
 *   len => the length/size of the column
 *   precision => precision of the column
 *   pdo_type => an integer, one of the PDO_PARAM_XXX values
 *
 *   scale => the floating point scale
 *   table => the table for that column
 *   type => a string representation of the type, mapped to the PHP equivalent type name
 *   native_type => a string representation of the type, native style, if different from
 *                  the mapped name.
 *   flags => an array of flags including zero or more of the following:
 *            primary_key, not_null, unique_key, multiple_key, unsigned, auto_increment, blob
 *
 * Any driver specific data should be returned using a prefixed key or value.
 * Eg: custom data for the mysql driver would use either
 *   'mysql:foobar' => 'some data' // to add a new key to the array
 * or
 *   'flags' => array('not_null', 'mysql:some_flag'); // to add data to an existing key
 */
typedef int (*pdo_stmt_get_column_meta_func)(pdo_stmt_t *stmt, zend_long colno, zval *return_value);

/* advances the statement to the next rowset of the batch.
 * If it returns 1, PDO will tear down its idea of columns
 * and meta data.  If it returns 0, PDO will indicate an error
 * to the caller. */
typedef int (*pdo_stmt_next_rowset_func)(pdo_stmt_t *stmt);

/* closes the active cursor on a statement, leaving the prepared
 * statement ready for re-execution.  Useful to explicitly state
 * that you are done with a given rowset, without having to explicitly
 * fetch all the rows. */
typedef int (*pdo_stmt_cursor_closer_func)(pdo_stmt_t *stmt);

struct pdo_stmt_methods {
	pdo_stmt_dtor_func			dtor;
	pdo_stmt_execute_func		executer;
	pdo_stmt_fetch_func			fetcher;
	pdo_stmt_describe_col_func	describer;
	pdo_stmt_get_col_data_func	get_col;
	pdo_stmt_param_hook_func	param_hook;
	pdo_stmt_set_attr_func		set_attribute;
	pdo_stmt_get_attr_func		get_attribute;
	pdo_stmt_get_column_meta_func get_column_meta;
	pdo_stmt_next_rowset_func		next_rowset;
	pdo_stmt_cursor_closer_func 	cursor_closer;
};

/* }}} */

enum pdo_placeholder_support {
	PDO_PLACEHOLDER_NONE=0,
	PDO_PLACEHOLDER_NAMED=1,
	PDO_PLACEHOLDER_POSITIONAL=2
};

struct _pdo_dbh_t {
	/* driver specific methods */
	struct pdo_dbh_methods *methods;
	/* driver specific data */
	void *driver_data;

	/* credentials */
	char *username, *password;

	/* if true, then data stored and pointed at by this handle must all be
	 * persistently allocated */
	unsigned is_persistent:1;

	/* if true, driver should act as though a COMMIT were executed between
	 * each executed statement; otherwise, COMMIT must be carried out manually
	 * */
	unsigned auto_commit:1;

	/* if true, the handle has been closed and will not function anymore */
	unsigned is_closed:1;

	/* if true, the driver requires that memory be allocated explicitly for
	 * the columns that are returned */
	unsigned alloc_own_columns:1;

	/* if true, commit or rollBack is allowed to be called */
	unsigned in_txn:1;

	/* max length a single character can become after correct quoting */
	unsigned max_escaped_char_length:3;

	/* oracle compat; see enum pdo_null_handling */
	unsigned oracle_nulls:2;

	/* when set, convert int/floats to strings */
	unsigned stringify:1;

	/* the sum of the number of bits here and the bit fields preceding should
	 * equal 32 */
	unsigned _reserved_flags:21;

	/* data source string used to open this handle */
	const char *data_source;
	size_t data_source_len;

	/* the global error code. */
	pdo_error_type error_code;

	enum pdo_error_mode error_mode;

	enum pdo_case_conversion native_case, desired_case;

	/* persistent hash key associated with this handle */
	const char *persistent_id;
	size_t persistent_id_len;
	unsigned int refcount;

	/* driver specific "class" methods for the dbh and stmt */
	HashTable *cls_methods[PDO_DBH_DRIVER_METHOD_KIND__MAX];

	pdo_driver_t *driver;

	zend_class_entry *def_stmt_ce;

	zval def_stmt_ctor_args;

	/* when calling PDO::query(), we need to keep the error
	 * context from the statement around until we next clear it.
	 * This will allow us to report the correct error message
	 * when PDO::query() fails */
	pdo_stmt_t *query_stmt;
	zval query_stmt_zval;

	/* defaults for fetches */
	enum pdo_fetch_type default_fetch_type;
};

/* represents a connection to a database */
struct _pdo_dbh_object_t {
	pdo_dbh_t *inner;
	/* these items must appear in this order at the beginning of the
       struct so that this can be cast as a zend_object.  we need this
       to allow the extending class to escape all the custom handlers
	   that PDO declares.
    */
	zend_object std;
};

static inline pdo_dbh_t *php_pdo_dbh_fetch_inner(zend_object *obj) {
	return (pdo_dbh_t *)(((pdo_dbh_object_t *)((char*)(obj) - XtOffsetOf(pdo_dbh_object_t, std)))->inner);
}

static inline pdo_dbh_object_t *php_pdo_dbh_fetch_object(zend_object *obj) {
	return (pdo_dbh_object_t *)((char*)(obj) - XtOffsetOf(pdo_dbh_object_t, std));
}

#define Z_PDO_DBH_P(zv) php_pdo_dbh_fetch_inner(Z_OBJ_P((zv)))
#define Z_PDO_OBJECT_P(zv) php_pdo_dbh_fetch_object(Z_OBJ_P((zv)))

/* describes a column */
struct pdo_column_data {
	zend_string *name;
	size_t maxlen;
	zend_ulong precision;
	enum pdo_param_type param_type;
};

/* describes a bound parameter */
struct pdo_bound_param_data {
	zval parameter;				/* the variable itself */

	zval driver_params;			/* optional parameter(s) for the driver */

	zend_long paramno; /* if -1, the