if (UNEXPECTED(!(test))) { \
			zend_restore_error_handling(&__zeh); \
			fail; \
		} \
		zend_restore_error_handling(&__zeh); \
	} while(0)

PHP_HTTP_API zend_class_entry *php_http_get_exception_interface_class_entry(void);
PHP_HTTP_API zend_class_entry *php_http_get_exception_runtime_class_entry(void);
PHP_HTTP_API zend_class_entry *php_http_get_exception_unexpected_val_class_entry(void);
PHP_HTTP_API zend_class_entry *php_http_get_exception_bad_method_call_class_entry(void);
PHP_HTTP_API zend_class_entry *php_http_get_exception_invalid_arg_class_entry(void);
PHP_HTTP_API zend_class_entry *php_http_get_exception_bad_header_class_entry(void);
PHP_HTTP_API zend_class_entry *php_http_get_exception_bad_url_class_entry(void);
PHP_HTTP_API zend_class_entry *php_http_get_exception_bad_message_class_entry(void);
PHP_HTTP_API zend_class_entry *php_http_get_exception_bad_conversion_class_entry(void);
PHP_HTTP_API zend_class_entry *php_http_get_exception_bad_querystring_class_entry(void);

PHP_MINIT_FUNCTION(http_exception);

#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */

PK       !  )  )    php/ext/http/php_http_buffer.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_BUFFER_H
#define PHP_HTTP_BUFFER_H

#ifndef PHP_HTTP_BUFFER_DEFAULT_SIZE
#	define PHP_HTTP_BUFFER_DEFAULT_SIZE 256
#endif

#define PHP_HTTP_BUFFER_ERROR ((size_t) -1)
#define PHP_HTTP_BUFFER_NOMEM PHP_HTTP_BUFFER_ERROR
#define PHP_HTTP_BUFFER_PASS0 PHP_HTTP_BUFFER_ERROR

#ifndef PTR_FREE
#	define PTR_FREE(PTR) \
	{ \
		if (EXPECTED(PTR)) { \
			efree(PTR); \
		} \
	}
#endif
#ifndef PTR_SET
#	define PTR_SET(PTR, SET) \
	{ \
		PTR_FREE(PTR); \
		PTR = SET; \
	}
#endif
#ifdef PHP_ATTRIBUTE_FORMAT
#	define PHP_HTTP_BUFFER_ATTRIBUTE_FORMAT(f, a, b) PHP_ATTRIBUTE_FORMAT(f, a, b)
#else
#	define PHP_HTTP_BUFFER_ATTRIBUTE_FORMAT(f, a, b)
#endif
#ifndef pemalloc
#	define pemalloc(s,p)	malloc(s)
#	define pefree(x,p)		free(x)
#	define perealloc(x,s,p)	realloc(x,s)
#	define perealloc_recoverable perealloc
#	define ecalloc calloc
static inline void *estrndup(void *p, size_t s)
{
	char *r = (char *) malloc(s+1);
	if (r) memcpy((void *) r, p, s), r[s] = '\0';
	return (void *) r;
}
#endif

#if defined(PHP_WIN32)
#	if defined(PHP_HTTP_BUFFER_EXPORTS)
#		define PHP_HTTP_BUFFER_API __declspec(dllexport)
#	elif defined(COMPILE_DL_PHP_HTTP_BUFFER)
#		define PHP_HTTP_BUFFER_API __declspec(dllimport)
#	else
#		define PHP_HTTP_BUFFER_API
#	endif
#else
#	define PHP_HTTP_BUFFER_API
#endif

#define PHP_HTTP_BUFFER(p) ((php_http_buffer_t *) (p))

#define FREE_PHP_HTTP_BUFFER_PTR(STR) pefree(STR, STR->pmem)
#define FREE_PHP_HTTP_BUFFER_VAL(STR) php_http_buffer_dtor(STR)
#define FREE_PHP_HTTP_BUFFER_ALL(STR) php_http_buffer_free(&(STR))
#define FREE_PHP_HTTP_BUFFER(free, STR) \
	switch (free) \
	{ \
	case PHP_HTTP_BUFFER_FREE_NOT: \
		break; \
	case PHP_HTTP_BUFFER_FREE_PTR: \
		pefree(STR, STR->pmem); \
		break; \
	case PHP_HTTP_BUFFER_FREE_VAL: \
		php_http_buffer_dtor(STR); \
		break; \
	case PHP_HTTP_BUFFER_FREE_ALL: { \
		php_http_buffer_t *PTR = (STR); \
		php_http_buffer_free(&PTR); \
		break; \
	} \
	default:\
		break; \
	}

#define RETURN_PHP_HTTP_BUFFER_PTR(STR) RETURN_PHP_HTTP_BUFFER((STR), PHP_HTTP_BUFFER_FREE_PTR, 0)
#define RETURN_PHP_HTTP_BUFFER_VAL(STR) RETURN_PHP_HTTP_BUFFER((STR), PHP_HTTP_BUFFER_FREE_NOT, 0)
#define RETURN_PHP_HTTP_BUFFER_DUP(STR) RETURN_PHP_HTTP_BUFFER((STR), PHP_HTTP_BUFFER_FREE_NOT, 1)
#define RETVAL_PHP_HTTP_BUFFER_PTR(STR) RETVAL_PHP_HTTP_BUFFER((STR), PHP_HTTP_BUFFER_FREE_PTR, 0)
#define RETVAL_PHP_HTTP_BUFFER_VAL(STR) RETVAL_PHP_HTTP_BUFFER((STR), PHP_HTTP_BUFFER_FREE_NOT, 0)
#define RETVAL_PHP_HTTP_BUFFER_DUP(STR) RETVAL_PHP_HTTP_BUFFER((STR), PHP_HTTP_BUFFER_FREE_NOT, 1)
/* RETURN_PHP_HTTP_BUFFER(buf, PHP_HTTP_BUFFER_FREE_PTR, 0) */
#define RETURN_PHP_HTTP_BUFFER(STR, free, dup) \
	RETVAL_PHP_HTTP_BUFFER((STR), (free), (dup)); \
	return;

#define RETVAL_PHP_HTTP_BUFFER(STR, free, dup) \
	php_http_buffer_fix(STR); \
	RETVAL_STRINGL((STR)->data, (STR)->used, (dup)); \
	FREE_PHP_HTTP_BUFFER((free), (STR));

typedef struct php_http_buffer {
	char  *data;
	size_t used;
	size_t free;
	size_t size;
	unsigned pmem:1;
	unsigned reserved:31;
} php_http_buffer_t;

typedef enum php_http_buffer_free {
	PHP_HTTP_BUFFER_FREE_NOT = 0,
	PHP_HTTP_BUFFER_FREE_PTR,	/* pefree() */
	PHP_HTTP_BUFFER_FREE_VAL,	/*