e of the PHP Group.

 */

#ifndef APC_GLOBALS_H
#define APC_GLOBALS_H

#include "apc.h"

ZEND_BEGIN_MODULE_GLOBALS(apcu)
	/* configuration parameters */
	zend_bool enabled;      /* if true, apc is enabled (defaults to true) */
	zend_long shm_segments;      /* number of shared memory segments to use */
	zend_long shm_size;          /* size of each shared memory segment (in MB) */
	zend_long entries_hint;      /* hint at the number of entries expected */
	zend_long gc_ttl;            /* parameter to apc_cache_create */
	zend_long ttl;               /* parameter to apc_cache_create */
	zend_long smart;             /* smart value */

#if APC_MMAP
	char *mmap_file_mask;   /* mktemp-style file-mask to pass to mmap */
#endif

	/* module variables */
	zend_bool initialized;       /* true if module was initialized */
	zend_bool enable_cli;        /* Flag to override turning APC off for CLI */
	zend_bool slam_defense;      /* true for user cache slam defense */

	char *preload_path;          /* preload path */
	zend_bool coredump_unmap;    /* trap signals that coredump and unmap shared memory */
	zend_bool use_request_time;  /* use the SAPI request start time for TTL */
	time_t request_time;         /* cached request time */

	char *serializer_name;       /* the serializer config option */

	/* Nesting level of apcu_entry calls. */
	unsigned int entry_level;
ZEND_END_MODULE_GLOBALS(apcu)

/* (the following is defined in php_apc.c) */
ZEND_EXTERN_MODULE_GLOBALS(apcu)

#ifdef ZTS
# define APCG(v) TSRMG(apcu_globals_id, zend_apcu_globals *, v)
#else
# define APCG(v) (apcu_globals.v)
#endif

extern struct _apc_cache_t* apc_user_cache;

#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim>600: noexpandtab sw=4 ts=4 sts=4 fdm=marker
 * vim<600: noexpandtab sw=4 ts=4 sts=4
 */
PK       ! ɶڥ    %  php/ext/apcu/php_apc_legacy_arginfo.hnu [        /* This is a generated file, edit the .stub.php file instead.
 * Stub hash: 5282d856fd334278d5799581ad251977a3c6b18e */

ZEND_BEGIN_ARG_INFO_EX(arginfo_apcu_clear_cache, 0, 0, 0)
ZEND_END_ARG_INFO()

ZEND_BEGIN_ARG_INFO_EX(arginfo_apcu_cache_info, 0, 0, 0)
	ZEND_ARG_INFO(0, limited)
ZEND_END_ARG_INFO()

ZEND_BEGIN_ARG_INFO_EX(arginfo_apcu_key_info, 0, 0, 1)
	ZEND_ARG_INFO(0, key)
ZEND_END_ARG_INFO()

#define arginfo_apcu_sma_info arginfo_apcu_cache_info

#define arginfo_apcu_enabled arginfo_apcu_clear_cache

ZEND_BEGIN_ARG_INFO_EX(arginfo_apcu_store, 0, 0, 1)
	ZEND_ARG_INFO(0, key)
	ZEND_ARG_INFO(0, value)
	ZEND_ARG_INFO(0, ttl)
ZEND_END_ARG_INFO()

#define arginfo_apcu_add arginfo_apcu_store

ZEND_BEGIN_ARG_INFO_EX(arginfo_apcu_inc, 0, 0, 1)
	ZEND_ARG_INFO(0, key)
	ZEND_ARG_INFO(0, step)
	ZEND_ARG_INFO(1, success)
	ZEND_ARG_INFO(0, ttl)
ZEND_END_ARG_INFO()

#define arginfo_apcu_dec arginfo_apcu_inc

ZEND_BEGIN_ARG_INFO_EX(arginfo_apcu_cas, 0, 0, 3)
	ZEND_ARG_INFO(0, key)
	ZEND_ARG_INFO(0, old)
	ZEND_ARG_INFO(0, new)
ZEND_END_ARG_INFO()

ZEND_BEGIN_ARG_INFO_EX(arginfo_apcu_fetch, 0, 0, 1)
	ZEND_ARG_INFO(0, key)
	ZEND_ARG_INFO(1, success)
ZEND_END_ARG_INFO()

#define arginfo_apcu_exists arginfo_apcu_key_info

#define arginfo_apcu_delete arginfo_apcu_key_info

ZEND_BEGIN_ARG_INFO_EX(arginfo_apcu_entry, 0, 0, 2)
	ZEND_ARG_INFO(0, key)
	ZEND_ARG_INFO(0, callback)
	ZEND_ARG_INFO(0, ttl)
ZEND_END_ARG_INFO()

#if defined(APC_DEBUG)
ZEND_BEGIN_ARG_INFO_EX(arginfo_apcu_inc_request_time, 0, 0, 0)
	ZEND_ARG_INFO(0, by)
ZEND_END_ARG_INFO()
#endif


PHP_APCU_API ZEND_FUNCTION(apcu_clear_cache);
PHP_APCU_API ZEND_FUNCTION(apcu_cache_info);
PHP_APCU_API ZEND_FUNCTION(apcu_key_info);
PHP_APCU_API ZEND_FUNCTION(apcu_sma_info);
PHP_APCU_API ZEND_FUNCTION(apcu_enabled);
PHP_APCU_API ZEND_FUNCTION(apcu_store);
PHP_APCU_API ZEND_FUNCTION(apcu_add);
PHP_APCU_API ZEND_FUNCTION(apcu_inc);
PHP_APCU_API ZEND_FUNCTION(apcu_dec);
PHP_APCU_API ZEND_FUNCTION(apcu_cas);
PHP_APCU_API ZEND_FUNCTION(apcu_fetch);
PHP_APCU_API ZEND_FUNCTION(apcu_exists);
PHP_APCU_API ZEND_FUNCTION(apcu_delete);
PHP_APCU_API ZEND_FUNCTION(apcu_entry);
#if defined(APC_DEBUG)
PHP_APCU_API ZEND_FUNCTION(apcu_inc_request_time);
#endif


static const zend_function_entry ext_functions[] = {
	ZEND_FE(apcu_clear_cache, arginfo_apcu_clear_cache)
	ZEND_FE(apcu_cache_info, arginfo_apcu_cache_info)
	ZEND_FE(apcu_key_info, arginfo_apcu_key_info)
	ZEND_FE(apcu_sma_info, arginfo_apcu_sma_info)
	ZEND_FE(apcu_enabled, arginfo_apcu_enabled)
	ZEND_FE(apcu_store, arginfo_apcu_store)
	ZEND_FE(apcu_add, arginfo_apcu_add)
	ZEND_FE(apcu_inc, arginfo_apcu_inc)
	ZEND_FE(apcu_dec, arginfo_apcu_dec)
	ZEND_FE(apcu_cas, arginfo_apcu_cas)
	ZEND_FE(apcu_fetch, arginfo_apcu_fetch)
	ZEND_FE(apcu_exists, arginfo_apcu_exists)
	ZEND_FE(apcu_delete, arginfo_apcu_delete)
	ZEND_FE(apcu_entry, arginfo_apcu_entry)
#if defined(APC_DEBUG)
	ZEND_FE(apcu_inc_request_time, arginfo_apcu_inc_request_time)
#endif
	ZEND_FE_END
};
PK       ! q   q     php/ext/apcu/apc_arginfo.hnu [        #if PHP_VERSION_ID < 80000
# include "php_apc_legacy_arginfo.h"
#else
# error Not supported on PHP >= 8.0
#endif
PK       !       php/ext/apcu/apc_stack.hnu [        /*
  +----------------------------------------------------------------------+
  | APC                                                                  |
  +----------------------------------------------------------------------+
  | Copyright (c) 2006-2011 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors: Daniel Cowgill <dcowgill@communityconnect.com>              |
  |          George Schlossnagle <george@omniti.com>                     |
  +----------------------------------------------------------------------+

   This software was contributed to PHP by Community Connect Inc. in 2002
   and revised in 2005 by Yahoo! Inc. to add support for PHP 5.1.
   Future revisions and derivatives of this source code must acknowledge
   Community Connect Inc. as the original contributor of this module by
   leaving this note intact in the source code.

   All other licensing and usage conditions are those of the PHP Group.

 */

#ifndef APC_STACK_H
#define APC_STACK_H

/* Basic stack datatype */

#define T apc_stack_t*
typedef struct apc_stack_t apc_stack_t; /* opaque stack type */

extern T apc_stack_create(size_t size_hint);
extern void apc_stack_destroy(T stack);
extern void apc_stack_clear(T stack);
extern void apc_stack_push(T stack, void* item);
extern void* apc_stack_pop(T stack);
extern void* apc_stack_top(T stack);
extern void* apc_stack_get(T stack, size_t n);
extern int apc_stack_size(T stack);

#undef T
#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim>600: noexpandtab sw=4 ts=4 sts=4 fdm=marker
 * vim<600: noexpandtab sw=4 ts=4 sts=4
 */
PK       ! 9<      php/ext/apcu/apc_api.hnu [        /*
  +----------------------------------------------------------------------+
  | APCu                                                                 |
  +----------------------------------------------------------------------+
  | Copyright (c) 2013 The PHP Group                                     |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +-----------------------