PHP_HTTP_OBJECT_H

typedef struct php_http_object {
	void *intern;
	zend_object zo;
} php_http_object_t;

zend_object *php_http_object_new(zend_class_entry *ce);
php_http_object_t *php_http_object_new_ex(zend_class_entry *ce, void *nothing);

typedef void *(*php_http_new_t)(zend_class_entry *ce, void *);

ZEND_RESULT_CODE php_http_new(void **obj_ptr, zend_class_entry *ce, php_http_new_t create, zend_class_entry *parent_ce, void *intern_ptr);

PHP_MINIT_FUNCTION(http_object);

typedef struct php_http_method {
	zend_fcall_info fci;
	zend_fcall_info_cache fcc;
} php_http_object_method_t;

php_http_object_method_t *php_http_object_method_init(php_http_object_method_t *cb, zval *zobject, const char *method_str, size_t method_len);
ZEND_RESULT_CODE php_http_object_method_call(php_http_object_method_t *cb, zval *zobject, zval *retval, int argc, zval *args);
void php_http_object_method_dtor(php_http_object_method_t *cb);
void php_http_object_method_free(php_http_object_method_t **cb);

#endif


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */

PK       ! H"      php/ext/http/php_http_version.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_VERSION_H
#define	PHP_HTTP_VERSION_H

typedef struct php_http_version {
	unsigned major;
	unsigned minor;
} php_http_version_t;

PHP_HTTP_API php_http_version_t *php_http_version_init(php_http_version_t *v, unsigned major, unsigned minor);
PHP_HTTP_API php_http_version_t *php_http_version_parse(php_http_version_t *v, const char *str);
PHP_HTTP_API void php_http_version_to_string(php_http_version_t *v, char **str, size_t *len, const char *pre, const char *post);
PHP_HTTP_API void php_http_version_dtor(php_http_version_t *v);
PHP_HTTP_API void php_http_version_free(php_http_version_t **v);

#endif	/* PHP_HTTP_VERSION_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */

PK       !  %	  %	    php/ext/psr/psr_cache.hnu [        
#ifndef PSR_CACHE_H
#define PSR_CACHE_H

#include "php.h"
#include "php_psr.h"

#define PHP_PSR_CACHE_VERSION "1.0.0"
#define PHP_PSR_CACHE_VERSION_ID 10000

extern PHP_PSR_API zend_class_entry * PsrCacheCacheItemInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrCacheCacheItemPoolInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrCacheInvalidArgumentException_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrCacheCacheException_ce_ptr;

extern PHP_MINIT_FUNCTION(psr_cache);

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemInterface, getKey, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemInterface, get, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemInterface, isHit, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemInterface, set, 1)
    ZEND_ARG_INFO(0, value)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemInterface, expiresAt, 1)
    ZEND_ARG_INFO(0, expiration)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemInterface, expiresAfter, 1)
    ZEND_ARG_INFO(0, time)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemPoolInterface, getItem, 1)
    ZEND_ARG_INFO(0, key)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemPoolInterface, getItems, 0)
    ZEND_ARG_ARRAY_INFO(0, keys, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemPoolInterface, hasItem, 1)
    ZEND_ARG_INFO(0, key)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemPoolInterface, clear, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemPoolInterface, deleteItem, 1)
    ZEND_ARG_INFO(0, key)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemPoolInterface, deleteItems, 1)
    ZEND_ARG_ARRAY_INFO(0, keys, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemPoolInterface, save, 1)
    ZEND_ARG_OBJ_INFO(0, logger, Psr\\Cache\\CacheItemInterface, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemPoolInterface, saveDeferred, 1)
    ZEND_ARG_OBJ_INFO(0, logger, Psr\\Cache\\CacheItemInterface, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Cache, CacheItemPoolInterface, commit, 0)
PHP_PSR_END_ARG_INFO()

#endif /* PSR_CACHE_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: fdm=marker
 * vim: et sw=4 ts=4
 */
PK       ! }i  i    php/ext/psr/psr_simple_cache.hnu [        
#ifndef PSR_SIMPLE_CACHE_H
#define PSR_SIMPLE_CACHE_H

#include "php.h"
#include "php_psr.h"

#define PHP_PSR_SIMPLE_CACHE_VERSION "1.0.0"
#define PHP_PSR_SIMPLE_CACHE_VERSION_ID 10000

extern PHP_PSR_API zend_class_entry * PsrSimpleCacheCacheException_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrSimpleCacheCacheInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrSimpleCacheInvalidArgumentException_ce_ptr;

extern PHP_MINIT_FUNCTION(psr_simple_cache);

PHP_PSR_BEGIN_ARG_INFO(SimpleCache, CacheInterface, get, 1)
    ZEND_ARG_INFO(0, key)
    ZEND_ARG_INFO(0, default)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(SimpleCache, CacheInterface, set, 2)
    ZEND_ARG_INFO(0, key)
    ZEND_ARG_INFO(0, value)
    ZEND_ARG_INFO(0, ttl)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(SimpleCache, CacheInterface, delete, 1)
    ZEND_ARG_INFO(0, key)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(SimpleCache, CacheInterface, clear, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(SimpleCache, CacheInterface, getMultiple, 1)
    ZEND_ARG_INFO(0, keys)
    ZEND_ARG_INFO(0, default)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(SimpleCache, CacheInterface, setMultiple, 1)
    ZEND_ARG_INFO(0, values)
    ZEND_ARG_INFO(0, ttl)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(SimpleCache, CacheInterface, deleteMultiple, 1)
    ZEND_ARG_INFO(0, keys)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(SimpleCache, CacheInterface, has, 1)
    ZEND_ARG_INFO(0, key)
PHP_PSR_END_ARG_INFO()

#endif /* PSR_CACHE_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: fdm=marker
 * vim: et sw=4 ts=4
 */
PK       ! M@  @  (  php/ext/psr/psr_http_server_middleware.hnu [        #ifndef PSR_HTTP_SERVER_MIDDLEWARE_H
#define PSR_HTTP_SERVER_MIDDLEWARE_H

#include "php.h"
#include "php_psr.h"

#define PHP_PSR_HTTP_SERVER_MIDDLEWARE_VERSION "1.0.0"
#define PHP_PSR_HTTP_SERVER_MIDDLEWARE_VERSION_ID 10000

extern PHP_MINIT_FUNCTION(psr_http_server_middleware);

extern PHP_PSR_API zend_class_entry * PsrHttpServerMiddlewareInterface_ce_ptr;

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpServer, MiddlewareInterface, process, 2, Psr\\Http\\Message\\ResponseInterface, 0)
    ZEND_ARG_OBJ_INFO(0, request, Psr\\Http\\Message\\ServerRequestInterface, 0)
    ZEND_ARG_OBJ_INFO(0, handler, Psr\\Http\\Server\\RequestHandlerInterface, 0)
PHP_PSR_END_ARG_INFO()

#endif /* PSR_HTTP_SERVER_MIDDLEWARE_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: fdm=marker
 * vim: et sw=4 ts=4
 */
PK       ! k~    "  php/ext/psr/psr_event_dispatcher.hnu [        
#ifndef PSR_EVENT_DISPATCHER_H
#define PSR_EVENT_DISPATCHER_H

#include "php.h"
#include "php_psr.h"

#if PHP_VERSION_ID >= 70200
#define PHP_PSR_EVENT_DISPATCHER_VERSION "1.0.0"
#define PHP_PSR_EVENT_DISPATCHER_VERSION_ID 10000

extern PHP_PSR_API zend_class_entry * PsrEventDispatcherEventDispatcherInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrEventDispatcherListenerProviderInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrEventDispatcherStoppableEventInterface_ce_ptr;

extern PHP_MINIT_FUNCTION(psr_event_dispatcher);

PHP_PSR_BEGIN_ARG_INFO(EventDispatcher, EventDispatcherInterface, dispatch, 1)
    ZEND_ARG_TYPE_INFO(0, event, IS_OBJECT, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_WITH_RETURN_TYPE_INFO(EventDispatcher, ListenerProviderInterface, getListenersForEvent, 1, IS_ITERABLE, 0)
    ZEND_ARG_TYPE_INFO(0, event, IS_OBJECT, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_WITH_RETURN_TYPE_INFO(EventDispatcher, StoppableEventInterface, isPropagationStopped, 0, _IS_BOOL, 0)
PHP_PSR_END_ARG_INFO()
#endif

#endif /* PSR_EVENT_DISPATCHER_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: fdm=marker
 * vim: et sw=4 ts=4
 */
PK       ! ̨k      php/ext/psr/psr_http_factory.hnu [        
#ifndef PSR_HTTP_FACTORY_H
#define PSR_HTTP_FACTORY_H

#include "php.h"
#include "php_psr.h"

#define PHP_PSR_HTTP_FACTORY_VERSION "1.0.0"
#define PHP_PSR_HTTP_FACTORY_VERSION_ID 10000

extern PHP_PSR_API zend_class_entry * PsrHttpMessageRequestFactoryInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpMessageResponseFactoryInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpMessageServerRequestFactoryInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpMessageStreamFactoryInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpMessageUploadedFileFactoryInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpMessageUriFactoryInterface_ce_ptr;

extern PHP_MINIT_FUNCTION(psr_http_factory);

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpMessage, RequestFactoryInterface, createRequest, 2, Psr\\Http\\Message\\RequestInterface, 0)
    ZEND_ARG_TYPE_INFO(0, method, IS_STRING, 0)
    ZEND_ARG_INFO(0, uri)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpMessage, ResponseFactoryInterface, createResponse, 0, Psr\\Http\\Message\\ResponseInterface, 0)
    ZEND_ARG_TYPE_INFO(0, code, IS_LONG, 0)
    ZEND_ARG_TYPE_INFO(0, reasonPhrase, IS_STRING, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpMessage, ServerRequestFactoryInterface, createServerRequest, 2, Psr\\Http\\Message\\ServerRequestInterface, 0)
    ZEND_ARG_TYPE_INFO(0, method, IS_STRING, 0)
    ZEND_ARG_INFO(0, uri)
    ZEND_ARG_ARRAY_INFO(0, serverParams, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpMessage, StreamFactoryInterface, createStream, 0, Psr\\Http\\Message\\StreamInterface, 0)
    ZEND_ARG_TYPE_INFO(0, content, IS_STRING, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpMessage, StreamFactoryInterface, createStreamFromFile, 1, Psr\\Http\\Message\\StreamInterface, 0)
    ZEND_ARG_TYPE_INFO(0, filename, IS_STRING, 0)
    ZEND_ARG_TYPE_INFO(0, mode, IS_STRING, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpMessage, StreamFactoryInterface, createStreamFromResource, 1, Psr\\Http\\Message\\StreamInterface, 0)
    ZEND_ARG_INFO(0, resouce)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpMessage, UploadedFileFactoryInterface, createUploadedFile, 1, Psr\\Http\\Message\\UploadedFileInterface, 0)
    ZEND_ARG_OBJ_INFO(0, stream, Psr\\Http\\Message\\StreamInterface, 0)
    ZEND_ARG_TYPE_INFO(0, size, IS_LONG, 1)
    ZEND_ARG_TYPE_INFO(0, error, IS_LONG, 0)
    ZEND_ARG_TYPE_INFO(0, clientFilename, IS_STRING, 1)
    ZEND_ARG_TYPE_INFO(0, clientMediaType, IS_STRING, 1)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpMessage, UriFactoryInterface, createUri, 0, Psr\\Http\\Message\\UriInterface, 0)
    ZEND_ARG_TYPE_INFO(0, uri, IS_STRING, 0)
PHP_PSR_END_ARG_INFO()

#endif /* PSR_HTTP_FACTORY_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: fdm=marker
 * vim: et sw=4 ts=4
 */
PK       ! kR	  	    php/ext/psr/psr_log.hnu [        
#ifndef PSR_LOG_H
#define PSR_LOG_H

#include "php.h"
#include "php_psr.h"

#define PHP_PSR_LOG_VERSION "1.0.0"
#define PHP_PSR_LOG_VERSION_ID 10000

extern PHP_PSR_API zend_class_entry * PsrLogInvalidArgumentException_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrLogLogLevel_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrLogLoggerInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrLogLoggerAwareInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrLogAbstractLogger_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrLogNullLogger_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrLogLoggerTrait_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrLogLoggerAwareTrait_ce_ptr;

extern PHP_MINIT_FUNCTION(psr_log);

#if PHP_VERSION_ID < 80000
#define PHP_PSR_CONTEXT_PARAM ZEND_ARG_ARRAY_INFO(0, context, 0)
#else
#define PHP_PSR_CONTEXT_PARAM ZEND_ARG_TYPE_INFO_WITH_DEFAULT_VALUE(0, context, IS_ARRAY, 0, "[]")
#endif

PHP_PSR_BEGIN_ARG_INFO(Log, LoggerInterface, emergency, 1)
    ZEND_ARG_INFO(0, message)
    PHP_PSR_CONTEXT_PARAM
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Log, LoggerInterface, alert, 1)
    ZEND_ARG_INFO(0, message)
    PHP_PSR_CONTEXT_PARAM
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Log, LoggerInterface, critical, 1)
    ZEND_ARG_INFO(0, message)
    PHP_PSR_CONTEXT_PARAM
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Log, LoggerInterface, error, 1)
    ZEND_ARG_INFO(0, message)
    PHP_PSR_CONTEXT_PARAM
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Log, LoggerInterface, warning, 1)
    ZEND_ARG_INFO(0, message)
    PHP_PSR_CONTEXT_PARAM
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Log, LoggerInterface, notice, 1)
    ZEND_ARG_INFO(0, message)
    PHP_PSR_CONTEXT_PARAM
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Log, LoggerInterface, info, 1)
    ZEND_ARG_INFO(0, message)
    PHP_PSR_CONTEXT_PARAM
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Log, LoggerInterface, debug, 1)
    ZEND_ARG_INFO(0, message)
    PHP_PSR_CONTEXT_PARAM
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Log, LoggerInterface, log, 2)
    ZEND_ARG_INFO(0, level)
    ZEND_ARG_INFO(0, message)
    PHP_PSR_CONTEXT_PARAM
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Log, LoggerAwareInterface, setLogger, 1)
    ZEND_ARG_OBJ_INFO(0, logger, Psr\\Log\\LoggerInterface, 0)
PHP_PSR_END_ARG_INFO();

#endif /* PSR_LOG_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: fdm=marker
 * vim: et sw=4 ts=4
 */
PK       ! Bg5I#  I#    php/ext/psr/psr_http_message.hnu [        
#ifndef PSR_HTTP_MESSAGE_H
#define PSR_HTTP_MESSAGE_H

#include "php.h"
#include "php_psr.h"

#define PHP_PSR_HTTP_MESSAGE_VERSION "1.0.0"
#define PHP_PSR_HTTP_MESSAGE_VERSION_ID 10000

extern PHP_PSR_API zend_class_entry * PsrHttpMessageMessageInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpMessageRequestInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpMessageResponseInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpMessageServerRequestInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpMessageStreamInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpMessageUploadedFileInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpMessageUriInterface_ce_ptr;

extern PHP_MINIT_FUNCTION(psr_http_message);

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, MessageInterface, getProtocolVersion, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, MessageInterface, withProtocolVersion, 1)
    ZEND_ARG_INFO(0, version)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, MessageInterface, getHeaders, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, MessageInterface, hasHeader, 1)
    ZEND_ARG_INFO(0, name)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, MessageInterface, getHeader, 1)
    ZEND_ARG_INFO(0, name)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, MessageInterface, getHeaderLine, 1)
    ZEND_ARG_INFO(0, name)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, MessageInterface, withHeader, 2)
    ZEND_ARG_INFO(0, name)
    ZEND_ARG_INFO(0, value)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, MessageInterface, withAddedHeader, 2)
    ZEND_ARG_INFO(0, name)
    ZEND_ARG_INFO(0, value)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, MessageInterface, withoutHeader, 1)
    ZEND_ARG_INFO(0, name)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, MessageInterface, getBody, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, MessageInterface, withBody, 1)
    ZEND_ARG_OBJ_INFO(0, body, Psr\\Http\\Message\\StreamInterface, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, RequestInterface, getRequestTarget, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, RequestInterface, withRequestTarget, 1)
    ZEND_ARG_INFO(0, requestTarget)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, RequestInterface, getMethod, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, RequestInterface, withMethod, 1)
    ZEND_ARG_INFO(0, method)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, RequestInterface, getUri, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, RequestInterface, withUri, 1)
    ZEND_ARG_OBJ_INFO(0, uri, Psr\\Http\\Message\\UriInterface, 0)
    ZEND_ARG_INFO(0, preserveHost)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ResponseInterface, getStatusCode, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ResponseInterface, withStatus, 1)
    ZEND_ARG_INFO(0, code)
    ZEND_ARG_INFO(0, reasonPhrase)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ResponseInterface, getReasonPhrase, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, getServerParams, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, getCookieParams, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, withCookieParams, 1)
    ZEND_ARG_ARRAY_INFO(0, cookies, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, getQueryParams, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, withQueryParams, 1)
    ZEND_ARG_ARRAY_INFO(0, query, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, getUploadedFiles, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, withUploadedFiles, 1)
    ZEND_ARG_ARRAY_INFO(0, uploadedFiles, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, getParsedBody, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, withParsedBody, 1)
    ZEND_ARG_INFO(0, parsedBody)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, getAttributes, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, getAttribute, 1)
    ZEND_ARG_INFO(0, name)
    ZEND_ARG_INFO(0, default)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, withAttribute, 2)
    ZEND_ARG_INFO(0, name)
    ZEND_ARG_INFO(0, value)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, ServerRequestInterface, withoutAttribute, 1)
    ZEND_ARG_INFO(0, name)
PHP_PSR_END_ARG_INFO()

#if PHP_VERSION_ID >= 80000
PHP_PSR_BEGIN_ARG_WITH_RETURN_TYPE_INFO(HttpMessage, StreamInterface, __toString, 0, IS_STRING, 0)
#else
PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, __toString, 0)
#endif
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, close, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, detach, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, getSize, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, tell, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, eof, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, isSeekable, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, seek, 1)
    ZEND_ARG_INFO(0, offset)
    ZEND_ARG_INFO(0, whence)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, rewind, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, isWritable, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, write, 1)
    ZEND_ARG_INFO(0, string)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, isReadable, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, read, 1)
    ZEND_ARG_INFO(0, length)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, getContents, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, StreamInterface, getMetadata, 0)
    ZEND_ARG_INFO(0, key)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UploadedFileInterface, getStream, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UploadedFileInterface, moveTo, 1)
    ZEND_ARG_INFO(0, targetPath)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UploadedFileInterface, getSize, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UploadedFileInterface, getError, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UploadedFileInterface, getClientFilename, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UploadedFileInterface, getClientMediaType, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, getScheme, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, getAuthority, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, getUserInfo, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, getHost, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, getPort, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, getPath, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, getQuery, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, getFragment, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, withScheme, 1)
    ZEND_ARG_INFO(0, scheme)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, withUserInfo, 1)
    ZEND_ARG_INFO(0, user)
    ZEND_ARG_INFO(0, password)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, withHost, 1)
    ZEND_ARG_INFO(0, host)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, withPort, 1)
    ZEND_ARG_INFO(0, port)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, withPath, 1)
    ZEND_ARG_INFO(0, path)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, withQuery, 1)
    ZEND_ARG_INFO(0, query)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, withFragment, 1)
    ZEND_ARG_INFO(0, fragment)
PHP_PSR_END_ARG_INFO()

#if PHP_VERSION_ID >= 80000
PHP_PSR_BEGIN_ARG_WITH_RETURN_TYPE_INFO(HttpMessage, UriInterface, __toString, 0, IS_STRING, 0)
#else
PHP_PSR_BEGIN_ARG_INFO(HttpMessage, UriInterface, __toString, 0)
#endif
PHP_PSR_END_ARG_INFO()

#endif /* PSR_HTTP_MESSAGE_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: fdm=marker
 * vim: et sw=4 ts=4
 */
PK       ! j{h  h    php/ext/psr/psr_container.hnu [        
#ifndef PSR_CONTAINER_H
#define PSR_CONTAINER_H

#include "php.h"
#include "php_psr.h"

#define PHP_PSR_CONTAINER_VERSION "1.1.1"
#define PHP_PSR_CONTAINER_VERSION_ID 10101

extern PHP_PSR_API zend_class_entry * PsrContainerContainerExceptionInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrContainerContainerInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrContainerNotFoundExceptionInterface_ce_ptr;

extern PHP_MINIT_FUNCTION(psr_container);

PHP_PSR_BEGIN_ARG_INFO(Container, ContainerInterface, get, 1)
    ZEND_ARG_TYPE_INFO(0, id, IS_STRING, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Container, ContainerInterface, has, 1)
    ZEND_ARG_TYPE_INFO(0, id, IS_STRING, 0)
PHP_PSR_END_ARG_INFO()

#endif /* PSR_CONTAINER_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: fdm=marker
 * vim: et sw=4 ts=4
 */
PK       ! M<5      php/ext/psr/psr_http_client.hnu [        
#ifndef PSR_HTTP_CLIENT_H
#define PSR_HTTP_CLIENT_H

#include "php.h"
#include "php_psr.h"

#define PHP_PSR_HTTP_CLIENT_VERSION "1.0.0"
#define PHP_PSR_HTTP_CLIENT_VERSION_ID 10000

extern PHP_PSR_API zend_class_entry * PsrHttpClientClientInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpClientClientExceptionInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpClientNetworkExceptionInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrHttpClientRequestExceptionInterface_ce_ptr;

extern PHP_MINIT_FUNCTION(psr_http_client);

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpClient, ClientInterface, sendRequest, 1, Psr\\Http\\Message\\ResponseInterface, 0)
    ZEND_ARG_OBJ_INFO(0, request, Psr\\Http\\Message\\RequestInterface, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpClient, NetworkExceptionInterface, getRequest, 0, Psr\\Http\\Message\\RequestInterface, 0)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpClient, RequestExceptionInterface, getRequest, 0, Psr\\Http\\Message\\RequestInterface, 0)
PHP_PSR_END_ARG_INFO()

#endif /* PSR_HTTP_CLIENT_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: fdm=marker
 * vim: et sw=4 ts=4
 */
PK       ! (    %  php/ext/psr/psr_http_server_handler.hnu [        #ifndef PSR_HTTP_SERVER_HANDLER_H
#define PSR_HTTP_SERVER_HANDLER_H

#include "php.h"
#include "php_psr.h"

#define PHP_PSR_HTTP_SERVER_HANDLER_VERSION "1.0.0"
#define PHP_PSR_HTTP_SERVER_HANDLER_VERSION_ID 10000

extern PHP_MINIT_FUNCTION(psr_http_server_handler);

extern PHP_PSR_API zend_class_entry * PsrHttpServerRequestHandlerInterface_ce_ptr;

PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(HttpServer, RequestHandlerInterface, handle, 1, Psr\\Http\\Message\\ResponseInterface, 0)
    ZEND_ARG_OBJ_INFO(0, request, Psr\\Http\\Message\\ServerRequestInterface, 0)
PHP_PSR_END_ARG_INFO()

#endif /* PSR_HTTP_SERVER_HANDLER_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: fdm=marker
 * vim: et sw=4 ts=4
 */
PK       ! p%      php/ext/psr/php_psr.hnu [        
#ifndef PHP_PSR_H
#define PHP_PSR_H

#include "php.h"
#include "php_ini.h"
#include "ext/standard/info.h"

#ifdef ZTS
#include "TSRM.h"
#endif

#ifdef PHP_WIN32
# ifdef PHP_PSR_EXPORTS
#  define PHP_PSR_API __declspec(dllexport)
# else
#  define PHP_PSR_API __declspec(dllimport)
# endif
#elif defined(__GNUC__) && __GNUC__ >= 4
# define PHP_PSR_API __attribute__ ((visibility("default")))
#else
# define PHP_PSR_API
#endif

#define PHP_PSR_NAME "psr"
#define PHP_PSR_VERSION "1.2.0"
#define PHP_PSR_VERSION_ID 10200
#define PHP_PSR_RELEASE "2021-12-11"
#define PHP_PSR_AUTHORS "John Boehr <jbboehr@gmail.com> (lead)"

#define PHP_PSR_ARGINFO(p, c, f) (arginfo_Psr ## p ## c ## _ ## f)
#define PHP_PSR_BEGIN_ARG_INFO(p, c, f, n) ZEND_BEGIN_ARG_INFO_EX(PHP_PSR_ARGINFO(p, c, f), ZEND_SEND_BY_VAL, ZEND_RETURN_VALUE, n)
#define PHP_PSR_END_ARG_INFO ZEND_END_ARG_INFO
#define REGISTER_PSR_CLASS_CONST_STRING(ce, const_name, value) \
        zend_declare_class_constant_stringl(ce, const_name, sizeof(const_name)-1, value, sizeof(value)-1);

#define PHP_PSR_CLASS_NAMESPACE "PsrExt"
#define PHP_PSR_ALIAS_NAMESPACE "Psr"

#ifdef ZEND_BEGIN_ARG_WITH_RETURN_OBJ_INFO_EX
#define PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(p, c, f, n, cn, an) ZEND_BEGIN_ARG_WITH_RETURN_OBJ_INFO_EX(PHP_PSR_ARGINFO(p, c, f), ZEND_RETURN_VALUE, n, cn, an)
#define PHP_PSR_BEGIN_ARG_WITH_RETURN_TYPE_INFO(p, c, f, n, t, an) ZEND_BEGIN_ARG_WITH_RETURN_TYPE_INFO_EX(PHP_PSR_ARGINFO(p, c, f), ZEND_RETURN_VALUE, n, t, an)
#else
#define PHP_PSR_BEGIN_ARG_WITH_RETURN_OBJ_INFO(p, c, f, n, cn, an) ZEND_BEGIN_ARG_WITH_RETURN_TYPE_INFO_EX(PHP_PSR_ARGINFO(p, c, f), ZEND_RETURN_VALUE, n, IS_OBJECT, #cn, an)
#define PHP_PSR_BEGIN_ARG_WITH_RETURN_TYPE_INFO(p, c, f, n, t, an) ZEND_BEGIN_ARG_WITH_RETURN_TYPE_INFO_EX(PHP_PSR_ARGINFO(p, c, f), ZEND_RETURN_VALUE, n, t, NULL, an)
#endif

extern zend_module_entry psr_module_entry;
#define phpext_psr_ptr &psr_module_entry

#endif /* PHP_PSR_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: fdm=marker
 * vim: et sw=4 ts=4
 */
PK       ! xQ  Q    php/ext/psr/psr_link.hnu [        
#ifndef PSR_LINK_H
#define PSR_LINK_H

#include "php.h"
#include "php_psr.h"

#define PHP_PSR_LINK_VERSION "1.0.0"
#define PHP_PSR_LINK_VERSION_ID 10000

extern PHP_PSR_API zend_class_entry * PsrLinkEvolvableLinkInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrLinkEvolvableLinkProviderInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrLinkLinkInterface_ce_ptr;
extern PHP_PSR_API zend_class_entry * PsrLinkLinkProviderInterface_ce_ptr;

extern PHP_MINIT_FUNCTION(psr_link);

PHP_PSR_BEGIN_ARG_INFO(Link, EvolvableLinkInterface, withHref, 1)
    ZEND_ARG_INFO(0, href)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Link, EvolvableLinkInterface, withRel, 1)
    ZEND_ARG_INFO(0, rel)
PHP_PSR_END_ARG_INFO()

PHP_PSR_BEGIN_ARG_INFO(Li