(c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_HEADER_PARSER_H
#define PHP_HTTP_HEADER_PARSER_H

#include "php_http_info.h"

typedef enum php_http_header_parser_state {
	PHP_HTTP_HEADER_PARSER_STATE_FAILURE = FAILURE,
	PHP_HTTP_HEADER_PARSER_STATE_START = 0,
	PHP_HTTP_HEADER_PARSER_STATE_KEY,
	PHP_HTTP_HEADER_PARSER_STATE_VALUE,
	PHP_HTTP_HEADER_PARSER_STATE_VALUE_EX,
	PHP_HTTP_HEADER_PARSER_STATE_HEADER_DONE,
	PHP_HTTP_HEADER_PARSER_STATE_DONE
} php_http_header_parser_state_t;

#define PHP_HTTP_HEADER_PARSER_CLEANUP 0x1

typedef struct php_http_header_parser {
	zend_ptr_stack stack;
	php_http_info_t info;
	struct {
		char *str;
		size_t len;
	} _key;
	struct {
		char *str;
		size_t len;
	} _val;
} php_http_header_parser_t;

PHP_HTTP_API php_http_header_parser_t *php_http_header_parser_init(php_http_header_parser_t *p