t (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_CLIENT_H
#define PHP_HTTP_CLIENT_H

typedef enum php_http_client_setopt_opt {
	PHP_HTTP_CLIENT_OPT_ENABLE_PIPELINING,
	PHP_HTTP_CLIENT_OPT_USE_EVENTS,
	PHP_HTTP_CLIENT_OPT_CONFIGURATION,
} php_http_client_setopt_opt_t;

typedef enum php_http_client_getopt_opt {
	PHP_HTTP_CLIENT_OPT_PROGRESS_INFO,		/* php_http_client_enqueue_t*, php_http_client_progress_state_t** */
	PHP_HTTP_CLIENT_OPT_TRANSFER_INFO,		/* php_http_client_enqueue_t*, HashTable* */
	PHP_HTTP_CLIENT_OPT_AVAILABLE_OPTIONS,		/* NULL, HashTable* */
	PHP_HTTP_CLIENT_OPT_AVAILABLE_CONFIGURATION,/* NULL, HashTable */
} php_http_client_getopt_opt_t;

typedef struct php_http_client_enqueue {
	php_http_message_t *request; /* unique */
	HashTable *options;
	void (*dtor)(struct php_http_client_enqueue *);
	void *opaque;
	struct {
		zend_fcall_info fci;
		zend_fcall_info_cache fcc;
	} closure;
	php_http_message_object_t *request_obj; /* supplemental to request */
} php_http_client_enqueue_t;

typedef struct php_http_client *(*php_http_client_init_func_t)(struct php_http_client *p, void *init_arg);
typedef struct php_http_client *(*php_http_client_copy_func_t)(struct php_http_client *from, struct php_http_client *to);
typedef void (*php_http_client_dtor_func_t)(struct php_http_client *p);
typedef void (*php_http_client_reset_func_t)(struct php_http_client *p);
typedef ZEND_RESULT_CODE (*php_http_client_exec_func_t)(struct php_http_client *p);
typedef int (*php_http_client_once_func_t)(struct php_http_client *p);
typedef ZEND_RESULT_CODE (*php_http_client_wait_func_t)(struct php_http_client *p, struct timeval *custom_timeout);
typedef ZEND_RESULT_CODE (*php_http_client_enqueue_func_t)(struct php_http_client *p, php_http_client_enqueue_t *enqueue);
typedef ZEND_RESULT_CODE (*php_http_client_dequeue_func_t)(struct php_http_client *p, php_http_client_enqueue_t *enqueue);
typedef ZEND_RESULT_CODE (*php_http_client_requeue_func_t)(struct php_http_client *p, php_http_client_enqueue_t *enqueue);
typedef ZEND_RESULT_CODE (*php_http_client_setopt_func_t)(struct php_http_client *p, php_http_client_setopt_opt_t opt, void *arg);
typedef ZEND_RESULT_CODE (*php_http_client_getopt_func_t)(struct php_http_client *h, php_http_client_getopt_opt_t opt, void *arg, void **res);

typedef struct php_http_client_ops {
	php_resource_factory_ops_t *rsrc;
	php_http_client_init_func_t init;
	php_http_client_copy_func_t copy;
	php_http_client_dtor_func_t dtor;
	php_http_client_reset_func_t reset;
	php_http_client_exec_func_t exec;
	php_http_client_wait_func_t wait;
	php_http_client_once_func_t once;
	php_http_