(php_http_header_parser_t *parser);
PHP_HTTP_API void php_http_header_parser_dtor(php_http_header_parser_t *parser);
PHP_HTTP_API void php_http_header_parser_free(php_http_header_parser_t **parser);
PHP_HTTP_API php_http_header_parser_state_t php_http_header_parser_parse(php_http_header_parser_t *parser, php_http_buffer_t *buffer, unsigned flags, HashTable *headers, php_http_info_callback_t callback_func, void *callback_arg);
PHP_HTTP_API php_http_header_parser_state_t php_http_headerparser_parse_stream(php_http_header_parser_t *parser, php_http_buffer_t *buffer, php_stream *s, unsigned flags, HashTable *headers, php_http_info_callback_t callback_func, void *callback_arg);

typedef struct php_http_header_parser_object {
	php_http_buffer_t *buffer;
	php_http_header_parser_t *parser;
	zend_object zo;
} php_http_header_parser_object_t;

PHP_HTTP_API zend_class_entry *php_http_get_header_parser_class_entry(void);

PHP_MINIT_FUNCTION(http_header_parser);

zend_object *php_http_header_parser_object_new(zend_class_entry *ce);
php_http_header_parser_object_t *php_http_header_parser_object_new_ex(zend_class_entry *ce, php_http_header_parser_t *parser);
void php_http_header_parser_object_free(zend_object *object);

#endif /* PHP_HTTP_HEADER_PARSER_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */

PK       ! I]	  	  #  php/ext/http/php_http_client_curl.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_CLIENT_CURL_H
#define PHP_HTTP_CLIENT_CURL_H

#if PHP_HTTP_HAVE_LIBCURL

struct php_http_client_curl_globals {
	php_http_client_driver_t driver;
};

typedef struct php_http_client_curl_handle {
	CURLM *multi;
	CURLSH *share;
} php_http_client_curl_handle_t;

typedef struct php_http_client_curl_ops {
	void *(*init)();
	void (*dtor)(void **ctx_ptr);
	ZEND_RESULT_CODE (*once)(void *ctx);
	ZEND_RESULT_CODE (*wait)(void *ctx, struct timeval *custom_timeout);
	ZEND_RESULT_CODE (*exec)(void *ctx);
} php_http_client_curl_ops_t;

typedef struct php_http_client_curl {
	php_http_client_curl_handle_t *handle;

	int unfinished;  /* int because of curl_multi_perform() */

	void *ev_ctx;
	php_http_client_curl_ops_t *ev_ops;
} php_http_client_curl_t;

static inline void php_http_client_curl_get_timeout(php_http_client_curl_t *curl, long max_tout, struct timeval *timeout)
{
	timeout->tv_sec = 0;
	timeout->tv_usec = 0;

	/* always returns CURLM_OK, check max_tout instead */
	curl_multi_timeout(curl->handle->multi, &max_tout);

	if (!max_tout) {
		/* immediately */
		return;
	}

	if (max_tout < 0) {
		/* 5ms */
		max_tout = 5;
	} else if (max_tout > 1000) {
		/* 1s */
		max_tout = 1000;
	}

	timeout->tv_sec = max_tout / 1000;
	timeout->tv_usec = (max_tout % 1000) * 1000;
}

PHP_HTTP_API void php_http_client_curl_responsehandler(php_http_client_t *client);
PHP_HTTP_API void php_http_client_curl_loop(php_http_client_t *client, curl_socket_t s, int curl_action);
PHP_HTTP_API php_http_client_ops_t *php_http_client_curl_get_ops(void);

PHP_MINIT_FUNCTION(http_client_curl);
PHP_MSHUTDOWN_FUNCTION(http_client_curl);

#endif /* PHP_HTTP_HAVE_LIBCURL */

#endif /* PHP_HTTP_CLIENT_CURL_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
PK       ! 1	  1	  %  php/ext/http/php_http_encoding_zlib.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_ENCODING_ZLIB_H
#define PHP_HTTP_ENCODING_ZLIB_H

#include "php_http_encoding.h"

#include <zlib.h>

#ifndef Z_FIXED
/* Z_FIXED does not exist prior 1.2.2.2 */
#	define Z_FIXED 0
#endif

extern PHP_MINIT_FUNCTION(http_encoding_zlib);

zend_class_entry *php_http_get_deflate_stream_class_entry(void);
zend_class_entry *php_http_get_inflate_stream_class_entry(void);

PHP_HTTP_API php_http_encoding_stream_ops_t *php_http_encoding_stream_get_deflate_ops(void);
PHP_HTTP_API php_http_encoding_stream_ops_t *php_http_encoding_stream_get_inflate_ops(void);

PHP_HTTP_API ZEND_RESULT_CODE php_http_encoding_deflate(int flags, const char *data, size_t data_len, char **encoded, size_t *encoded_len);
PHP_HTTP_API ZEND_RESULT_CODE php_http_encoding_inflate(const char *data, size_t data_len, char **decoded, size_t *decoded_len);

#define PHP_HTTP_DEFLATE_LEVEL_DEF			0x00000000
#define PHP_HTTP_DEFLATE_LEVEL_MIN			0x00000001
#define PHP_HTTP_DEFLATE_LEVEL_MAX			0x00000009
#define PHP_HTTP_DEFLATE_TYPE_ZLIB			0x00000000
#define PHP_HTTP_DEFLATE_TYPE_GZIP			0x00000010
#define PHP_HTTP_DEFLATE_TYPE_RAW			0x00000020
#define PHP_HTTP_DEFLATE_STRATEGY_DEF		0x00000000
#define PHP_HTTP_DEFLATE_STRATEGY_FILT		0x00000100
#define PHP_HTTP_DEFLATE_STRATEGY_HUFF		0x00000200
#define PHP_HTTP_DEFLATE_STRATEGY_RLE		0x00000300
#define PHP_HTTP_DEFLATE_STRATEGY_FIXED		0x00000400

#define PHP_HTTP_INFLATE_TYPE_ZLIB			0x00000000
#define PHP_HTTP_INFLATE_TYPE_GZIP			0x00000000
#define PHP_HTTP_INFLATE_TYPE_RAW			0x00000001

#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */

PK       ! 2V    &  php/ext/http/php_http_client_request.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                        