p_url_t *php_http_url_mod(const php_http_url_t *old_url, const php_http_url_t *new_url, unsigned flags);
PHP_HTTP_API php_http_url_t *php_http_url_copy(const php_http_url_t *url, zend_bool persistent);
PHP_HTTP_API php_http_url_t *php_http_url_from_struct(HashTable *ht);
PHP_HTTP_API php_http_url_t *php_http_url_from_zval(zval *value, unsigned flags);
PHP_HTTP_API HashTable *php_http_url_to_struct(const php_http_url_t *url, zval *strct);
PHP_HTTP_API char *php_http_url_to_string(const php_http_url_t *url, char **url_str, size_t *url_len, zend_bool persistent);
PHP_HTTP_API char *php_http_url_authority_to_string(const php_http_url_t *url, char **url_str, size_t *url_len);
PHP_HTTP_API void php_http_url_free(php_http_url_t **url);

PHP_HTTP_API ZEND_RESULT_CODE php_http_url_encode_hash(HashTable *hash, const char *pre_encoded_str, size_t pre_encoded_len, char **encoded_str, size_t *encoded_len);
PHP_HTTP_API ZEND_RESULT_CODE php_http_url_encode_hash_ex(HashTable *hash, php_http_buffer_t *qstr, const char *arg_sep_str, size_t arg_sep_len, const char *val_sep_str, size_t val_sep_len, const char *pre_encoded_str, size_t pre_encoded_len);

static inline void php_http_url_argsep(const char **str, size_t *len)
{
	if (SUCCESS != php_http_ini_entry(ZEND_STRL("arg_separator.output"), str, len, 0) || !*len) {
		*str = PHP_HTTP_URL_ARGSEP;
		*len = lenof(PHP_HTTP_URL_ARGSEP);
	}
}

static inline zend_bool php_http_url_is_empty(const php_http_url_t *url) {
	return !(url->scheme || url->pass || url->user || url->host || url->port ||	url->path || url->query || url->fragment);
}

PHP_HTTP_API zend_class_entry *php_http_url_get_class_entry(void);
PHP_HTTP_API zend_class_entry *php_http_get_env_url_class_entry(void);
PHP_MINIT_FUNCTION(http_url);

#define php_http_url_object_new php_http_object_new
#define php_http_url_object_new_ex php_http_object_new_ex

#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */

PK       ! Si
  
    php/ext/http/php_http_header.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_HEADERS_H
#define PHP_HTTP_HEADERS_H

#include "php_http_info.h"

PHP_HTTP_API ZEND_RESULT_CODE php_http_header_parse(const char *header, size_t length, HashTable *headers, php_http_info_callback_t callback_func, void **callback_data);

PHP_HTTP_API void php_http_header_to_callback(HashTable *headers, zend_bool crlf, php_http_pass_format_callback_t cb, void *cb_arg);
PHP_HTTP_API void php_http_header_to_callback_ex(const char *key, zval *val, zend_bool crlf, php_http_pass_format_callback_t cb, void *cb_arg);
PHP_HTTP_API void php_http_header_to_string(php_http_buffer_t *str, HashTable *headers);
PHP_HTTP_API void php_http_header_to_string_ex(php_http_buffer_t *str, const char *key, zval *val);

PHP_HTTP_API zend_string *php_http_header_value_to_string(zval *header);
PHP_HTTP_API zend_string *php_http_header_value_array_to_string(zval *header);

PHP_HTTP_API zend_class_entry *php_http_header_get_class_entry(void);
PHP_MINIT_FUNCTION(http_header);

#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */

PK       ! /    &  php/ext/http/php_http_message_parser.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_MESSAGE_PARSER_H
#define PHP_HTTP_MESSAGE_PARSER_H

#include "php_http_header_parser.h"
#include "php_http_encoding.h"
#include "php_http_message.h"

typedef enum php_http_message_parser_state {
	PHP_HTTP_MESSAGE_PARSER_STATE_FAILURE = FAILURE,
	PHP_HTTP_MESSAGE_PARSER_STATE_START = 0,
	PHP_HTTP_MESSAGE_PARSER_STATE_HEADER,
	PHP_HTTP_MESSAGE_PARSER_STATE_HEADER_DONE,
	PHP_HTTP_MESSAGE_PARSER_STATE_BODY,
	PHP_HTTP_MESSAGE_PARSER_STATE_BODY_DUMB,
	PHP_HTTP_MESSAGE_PARSER_STATE_BODY_LENGTH,
	PHP_HTTP_MESSAGE_PARSER_STATE_BODY_CHUNKED,
	PHP_HTTP_MESSAGE_PARSER_STATE_BODY_DONE,
	PHP_HTTP_MESSAGE_PARSER_STATE_UPDATE_CL,
	PHP_HTTP_MESSAGE_PARSER_STATE_DONE
} php_http_message_parser_state_t;

#define PHP_HTTP_MESSAGE_PARSER_CLEANUP			0x1
#define PHP_HTTP_MESSAGE_PARSER_DUMB_BODIES		0x2
#define PHP_HTTP_MESSAGE_PARSER_EMPTY_REDIRECTS	0x4
#define PHP_HTTP_MESSAGE_PARSER_GREEDY			0x8

typedef struct php_http_message_parser {
	php_http_header_parser_t header;
	zend_ptr_stack stack;
	size_t body_length;
	php_http_message_t *message;
	php_http_encoding_stream_t *dechunk;
	php_http_encoding_stream_t *inflate;
} php_http_message_parser_t;

PHP_HTTP_API php_http_message_parser_t *php_http_message_parser_init(php_http_message_parser_t *parser);
PHP_HTTP_API php_http_message_parser_state_t php_http_message_parser_state_is(php_http_message_parser_t *parser);
PHP_HTTP_API void php_http_message_parser_dtor(php_http_message_parser_t *parser);
PHP_HTTP_API void php_http_message_parser_free(php_http_message_parser_t **parser);
PHP_HTTP_API php_http_message_parser_state_t php_http_message_parser_parse(php_http_message_parser_t *parser, php_http_buffer_t *buffer, unsigned flags, php_http_message_t **message);
PHP_HTTP_API php_http_message_parser_state_t php_http_message_parser_parse_stream(php_http_message_parser_t *parser, php_http_buffer_t *buffer, php_stream *s, unsigned flags, php_http_message_t **message);

typedef struct php_http_message_parser_object {
	php_http_buffer_t buffer;
	php_http_message_parser_t *parser;
	zend_object zo;
} php_http_message_parser_object_t;

PHP_HTTP_API zend_class_entry *php_http_get_message_parser_class_entry(void);

PHP_MINIT_FUNCTION(http_message_parser);

zend_ob