	PHP_HTTP_CONTENT_ENCODING_GZIP
} php_http_content_encoding_t;

typedef enum php_http_range_status {
	PHP_HTTP_RANGE_NO,
	PHP_HTTP_RANGE_OK,
	PHP_HTTP_RANGE_ERR
} php_http_range_status_t;

PHP_HTTP_API php_http_range_status_t php_http_env_get_request_ranges(HashTable *ranges, size_t entity_length, php_http_message_t *request);
PHP_HTTP_API void php_http_env_get_request_headers(HashTable *headers);
PHP_HTTP_API char *php_http_env_get_request_header(const char *name_str, size_t name_len, size_t *len, php_http_message_t *request);
PHP_HTTP_API zend_bool php_http_env_got_request_header(const char *name_str, size_t name_len, php_http_message_t *request);
PHP_HTTP_API php_http_message_body_t *php_http_env_get_request_body(void);
PHP_HTTP_API const char *php_http_env_get_request_method(php_http_message_t *request);

typedef enum php_http_content_disposition {
	PHP_HTTP_CONTENT_DISPOSITION_NONE,
	PHP_HTTP_CONTENT_DISPOSITION_INLINE,
	PHP_HTTP_CONTENT_DISPOSITION_ATTACHMENT
} php_http_content_disposition_t;

typedef enum php_http_cache_status {
	PHP_HTTP_CACHE_NO,
	PHP_HTTP_CACHE_HIT,
	PHP_HTTP_CACHE_MISS
} php_http_cache_status_t;

PHP_HTTP_API long php_http_env_get_response_code(void);
PHP_HTTP_API const char *php_http_env_get_response_status_for_code(unsigned code);
PHP_HTTP_API ZEND_RESULT_C