
#include "php_http_env_response.h"
#include "php_http_etag.h"
#include "php_http_exception.h"
#include "php_http_filter.h"
#include "php_http_header_parser.h"
#include "php_http_header.h"
#include "php_http_message_body.h"
#include "php_http_message_parser.h"
#include "php_http_negotiate.h"
#include "php_http_object.h"
#include "php_http_params.h"
#include "php_http_querystring.h"
#include "php_http_client.h"
#include "php_http_curl.h"
#include "php_http_client_request.h"
#include "php_http_client_response.h"
#include "php_http_client_curl.h"
#include "php_http_client_curl_event.h"
#include "php_http_client_curl_user.h"
#include "php_http_url.h"
#include "php_http_version.h"

ZEND_BEGIN_MODULE_GLOBALS(php_http)
	struct php_http_env_globals env;
#if PHP_HTTP_HAVE_CLIENT
	struct {
#	if PHP_HTTP_HAVE_LIBCURL
		struct php_http_client_curl_globals curl;
#	endif
	} client;
#endif
ZEND_END_MODULE_GLOBALS(php_http)

ZEND_EXTERN_MODULE_GLOBALS(php_http);

#if ZTS
#	include "TSRM/TSRM.h"
#	define PHP_HTTP_G ((zend_php_http_globals *) (*((void ***) tsrm_get_ls_cache()))[TSRM_UNSHUFFLE_RSRC_ID(php_http_globals_id)])
#	undef TSRMLS_FETCH_FROM_CTX
#	define TSRMLS_FETCH_FROM_CTX(ctx) ERROR
#else
#	define PHP_HTTP_G (&php_http_globals)
#endif

#if PHP_DEBUG
#	define _DPF_STR	0
#	define _DPF_IN	1
#	define _DPF_OUT	2
extern void _dpf(int type, const char *data, size_t length);
#else
#	define _dpf(t,s,l);
#endif

#endif /* PHP_HTTP_API_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
PK       ! ~2	  	    php/ext/http/php_http_params.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_PARAMS_H
#define PHP_HTTP_PARAMS_H

typedef struct php_http_params_token {
	char *str;
	size_t len;
} php_http_params_token_t;

#define PHP_HTTP_PARAMS_RAW			0x00
#define PHP_HTTP_PARAMS_ESCAPED		0x01
#define PHP_HTTP_PARAMS_URLENCODED	0x04
#define PHP_HTTP_PARAMS_DIMENSION	0x08
#define PHP_HTTP_PARAMS_RFC5987		0x10
#define PHP_HTTP_PARAMS_RFC5988		0x20
#define PHP_HTTP_PARAMS_QUERY		(PHP_HTTP_PARAMS_URLENCODED|PHP_HTTP_PARAMS_DIMENSION)
#define PHP_HTTP_PARAMS_DEFAULT		(PHP_HTTP_PARAMS_ESCAPED|PHP_HTTP_PARAMS_RFC5987)

typedef struct php_http_params_opts {
	php_http_params_token_t input;
	php_http_params_token_t **param;
	php_http_params_token_t **arg;
	php_http_params_token_t **val;
	zval defval;
	unsigned flags;
} php_http_params_opts_t;

PHP_HTTP_API php_http_params_opts_t *php_http_params_opts_default_get(php_http_params_opts_t *opts);
PHP_HTTP_API HashTable *php_http_params_parse(HashTable *params, const php_http_params_opts_t *opts);
PHP_HTTP_API php_http_buffer_t *php_http_params_to_string(php_http_buffer_t *buf, HashTable *params, const char *pss, size_t psl, const char *ass, size_t asl, const char *vss, size_t vsl, unsigned flags);

PHP_HTTP_API php_http_params_token_t **php_http_params_separator_init(zval *zv);
PHP_HTTP_API void php_http_params_separator_free(php_http_params_token_t **separator);

typedef php_http_object_t php_http_params_object_t;

PHP_HTTP_API zend_class_entry *php_http_params_get_class_entry(void);

PHP_MINIT_FUNCTION(http_params);

#define php_http_params_object_new php_http_object_new
#define php_http_params_object_new_ex php_http_object_new_ex

#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */

PK       ! M&(      php/ext/http/php_http.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_EXT_HTTP_H
#define PHP_EXT_HTTP_H

#define PHP_PECL_HTTP_VERSION "4.2.6"

extern zend_module_entry http_module_entry;
#define phpext_http_ptr &http_module_entry

extern int http_module_number;

#endif /* PHP_EXT_HTTP_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
PK       !  g|  |    php/ext/http/php_http_misc.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_MISC_H
#define PHP_HTTP_MISC_H

/* DEFAULTS */

/* DATE FORMAT RFC1123 */
#define PHP_HTTP_DATE_FORMAT "D, d M Y H:i:s \\G\\M\\T"

/* CR LF */
#define PHP_HTTP_CRLF "\r\n"

/* def URL arg separator */
#define PHP_HTTP_URL_ARGSEP "&"

/* send buffer size */
#define PHP_HTTP_SENDBUF_SIZE 40960

/* allowed characters of header field names */
#define PHP_HTTP_HEADER_NAME_CHARS "!#$%&'*+-.^_`|~1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"

/* SLEEP */

#define PHP_HTTP_DIFFSEC (0.001)
#define PHP_HTTP_MLLISEC (1000)
#define PHP_HTTP_MCROSEC (1000 * 1000)
#define PHP_HTTP_NANOSEC (1000 * 1000 * 1000)
#define PHP_HTTP_MSEC(s) ((long)(s * PHP_HTTP_MLLISEC))
#define PHP_HTTP_USEC(s) ((long)(s * PHP_HTTP_MCROSEC))
#define PHP_HTTP_NSEC(s) ((long)(s * PHP_HTTP_NANOSEC))

PHP_HTTP_API void php_http_sleep(double s);

/* STRING UTILITIES */

#ifndef PTR_SET
#	define PTR_SET(STR, SET) \
	{ \
		PTR_FREE(STR); \
		STR = SET; \
	}
#endif

#define STR_PTR(s) (s?s:"")

#define lenof(S) (sizeof(S) - 1)

#define PHP_HTTP_MATCH_LOOSE	0
#define PHP_HTTP_MATCH_CASE		0x01
#define PHP_HTTP_MATCH_WORD		0x10
#define PHP_HTTP_MATCH_FULL		0x20
#define PHP_HTTP_MATCH_STRICT	(PHP_HTTP_MATCH_CASE|PHP_HTTP_MATCH_FULL)

int php_http_match(const char *haystack, const char *needle, int flags);
char *php_http_pretty_key(register char *key, size_t key_len, zend_bool uctitle, zend_bool xhyphe