                   |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_URL_H
#define PHP_HTTP_URL_H

#include "ext/standard/url.h"

/* php_http_url_mod() */
#define PHP_HTTP_URL_REPLACE		0x000
#define PHP_HTTP_URL_JOIN_PATH		0x001
#define PHP_HTTP_URL_JOIN_QUERY		0x002
#define PHP_HTTP_URL_STRIP_USER		0x004
#define PHP_HTTP_URL_STRIP_PASS		0x008
#define PHP_HTTP_URL_STRIP_AUTH		(PHP_HTTP_URL_STRIP_USER|PHP_HTTP_URL_STRIP_PASS)
#define PHP_HTTP_URL_STRIP_PORT		0x020
#define PHP_HTTP_URL_STRIP_PATH		0x040
#define PHP_HTTP_URL_STRIP_QUERY	0x080
#define PHP_HTTP_URL_STRIP_FRAGMENT	0x100
#define PHP_HTTP_URL_STRIP_ALL ( \
	PHP_HTTP_URL_STRIP_AUTH | \
	PHP_HTTP_URL_STRIP_PORT | \
	PHP_HTTP_URL_STRIP_PATH | \
	PHP_HTTP_URL_STRIP_QUERY | \
	PHP_HTTP_URL_STRIP_FRAGMENT \
)
#define PHP_HTTP_URL_FROM_ENV		0x1000
#define PHP_HTTP_URL_SANITIZE_PATH	0x2000

/* parse multibyte according to locale */
#define PHP_HTTP_URL_PARSE_MBLOC	0x10000
/* parse utf8 multibyte sequences */
#define PHP_HTTP_URL_PARSE_MBUTF8	0x20000
/* convert multibyte hostnames to IDNA */
#define PHP_HTTP_URL_PARSE_TOIDN	0x100000
/* percent encode multibyte sequences in userinfo, path, query and fragment */
#define PHP_HTTP_URL_PARSE_TOPCT	0x200000

#if PHP_HTTP_HAVE_IDNA2008
#define PHP_HTTP_URL_PARSE_TOIDN_2008 \
	(PHP_HTTP_URL_PARSE_TOIDN	|	0x400000)
#endif
#if PHP_HTTP_HAVE_IDNA2003
#define PHP_HTTP_URL_PARSE_TOIDN_2003 \
	(PHP_HTTP_URL_PARSE_TOIDN	|	0x800000)
#endif

/* ignore errors */
#define PHP_HTTP_URL_IGNORE_ERRORS	0x10000000
/* do not report errors */
#define PHP_HTTP_URL_SILENT_ERRORS	0x20000000

#define PHP_HTTP_URL_STDFLAGS		0x00332003

typedef struct php_http_url {
	char *scheme;
	char *user;
	char *pass;
	char *host;
	unsigned short port;
	char *path;
	char *query;
	char *fragment;
} php_http_url_t;

PHP_HTTP_API php_http_url_t *php_http_url_parse(const char *str, size_t len, unsigned flags);
PHP_HTTP_API php_http_url_t *php_http_url_par