------------------------------------------------+
*/

#ifndef PHP_HTTP_NEGOTIATE_H
#define PHP_HTTP_NEGOTIATE_H

PHP_HTTP_API HashTable *php_http_negotiate(const char *value_str, size_t value_len, HashTable *supported, const char *primary_sep_str, size_t primary_sep_len);

static inline HashTable *php_http_negotiate_language(HashTable *supported, php_http_message_t *request)
{
	HashTable *result = NULL;
	size_t length;
	char *value = php_http_env_get_request_header(ZEND_STRL("Accept-Language"), &length, request);

	if (value) {
		result = php_http_negotiate(value, length, supported, "-", 1);
	}
	PTR_FREE(value);

	return result;
}

static inline HashTable *php_http_negotiate_encoding(HashTable *supported, php_http_message_t *request)
{
	HashTable *result = NULL;
	size_t length;
	char *value = php_http_env_get_request_header(ZEND_STRL("Accept-Encoding"), &length, request);

	if (value) {
		result = php_http_negotiate(value, length, supported, NULL, 0);
	}
	PTR_FREE(value);

	return result;
}

static inline HashTable *php_http_negotiate_charset(HashTable *supported, php_http_message_t *request)
{
	HashTable *result = NULL;
	size_t length;
	char *value = php_http_env_get_request_header(ZEND_STRL("Accept-Charset"), &length, request);

	if (value) {
		result = php_http_negotiate(value, length, supported, NULL, 0);
	}
	PTR_FREE(value);

	return result;
}

static inline HashTable *php_http_negotiate_content_type(HashTable *supported, php_http_message_t *request)
{
	HashTable *result = NULL;
	size_t length;
	char *value = php_http_env_get_request_header(ZEND_STRL("Accept"), &length, request);

	if (value) {
		result = php_http_negotiate(value, length, supported, "/", 1);
	}
	PTR_FREE(value);

	return result;
}

#define PHP_HTTP_DO_NEGOTIATE_DEFAULT(supported) \
	{ \
		zval *value; \
		HashPosition pos; \
		 \
		zend_hash_internal_pointer_reset_ex((supported), &pos); \
		if ((value = zend_hash_get_current_data_ex((supported), &pos))) { \
			RETVAL_ZVAL(value, 1, 0); \
		} else { \
			RETVAL_NULL(); \
		} \
	}

#define PHP_HTTP_DO_NEGOTIATE_HANDLE_DEFAULT(supported, rs_array) \
	PHP_HTTP_DO_NEGOTIATE_DEFAULT(supported); \
	if (rs_array) { \
		zval *value; \
		 \
		ZEND_HASH_FOREACH_VAL(supported, value) \
		{ \
			zend_string *zs = zval_get_string(value); \
			add_assoc_double_ex(rs_array, zs->val, zs->len, 1.0); \
			zend_string_release(zs); \
		} \
		ZEND_HASH_FOREACH_END(); \
	}

#define PHP_HTTP_DO_NEGOTIATE_HANDLE_RESULT(result, supported, rs_array) \
	{ \
		zend_string *key; \
		zend_ulong idx; \
		 \
		if (zend_hash_num_elements(result) && HASH_KEY_IS_STRING == zend_hash_get_current_key(result, &key, &idx)) { \
			RETVAL_STR_COPY(key); \
		} else { \
			PHP_HTTP_DO_NEGOTIATE_DEFAULT(supported); \
		} \
		\
		if (rs_array) { \
			zend_hash_copy(Z_ARRVAL_P(rs_array), result, (copy_ctor_func_t) zval_add_ref); \
		} \
		\
		zend_hash_destroy(result); \
		FREE_HASHTABLE(result); \
	}

#define PHP_HTTP_DO_NEGOTIATE(type, supported, rs_array) \
	{ \
		HashTable *result; \
		if ((result = php_http_negotiate_ ##type(supported, NULL))) { \
			PHP_HTTP_DO_NEGOTIATE_HANDLE_RESULT(result, supported, rs_array); \
		} else { \
			PHP_HTTP_DO_NEGOTIATE_HANDLE_DEFAULT(supported, rs_array); \
		} \
	}

#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */

PK       !       php/ext/http/php_http_cookie.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_COOKIE_H
#define PHP_HTTP_COOKIE_H

#define PHP_HTTP_COOKIE_SECURE		0x10L
#define PHP_HTTP_COOKIE_HTTPONLY	0x20L

#define PHP_HTTP_COOKIE_PARSE_RAW	0x01L

/*
	generally a netscape cookie compliant struct, recognizing httpOnly attribute, too;
	cookie params like those from rfc2109 and rfc2965 are just put into extras, if
	one specifies them in allowed extras, else they're treated like cookies themself
*/
typedef struct php_http_cookie_list {
	HashTable cookies;
	HashTable extras;
	long flags;
	char *path;
	char *domain;
	time_t expires;
	time_t max_age;
} php_http_cookie_list_t;

PHP_HTTP_API php_http_cookie_list_t *php_http_cookie_list_init(php_http_cookie_list_t *list);
PHP_HTTP_API php_http_cookie_list_t *php_http_cookie_list_parse(php_http_cookie_list_t *list, const char *str, size_t len, long flags, char **allowed_extras);
PHP_HTTP_API php_http_cookie_list_t *php_http_cookie_list_copy(php_http_cookie_list_t *from, php_http_cookie_list_t *to);
PHP_HTTP_API void php_http_cookie_list_dtor(php_http_cookie_list_t *list);
PHP_HTTP_API void php_http_cookie_list_free(php_http_cookie_list_t **list);

#define php_http_cookie_list_has_cookie(list, name, name_len) zend_symtable_str_exists(&(list)->cookies, (name), (name_len))
#define php_http_cookie_list_del_cookie(list, name, name_len) zend_symtable_str_del(&(list)->cookies, (name), (name_len))
PHP_HTTP_API void php_http_cookie_list_add_cookie(php_http_cookie_list_t *list, const char *name, size_t name_len, const char *value, size_t value_len);
PHP_HTTP_API const char *php_http_cookie_list_get_cookie(php_http_cookie_list_t *list, const char *name, size_t name_len, zval *cookie);

#define php_http_cookie_list_has_extra(list, name, name_len) zend_symtable_str_exists(&(list)->extras, (name), (name_len))
#define php_http_cookie_list_del_extra(list, name, name_len) zend_symtable_str_del(&(list)->extras, (name), (name_len))
PHP_HTTP_API void php_http_cookie_list_add_extra(php_http_cookie_list_t *list, const char *name, size_t name_len, const char *value, size_t value_len);
PHP_HTTP_API const char *php_http_cookie_list_get_extra(php_http_cookie_list_t *list, const char *name, size_t name_len, zval *extra);

PHP_HTTP_API void php_http_cookie_list_to_string(php_http_cookie_list_t *list, char **str, size_t *len);
PHP_HTTP_API php_http_cookie_list_t *php_http_cookie_list_from_struct(php_http_cookie_list_t *list, zval *strct);
PHP_HTTP_API void php_http_cookie_list_to_struct(php_http_cookie_list_t *list, zval *strct);

PHP_HTTP_API zend_class_entry *php_http_cookie_get_class_entry(void);

typedef struct php_http_cookie_object {
	php_http_cookie_list_t *list;
	zend_object zo;
} php_http_cookie_object_t;

zend_object *php_http_cookie_object_new(zend_class_entry *ce);
php_http_cookie_object_t *php_http_cookie_object_new_ex(zend_class_entry *ce, php_http_cookie_list_t *list);
zend_object *php_http_cookie_object_clone(zend_object *this_ptr);
void php_http_cookie_object_free(zend_object *object);

PHP_MINIT_FUNCTION(http_cookie);

#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
PK       ! k!  !  &  php/ext/http/php_http_response_codes.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2015, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_RESPONSE_CODE
#	define PHP_HTTP_RESPONSE_CODE(code, status)
#endif

PHP_HTTP_RESPONSE_CODE(100, "Continue")
PHP_HTTP_RESPONSE_CODE(101, "Switching Protocols")
PHP_HTTP_RESPONSE_CODE(102, "Processing")
PHP_HTTP_RESPONSE_CODE(200, "OK")
PHP_HTTP_RESPONSE_CODE(201, "Created")
PHP_HTTP_RESPONSE_CODE(202, "Accepted")
PHP_HTTP_RESPONSE_CODE(203, "Non-Authoritative Information")
PHP_HTTP_RESPONSE_CODE(204, "No Content")
PHP_HTTP_RESPONSE_CODE(205, "Reset Content")
PHP_HTTP_RESPONSE_CODE(206, "Partial Content")
PHP_HTTP_RESPONSE_CODE(207, "Multi-Status")
PHP_HTTP_RESPONSE_CODE(208, "Already Reported")
PHP_HTTP_RESPONSE_CODE(226, "IM Used")
PHP_HTTP_RESPONSE_CODE(300, "Multiple Choices")
PHP_HTTP_RESPONSE_CODE(301, "Moved Permanently")
PHP_HTTP_RESPONSE_CODE(302, "Found")
PHP_HTTP_RESPONSE_CODE(303, "See Other")
PHP_HTTP_RESPONSE_CODE(304, "Not Modified")
PHP_HTTP_RESPONSE_CODE(305, "Use Proxy")
PHP_HTTP_RESPONSE_CODE(307, "Temporary Redirect")
PHP_HTTP_RESPONSE_CODE(308, "Permanent Redirect")
PHP_HTTP_RESPONSE_CODE(400, "Bad Request")
PHP_HTTP_RESPONSE_CODE(401, "Unauthorized")
PHP_HTTP_RESPONSE_CODE(402, "Payment Required")
PHP_HTTP_RESPONSE_CODE(403, "Forbidden")
PHP_HTTP_RESPONSE_CODE(404, "Not Found")
PHP_HTTP_RESPONSE_CODE(405, "Method Not Allowed")
PHP_HTTP_RESPONSE_CODE(406, "Not Acceptable")
PHP_HTTP_RESPONSE_CODE(407, "Proxy Authentication Required")
PHP_HTTP_RESPONSE_CODE(408, "Request Timeout")
PHP_HTTP_RESPONSE_CODE(409, "Conflict")
PHP_HTTP_RESPONSE_CODE(410, "Gone")
PHP_HTTP_RESPONSE_CODE(411, "Length Required")
PHP_HTTP_RESPONSE_CODE(412, "Precondition Failed")
PHP_HTTP_RESPONSE_CODE(413, "Request Entity Too Large")
PHP_HTTP_RESPONSE_CODE(414, "Request URI Too Long")
PHP_HTTP_RESPONSE_CODE(415, "Unsupported Media Type")
PHP_HTTP_RESPONSE_CODE(416, "Requested Range Not Satisfiable")
PHP_HTTP_RESPONSE_CODE(417, "Expectation Failed")
PHP_HTTP_RESPONSE_CODE(422, "Unprocessible Entity")
PHP_HTTP_RESPONSE_CODE(423, "Locked")
PHP_HTTP_RESPONSE_CODE(424, "Failed Dependency")
PHP_HTTP_RESPONSE_CODE(426, "Upgrade Required")
PHP_HTTP_RESPONSE_CODE(428, "Precondition Required")
PHP_HTTP_RESPONSE_CODE(429, "Too Many Requests")
PHP_HTTP_RESPONSE_CODE(431, "Request Header Fields Too Large")
PHP_HTTP_RESPONSE_CODE(500, "Internal Server Error")
PHP_HTTP_RESPONSE_CODE(501, "Not Implemented")
PHP_HTTP_RESPONSE_CODE(502, "Bad Gateway")
PHP_HTTP_RESPONSE_CODE(503, "Service Unavailable")
PHP_HTTP_RESPONSE_CODE(504, "Gateway Timeout")
PHP_HTTP_RESPONSE_CODE(505, "HTTP Version Not Supported")
PHP_HTTP_RESPONSE_CODE(506, "Variant Also Negotiates")
PHP_HTTP_RESPONSE_CODE(507, "Insufficient Storage")
PHP_HTTP_RESPONSE_CODE(508, "Loop Detected")
PHP_HTTP_RESPONSE_CODE(510, "Not Extended")
PHP_HTTP_RESPONSE_CODE(511, "Network Authentication Required")


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
PK       ! ~>  >  '  php/ext/http/php_http_encoding_brotli.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_ENCODING_BROTLI_H
#define PHP_HTTP_ENCODING_BROTLI_H
#if PHP_HTTP_HAVE_LIBBROTLI

#include <brotli/decode.h>
#include <brotli/encode.h>

extern PHP_MINIT_FUNCTION(http_encoding_brotli);

PHP_HTTP_API zend_class_entry *php_http_get_enbrotli_stream_class_entry(void);
PHP_HTTP_API zend_class_entry *php_http_get_debrotli_stream_class_entry(void);

PHP_HTTP_API php_http_encoding_stream_ops_t *php_http_encoding_stream_get_enbrotli_ops(void);
PHP_HTTP_API php_http_encoding_stream_ops_t *php_http_encoding_stream_get_debrotli_ops(void);

PHP_HTTP_API ZEND_RESULT_CODE php_http_encoding_enbrotli(int flags, const char *data, size_t data_len, char **encoded, size_t *encoded_len);
PHP_HTTP_API ZEND_RESULT_CODE php_http_encoding_debrotli(const char *encoded, size_t encoded_len, char **decoded, size_t *decoded_len);

#define PHP_HTTP_ENBROTLI_LEVEL_MIN			0x00000001
#define PHP_HTTP_ENBROTLI_LEVEL_DEF			0x00000004
#define PHP_HTTP_ENBROTLI_LEVEL_MAX			0x0000000b

#define PHP_HTTP_ENBROTLI_WBITS_MIN			0x000000a0
#define PHP_HTTP_ENBROTLI_WBITS_DEF			0x00000160
#define PHP_HTTP_ENBROTLI_WBITS_MAX			0x00000180

#define PHP_HTTP_ENBROTLI_MODE_GENERIC		0x00000000
#define PHP_HTTP_ENBROTLI_MODE_TEXT			0x00001000
#define PHP_HTTP_ENBROTLI_MODE_FONT			0x00002000

#endif
#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */

PK       ! g       php/ext/http/php_http_encoding.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_ENCODING_H
#define PHP_HTTP_ENCODING_H

extern PHP_MINIT_FUNCTION(http_encoding);

#define PHP_HTTP_ENCODING_STREAM_PERSISTENT	0x01000000
#define PHP_HTTP_ENCODING_STREAM_DIRTY		0x02000000

#define PHP_HTTP_ENCODING_STREAM_FLUSH_NONE	0x00000000
#define PHP_HTTP_ENCODING_STREAM_FLUSH_SYNC 0x00100000
#define PHP_HTTP_ENCODING_STREAM_FLUSH_FULL 0x00200000

#define PHP_HTTP_ENCODING_STREAM_FLUSH_FLAG(flags, full, sync, none) \
	(((flags) & PHP_HTTP_ENCODING_STREAM_FLUSH_FULL) ? (full) : \
	(((flags) & PHP_HTTP_ENCODING_STREAM_FLUSH_SYNC) ? (sync) : (none)))

typedef struct php_http_encoding_stream php_http_encoding_stream_t;

typedef php_http_encoding_stream_t *(*php_http_encoding_stream_init_func_t)(php_http_encoding_stream_t *s);
typedef php_http_encoding_stream_t *(*php_http_encoding_stream_copy_func_t)(php_http_encoding_stream_t *from, php_http_encoding_stream_t *to);
typedef ZEND_RESULT_CODE (*php_http_encoding_stream_update_func_t)(php_http_encoding_stream_t *s, const char *in_str, size_t in_len, char **out_str, size_t *out_len);
typedef ZEND_RESULT_CODE (*php_http_encoding_stream_flush_func_t)(php_http_encoding_stream_t *s, char **out_str, size_t *out_len);
typedef zend_bool (*php_http_encoding_stream_done_func_t)(php_http_encoding_stream_t *s);
typedef ZEND_RESULT_CODE (*php_http_encoding_stream_finish_func_t)(php_http_encoding_stream_t *s, char **out_str, size_t *out_len);
typedef void (*php_http_encoding_stream_dtor_func_t)(php_http_encoding_stream_t *s);

typedef struct php_http_encoding_stream_ops {
	php_http_encoding_stream_init_func_t init;
	php_http_encoding_stream_copy_func_t copy;
	php_http_encoding_stream_update_func_t update;
	php_http_encoding_stream_flush_func_t flush;
	php_http_encoding_stream_done_func_t done;
	php_http_encoding_stream_finish_func_t finish;
	php_http_encoding_stream_dtor_func_t dtor;
} php_http_encoding_stream_ops_t;

struct php_http_encoding_stream {
	unsigned flags;
	void *ctx;
	php_http_encoding_stream_ops_t *ops;
};


PHP_HTTP_API php_http_encoding_stream_t *php_http_encoding_stream_init(php_http_encoding_stream_t *s, php_http_encoding_stream_ops_t *ops, unsigned flags);
PHP_HTTP_API php_http_encoding_stream_t *php_http_encoding_stream_copy(php_http_encoding_stream_t *from, php_http_encoding_stream_t *to);
PHP_HTTP_API ZEND_RESULT_CODE php_http_encoding_stream_reset(php_http_encoding_stream_t **s);
PHP_HTTP_API ZEND_RESULT_CODE php_http_encoding_stream_update(php_http_encoding_stream_t *s, const char *in_str, size_t in_len, char **out_str, size_t *out_len);
PHP_HTTP_API ZEND_RESULT_CODE php_http_encoding_stream_flush(php_http_encoding_stream_t *s, char **out_str, size_t *len);
PHP_HTTP_API zend_bool php_http_encoding_stream_done(php_http_encoding_stream_t *s);
PHP_HTTP_API ZEND_RESULT_CODE php_http_encoding_stream_finish(php_http_encoding_stream_t *s, char **out_str, size_t *len);
PHP_HTTP_API void php_http_encoding_stream_dtor(php_http_encoding_stream_t *s);
PHP_HTTP_API void php_http_enc