eam_ops_t *php_http_encoding_stream_get_dechunk_ops(void);
PHP_HTTP_API const char *php_http_encoding_dechunk(const char *encoded, size_t encoded_len, char **decoded, size_t *decoded_len);
PHP_HTTP_API zend_class_entry *php_http_get_dechunk_stream_class_entry(void);

typedef struct php_http_encoding_stream_object {
	php_http_encoding_stream_t *stream;
	zend_object zo;
} php_http_encoding_stream_object_t;

PHP_HTTP_API zend_class_entry *php_http_get_encoding_stream_class_entry(void);

zend_object *php_http_encoding_stream_object_new(zend_class_entry *ce);
php_http_encoding_stream_object_t *php_http_encoding_stream_object_new_ex(zend_class_entry *ce, php_http_encoding_stream_t *s);
zend_object *php_http_encoding_stream_object_clone(zend_object *object);
void php_http_encoding_stream_object_free(zend_object *object);

#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
PK       !  ZU  U  #  php/ext/http/php_http_querystring.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_QUERYSTRING_H
#define PHP_HTTP_QUERYSTRING_H

#if PHP_HTTP_HAVE_ICONV
PHP_HTTP_API ZEND_RESULT_CODE php_http_querystring_xlate(zval *dst, zval *src, const char *ie, const char *oe);
#endif /* PHP_HTTP_HAVE_ICONV */
PHP_HTTP_API ZEND_RESULT_CODE php_http_querystring_update(zval *qarray, zval *params, zval *qstring);
PHP_HTTP_API ZEND_RESULT_CODE php_http_querystring_ctor(zval *instance, zval *params);

typedef php_http_object_t php_http_querystring_object_t;

#define PHP_HTTP_QUERYSTRING_TYPE_BOOL		_IS_BOOL
#define PHP_HTTP_QUERYSTRING_TYPE_INT		IS_LONG
#define PHP_HTTP_QUERYSTRING_TYPE_FLOAT		IS_DOUBLE
#define PHP_HTTP_QUERYSTRING_TYPE_STRING	IS_STRING
#define PHP_HTTP_QUERYSTRING_TYPE_ARRAY		IS_ARRAY
#define PHP_HTTP_QUERYSTRING_TYPE_OBJECT	IS_OBJECT

PHP_HTTP_API zend_class_entry *php_http_querystring_get_class_entry(void);

PHP_MINIT_FUNCTION(http_querystring);

#define php_http_querystring_object_new php_http_object_new
#define php_http_querystring_object_new_ex php_http_object_new_ex

#endif /* PHP_HTTP_QUERYSTRING_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
PK       ! #      php/ext/http/php_http_message.hnu [        /*
    +--------------------------------------------------------------------+
    | PECL :: http                                                       |
    +--------------------------------------------------------------------+
    | Redistribution and use in source and binary forms, with or without |
    | modification, are permitted provided that the conditions mentioned |
    | in the accompanying LICENSE file are met.                          |
    +--------------------------------------------------------------------+
    | Copyright (c) 2004-2014, Michael Wallner <mike@php.net>            |
    +--------------------------------------------------------------------+
*/

#ifndef PHP_HTTP_MESSAGE_H
#define PHP_HTTP_MESSAGE_H

#include "php_http_message_body.h"
#include "php_http_header.h"

/* required minimum length of an HTTP message "HTTP/1.1" */
#define PHP_HTTP_MESSAGE_MIN_SIZE 8
#define PHP_HTTP_MESSAGE_TYPE(TYPE, msg) ((msg) && ((msg)->type == PHP_HTTP_ ##TYPE))

typedef php_http_info_type_t php_http_message_type_t;
typedef struct php_http_message php_http_message_t;

struct php_http_message {
	PHP_HTTP_INFO_IMPL(http, type)
	HashTable hdrs;
	php_http_message_body_t *body;
	php_http_message_t *parent;
	void *opaque;
};

PHP_HTTP_API zend_bool php_http_message_info_callback(php_http_message_t **message, HashTable **headers, php_http_info_t *info);

PHP_HTTP_API php_http_message_t *php_http_message_init(php_http_message_t *m, php_http_message_type_t t, php_http_message_body_t *body);
PHP_HTTP_API php_http_message_t *php_http_message_init_env(php_http_message_t *m, php_http_message_type_t t);
PHP_HTTP_API php_http_message_t *php_http_message_copy_ex(php_http_message_t *from, php_http_message_t *to, zend_bool parents);
static inline php_http_message_t *php_http_message_copy(php_http_message_t *from, php_http_message_t *to)
{
	return php_http_message_copy_ex(from, to, 1);
}

PHP_HTTP_API void php_http_message_dtor(php_http_message_t *message);
PHP_HTTP_API void php_http_message_free(php_http_message_t **message);

PHP_HTTP_API void php_http_message_set_type(php_http_message_t *m, php_http_message_type_t t);
PHP_HTTP_API void php_http_message_set_info(php_http_message_t *message, php_http_info_t *info);

PHP_HTTP_API void php_http_message_update_headers(php_http_message_t *msg);

PHP_HTTP_API zval *php_http_message_header(php_http_message_t *msg, const char *key_str, size_t key_len);

static inline zend_string *php_http_message_header_string(php_http_message_t *msg, const char *key_str, size_t key_len)
{
	zval *header;

	if ((header = php_http_message_header(msg, key_str, key_len))) {
		return php_http_header_value_to_string(header);
	}
	return NULL;
}

PHP_HTTP_API zend_bool php_http_message_is_multipart(php_http_message_t *msg, char **boundary);

PHP_HTTP_API void php_http_message_to_string(php_http_message_t *msg, char **string, size_t *length);
PHP_HTTP_API void php_http_message_to_struct(php_http_message_t *msg, zval *strct);
PHP_HTTP_API void php_http_message_to_callback(php_http_message_t *msg, php_http_pass_callback_t cb, void *cb_arg);

PHP_HTTP_API void php_http_message_serialize(php_http_message_t *message, char **string, size_t *length);
PHP_HTTP_API php_http_message_t *php_http_message_reverse(php_http_message_t *msg);
PHP_HTTP_API php_http_message_t *php_http_message_zip(php_http_message_t *one, php_http_message_t *two);

static inline size_t php_http_message_count(php_http_message_t *m)
{
	size_t c = 1;

	while ((m = m->parent)) {
		++c;
	}

	return c;
}

PHP