ve been
 * allocated while calling 'timelib_zoneinfo'.
 */
void timelib_zoneinfo_dtor(timelib_tzdb *tzdb);

/* From timelib.c */

/**
 * Returns a static string containing an error message belonging to a specific
 * error code.
 */
const char *timelib_get_error_message(int error_code);

/**
 * Allocates resources for the relative time structure.
 *
 * Must be freed with 'timelib_rel_time_dtor'.
 */
timelib_rel_time* timelib_rel_time_ctor(void);

/**
 * Frees up the resources as allocated through 'timelib_rel_time_ctor'.
 */
void timelib_rel_time_dtor(timelib_rel_time* t);

/**
 * Creates a new timelib_rel_time resource and copies over the information
 * from 'tz'.
 *
 * Must be freed with 'timelib_rel_time_dtor'.
 */
timelib_rel_time* timelib_rel_time_clone(timelib_rel_time *tz);

/**
 * Allocates resources for the time structure.
 *
 * Must be freed with 'timelib_time_dtor'.
 */
timelib_time* timelib_time_ctor(void);

/**
 * Frees up the resources as allocated through 'timelib_time_ctor'.
 */
void timelib_time_dtor(timelib_time* t);

/**
 * Creates a new timelib_time resource and copies over the information
 * from 'orig'.
 *
 * Must be freed with 'timelib_time_dtor'.
 */
timelib_time* timelib_time_clone(timelib_time* orig);

/**
 * Compares two timelib_time structures and returns which one is earlier in
 * time.
 *
 * To decide which comes earlier it uses the 'sse' (Seconds Since Epoch) and
 * 'us' (microseconds) fields.
 *
 * Returns -1 if t1 < t2, 0 if t1 == t2, and -1 if t1 > t2.
 */
int timelib_time_compare(timelib_time *t1, timelib_time *t2);

/**
 * Allocates resources for the time offset structure.
 *
 * Must be freed with 'timelib_time_offset_dtor'.
 */
timelib_time_offset* timelib_time_offset_ctor(void);

/**
 * Frees up the resources as allocated through 'timelib_time_offset_ctor'.
 */
void timelib_time_offset_dtor(timelib_time_offset* t);

/**
 * Frees up the resources allocated while converting strings to timelib_time
 * structures with the timelib_strtotime and timelib_strtointerval functions.
 */
void timelib_error_container_dtor(timelib_error_container *errors);

/**
 * Converts the 'sse' value of 'd' to a timelib_long type.
 *
 * If the value fits in the TIMELIB_LONG_MIN and TIMELIB_LONG_MAX range, the
 * value is cast to (timelib_long) and returned. If *error is not a NULL
 * pointer, it will be set to 0.
 *
 * If the value does *not* fit in the range, the function returns 0 and if
 * *error is not a NULL pointer, it will be set to 1.
 *
 * timelib_long is a 32 bit signed long integer on 32 bit platforms, and a 64
 * bit signed long long integer on 64 bit platforms. In other words, it makes
 * sure that the value in 'sse' (which is always a signed long long 64 bit
 * integer) can be used safely outside of the library.
 */
timelib_long timelib_date_to_int(timelib_time *d, int *error);

/**
 * Displays debugging information about the date/time information stored in 'd'.
 *
 * 'options' is a bit field, where:
 * - 1 controls whether the relative time portion is shown.
 * - 2 controls whether the zone type is shown.
 */
void timelib_dump_date(timelib_time *d, int options);

/**
 * Displays debugging information about the relative time information stored
 * in 'd'.
 */
void timelib_dump_rel_time(timelib_rel_time *d);

/**
 * Converts a decimal hour into hour/min/sec components
 */
void timelib_decimal_hour_to_hms(double h, int *hour, int *min, int *sec);

/**
 * Converts hour/min/sec values into a decimal hour
 */
void timelib_hms_to_decimal_hour(int hour, int min, int sec, double *h);

/* from astro.c */

/**
 * Converts the Unix Epoch time stamp 'ts' to a Julian Day
 *
 * The value returned is the number of whole days since -4714-11-24T12:00:00 UTC
 * (in the proleptic Gregorian calendar):
 * https://en.wikipedia.org/wiki/Julian_day
 */
double timelib_ts_to_julianday(timelib_sll ts);

/**
 * Converts the Unix Epoch time stamp 'ts' to the J2000 epoch
 *
 * The value returned is the number of whole days since 2000-01-01T12:00:00
 * UTC: https://en.wikipedia.org/wiki/Epoch_(astronomy)#Julian_years_and_J2000
 */
double timelib_ts_to_j2000(timelib_sll ts);

/**
 * Calculates when the Sun is above a certain latitude.
 *
 * Parameters:
 * - time: A timelib_time time describing that needs to specific midnight for a
 *         specific day.
 * - lon: The longitude of the observer (East positive, West negative).
 * - lat: The latitude of the observer (North positive, South negative).
 * - altit: The altitude. Set to -35/60 for rise/set, -6 for civil twilight,
 *          -12 for nautical, and -18 for astronomical twilight.
 * - upper_limb: set to non-zero for rise/set calculations, and 0 for twilight
 *               calculations.
 *
 * Out Parameters:
 * - h_rise: The decimal hour when the Sun rises
 * - h_set: The decimal hour when the Sun sets
 * - ts_rise: The Unix timestamp of the Sun rising
 * - ts_set: The Unix timestamp of the Sun setting
 * - ts_transit: The Unix timestmap of the Sun transitting through South
 *
 * Return Values:
 * - 0: The Sun rises and sets.
 * - +1: The Sun is always above the horizon. (ts_rise is set to ts_transit -
 *       (12 * 3600); ts_set is set to ts_transit + (12 * 3600).
 * - -1: The Sun is awlays below the horizon. (ts_rise and ts_set are set
 *       to ts_transit)
 */
int timelib_astro_rise_set_altitude(timelib_time *time, double lon, double lat, double altit, int upper_limb, double *h_rise, double *h_set, timelib_sll *ts_rise, timelib_sll *ts_set, timelib_sll *ts_transit);

/* from interval.c */

/**
 * Calculates the difference between two times
 *
 * The result is a timelib_rel_time structure that describes how you can
 * convert from 'one' to 'two' with 'timelib_add'. This does *not* necessarily
 * mean that you can go from 'two' to 'one' by using 'timelib_sub' due to the
 * way months and days are calculated.
 */
timelib_rel_time *timelib_diff(timelib_time *one, timelib_time *two);

/**
 * Adds the relative time information 'interval' to the base time 't'.
 *
 * This can be a relative time as created by 'timelib_diff', but also by more
 * complex statements such as "next workday".
 */
timelib_time *timelib_add(timelib_time *t, timelib_rel_time *interval);

/**
 * Subtracts the relative time information 'interval' to the base time 't'.
 *
 * This can be a relative time as created by 'timelib_diff'. Unlike with
 * 'timelib_add', this does not support more complex statements such as "next
 * workday".
 */
timelib_time *timelib_sub(timelib_time *t, timelib_rel_time *interval);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
PK       ! j9  9  !  php/ext/date/lib/timelib_config.hnu [        #ifdef PHP_WIN32
# include "config.w32.h"
#else
# include <php_config.h>
#endif
#include <php_stdint.h>
#define TIMELIB_OMIT_STDINT 1

#include "zend.h"

#define timelib_malloc  emalloc
#define timelib_realloc erealloc
#define timelib_calloc  ecalloc
#define timelib_strdup  estrdup
#define timelib_free    efree
PK       ! 6d      php/ext/apcu/php_apc.hnu [        /*
  +----------------------------------------------------------------------+
  | APC                                                                  |
  +----------------------------------------------------------------------+
  | Copyright (c) 2006-2011 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors: Daniel Cowgill <dcowgill@communityconnect.com>              |
  |          George Schlossnagle <george@omniti.com>                     |
  |          Rasmus Lerdorf <rasmus@php.net>                             |
  +----------------------------------------------------------------------+

   This software was contributed to PHP by Community Connect Inc. in 2002
   and revised in 2005 by Yahoo! Inc. to add support for PHP 5.1.
   Future revisions and derivatives of this source code must acknowledge
   Community Connect Inc. as the original contributor of this module by
   leaving this note intact in the source code.

   All other licensing and usage conditions are those of the PHP Group.

 */

#ifndef PHP_APCU_H
#define PHP_APCU_H

#include "apc.h"
#include "apc_globals.h"

#define PHP_APCU_VERSION "5.1.23"
#define PHP_APCU_EXTNAME "apcu"

PHP_APCU_API zend_bool apc_is_enabled(void);

extern zend_module_entry apcu_module_entry;
#define apcu_module_ptr &apcu_module_entry

#define phpext_apcu_ptr apcu_module_ptr

#if defined(ZTS) && defined(COMPILE_DL_APCU)
ZEND_TSRMLS_CACHE_EXTERN();
#endif

#endif /* PHP_APC_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim>600: noexpandtab sw=4 ts=4 sts=4 fdm=marker
 * vim<600: noexpandtab sw=4 ts=4 sts=4
 */
PK       ! Uw)      php/ext/apcu/apc_serializer.hnu [        /*
  +----------------------------------------------------------------------+
  | APC                                                                  |
  +----------------------------------------------------------------------+
  | Copyright (c) 2006-2011 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt.                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors: Gopal Vijayaraghavan <gopalv@php.net>                       |
  +----------------------------------------------------------------------+

 */

#ifndef APC_SERIALIZER_H
#define APC_SERIALIZER_H

/* this is a shipped .h file, do not include any other header in this file */
#define APC_SERIALIZER_NAME(module) module##_apc_serializer
#define APC_UNSERIALIZER_NAME(module) module##_apc_unserializer

#define APC_SERIALIZER_ARGS unsigned char **buf, size_t *buf_len, const zval *value, void *config
#define APC_UNSERIALIZER_ARGS zval *value, unsigned char *buf, size_t buf_len, void *config

typedef int (*apc_serialize_t)(APC_SERIALIZER_ARGS);
typedef int (*apc_unserialize_t)(APC_UNSERIALIZER_ARGS);

typedef int (*apc_register_serializer_t)(const char* name, apc_serialize_t serialize, apc_unserialize_t unserialize, void *config);

/*
 * ABI version for constant hooks. Increment this any time you make any changes
 * to any function in this file.
 */
#define APC_SERIALIZER_ABI "0"
#define APC_SERIALIZER_CONSTANT "\000apc_register_serializer-" APC_SERIALIZER_ABI

#if !defined(APC_UNUSED)
# if defined(__GNUC__)
#  define APC_UNUSED __attribute__((unused))
# else
# define APC_UNUSED
# endif
#endif

static APC_UNUSED int apc_register_serializer(
        const char* name, apc_serialize_t serialize, apc_unserialize_t unserialize, void *config)
{
	int retval = 0;

	zend_string *lookup = zend_string_init(
		APC_SERIALIZER_CONSTANT, sizeof(APC_SERIALIZER_CONSTANT)-1, 0);
	zval *magic = zend_get_constant(lookup);

	/* zend_get_constant will return 1 on success, otherwise apc_magic_constant wouldn't be touched at all */
	if (magic) {
		apc_register_serializer_t register_func = (apc_register_serializer_t)(Z_LVAL_P(magic));
		if(register_func) {
			retval = register_func(name, serialize, unserialize, NULL);
		}
	}

	zend_string_release(lookup);

	return retval;
}

#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim>600: noexpandtab sw=4 ts=4 sts=4 fdm=marker
 * vim<600: noexpandtab sw=4 ts=4 sts=4
 */
PK       ! UUQ  Q    php/ext/apcu/apc_lock.hnu [        /*
  +----------------------------------------------------------------------+
  | APCu                                                                 |
  +----------------------------------------------------------------------+
  | Copyright (c) 2013 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Joe Watkins <joe.watkins@live.co.uk>                        |
  +----------------------------------------------------------------------+
 */

#ifndef APC_LOCK_H
#define APC_LOCK_H

/*
 APCu works most efficiently where there is access to native read/write locks
 If the current system has native rwlocks present they will be used, if they are
	not present, APCu will emulate their behavior with standard mutex.
 While APCu is emulating read/write locks, reads and writes are exclusive,
	additionally the write lock prefers readers, as is the default behaviour of
	the majority of Posix rwlock implementations
*/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "apc.h"

#ifndef PHP_WIN32
# ifndef __USE_UNIX98
#  define __USE_UNIX98
# endif
# include "pthread.h"
# ifndef APC_SPIN_LOCK
#   ifndef APC_FCNTL_LOCK
#       ifdef APC_NATIVE_RWLOCK
		typedef pthread_rwlock_t apc_lock_t;
#		define APC_LOCK_SHARED
#       else
		typedef pthread_mutex_t apc_lock_t;
#		define APC_LOCK_RECURSIVE
#       endif
#   else
		typedef int apc_lock_t;
#		define APC_LOCK_FILE
#   endif
# else
# define APC_LOCK_NICE 1
typedef struct {
	unsigned long state;
} apc_lock_t;
# endif
#else
/* XXX kernel lock mode only for now, compatible through all the wins, add more ifdefs for others */
# include "apc_windows_srwlock_kernel.h"
typedef apc_windows_cs_rwlock_t apc_lock_t;
# define APC_LOCK_SHARED
#endif

/* {{{ functions */
/*
  The following functions should be called once per process:
	apc_lock_init initializes attributes suitable for all locks
	apc_lock_cleanup destroys those attributes
  This saves us from having to create and destroy attributes for
  every lock we use at runtime */
PHP_APCU_API zend_bool apc_lock_init(void);
PHP_APCU_API void      apc_lock_cleanup(void);
/*
  The following functions should be self explanitory:
*/
PHP_APCU_API zend_bool apc_lock_create(apc_lock_t *lock);
PHP_APCU_API zend_bool apc_lock_rlock(apc_lock_t *lock);
PHP_APCU_API zend_bool apc_lock_wlock(apc_lock_t *lock);
PHP_APCU_API zend_bool apc_lock_runlock(apc_lock_t *lock);
PHP_APCU_API zend_bool apc_lock_wunlock(apc_lock_t *lock);
PHP_APCU_API void apc_lock_destroy(apc_lock_t *lock); /* }}} */

/* {{{ generic locking macros */
#define CREATE_LOCK(lock)     apc_lock_create(lock)
#define DESTROY_LOCK(lock)    apc_lock_destroy(lock)
#define WLOCK(lock)           apc_lock_wlock(lock)
#define WUNLOCK(lock)         { apc_lock_wunlock(lock); HANDLE_UNBLOCK_INTERRUPTIONS(); }
#define RLOCK(lock)           apc_lock_rlock(lock)
#define RUNLOCK(lock)         { apc_lock_runlock(lock); HANDLE_UNBLOCK_INTERRUPTIONS(); }
/* }}} */

/* atomic operations */
#ifdef PHP_WIN32
# ifdef _WIN64
#  define ATOMIC_INC(a) InterlockedIncrement64(&a)
#  define ATOMIC_DEC(a) InterlockedDecrement64(&a)
#  define ATOMIC_ADD(a, b) (InterlockedExchangeAdd64(&a, b) + b)
#  define ATOMIC_CAS(a, old, new) (InterlockedCompareExchange64(&a, new, old) == old)
# else
#  define ATOMIC_INC(a) InterlockedIncrement(&a)
#  define ATOMIC_DEC(a) InterlockedDecrement(&a)
#  define ATOMIC_ADD(a, b) (InterlockedExchangeAdd(&a, b) + b)
#  define ATOMIC_CAS(a, old, new) (InterlockedCompareExchange(&a, new, old) == old)
# endif
#else
# define ATOMIC_INC(a) __sync_add_and_fetch(&a, 1)
# define ATOMIC_DEC(a) __sync_sub_and_fetch(&a, 1)
# define ATOMIC_ADD(a, b) __sync_add_and_fetch(&a, b)
# define ATOMIC_CAS(a, old, new) __sync_bool_compare_and_swap(&a, old, new)
#endif

#endif
PK       ! Ti      php/ext/apcu/apc_sma.hnu [        /*
  +----------------------------------------------------------------------+
  | APC                                                                  |
  +----------------------------------------------------------------------+
  | Copyright (c) 2006-2011 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors: Daniel Cowgill <dcowgill@communityconnect.com>              |
  +----------------------------------------------------------------------+

   This software was contributed to PHP by Community Connect Inc. in 2002
   and revised in 2005 by Yahoo! Inc. to add support for PHP 5.1.
   Future revisions and derivatives of this source code must acknowledge
   Community Connect Inc. as the original contributor of this module by
   leaving this note intact in the source code.

   All other licensing and usage conditions are those of the PHP Group.

 */

#ifndef APC_SMA_H
#define APC_SMA_H

/* {{{ SMA API
	APC SMA API provides support for shared memory allocators to external libraries ( and to APC )
	Skip to the bottom macros for error free usage of the SMA API
*/

#include "apc.h"

/* {{{ struct definition: apc_segment_t */
typedef struct _apc_segment_t {
	size_t size;            /* size of this segment */
	void* shmaddr;          /* address of shared memory */
#ifdef APC_MEMPROTECT
	void* roaddr;           /* read only (mprotect'd) address */
#endif
} apc_segment_t; /* }}} */

/* {{{ struct definition: apc_sma_link_t */
typedef struct apc_sma_link_t apc_sma_link_t;
struct apc_sma_link_t {
	zend_long size;              /* size of this free block */
	zend_long offset;            /* offset in segment of this block */
	apc_sma_link_t* next;   /* link to next free block */
};
/* }}} */

/* {{{ struct definition: apc_sma_info_t */
typedef struct apc_sma_info_t apc_sma_info_t;
struct apc_sma_info_t {
	int num_seg;            /* number of segments */
	size_t seg_size;        /* segment size */
	apc_sma_link_t** list;  /* one list per segment of links */
};
/* }}} */

typedef void (*apc_sma_expunge_f)(void *pointer, size_t size); /* }}} */

/* {{{ struct definition: apc_sma_t */
typedef struct _apc_sma_t {
	zend_bool initialized;         /* flag to indicate this sma has been initialized */

	/* callback */
	apc_sma_expunge_f expunge;     /* expunge */
	void** data;                   /* expunge data */

	/* info */
	int32_t  num;                  /* number of segments */
	size_t size;                   /* segment size */
	int32_t  last;                 /* last segment */

	/* segments */
	apc_segment_t *segs;           /* segments */
} apc_sma_t; /* }}} */

/*
* apc_sma_api_init will initialize a shared memory allocator with num segments of the given size
*
* should be called once per allocator per process
*/
PHP_APCU_API void apc_sma_init(
		apc_sma_t* sma, void** data, apc_sma_expunge_f expunge,
		int32_t num, size_t size, char *mask);

/*
 * apc_sma_detach will detach from shared memory and cleanup local allocations.
 */
PHP_APCU_API void apc_sma_detach(apc_sma_t* sma);

/*
* apc_smap_api_malloc will allocate a block from the sma of the given size
*/
PHP_APCU_API void* apc_sma_malloc(apc_sma_t* sma, size_t size);

/*
 * apc_sma_api_malloc_ex will allocate a block from the sma of the given size and
 * provide the size of the actual allocation.
 */
PHP_APCU_API void *apc_sma_malloc_ex(
		apc_sma_t *sma, size_t size, size_t *allocated);

/*
* apc_sma_api_free will free p (which should be a pointer to a block allocated from sma)
*/
PHP_APCU_API void apc_sma_free(apc_sma_t* sma, void* p);

/*
* apc_sma_api_protect will protect p (which should be a pointer to a block allocated from sma)
*/
PHP_APCU_API void* apc_sma_protect(apc_sma_t* sma, void* p);

/*
* apc_sma_api_protect will uprotect p (which should be a pointer to a block allocated from sma)
*/
PHP_APCU_API void* apc_sma_unprotect(apc_sma_t* sma, void *p);

/*
* apc_sma_api_info returns information about the allocator
*/
PHP_APCU_API apc_sma_info_t* apc_sma_info(apc_sma_t* sma, zend_bool limited);

/*
* apc_sma_api_info_free_info is for freeing apc_sma_info_t* returned by apc_sma_api_info
*/
PHP_APCU_API void apc_sma_free_info(apc_sma_t* sma, apc_sma_info_t* info);

/*
* apc_sma_api_get_avail_mem will return the amount of memory available left to sma
*/
PHP_APCU_API size_t apc_sma_get_avail_mem(apc_sma_t* sma);

/*
* apc_sma_api_get_avail_size will return true if at least size bytes are available to the sma
*/
PHP_APCU_API zend_bool apc_sma_get_avail_size(apc_sma_t* sma, size_t size);

/*
* apc_sma_api_check_integrity will check the integrity of sma
*/
PHP_APCU_API void apc_sma_check_integrity(apc_sma_t* sma); /* }}} */

/* {{{ ALIGNWORD: pad up x, aligned to the system's word boundary */
typedef union { void* p; int i; long l; 