*query_string;
	size_t query_stringlen;

	/* the copy of the query with expanded binds ONLY for emulated-prepare drivers */
	char *active_query_string;
	size_t active_query_stringlen;

	/* the cursor specific error code. */
	pdo_error_type error_code;

	/* for lazy fetches, we always return the same lazy object handle.
	 * Let's keep it here. */
	zval lazy_object_ref;
	zend_ulong refcount;

	/* defaults for fetches */
	enum pdo_fetch_type default_fetch_type;
	union {
		int column;
		struct {
			zval ctor_args;            /* freed */
			zend_fcall_info fci;
			zend_fcall_info_cache fcc;
			zval retval;
			zend_class_entry *ce;
		} cls;
		struct {
			zval fetch_args;           /* freed */
			zend_fcall_info fci;
			zend_fcall_info_cache fcc;
			zval object;
			zval function;
			zval *values;              /* freed */
		} func;
		zval into;
	} fetch;

	/* used by the query parser for driver specific
	 * parameter naming (see pgsql driver for example) */
	const char *named_rewrite_template;

	/* these items must appear in this order at the beginning of the
       struct so that this can be cast as a zend_object.  we need this
       to allow the extending class to escape all the custom handlers
	   that PDO declares.
    */
	zend_object std;
};

static inline pdo_stmt_t *php_pdo_stmt_fetch_object(zend_object *obj) {
	return (pdo_stmt_t *)((char*)(obj) - XtOffsetOf(pdo_stmt_t, std));
}

#define Z_PDO_STMT_P(zv) php_pdo_stmt_fetch_object(Z_OBJ_P